/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.controls.display.DisRegObject;
import oracle.dbtools.raptor.controls.display.DisplayChartDetails;
import oracle.dbtools.raptor.controls.display.DisplayCodeEditor;
import oracle.dbtools.raptor.controls.display.DisplayGaugeDetails;
import oracle.dbtools.raptor.controls.display.DisplayPLSQL;
import oracle.dbtools.raptor.controls.display.DisplayResultTable;
import oracle.dbtools.raptor.controls.display.DisplayScript;
import oracle.dbtools.raptor.controls.display.DisplaySimpleChart;
import oracle.dbtools.raptor.controls.display.DisplaySimpleGuage;
import oracle.dbtools.raptor.controls.display.DisplayTableDetails;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.IDisplayDetail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayRegistry {
    private static HashMap<String, DisRegObject> _registry = new HashMap();

    public static synchronized void registerDisplay(String string, Class clazz) {
        if (!IDisplay.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must be instance of IDisplay");
        }
        DisRegObject disRegObject = new DisRegObject(clazz);
        _registry.put(string, disRegObject);
    }

    public static synchronized void registerDisplay(String string, Class clazz, Class clazz2, Boolean bl) {
        if (clazz.isAssignableFrom(IDisplay.class)) {
            if (!clazz2.isAssignableFrom(IDisplayDetail.class)) {
                throw new IllegalArgumentException("Detail must be instance of IDisplayDetail");
            }
        } else {
            throw new IllegalArgumentException("Clazz must be instance of IDisplay");
        }
        DisRegObject disRegObject = new DisRegObject(clazz, clazz2, bl);
        _registry.put(string, disRegObject);
    }

    public static synchronized void unregisterDisplay(String string) {
        _registry.remove(string);
    }

    public static synchronized IDisplay getInstanceFor(String string) throws Exception {
        if (_registry.get(string) != null) {
            return (IDisplay)_registry.get(string).getClazz().newInstance();
        }
        return (IDisplay)_registry.get("Table").getClazz().newInstance();
    }

    public static synchronized Boolean hasDetails(String string) throws Exception {
        if (_registry.get(string).getEditor() != null) {
            return true;
        }
        return false;
    }

    public static synchronized Boolean allowChildren(String string) throws Exception {
        return _registry.get(string).childAllowed();
    }

    public static synchronized IDisplayDetail getDetailPanel(String string) throws Exception {
        if (_registry.get(string) != null) {
            return (IDisplayDetail)_registry.get(string).getEditor().newInstance();
        }
        return (IDisplayDetail)_registry.get("Table").getEditor().newInstance();
    }

    public static synchronized ArrayList<String> getStylesAllowChildren() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            if (!_registry.get(string).childAllowed().booleanValue()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized ArrayList<String> getStylesNoChildren() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            if (_registry.get(string).childAllowed().booleanValue()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static synchronized ArrayList<String> getStyles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : _registry.keySet()) {
            arrayList.add(string);
        }
        return arrayList;
    }

    static {
        _registry.put("Table", new DisRegObject(DisplayResultTable.class, DisplayTableDetails.class, true));
        _registry.put("Code", new DisRegObject(DisplayCodeEditor.class, null, false));
        _registry.put("Chart", new DisRegObject(DisplaySimpleChart.class, DisplayChartDetails.class, false));
        _registry.put("Gauge", new DisRegObject(DisplaySimpleGuage.class, DisplayGaugeDetails.class, false));
        _registry.put("plsql-dbms_output", new DisRegObject(DisplayPLSQL.class, null, false));
        _registry.put("Script", new DisRegObject(DisplayScript.class, null, false));
    }
}

