/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.jle.tool.SelectionEvent;
import oracle.bali.jle.tool.SelectionListener;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.controls.display.DisplayRegistry;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.runner.run.RunArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(DisplayPanel.class.getName());
    private Toolbar _toolbar = new Toolbar();
    private DisplayPanel _parent = null;
    private DisplayModel _model;
    private JSplitPane _sp;
    private CustomTabbedPane _tabbed;
    private IDisplay _main = null;
    private ArrayList<IDisplay> _children = new ArrayList();
    private ArrayList<DisplayPanel> _childPanels = new ArrayList();
    JEWTDialog dlg;
    boolean renderDisplay = true;
    boolean _building = false;
    private JComboBox _timerInterval;
    private Timer _timer;
    private TimerTask _tt;
    private DisplayPanel _panel;
    private boolean prompt;
    SelectionListener selectListener = new SelectionListener(){

        public void itemDeleted(SelectionEvent selectionEvent) {
        }

        public void itemDeleting(SelectionEvent selectionEvent) {
        }

        public void itemDeselected(SelectionEvent selectionEvent) {
        }

        public void itemDeselecting(SelectionEvent selectionEvent) {
        }

        public void itemSelected(SelectionEvent selectionEvent) {
            if (DisplayPanel.this._children != null) {
                DisplayPanel.this.logger.finer("MouseClicked with " + DisplayPanel.this._children.size() + " children");
                for (IDisplay iDisplay : DisplayPanel.this._children) {
                    iDisplay.setConn(DisplayPanel.this.getConnection());
                    iDisplay.setDirty(true);
                    if (!iDisplay.getUI().isShowing()) continue;
                    iDisplay.refresh(true);
                }
            }
        }

        public void itemSelecting(SelectionEvent selectionEvent) {
        }
    };
    MouseListener mouseListener = new MouseAdapter(){

        public void mousePressed(MouseEvent mouseEvent) {
            if (DisplayPanel.this._children != null) {
                DisplayPanel.this.logger.finer("MouseClicked with " + DisplayPanel.this._children.size() + " children");
                for (IDisplay iDisplay : DisplayPanel.this._children) {
                    iDisplay.setConn(DisplayPanel.this.getConnection());
                    iDisplay.setBindMap(DisplayPanel.this._main.getBinds(mouseEvent.getPoint()));
                    iDisplay.setDirty(true);
                    if (!iDisplay.getUI().isShowing()) continue;
                    iDisplay.refresh(true);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (DisplayPanel.this._children != null) {
                DisplayPanel.this.logger.finer("MouseClicked with " + DisplayPanel.this._children.size() + " children");
                DisplayPanel.this.setChildBinds(DisplayPanel.this._main.getBinds(mouseEvent.getPoint()));
            }
        }
    };
    private HashMap<String, Object> _binds;
    private boolean _forceBindPrompt = false;
    private String _connName;
    boolean _force;
    boolean _detail;

    public DisplayPanel(DisplayModel displayModel) {
        this(displayModel, null, true);
        this._panel = this;
    }

    public DisplayPanel(DisplayModel displayModel, boolean bl) {
        this(displayModel, null, bl);
        this._panel = this;
    }

    public DisplayPanel(DisplayModel displayModel, HashMap<String, Object> hashMap, boolean bl) {
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this._binds = hashMap;
        if (displayModel == null) {
            this._model = new DisplayModel();
        } else {
            this._model = displayModel;
            this.close();
            this.buildUI(bl);
            this.setChildBinds(hashMap);
        }
        if (this._main != null) {
            this._main.setBindMap(this._binds);
        }
        this._panel = this;
    }

    public DisplayPanel(DisplayModel displayModel, DisplayPanel displayPanel) {
        this._parent = displayPanel;
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.buildToolbar();
        if (displayModel == null) {
            this._model = new DisplayModel();
        } else {
            this._model = displayModel;
            this.close();
            this.buildUI(true);
        }
        this._panel = this;
    }

    public void setChildBinds(HashMap<String, Object> hashMap) {
        for (IDisplay iDisplay : this._children) {
            iDisplay.setConn(this.getConnection());
            iDisplay.setBindMap(hashMap);
        }
    }

    public void buildToolbar() {
        AbstractAction abstractAction = new AbstractAction("Run Report", RunArb.getIcon((int)17)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this.refresh(false, true);
            }
        };
        abstractAction.putValue("ShortDescription", "Run Report");
        this._toolbar.add((Action)abstractAction);
        this._toolbar.addSeparator();
        AbstractAction abstractAction2 = new AbstractAction("Run Report in SQLWorksheet", CommonArb.getIcon(0)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this.openSQLEditor();
            }
        };
        abstractAction2.putValue("ShortDescription", "Run Report in SQLWorksheet");
        this._toolbar.addSeparator();
        JLabel jLabel = new JLabel("Refresh:");
        this._timerInterval = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this._timerInterval.getModel();
        defaultComboBoxModel.addElement("0");
        defaultComboBoxModel.addElement("5");
        defaultComboBoxModel.addElement("10");
        defaultComboBoxModel.addElement("15");
        defaultComboBoxModel.addElement("20");
        defaultComboBoxModel.addElement("25");
        defaultComboBoxModel.addElement("30");
        defaultComboBoxModel.addElement("60");
        defaultComboBoxModel.addElement("120");
        this._timerInterval.setMaximumSize(this._timerInterval.getMinimumSize());
        this._timerInterval.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (DisplayPanel.this._timer != null) {
                        DisplayPanel.this._timer.cancel();
                        DisplayPanel.this._timer = null;
                        DisplayPanel.this._panel.prompt = true;
                    }
                    if (!DisplayPanel.this._timerInterval.getSelectedItem().equals("0")) {
                        DisplayPanel.this._timer = new Timer();
                        DisplayPanel.this._tt = new TimerTask(){

                            public void run() {
                                DisplayPanel.this._panel.prompt = false;
                                DisplayPanel.this._panel.refresh(false, true);
                            }
                        };
                        DisplayPanel.this._timer.scheduleAtFixedRate(DisplayPanel.this._tt, 0L, Long.parseLong((String)DisplayPanel.this._timerInterval.getSelectedItem()) * 1000L);
                    }
                }
            }
        });
        this._toolbar.add((Component)jLabel);
        this._toolbar.add((Component)this._timerInterval);
        this._toolbar.addSeparator();
    }

    public void openSQLEditor() {
    }

    public IDisplay getMainUI() {
        return this._main;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void addListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                DisplayPanel.this.refresh();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DisplayPanel.this.refresh();
            }
        });
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            public void componentResized(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }

            public void componentShown(ComponentEvent componentEvent) {
                DisplayPanel.this.refresh();
            }
        });
    }

    public Connection getConnection() {
        String string;
        Connection connection = this._model.getConnection();
        if (connection == null && (string = this._model.getConnName()) != null) {
            try {
                connection = Connections.getInstance().getConnection(string);
                this._model.setConnection(connection);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return connection;
    }

    public DisplayModel getModel() {
        return this._model;
    }

    public void setModel(DisplayModel displayModel) {
        if (this._main == null || this._model != displayModel) {
            this._model = displayModel;
            this.close();
            this.buildUI();
        } else {
            this.refresh();
        }
    }

    public void setMainPanelBinds(HashMap<String, Object> hashMap) {
        this._binds = hashMap;
    }

    private void initTabbedPane() {
        this._tabbed = new CustomTabbedPane();
        this._sp = new JSplitPane();
        this._sp.setOneTouchExpandable(true);
        this._sp.setContinuousLayout(true);
        this._sp.setOrientation(0);
        this._sp.setTopComponent(this._main.getScrollableUI());
        this._sp.setBottomComponent(this._tabbed);
        this._sp.setResizeWeight(0.5);
        this._sp.setDividerLocation(0.5);
        this.add((Component)this._sp, "Center");
        this._tabbed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DisplayPanel.this.logger.finer("DisplayPanel.stateChanged() has fired...");
                if (((CustomTabbedPane)changeEvent.getSource()).getActivePanel().isShowing() && !DisplayPanel.this._building) {
                    ((DisplayPanel)((CustomTabbedPane)changeEvent.getSource()).getActivePanel()).refresh();
                }
            }
        });
    }

    public void buildUI() {
        this.buildUI(false);
    }

    public void buildUI(boolean bl) {
        this.logger.finer("DisplayPanel.buildUI()");
        this._building = true;
        try {
            if (this._model == null) {
                return;
            }
            this._main = DisplayRegistry.getInstanceFor(this._model.getStyle());
            this._main.setId(this._model.getID());
            this._main.setConn(this.getConnection());
            this._main.setQuery(this._model.getQuery(this.getConnection()));
            this._main.setExtVales(this._model.getExtValues());
            this._main.addSelectionChangeListener(new SelectChanged());
            this._main.setType(this._model.getType());
            this._main.addActions(this._model.getActions());
            if (this._model.hasChildren()) {
                this.initTabbedPane();
                DisplayPanel displayPanel = null;
                for (DisplayModel displayModel : this._model.getChildren()) {
                    displayPanel = new DisplayPanel(displayModel, this);
                    this._children.add(displayPanel.getMainUI());
                    this._childPanels.add(displayPanel);
                    if (displayPanel.getMainUI() instanceof ISelectionChangeListener) {
                        this._main.addSelectionChangeListener((ISelectionChangeListener)((Object)displayPanel.getMainUI()));
                    }
                    this._tabbed.addTab(displayModel.getIcon(), displayModel.getName(), displayPanel);
                }
            } else {
                this.add((Component)this._main.getScrollableUI(), "Center");
            }
            boolean bl2 = true;
            for (MouseListener mouseListener : this._main.getUI().getMouseListeners()) {
                if (mouseListener != this.mouseListener) continue;
                bl2 = false;
            }
            if (bl2) {
                this._main.getUI().addMouseListener(this.mouseListener);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (this._model.getQuery(this.getConnection()) == null) {
            this.displayNoQuery();
            return;
        }
        if (this._model.getQueriesBindMap() != null) {
            this._main.setBindMap(this._model.getQueriesBindMap());
        } else if (this._parent == null && this._binds == null && !bl) {
            this.promptForBind(this._model.getQuery(this.getConnection()));
        } else if (this._binds != null) {
            this._main.setBindMap(this._binds);
        }
        this._main.setConnName(this._connName);
        if (!bl && this.renderDisplay) {
            this._main.refresh();
        }
        this._building = false;
    }

    public String getConnectionName() {
        return this._connName;
    }

    public void setConnectionName(String string) {
        this._connName = string;
    }

    private Component createSplitPane(Component component, Component component2) {
        this._sp = new JSplitPane(0);
        JScrollPane jScrollPane = new JScrollPane(component);
        if (component instanceof JTable) {
            jScrollPane.setRowHeaderView(((JTable)component).getTableHeader());
        }
        this._sp.setTopComponent(jScrollPane);
        this._sp.setDividerLocation(200);
        JScrollPane jScrollPane2 = new JScrollPane(component2);
        if (component2 instanceof JTable) {
            jScrollPane2.setRowHeaderView(((JTable)component2).getTableHeader());
        }
        this._sp.setBottomComponent(component2);
        return this._sp;
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean bl) {
        this.logger.finer("DisplayPanel.Refresh()");
        this.refresh(true, bl);
    }

    public void clear() {
        if (this._main != null) {
            this._main.clear();
        }
        for (IDisplay iDisplay : this._children) {
            iDisplay.clear();
        }
    }

    public void close() {
        if (this._main != null) {
            this._main.close();
        }
        for (IDisplay iDisplay : this._children) {
            iDisplay.close();
        }
        this._children.clear();
        if (this._sp != null && this._sp.getParent() != null) {
            this._sp.getParent().remove(this._sp);
        }
        if (this._main != null && this._main.getScrollableUI() != null && this._main.getScrollableUI().getParent() != null) {
            this._main.getScrollableUI().getParent().remove(this._main.getScrollableUI());
        }
        if (this._main != null && this._main.getUI().getParent() != null) {
            this._main.getUI().getParent().remove(this._main.getUI());
        }
    }

    public void displayNoQuery() {
        JLabel jLabel = new JLabel(Translate.translate((String)"No query found for version of the selected database."));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jLabel, null, (String)Translate.translate((String)"No Valid Query"), (int)1);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DisplayPanel.this.dlg.dispose();
            }
        });
        this.dlg.setSize(500, 150);
        this.dlg.setPreferredSize(500, 150);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void promptForBind(Query query) {
        if (query.getBinds().size() > 0) {
            this.renderDisplay = false;
            BindInfo bindInfo = new BindInfo(query);
            HelpSystem.getHelpSystem().registerTopic((JComponent)bindInfo, "f1_bindnulldefault_html");
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)bindInfo, null, (String)Translate.translate((String)"Enter Bind Values"), (int)14);
            this.dlg.setDefaultButton(8);
            this.dlg.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DisplayPanel.this.renderDisplay = true;
                    DisplayPanel.this.dlg.dispose();
                }
            });
            this.dlg.pack();
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
            this.dlg.setVisible(true);
        } else {
            this.renderDisplay = true;
        }
    }

    public void promptForBindsOnNextRun(boolean bl) {
        this._forceBindPrompt = bl;
    }

    public void refresh(boolean bl, boolean bl2) {
        this._force = bl2;
        this._detail = bl;
        this.logger.finer("DisplayPanel.Refresh(" + bl + "}");
        Query query = this.getModel().getQuery(this.getConnection());
        if (query == null && this._binds != null) {
            this.displayNoQuery();
            return;
        }
        if (this._parent == null && this._binds == null && this.prompt) {
            this.promptForBind(query);
            this._forceBindPrompt = false;
        }
        if (this._forceBindPrompt) {
            this.promptForBind(query);
            this._forceBindPrompt = false;
        }
        if (!this.renderDisplay) {
            return;
        }
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public Object doWork() {
                for (IDisplay iDisplay : DisplayPanel.this._children) {
                    boolean bl = true;
                    for (Container container = iDisplay.getUI(); container != null && bl && container.getParent() != null; container = container.getParent()) {
                        bl = container.isShowing();
                    }
                    if (!bl) continue;
                    boolean bl2 = true;
                    for (Bind bind : iDisplay.getQuery().getBinds()) {
                        if (DisplayPanel.this._binds == null || DisplayPanel.this._binds.containsKey(bind.getName())) continue;
                        bl2 = false;
                    }
                    if (DisplayPanel.this._binds != null) {
                        iDisplay.setBindMap(DisplayPanel.this._binds);
                    } else if (DisplayPanel.this._parent != null) {
                        iDisplay.setBindMap(DisplayPanel.this._parent.getMainUI().getBindMap());
                    }
                    if (!bl2) continue;
                    iDisplay.refresh(DisplayPanel.this._detail);
                    iDisplay.getUI().paintAll(iDisplay.getUI().getGraphics());
                }
                DisplayPanel.this._main.setConn(DisplayPanel.this.getConnection());
                DisplayPanel.this._main.setQuery(DisplayPanel.this._model.getQuery(DisplayPanel.this.getConnection()));
                if (DisplayPanel.this._binds != null) {
                    DisplayPanel.this._main.setBindMap(DisplayPanel.this._binds);
                } else if (DisplayPanel.this._parent == null) {
                    DisplayPanel.this._main.setBindMap(DisplayPanel.this._model.getQuery(DisplayPanel.this.getConnection()).getBindValues());
                } else {
                    DisplayPanel.this._main.setBindMap(DisplayPanel.this._parent.getMainUI().getBindMap());
                }
                DisplayPanel.this._main.refresh(DisplayPanel.this._force);
                return null;
            }

            public void cancel() {
            }

            public void finish(Object object) {
            }

            public void preWork() {
            }
        };
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Loading Results", "", 500, iDelayedProgressRunnable, null);
        delayedProgressRunnable.start();
    }

    public DisplayPanel getParentPanel() {
        return this._parent;
    }

    public void setParentPanel(DisplayPanel displayPanel) {
        this._parent = displayPanel;
    }

    public Component getFocusedComponent() {
        return this.getFocusedComponent(this);
    }

    public Component getFocusedComponent(Component component) {
        Component component2 = null;
        if (component.hasFocus()) {
            component2 = component;
        } else if (component instanceof Container) {
            for (int i = 0; component2 == null && i < ((Container)component).getComponentCount(); ++i) {
                component2 = this.getFocusedComponent(((Container)component).getComponent(i));
            }
        }
        return component2;
    }

    private class SelectChanged
    implements ISelectionChangeListener {
        private SelectChanged() {
        }

        public void parentSelectionChanged() {
            DisplayPanel.this.setChildBinds(DisplayPanel.this._main.getBinds(null));
            for (IDisplay iDisplay : DisplayPanel.this._children) {
                iDisplay.setConn(DisplayPanel.this.getConnection());
                iDisplay.setBindMap(DisplayPanel.this._main.getBinds(null));
                iDisplay.setDirty(true);
                if (!iDisplay.getUI().isShowing()) continue;
                iDisplay.refresh(true);
            }
        }
    }
}

