/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.proformatter.ProFormatOptions;
import oracle.dbtools.proformatter.SQLFormatCommand;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayCodeEditor
extends DisplayAdapter {
    private BasicEditorPane _codeArea;
    private JScrollPane _spSql;

    @Override
    public BasicEditorPane getCodeEditor() {
        return this._codeArea;
    }

    public void init() {
        if (this._codeArea == null) {
            this._codeArea = EditorFactory.createIdeEditorPane();
            this._codeArea.setText("");
            this._codeArea.setDocument((Document)new BasicDocument("foo.plsql"));
            final LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
            HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin();
            this._codeArea.installPlugin((EditorPlugin)lineGutterPlugin);
            this._codeArea.installPlugin((EditorPlugin)highlightEditorPlugin);
            this._codeArea.setText("");
            this._codeArea.setEditable(false);
            this._spSql = new JScrollPane((Component)this._codeArea, 22, 32);
            this._spSql.setRowHeaderView((Component)lineGutterPlugin);
            final JPopupMenu jPopupMenu = new JPopupMenu("Context Menu");
            JMenuItem jMenuItem = new JMenuItem("Toggle Line Numbers");
            jPopupMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            lineGutterPlugin.addGutterClickListener(new GutterClickListener(){

                public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
                    gutter.hashCode();
                    jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                }
            });
            this._spSql.getRowHeader().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        jPopupMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(boolean bl) {
        Object object;
        Object object2;
        Object object3;
        this.init();
        DBConfig dBConfig = DBConfig.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        ResultSet resultSet = null;
        if (this.getConnection() == null) {
            return;
        }
        Object object4 = this.getConnection();
        synchronized (object4) {
            try {
                object3 = this._query.getCols();
                this._codeArea.getDocument().remove(0, this._codeArea.getDocument().getLength());
                resultSet = DBUtil.getInstance().executeQuery(this.getConnName(), this.getQuery().getSql(), this.getBindMap());
                while (resultSet.next()) {
                    if (object3 != null && object3.size() > 0) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (Column)object2.next();
                            stringBuilder.append(resultSet.getString(object.getName()));
                        }
                        continue;
                    }
                    stringBuilder.append(resultSet.getString(1));
                }
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    ExceptionHandler.handleException((Exception)exception);
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        object3 = resultSet.getStatement();
                        resultSet.close();
                        if (object3 != null) {
                            object3.close();
                        }
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        this._codeArea.setEditable(true);
        if (stringBuilder.length() == 0) {
            this._codeArea.setText("NO TEXT AVAILABLE");
            this._codeArea.setBackground(Color.GRAY);
        } else {
            this._codeArea.setBackground(Color.WHITE);
            if (dBConfig.getBoolean("AUTO_READONLY_FORMAT").booleanValue()) {
                object4 = null;
                object3 = Preferences.getPreferences();
                object2 = ConfigProFormat.getInstance((PropertyStorage)object3);
                if (object2 != null && (object4 = ((ConfigProFormat)((Object)object2)).getAdvancedFormatOptions()) == null) {
                    object4 = new ProFormatOptions();
                }
                ((ProFormatOptions)object4).setSQLPlus(false);
                object = new SQLFormatCommand();
                String string = ((SQLFormatCommand)((Object)object)).reallyDoIt(stringBuilder.toString(), (ProFormatOptions)object4);
                this._codeArea.setText(string);
            } else {
                this._codeArea.setText(stringBuilder.toString());
            }
        }
        this._codeArea.setEditable(false);
    }

    @Override
    public void addActions(final ArrayList<ObjectAction> arrayList) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 2) {
                    ContextMenu contextMenu = new ContextMenu();
                    for (ObjectAction objectAction : arrayList) {
                        contextMenu.add((Component)objectAction.getMenuItem());
                    }
                    Context context = new Context();
                    context.setEvent((EventObject)mouseEvent);
                    contextMenu.show(context);
                }
            }
        };
        this.init();
        this._codeArea.addMouseListener((MouseListener)mouseAdapter);
    }

    @Override
    public void clear() {
        this._codeArea.setEditable(true);
        this._codeArea.setText("heloo");
        try {
            this._codeArea.getDocument().remove(0, this._codeArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
        this._codeArea.setEditable(false);
    }
}

