/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Point;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisplayAdapter
implements IDisplay {
    protected Query _query;
    protected String _connName;
    protected JScrollPane _sp;
    private HashMap<String, Object> _bindMap;
    protected boolean _dirty = false;
    private HashMap<String, String> _extVales;
    private ArrayList<ISelectionChangeListener> _listeners = null;
    private String _type;
    private String _id;

    @Override
    public void setId(String string) {
        this._id = string;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void addSelectionChangeListener(ISelectionChangeListener iSelectionChangeListener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(iSelectionChangeListener);
    }

    public void fireSelectionChanged() {
        if (this._listeners != null) {
            for (ISelectionChangeListener iSelectionChangeListener : this._listeners) {
                iSelectionChangeListener.parentSelectionChanged();
            }
        }
    }

    @Override
    public HashMap<String, String> getExtVales() {
        return this._extVales;
    }

    @Override
    public void setExtVales(HashMap<String, String> hashMap) {
        this._extVales = hashMap;
    }

    @Override
    public JComponent getScrollableUI() {
        if (this._sp == null) {
            this._sp = new JScrollPane(this.getUI());
        }
        return this._sp;
    }

    @Override
    public void setBindMap(HashMap<String, Object> hashMap) {
        if (hashMap != null) {
            if (this._bindMap == null) {
                this._bindMap = new HashMap();
            }
            for (String string : hashMap.keySet()) {
                if (this._bindMap != null && ModelUtil.areEqual((Object)this._bindMap.get(string), (Object)hashMap.get(string))) continue;
                this._dirty = true;
                this._bindMap.putAll(hashMap);
            }
        }
    }

    @Override
    public HashMap<String, Object> getBindMap() {
        HashMap hashMap = this._query.getBindValues();
        if (this._bindMap != null) {
            hashMap.putAll(this._bindMap);
        }
        return hashMap;
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    @Override
    public void populateToolBar(Toolbar toolbar) {
    }

    @Override
    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    @Override
    public void setConn(Connection connection) {
        if (!ModelUtil.areEqual((Object)this.getConnection(), (Object)connection)) {
            this._connName = Connections.getInstance().getConnectionName(connection);
            this._dirty = true;
        }
    }

    @Override
    public void setConnName(String string) {
        if (!ModelUtil.areEqual((Object)this._connName, (Object)string)) {
            this._connName = string;
            this._dirty = true;
        }
    }

    public String getConnName() {
        return this._connName;
    }

    public Connection getConnection() {
        Connection connection = null;
        try {
            if (this._connName != null) {
                connection = Connections.getInstance().getConnection(this._connName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    @Override
    public HashMap<String, Object> getBinds(Point point) {
        return null;
    }

    @Override
    public void setDirty(boolean bl) {
        this._dirty = bl;
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public void close() {
    }

    @Override
    public void setType(String string) {
        this._type = string;
    }

    @Override
    public String getType() {
        return this._type;
    }

    public BasicEditorPane getCodeEditor() {
        return null;
    }
}

