/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.diff;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.controls.diff.DiffArb;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabase;

public class SourceSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    public OracleConnectionComboBox _dbComboBox;
    private OracleDatabase _db;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private JScrollPane _sp;

    public SourceSelector() {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_diffsource_html");
        this.setLayout(new SpringLayout());
        String string = null;
        if (EditorManager.getEditorManager().getCurrentEditor() instanceof IDBEditor && ((IDBEditor)EditorManager.getEditorManager().getCurrentEditor()).getDatabase() != null) {
            string = Connections.getInstance().getConnectionName(((IDBEditor)EditorManager.getEditorManager().getCurrentEditor()).getDatabase());
        }
        this.add(new JLabel(DiffArb.getString(6)));
        this._dbComboBox = new OracleConnectionComboBox();
        this.add(this._dbComboBox.getJComboBox());
        this.add(new JLabel(DiffArb.getString(7)));
        this._sp = new JScrollPane();
        this._sp.setMinimumSize(new Dimension(200, 200));
        this.add(this._sp);
        this._dbComboBox.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        SourceSelector.this._db = (OracleDatabase)SourceSelector.this._dbComboBox.getCurrentDatabase();
                        SourceSelector.this.initTree();
                    }
                    catch (DBException dBException) {
                        DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
                        ExceptionHandler.handleException((Exception)((Object)dBException2));
                    }
                }
            }
        });
        if (string != null) {
            this._dbComboBox.setCurrentConnection(string);
        } else {
            this._dbComboBox.getJComboBox().setSelectedIndex(-1);
        }
        SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 0, 2);
    }

    public CustomJTree getTree() {
        return this._tree;
    }

    public OracleDatabase getDatabase() {
        return this._db;
    }

    private void initTree() {
        if (this._root == null) {
            this._root = this.createCheck("Objects", "MY", false, false);
        } else {
            this._root.removeAllChildren();
        }
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this.addTypes((JMutableTreeNode)this._root);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                try {
                    SourceSelector.this.populateChildren((JMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent(), treeExpansionEvent.getSource());
                    ((JMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).sortChildren();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this._sp.setViewportView((Component)this._tree);
    }

    private JMutableTreeNode createCheck(String string, String string2, boolean bl, boolean bl2) {
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        jTreeCellData.setCheckBoxEnabled(bl);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setHasCheckBox(bl);
        jTreeCellData.setUserObject((Object)string2);
        jTreeCellData.setCheckBoxState(bl2);
        return new JMutableTreeNode(jTreeCellData);
    }

    private JMutableTreeNode createCheck(String string, String string2, boolean bl) {
        return this.createCheck(string, string2, true, bl);
    }

    private void addTypes(JMutableTreeNode jMutableTreeNode) {
        JMutableTreeNode jMutableTreeNode2 = null;
        if (this._db != null) {
            for (String string : this._db.listObjectTypes()) {
                if (!string.equals("VIEW") && !string.equals("PROCEDURE") && !string.equals("PACKAGE") && !string.equals("MATERIALIZED VIEW") && !string.equals("FUNCTION") && !string.equals("TABLE")) continue;
                jMutableTreeNode2 = this.createCheck(string, "OBJECT_TYPE", false);
                jMutableTreeNode2.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
                ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    public Schema getSchema(JMutableTreeNode jMutableTreeNode) throws DBException {
        Database database = this._dbComboBox.getCurrentDatabase();
        return database.getSchema(database.getUserName());
    }

    public String getType(JMutableTreeNode jMutableTreeNode) throws DBException {
        String string = null;
        for (int i = jMutableTreeNode.getPath().length - 1; string == null && i > -1; --i) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getPath()[i];
            if (((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject() == null) continue;
            String string2 = (String)((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject();
            if (string2.equals("OBJECT_TYPE")) {
                string = ((JTreeCellData)jMutableTreeNode2.getUserObject()).getText();
                continue;
            }
            if (!string2.equals("SCHEMA") && !string2.equals("MY")) continue;
            string = "SCHEMA";
        }
        return string;
    }

    protected void populateChildren(JMutableTreeNode jMutableTreeNode, Object object) throws Exception {
        JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)((DefaultTreeModel)this._tree.getModel()).getChild(jMutableTreeNode, 0);
        boolean bl = ((JTreeCellData)((JMutableTreeNode)jMutableTreeNode2.getParent()).getUserObject()).getCheckBoxState() == TriStateBoolean.TRUE;
        String string = ((JTreeCellData)jMutableTreeNode2.getUserObject()).getText();
        if (string != null && string.equals("Loading....")) {
            ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent((MutableTreeNode)jMutableTreeNode2);
            String string2 = (String)((JTreeCellData)jMutableTreeNode.getUserObject()).getUserObject();
            Schema schema = this.getSchema(jMutableTreeNode);
            if (this._db == null) {
                this._db = (OracleDatabase)this._dbComboBox.getCurrentDatabase();
            }
            if (string2.equals("MY")) {
                this.addTypes(jMutableTreeNode);
            } else if (string2.equals("OTHERS")) {
                for (Schema schema2 : this._db.listSchemas()) {
                    if (this._db.getDefaultSchema().equals((Object)schema2)) continue;
                    JMutableTreeNode jMutableTreeNode3 = this.createCheck(schema2.toString(), "SCHEMA", bl);
                    ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode3, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
                    this.addTypes(jMutableTreeNode3);
                }
            } else {
                string2 = this.getType(jMutableTreeNode);
                String[] stringArray = this._db.listObjects(string2, schema);
                if (stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        JMutableTreeNode jMutableTreeNode4 = this.createCheck(stringArray[i], string2, bl);
                        ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode4, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
                    }
                }
            }
            this._tree.expandPath(this._tree.getSelectionPath());
        }
    }

    public void reset() {
        this.initTree();
    }
}

