/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.net.URLFactory;
import oracle.ide.xml.XMLUtil;

public class ResultSetTablePersistedSettings {
    private int[] m_hiddenColumns;
    private int[] m_columnWidths;
    private String orderByClause;
    private List m_columnPositions;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"Table-attributes");
    private static final String ROOT_TAG = "TableSettings";

    public void setColumnPositions(List list) {
        this.m_columnPositions = list;
    }

    public List getColumnPositions() {
        return this.m_columnPositions;
    }

    public int[] getHiddenColumns() {
        return this.m_hiddenColumns;
    }

    public void setHiddenColumns(int[] nArray) {
        this.m_hiddenColumns = nArray;
    }

    public int[] getColumnWidths() {
        return this.m_columnWidths;
    }

    public void setColumnWidths(int[] nArray) {
        this.m_columnWidths = nArray;
    }

    public boolean isSorted() {
        return this.orderByClause != null && this.orderByClause.length() > 0;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String string) {
        this.orderByClause = string;
    }

    public static URL getPersistedSettingsURL(String string) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        if (extensionRegistry.findExtension("oracle.sqldeveloper") != null) {
            URL uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper");
            if (string != null) {
                return URLFactory.newURL((URL)uRL, (String)(string.hashCode() + "TableSettings.xml"));
            }
        }
        return null;
    }

    public static ResultSetTablePersistedSettings loadPersistedSettings(String string) {
        ResultSetTablePersistedSettings resultSetTablePersistedSettings = null;
        try {
            URL uRL = ResultSetTablePersistedSettings.getPersistedSettingsURL(string);
            if (uRL != null) {
                Object2Dom object2Dom = Object2Dom.newInstance();
                resultSetTablePersistedSettings = (ResultSetTablePersistedSettings)object2Dom.toObject(uRL);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Object2DomException object2DomException) {
        }
        catch (Exception exception) {
            Logger.getLogger(ResultSetTablePersistedSettings.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return resultSetTablePersistedSettings;
    }

    public void savePersistentSettings(String string) {
        final ResultSetTablePersistedSettings resultSetTablePersistedSettings = this;
        final URL uRL = ResultSetTablePersistedSettings.getPersistedSettingsURL(string);
        final Object2Dom object2Dom = Object2Dom.newInstance();
        object2Dom.setNamespaceURI(NAMESPACE_URI);
        NamedSwingWorker namedSwingWorker = new NamedSwingWorker("SaveSettings"){

            public Object construct() {
                try {
                    if (uRL != null) {
                        object2Dom.toDocument((Object)resultSetTablePersistedSettings, ResultSetTablePersistedSettings.ROOT_TAG, uRL);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                return this;
            }
        };
        namedSwingWorker.start();
    }
}

