/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.ColumnAutoSize;
import oracle.dbtools.raptor.controls.IResultSetTableDrillDown;
import oracle.dbtools.raptor.controls.ResultSetTablePersistedSettings;
import oracle.dbtools.raptor.controls.celleditor.RSTableEditorJPanel;
import oracle.dbtools.raptor.controls.cellrenderers.DefaultCellRenderer;
import oracle.dbtools.raptor.controls.table.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.controls.table.RSTableHeaderMenu;
import oracle.dbtools.raptor.controls.table.ResultsSetTableContextMenu;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableColumnModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.db.Database;
import oracle.javatools.util.SwingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static IResultSetTableDrillDown _drillDown;
    private static final int ROW_NUMBER_WIDTH = 45;
    private static final int ROW_HEIGHT = 20;
    private String _sql;
    private JTable _rowHeader;
    protected Object LOCK = new Object();
    private volatile NamedSwingWorker _worker;
    private ResultSetTablePersistenceInvoker persistenceInvoker = new ResultSetTablePersistenceInvoker();
    private KeyNavigationManager _knm;
    private CopyableResultSetTableAdapter _copyAdapter;
    private String _defaultExportName;
    private boolean _translatedColNames = true;
    private boolean _threaded = true;
    private boolean _verticalDisplay = false;
    private List<String> _skipCols;
    private KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
    private KeyStroke copyWithHeader = KeyStroke.getKeyStroke(67, 3, false);
    private KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
    private KeyStroke fetchAll = KeyStroke.getKeyStroke(34, 2, false);
    private KeyStroke fetchEndAll = KeyStroke.getKeyStroke(35, 2, false);
    private final KeyStroke tabKeyStroke = KeyStroke.getKeyStroke(9, 0);
    protected ResultSetInvalidEventHandler _resultSetInvalidEventHandler;
    protected int _lastSelectedRow = -1;
    protected int _lastSelectedCol = -1;
    private DBObject _dbObject;
    private ResultSetTableModel _tmpModel;
    private ActionListener _copyListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().compareTo("Copy") == 0) {
                ResultSetTable.this._copyAdapter.setNullString("");
                ResultSetTable.this._copyAdapter.copyToClipboard();
            } else if (actionEvent.getActionCommand().compareTo("Paste") == 0) {
                ResultSetTable.this._copyAdapter.setNullString("");
                ResultSetTable.this._copyAdapter.pasteToJTable();
            } else if (actionEvent.getActionCommand().compareTo("Copy.With.Header") == 0) {
                ResultSetTable.this._copyAdapter.setNullString("");
                ResultSetTable.this._copyAdapter.copyToClipboard(false, true);
            }
        }
    };

    public ResultSetTableModel getMdl() {
        TableModel tableModel = this.getModel();
        return tableModel instanceof ResultSetTableModel ? (ResultSetTableModel)tableModel : null;
    }

    public ResultSetTable() {
        this(true);
    }

    public ResultSetTable(boolean bl) {
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.setColumnModel(new ResultSetTableColumnModel(this));
        this.setAutoResizeMode(0);
        this.getTableHeader().setAutoscrolls(true);
        this.setDragEnabled(true);
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                ResultSetTable.this.autoScrollColumn(mouseEvent.getPoint());
            }
        });
        this.setDefaultRenderer(TableColumn.class, new DefaultCellRenderer());
        this.setSurrendersFocusOnKeystroke(true);
        if (bl) {
            ResultsSetTableContextMenu.attachMenu(this);
            ResultsSetTableContextMenu.attachMenu(this.getTableHeader());
        }
        this.setAutoCreateColumnsFromModel(true);
        this.getTableHeader().addMouseListener(new ColumnAutoSize());
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getSource() instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    JTable jTable = jTableHeader.getTable();
                    if (jTable.isEditing()) {
                        jTable.getCellEditor().cancelCellEditing();
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        int n;
                        int n2 = jTableHeader.getResizingColumn() != null ? jTableHeader.getResizingColumn().getModelIndex() : -1;
                        TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                        int n3 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                        if (n3 != -1 && (n = tableColumnModel.getColumn(n3).getModelIndex()) != -1 && n2 == -1) {
                            ResultSetTable.this.headerSortClicked(n3);
                        }
                    } else if (mouseEvent.getClickCount() == 1) {
                        ResultSetTable.this.setCellSelectionEnabled(false);
                        ResultSetTable.this.setColumnSelectionAllowed(true);
                        ResultSetTable.this.setRowSelectionAllowed(false);
                        RSTableHeaderMenu.select(ResultSetTable.this.getColumnModel().getSelectionModel(), mouseEvent, ResultSetTable.this.columnAtPoint(mouseEvent.getPoint()));
                        ResultSetTable.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.getTableHeader().addMouseListener(this.persistenceInvoker);
        this.getColumnModel().addColumnModelListener(this.persistenceInvoker);
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this._knm = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TableKeyAdapter((JTable)this));
        this.registerKeyboardAction(this._copyListener, "Copy", this.copy, 0);
        this.registerKeyboardAction(this._copyListener, "Copy.With.Header", this.copyWithHeader, 0);
        this.registerKeyboardAction(this._copyListener, "Paste", this.paste, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchAll, 0);
        this.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTable.this.fetchAll();
            }
        }, "FetchAll", this.fetchEndAll, 0);
        this._copyAdapter = new CopyableResultSetTableAdapter(this);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ResultSetTable.this.processDoubleClick();
                }
            }
        });
    }

    public void processDoubleClick() {
        if (_drillDown != null && this.getModel() instanceof ResultSetTableModel) {
            ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.getModel();
            int n = this.getSelectionModel().getAnchorSelectionIndex();
            if (n > -1 && resultSetTableModel.getDrillUrls().size() > n) {
                URL uRL = resultSetTableModel.getDrillUrls().get(n).getUrl();
                String string = resultSetTableModel.getDrillUrls().get(n).getRow();
                DatabaseNode databaseNode = null;
                try {
                    databaseNode = DatabaseNavigatorElementFactory.getObjectNode(uRL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (databaseNode != null) {
                    _drillDown.performDrill(databaseNode, string);
                }
            }
        }
    }

    public boolean isColSortable(int n) {
        boolean bl = false;
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this.getModel();
        if (resultSetTableModel.getColNameOccurance() != null) {
            for (Integer object : resultSetTableModel.getColNameOccurance().values()) {
                if (object <= 1) continue;
                return false;
            }
        }
        int n2 = resultSetTableModel.getType(n);
        if (this._sql != null && !this._verticalDisplay) {
            switch (n2) {
                case 12: {
                    try {
                        Object exception = resultSetTableModel.getValueAt(0, n + 1);
                        if (exception != null && exception.toString().indexOf("SQLDEV:") == 0) {
                            bl = false;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                case -13: 
                case -10: 
                case -7: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 1111: 
                case 2000: 
                case 2002: 
                case 2003: 
                case 2004: 
                case 2005: 
                case 2006: 
                case 2007: 
                case 2008: {
                    ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(resultSetTableModel.getConnName(), resultSetTableModel.getConnection());
                    if (connectionTypeDetails == null) {
                        bl = false;
                        break;
                    }
                    return connectionTypeDetails.isColumnTypeSortable(n2);
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private ResultSetTableModel resetModel() {
        ResultSetTableModel resultSetTableModel = null;
        if (this.getModel() != null && this.getModel() instanceof ResultSetTableModel) {
            resultSetTableModel = (ResultSetTableModel)this.getModel();
            resultSetTableModel.close();
            resultSetTableModel = new ResultSetTableModel();
        } else {
            resultSetTableModel = new ResultSetTableModel();
        }
        return resultSetTableModel;
    }

    private ResultSetTableModel resetModel2() {
        ResultSetTableModel resultSetTableModel = null;
        if (this.getModel() != null && this.getModel() instanceof ResultSetTableModel) {
            resultSetTableModel = (ResultSetTableModel)this.getModel();
            resultSetTableModel.close();
        } else {
            resultSetTableModel = new ResultSetTableModel();
        }
        return resultSetTableModel;
    }

    public void headerSortClicked(int n) {
        if (!(this.getModel() instanceof EditableResultSetTableModel) && this.getModel() instanceof ResultSetTableModel && this.isColSortable(n)) {
            final int n2 = ((ResultSetTableModel)this.getModel()).getLoadedCount();
            final ResultSetTableModel resultSetTableModel = this.resetModel2();
            resultSetTableModel.setTranslatedColNames(this._translatedColNames);
            resultSetTableModel.setThreaded(this.isThreaded());
            resultSetTableModel.setVerticalDisplay(this._verticalDisplay);
            resultSetTableModel.setSkipCols(this._skipCols);
            resultSetTableModel.setSortCol(this.convertColumnIndexToModel(n));
            ProgressRunnable progressRunnable = new ProgressRunnable(){

                protected Object doWork() throws Exception {
                    resultSetTableModel.open(n2);
                    return null;
                }
            };
            if (!this.isThreaded()) {
                progressRunnable.setTitle("Sorting");
                try {
                    SwingUtilities.invokeLater((Runnable)progressRunnable);
                }
                catch (Exception exception) {}
            } else {
                resultSetTableModel.open(n2);
            }
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        tableColumn.setHeaderRenderer(ColumnHeaderCellRenderer.INSTANCE);
        super.addColumn(tableColumn);
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(keyEvent);
        }
        super.processKeyEvent(keyEvent);
        if (this._knm != null) {
            this._knm.postProcessKeyEvent(keyEvent);
        }
    }

    public void setDefaultExportName(String string) {
        this._defaultExportName = string;
    }

    public String getDefaultExportName() {
        return this._defaultExportName;
    }

    public void refresh() {
        final TableModel tableModel = this.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            ((ResultSetTableModel)tableModel).refresh();
            SwingUtils.invokeAfterRepaint((Runnable)new Runnable(){

                public void run() {
                    ((ResultSetTableModel)tableModel).fireTableStructureChanged();
                    if (ResultSetTable.this.getModel() != null) {
                        ResultSetTable.this.applyPersistentSettings();
                    }
                }
            });
        }
    }

    private static void invokeAfterRepaint(final Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtils.invokeAfterRepaint((Runnable)runnable);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SwingUtils.invokeAfterRepaint((Runnable)runnable);
                }
            });
        }
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.setModel(tableModel, false);
    }

    public void setModel(final TableModel tableModel, final boolean bl) {
        TableModel tableModel2 = this.getModel();
        if (tableModel2 != tableModel && tableModel2 instanceof ResultSetTableModel) {
            ((ResultSetTableModel)tableModel2).close();
        }
        ResultSetTable.invokeAfterRepaint(new Runnable(){

            public void run() {
                ResultSetTable.super.setModel(tableModel);
                if (tableModel instanceof ResultSetTableModel && ((ResultSetTableModel)tableModel).getConnection() != null) {
                    if (!(tableModel instanceof EditableResultSetTableModel) && !bl) {
                        ((ResultSetTableModel)tableModel).open();
                    }
                    ((ResultSetTableModel)tableModel).fireTableStructureChanged();
                    if (ResultSetTable.this._rowHeader != null) {
                        ResultSetTable.this._rowHeader.setModel(tableModel);
                    }
                }
            }
        });
        if (this._sql != null && tableModel instanceof ResultSetTableModel) {
            this._sql = ((ResultSetTableModel)tableModel).getSQL();
            if (this._sql != null) {
                ResultSetTable.invokeAfterRepaint(new Runnable(){

                    public void run() {
                        if (ResultSetTable.this.getModel() != null) {
                            ResultSetTable.this.applyPersistentSettings();
                        }
                    }
                });
            }
        }
    }

    public void setQuery(Connection connection, ResultSet resultSet, String string, Map map) {
        ResultSetTableModel resultSetTableModel = this.resetModel();
        resultSetTableModel.setResultSet(resultSet);
        resultSetTableModel.setConn(connection);
        if (string != null) {
            resultSetTableModel.setSql(string);
        }
        this._sql = string;
        resultSetTableModel.setBindMap(map);
        resultSetTableModel.setTranslatedColNames(this._translatedColNames);
        resultSetTableModel.setThreaded(this.isThreaded());
        resultSetTableModel.setVerticalDisplay(this._verticalDisplay);
        resultSetTableModel.setSkipCols(this._skipCols);
        resultSetTableModel.setSortCol(-1);
        this.setModel(resultSetTableModel);
    }

    public void cancel() {
        if (this._tmpModel != null) {
            this._tmpModel.cancelStmt();
        }
        if (this.getModel() instanceof ResultSetTableModel) {
            ((ResultSetTableModel)this.getModel()).cancelStmt();
        }
    }

    public void setQuery(Connection connection, ResultSet resultSet, String string, Map map, int n, int n2, boolean bl) {
        ResultSetTableModel resultSetTableModel;
        this._tmpModel = resultSetTableModel = this.resetModel();
        resultSetTableModel.setConn(connection);
        resultSetTableModel.setSql(string);
        this._sql = string;
        resultSetTableModel.setBindMap(map);
        resultSetTableModel.setTranslatedColNames(this._translatedColNames);
        resultSetTableModel.setThreaded(this.isThreaded());
        resultSetTableModel.setVerticalDisplay(this._verticalDisplay);
        resultSetTableModel.setSkipCols(this._skipCols);
        resultSetTableModel.setSortCol(-1);
        resultSetTableModel.setLine(n);
        resultSetTableModel.setCol(n2);
        if (bl) {
            resultSetTableModel.open();
        }
        this.setModel(resultSetTableModel, bl);
        this._tmpModel = null;
    }

    public void setQuery(Connection connection, ResultSet resultSet, String string) {
        this.setQuery(connection, resultSet, string, (Map)null);
    }

    public void setQuery(Connection connection, ResultSet resultSet, String string, List list) {
        ResultSetTableModel resultSetTableModel = this.getModel() != null && this.getModel() instanceof ResultSetTableModel ? (ResultSetTableModel)this.getModel() : new ResultSetTableModel();
        resultSetTableModel.setConn(connection);
        resultSetTableModel.setSql(string);
        this._sql = string;
        resultSetTableModel.setBindList(list);
        resultSetTableModel.setTranslatedColNames(this._translatedColNames);
        resultSetTableModel.setThreaded(this.isThreaded());
        resultSetTableModel.setSkipCols(this._skipCols);
        resultSetTableModel.setVerticalDisplay(this._verticalDisplay);
        resultSetTableModel.setSortCol(-1);
        this.setModel(resultSetTableModel);
    }

    public DBObject getDBObject() {
        return this._dbObject;
    }

    public void setQuery(Connection connection, ResultSet resultSet, String string, boolean bl, Database database, DBObject dBObject) {
        this._dbObject = dBObject;
        if (bl) {
            EditableResultSetTableModel editableResultSetTableModel = new EditableResultSetTableModel(connection, resultSet, string, database, dBObject);
            this._sql = string;
            this.setModel(editableResultSetTableModel);
        } else {
            this.setQuery(connection, resultSet, string);
        }
    }

    public JTable getRowHeader() {
        if (this._rowHeader == null) {
            this._rowHeader = new JTable();
            this._rowHeader.setRowHeight(20);
            this._rowHeader.setColumnModel(new RowHeaderTableColumnModel());
            this._rowHeader.setModel(this.getModel() == null ? new ResultSetTableModel() : this.getModel());
            this._rowHeader.setSelectionModel(this.getSelectionModel());
            this._rowHeader.setAutoResizeMode(0);
            this._rowHeader.setColumnSelectionAllowed(false);
            this._rowHeader.setCellSelectionEnabled(false);
            this._rowHeader.setSelectionBackground(this._rowHeader.getBackground());
            this._rowHeader.setMaximumSize(new Dimension(45, Integer.MAX_VALUE));
            this._rowHeader.addHierarchyListener(new HierarchyListener(){
                private JViewport view;
                private ChangeListener cl = new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        for (Container container = ResultSetTable.this.getParent(); container != null; container = container.getParent()) {
                            if (!(container instanceof JViewport)) continue;
                            JViewport jViewport = (JViewport)container;
                            Point point = ((JViewport)changeEvent.getSource()).getViewPosition();
                            Point point2 = jViewport.getViewPosition();
                            if (point.y == point2.y) break;
                            point2.y = point.y;
                            jViewport.setViewPosition(point2);
                            break;
                        }
                    }
                };

                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    for (Container container = ResultSetTable.this._rowHeader.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof JViewport)) continue;
                        if (this.view == container) break;
                        if (this.view != null) {
                            this.view.removeChangeListener(this.cl);
                        }
                        this.view = (JViewport)container;
                        this.view.setPreferredSize(ResultSetTable.this._rowHeader.getMaximumSize());
                        this.view.addChangeListener(this.cl);
                        break;
                    }
                }
            });
            this._rowHeader.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchAll, 0);
            this._rowHeader.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ResultSetTable.this.fetchAll();
                }
            }, "FetchAll", this.fetchEndAll, 0);
        }
        this._rowHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ResultSetTable.this.setColumnSelectionAllowed(false);
                ResultSetTable.this.setRowSelectionAllowed(true);
                RSTableHeaderMenu.select(ResultSetTable.this.getSelectionModel(), mouseEvent, ResultSetTable.this.rowAtPoint(mouseEvent.getPoint()));
                ResultSetTable.this.requestFocusInWindow();
            }
        });
        return this._rowHeader;
    }

    public void closeModel() {
        this._sql = null;
        this.setModel(new DefaultTableModel());
    }

    public void fetchAll() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof ResultSetTableModel) {
            final ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
            final boolean bl = resultSetTableModel.getThreaded();
            resultSetTableModel.setThreaded(true);
            resultSetTableModel.fetchAll();
            Runnable runnable = new Runnable(){
                int lastScroll = 0;

                public void run() {
                    resultSetTableModel.setThreaded(bl);
                    if (this.lastScroll != resultSetTableModel.getLoadedCount()) {
                        ResultSetTable.this.scrollToRow(resultSetTableModel.getLoadedCount());
                        this.lastScroll = resultSetTableModel.getLoadedCount();
                    }
                    if (!resultSetTableModel.allFetched()) {
                        SwingUtilities.invokeLater(this);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void scrollToRow(int n) {
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, 0, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        jViewport.scrollRectToVisible(rectangle);
    }

    public void autoScrollColumn(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x, point.y, 0, 0);
            this.scrollRectToVisible(rectangle3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectAll() {
        Object object = this.LOCK;
        synchronized (object) {
            this._worker = new NamedSwingWorker("SelectAll"){

                public Object construct() {
                    Ide.getMainWindow().setCursor(new Cursor(3));
                    TableModel tableModel = ResultSetTable.this.getModel();
                    if (tableModel instanceof ResultSetTableModel) {
                        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)tableModel;
                        resultSetTableModel.fetchAll();
                    }
                    return this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    ResultSetTable.this.superSelectAll();
                    Ide.getMainWindow().setCursor(new Cursor(0));
                    Object object = ResultSetTable.this.LOCK;
                    synchronized (object) {
                        ResultSetTable.this._worker = null;
                    }
                }
            };
            this._worker.start();
        }
    }

    private void superSelectAll() {
        super.selectAll();
    }

    protected void savePersistentSettings() {
        ResultSetTablePersistedSettings resultSetTablePersistedSettings = this.getPersistentSettings();
        resultSetTablePersistedSettings.savePersistentSettings(this._sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDefaultSettings() {
        Object object = this.LOCK;
        synchronized (object) {
            ColumnAutoSize.autoResizeTable(this, ColumnAutoSize.AUTO_FIT_OPTIMUM);
        }
    }

    int getRequiredColumnWidth(TableColumn tableColumn) {
        int n = this.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
        int n2 = (int)this.getDefaultRenderer(tableColumn.getClass()).getTableCellRendererComponent(this, tableColumn.getIdentifier(), false, false, -1, n).getPreferredSize().getWidth();
        int n3 = this.getModel() instanceof ResultSetTableModel ? ((ResultSetTableModel)this.getModel()).getLoadedCount() : this.getRowCount();
        for (int i = 0; i < n3; ++i) {
            if (n >= this.getColumnCount()) continue;
            int n4 = (int)this.getCellRenderer(i, n).getTableCellRendererComponent(this, this.getValueAt(i, n), false, false, i, n).getPreferredSize().getWidth();
            n2 = Math.max(n2, n4);
        }
        if (n2 > 200) {
            n2 = 200;
        }
        return n2;
    }

    protected void applyPersistentSettings() {
        ResultSetTablePersistedSettings resultSetTablePersistedSettings = ResultSetTablePersistedSettings.loadPersistedSettings(this._sql);
        if (resultSetTablePersistedSettings != null) {
            this.setPersistentSettings(resultSetTablePersistedSettings);
        } else {
            this.applyDefaultSettings();
        }
    }

    protected ResultSetTablePersistedSettings getPersistentSettings() {
        Object object;
        int n;
        ResultSetTablePersistedSettings resultSetTablePersistedSettings = new ResultSetTablePersistedSettings();
        int[] nArray = new int[this.getModel().getColumnCount()];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < this.getModel().getColumnCount(); ++n) {
            int n2 = this.convertColumnIndexToView(n);
            object = null;
            if (n2 != -1) {
                object = this.getTableHeader().getColumnModel().getColumn(n2);
            }
            nArray[n] = object == null ? 0 : ((TableColumn)object).getPreferredWidth();
        }
        for (n = 0; n < this.getColumnModel().getColumnCount(); ++n) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            object = tableColumn.getIdentifier();
            arrayList.add(object);
        }
        resultSetTablePersistedSettings.setColumnWidths(nArray);
        resultSetTablePersistedSettings.setColumnPositions(arrayList);
        return resultSetTablePersistedSettings;
    }

    protected void setPersistentSettings(ResultSetTablePersistedSettings resultSetTablePersistedSettings) {
        TableColumn tableColumn;
        for (int i = 0; i < resultSetTablePersistedSettings.getColumnWidths().length; ++i) {
            int n = this.convertColumnIndexToView(i);
            tableColumn = null;
            if (n != -1) {
                tableColumn = this.getTableHeader().getColumnModel().getColumn(n);
            }
            if (tableColumn == null) continue;
            tableColumn.setPreferredWidth(resultSetTablePersistedSettings.getColumnWidths()[i]);
        }
        List list = resultSetTablePersistedSettings.getColumnPositions();
        try {
            if (list != null) {
                Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    tableColumn = enumeration.nextElement();
                    tableColumn.getIdentifier();
                }
                for (int i = 0; i < list.size(); ++i) {
                    int n = this.getColumnModel().getColumnIndex(list.get(i));
                    if (n == i) continue;
                    this.getColumnModel().moveColumn(n, i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTranslatedColNames(boolean bl) {
        this._translatedColNames = bl;
    }

    public boolean isTranslatedColNames() {
        return this._translatedColNames;
    }

    public void setThreaded(boolean bl) {
        this._threaded = bl;
    }

    public boolean isThreaded() {
        return this._threaded;
    }

    public String getRawColumnName(int n) {
        return this.getModel() instanceof ResultSetTableModel ? ((ResultSetTableModel)this.getModel()).getRawColumnName(n) : null;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public void setSkipCols(List<String> list) {
        this._skipCols = list;
    }

    public static synchronized void setDrillDown(IResultSetTableDrillDown iResultSetTableDrillDown) {
        _drillDown = iResultSetTableDrillDown;
    }

    public String convertValueToText(Object object, int n, int n2) {
        String string;
        if (object != null && (string = DataTypesUtil.stringValue((Object)object, (Connection)((ResultSetTableModel)this.getModel()).getConnection()).toString()) != null) {
            return string;
        }
        return "";
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = this.prepareRenderer((TableCellRenderer)(object = this.getCellRenderer(n2, n)), n2, n)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n2, n, false);
            if (rectangle.width >= component.getPreferredSize().width) {
                return null;
            }
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        if (string == null) {
            object = null;
            try {
                object = this.getValueAt(n2, n);
            }
            catch (Exception exception) {
                return null;
            }
            string = this.convertValueToText(object, n2, n);
            if (string.length() == 0) {
                string = null;
            }
        }
        return string;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n2 == -1) {
            return null;
        }
        boolean bl = this.getToolTipText() == null ? this.getToolTipText(mouseEvent) != null : true;
        return bl ? this.getCellRect(n, n2, false).getLocation() : null;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.columnAtPoint(point);
                int n2 = ResultSetTable.this.rowAtPoint(point);
                Rectangle rectangle = ResultSetTable.this.getCellRect(n2, n, false);
                int n3 = this.columnModel.getColumnIndexAtX(point.x);
                if (n3 != -1 && ResultSetTable.this.getModel() instanceof ResultSetTableModel) {
                    int n4 = new Double(new JLabel(((ResultSetTableModel)ResultSetTable.this.getModel()).getRawColumnName(n3)).getPreferredSize().getWidth()).intValue();
                    return rectangle.width > n4 ? null : ((ResultSetTableModel)ResultSetTable.this.getModel()).getRawColumnName(n3);
                }
                return null;
            }
        };
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        boolean bl = super.editCellAt(n, n2, eventObject);
        final Component component = this.getEditorComponent();
        if (component != null && component instanceof RSTableEditorJPanel) {
            if (eventObject == null) {
                ((RSTableEditorJPanel)component).getTextField().selectAll();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((RSTableEditorJPanel)component).getTextField().selectAll();
                    }
                });
            }
        }
        return bl;
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        KeyEvent keyEvent = null;
        if (aWTEvent instanceof KeyEvent) {
            keyEvent = (KeyEvent)aWTEvent;
            if (this.getModel() instanceof EditableResultSetTableModel && n == 0 && n2 == 0 && KeyStroke.getKeyStrokeForEvent(keyEvent).equals(this.tabKeyStroke) && !((EditableResultSetTableModel)this.getModel()).isExternalTable()) {
                n = this.getRowCount();
                ((EditableResultSetTableModel)this.getModel()).addRow(n);
            }
        }
        if (n >= this.getMdl().getLoadedCount()) {
            this._lastSelectedRow = n;
            this._lastSelectedCol = n2;
        }
        super.changeSelection(n, n2, bl, bl2);
    }

    @Override
    public boolean isFocusCycleRoot() {
        return this.isEditing();
    }

    @Override
    public int getRowCount() {
        if (this.getModel() == null) {
            return 0;
        }
        return super.getRowCount();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        Serializable serializable;
        if (tableModelEvent instanceof ResultSetTableModel.ResultSetInvalidEvent) {
            serializable = (ResultSetTableModel.ResultSetInvalidEvent)tableModelEvent;
            if (this._resultSetInvalidEventHandler != null) {
                this._resultSetInvalidEventHandler.resultSetInvalidated((ResultSetTableModel.ResultSetInvalidEvent)serializable);
            }
        }
        serializable = this.getMdl();
        boolean bl = false;
        if (serializable != null && tableModelEvent.getColumn() == -1 && this._lastSelectedRow != -1 && tableModelEvent.getLastRow() > ((ResultSetTableModel)serializable).getLoadedCount()) {
            bl = true;
        }
        super.tableChanged(tableModelEvent);
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ResultSetTable.this.changeSelection(ResultSetTable.this._lastSelectedRow, ResultSetTable.this._lastSelectedCol, false, false);
                    ResultSetTable.this._lastSelectedRow = -1;
                    ResultSetTable.this._lastSelectedCol = -1;
                }
            });
        }
    }

    public String getSql() {
        return this._sql;
    }

    public void setResultSetInvalidEventHandler(ResultSetInvalidEventHandler resultSetInvalidEventHandler) {
        this._resultSetInvalidEventHandler = resultSetInvalidEventHandler;
    }

    public static interface ResultSetInvalidEventHandler {
        public void resultSetInvalidated(ResultSetTableModel.ResultSetInvalidEvent var1);
    }

    private class ResultSetTablePersistenceInvoker
    extends MouseAdapter
    implements TableColumnModelListener {
        private boolean colMoved = false;
        private boolean marginChanged = false;
        private int movedFrom = -1;
        private int movedTo = -1;

        private ResultSetTablePersistenceInvoker() {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                ResultSetTableModel resultSetTableModel;
                int[] nArray;
                TableModel tableModel;
                this.colMoved = true;
                this.movedFrom = tableColumnModelEvent.getFromIndex();
                this.movedTo = tableColumnModelEvent.getToIndex();
                if (this.movedFrom != this.movedTo && this.movedFrom != -1 && this.movedTo != -1 && (tableModel = ResultSetTable.this.getModel()) instanceof ResultSetTableModel && this.movedFrom <= (nArray = (resultSetTableModel = (ResultSetTableModel)tableModel).getTypes()).length && this.movedTo <= nArray.length) {
                    try {
                        resultSetTableModel.reorderColumnNamesList(this.movedFrom, this.movedTo);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                this.movedFrom = -1;
                this.movedTo = -1;
            }
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.marginChanged = true;
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.colMoved || this.marginChanged) {
                this.colMoved = false;
                this.marginChanged = false;
                ResultSetTable.this.savePersistentSettings();
                ResultSetTable.this.scrollRectToVisible(ResultSetTable.this.getCellRect(ResultSetTable.this._lastSelectedRow, ResultSetTable.this._lastSelectedCol, true));
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ResultSetTable.this._lastSelectedRow = ResultSetTable.this.getSelectedRow();
            ResultSetTable.this._lastSelectedCol = ResultSetTable.this.getSelectedColumn();
        }
    }

    public static class ColumnHeaderCellRenderer
    extends DefaultCellRenderer {
        private static final long serialVersionUID = 1L;
        static final ColumnHeaderCellRenderer INSTANCE = new ColumnHeaderCellRenderer();

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            this.setHorizontalAlignment(2);
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (jTable.getModel() instanceof ResultSetTableModel && jTable.getColumnModel() != null && jTable.getColumnModel().getColumnCount() > n2) {
                if (((ResultSetTableModel)jTable.getModel()).getSortCol() == jTable.convertColumnIndexToModel(n2) && ((ResultSetTableModel)jTable.getModel()).getSortDirection() == " asc") {
                    this.setIcon(RaptorImagesArb.getIcon(50));
                    this.paintAll(this.getGraphics());
                } else if (((ResultSetTableModel)jTable.getModel()).getSortCol() == jTable.convertColumnIndexToModel(n2) && ((ResultSetTableModel)jTable.getModel()).getSortDirection() == " desc") {
                    this.setIcon(RaptorImagesArb.getIcon(49));
                    this.paintAll(this.getGraphics());
                } else if (((ResultSetTable)jTable).isColSortable(n2)) {
                    this.setIcon(RaptorImagesArb.getIcon(51));
                    this.paintAll(this.getGraphics());
                } else {
                    this.setIcon(null);
                    this.paintAll(this.getGraphics());
                }
            }
            return this;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    private static class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        static final RowHeaderCellRenderer INSTANCE = new RowHeaderCellRenderer();

        private RowHeaderCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(4);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = jLabel.getBorder();
            if (jTable.getModel() instanceof EditableResultSetTableModel) {
                EditableResultSetTableModel editableResultSetTableModel = (EditableResultSetTableModel)jTable.getModel();
                border = editableResultSetTableModel.getRowCountBorder(n, n2);
            }
            if (border != null) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            jLabel.setBorder(border);
            return jLabel;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    private class RowHeaderTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        private RowHeaderTableColumnModel() {
        }

        public TableColumn getColumn(int n) {
            if (n < this.getColumnCount()) {
                return (TableColumn)this.tableColumns.elementAt(n);
            }
            return null;
        }

        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setCellRenderer(RowHeaderCellRenderer.INSTANCE);
                tableColumn.setMaxWidth(45);
                super.addColumn(tableColumn);
            }
        }
    }
}

