/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;

public class PropertyPanel
extends JPanel {
    private String _helpId = null;
    private JPanel _northPanel;
    private int _northRows = 0;
    private JPanel _southPanel;
    private GridLayout _northGrid;

    public PropertyPanel() {
        this.init();
        this.addMouseListener(new DebugMouseListener(this));
    }

    private void add(JComponent jComponent) {
        this._northPanel.add(jComponent);
    }

    public void addSingleComp(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string == null ? "" : string.toString());
        jLabel.setSize(200, jLabel.getSize().height);
        this._southPanel.add(jLabel);
    }

    public void addSingleComp(JComponent jComponent) {
        this._southPanel.add(jComponent);
    }

    public void addValueAsLabel(String string, Object object) {
        JLabel jLabel = new JLabel();
        jLabel.setText(object == null ? "" : object.toString());
        jLabel.setSize(200, jLabel.getSize().height);
        this.addComp(string, jLabel);
    }

    public void addItem(String string, Object object) {
        this.addValueAsLabel(string, object);
    }

    public void addComp(String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(Translate.translate((String)string));
        jLabel.setSize(jLabel.getPreferredSize());
        this._northPanel.add(jLabel);
        this._northPanel.add(jComponent);
        ++this._northRows;
        SpringUtilities.makeCompactGrid(this._northPanel, this._northRows, 2, 0, 0, 6, 6);
    }

    private void init() {
        this._northPanel = new JPanel();
        this._southPanel = new JPanel();
        this._northPanel.setLayout(new SpringLayout());
        this._southPanel.setLayout(new GridLayout(0, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this._northPanel, "North");
        this.add((Component)this._southPanel, "South");
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._northPanel != null) {
            this._northPanel.setBackground(color);
        }
        if (this._southPanel != null) {
            this._southPanel.setBackground(color);
        }
    }

    public void removeAll() {
        this._northPanel.removeAll();
        this._northRows = 0;
        this._southPanel.removeAll();
    }

    private class DebugMouseListener
    implements MouseListener {
        private JPanel _panel = null;
        private Color[] colors = new Color[]{Color.RED, Color.BLACK, Color.BLUE, Color.ORANGE, Color.YELLOW};
        private int colorIdx = 0;

        public DebugMouseListener(JPanel jPanel) {
            this._panel = jPanel;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isControlDown() && mouseEvent.isAltDown()) {
                this.colorIdx = 0;
                this.processPanel(this._panel, this.colors[this.colorIdx]);
            }
        }

        public void processPanel(JPanel jPanel, Color color) {
            int n = jPanel.getComponentCount();
            if (jPanel.getBorder() == null) {
                jPanel.setBorder(BorderFactory.createLineBorder(color));
                ++this.colorIdx;
                for (int i = 0; i < n; ++i) {
                    if (jPanel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)jPanel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(jPanel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)jPanel.getComponent(i)).setBorder(BorderFactory.createLineBorder(color));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    jPanel.setBorder(null);
                    if (jPanel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)jPanel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(jPanel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)jPanel.getComponent(i)).setBorder(null);
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

