/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.FilePanelAcc;

public class FilePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JTextField _fileName;
    private Component _parent;
    private JButton _browse;
    private String _defaultName = "";
    private String _encoding;

    public FilePanel(Component component) {
        this._parent = component;
        this.setLayout(new BorderLayout());
        this._fileName = new JTextField(this._defaultName);
        this.add((Component)this._fileName, "Center");
        this._browse = new JButton("Browse...");
        this._browse.setMnemonic(new Integer(82));
        this._browse.addActionListener(this);
        this.add((Component)this._browse, "East");
        int n = Double.valueOf(this.getPreferredSize().getWidth()).intValue();
        Dimension dimension = new Dimension(n + 150, Double.valueOf(this.getPreferredSize().getHeight()).intValue());
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
    }

    public void prompt() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export File Chooser");
        String string = this._fileName.getText();
        String string2 = DBConfig.getInstance().getString("EXPORTDIR") + File.separator;
        if (string2 == null || string2.equals("")) {
            string2 = System.getProperty("user.home");
        }
        if (string.equals("")) {
            try {
                File file = new File(string2 + "export.sql");
                jFileChooser.setSelectedFile(file);
            }
            catch (Exception exception) {
                File file = new File(string2 + "export.sql");
                jFileChooser.setSelectedFile(file);
            }
        } else {
            int n = string.lastIndexOf(File.separator);
            if (n > -1) {
                jFileChooser.setSelectedFile(new File(string));
            } else {
                jFileChooser.setSelectedFile(new File(DBConfig.getInstance().getString("EXPORTDIR") + File.separator + string));
            }
        }
        jFileChooser.setAccessory(new FilePanelAcc());
        if (jFileChooser.showSaveDialog(this._parent) == 0) {
            int n;
            String string3 = jFileChooser.getSelectedFile().toString();
            String string4 = string3.substring(n = string3.lastIndexOf(File.separator));
            if (string4.lastIndexOf(".") > -1) {
                this._fileName.setText(jFileChooser.getSelectedFile().toString());
            } else {
                this._fileName.setText(jFileChooser.getSelectedFile().toString() + ".sql");
            }
            this._encoding = ((FilePanelAcc)jFileChooser.getAccessory()).getEncoding();
        }
    }

    public void setFileName(String string) {
        this._fileName.setText(string);
    }

    public String getFileName() {
        return this._fileName.getText();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.prompt();
    }
}

