/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnDDropGenerator {
    private static final String DEFAULT_TEMPLATE = "dnd";
    private StringTemplateGroup m_templateGroup;
    private int m_option = 0;
    private WorksheetDndOptionPanel m_panel;

    private int getOption(ArrayList arrayList) {
        int n = 0;
        DBConfig dBConfig = DBConfig.getInstance();
        this.m_panel = new WorksheetDndOptionPanel();
        this.m_panel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
        this.m_panel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        if (arrayList != null && (n = arrayList.size()) > 1) {
            this.m_panel.enableJoin();
        } else {
            this.m_panel.disableJoin();
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("apply")) {
                    DBConfig dBConfig = DBConfig.getInstance();
                    DnDDropGenerator.this.m_panel.setCancel(false);
                    DnDDropGenerator.this.m_option = DnDDropGenerator.this.m_panel.getDragType();
                    int n = DnDDropGenerator.this.m_panel.getPrompt();
                    dBConfig.putInt("DRAG_N_DROP_PROMPT", n);
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                }
            }
        };
        UIUtils.showPanelAsDialog((JPanel)this.m_panel, PreferencesArb.getString(10), actionListener, true);
        return this.m_panel.isCanceled() ? -911 : this.m_panel.getDragType();
    }

    private boolean objInDragList(String string, ArrayList<ObjectNode> arrayList) {
        if (string != null && arrayList != null) {
            for (ObjectNode objectNode : arrayList) {
                if (!objectNode.getObjectName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private String getAlias(String string, String string2, ArrayList<RefPair> arrayList, ArrayList<RefPair> arrayList2) {
        if (!(arrayList != null && arrayList.size() != 0 || arrayList2 != null && arrayList2.size() != 0)) {
            return AliasGenerator.getInstance().getNextAlias();
        }
        String string3 = null;
        ListIterator<RefPair> listIterator = null;
        if (arrayList != null) {
            listIterator = arrayList.listIterator();
        }
        ListIterator<RefPair> listIterator2 = null;
        if (arrayList2 != null) {
            listIterator2 = arrayList2.listIterator();
        }
        RefPair refPair = null;
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        while (string3 == null && listIterator2 != null && listIterator2.hasNext()) {
            refPair = listIterator2.next();
            if (string.equals(refPair.getPrimTableOwner()) && string2.equals(refPair.getPrimTable())) {
                string3 = refPair.getPrimAlias();
                break;
            }
            if (!string.equals(refPair.getRefTableOwner()) || !string2.equals(refPair.getRefTable())) continue;
            string3 = refPair.getRefAlias();
            break;
        }
        if (string3 == null) {
            string3 = AliasGenerator.getInstance().getNextAlias();
        }
        return string3;
    }

    private RefPair getRefPairsFromConsName(String string, String string2, String string3, String string4, String string5, String string6, ArrayList<ObjectNode> arrayList, ArrayList<RefPair> arrayList2, ArrayList<RefPair> arrayList3) throws SQLException {
        String string7 = "select table_name, column_name from all_cons_columns where constraint_name = '" + string4 + "' and owner = '" + string6 + "'";
        String string8 = "select table_name, column_name from all_cons_columns where constraint_name = '" + string5 + "' and owner = '" + string2 + "'";
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance();
        ResultSet resultSet = dBUtil.executeQuery(string, string7, (List)null);
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        String string9 = null;
        String string10 = null;
        String string11 = null;
        if (resultSet == null || !resultSet.next()) {
            return null;
        }
        do {
            if (!this.objInDragList(string9 = resultSet.getString(1), arrayList)) {
                return null;
            }
            string10 = resultSet.getString(2);
            arrayList4.add(string10);
        } while (resultSet.next());
        refPair = new RefPair();
        refPair.setPrimTable(string9);
        refPair.setPrimTableOwner(string6);
        string11 = this.getAlias(string6, string9, arrayList2, arrayList3);
        refPair.setPrimAlias(string11);
        refPair.setPrimConstName(string4);
        refPair.setPrimCols(arrayList4);
        try {
            if (resultSet != null) {
                resultSet.getStatement().close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        resultSet = dBUtil.executeQuery(string, string8, (List)null);
        while (resultSet != null && resultSet.next()) {
            string9 = resultSet.getString(1);
            string10 = resultSet.getString(2);
            arrayList5.add(string10);
        }
        refPair.setRefTable(string9);
        refPair.setRefTableOwner(string2);
        string11 = refPair.getPrimTableOwner().equals(refPair.getRefTableOwner()) && refPair.getPrimTable().equals(refPair.getRefTable()) ? refPair.getPrimAlias() : this.getAlias(string2, string9, arrayList2, arrayList3);
        refPair.setRefAlias(string11);
        refPair.setRefConstName(string5);
        refPair.setRefCols(arrayList5);
        try {
            if (resultSet != null) {
                resultSet.getStatement().close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return refPair;
    }

    private ArrayList<RefPair> getRefPairsForObjectName(String string, String string2, String string3, ArrayList<ObjectNode> arrayList, ArrayList<RefPair> arrayList2) throws SQLException {
        String string4 = "select constraint_name, r_constraint_name, r_owner from all_constraints where constraint_type = 'R' and table_name = '" + string3 + "' and owner = '" + string2 + "'";
        ArrayList<RefPair> arrayList3 = null;
        RefPair refPair = null;
        DBUtil dBUtil = DBUtil.getInstance();
        ResultSet resultSet = dBUtil.executeQuery(string, string4, (List)null);
        while (resultSet != null && resultSet.next()) {
            String string5;
            String string6 = resultSet.getString(1);
            String string7 = resultSet.getString(2);
            refPair = this.getRefPairsFromConsName(string, string2, string3, string7, string6, string5 = resultSet.getString(3), arrayList, arrayList2, arrayList3);
            if (refPair == null) continue;
            if (arrayList3 == null) {
                arrayList3 = new ArrayList<RefPair>();
            }
            arrayList3.add(refPair);
        }
        try {
            if (resultSet != null) {
                resultSet.getStatement().close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return arrayList3;
    }

    private boolean isObjectPartOfRefPair(String string, ArrayList<RefPair> arrayList) {
        RefPair refPair = null;
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                refPair = arrayList.get(i);
                if (!refPair.getQuotedPrimTable().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private ArrayList<String> getTableColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "select column_name from all_tab_columns where table_name='" + string3 + "' AND owner = '" + string2 + "'";
        ArrayList<String> arrayList = new ArrayList<String>();
        DBUtil dBUtil = DBUtil.getInstance();
        String string5 = DBUtil.enquote((String)string2) + "." + DBUtil.enquote((String)string3) + ".";
        ResultSet resultSet = dBUtil.executeQuery(string, string4, (List)null);
        while (resultSet != null && resultSet.next()) {
            arrayList.add(string5 + DBUtil.enquote((String)resultSet.getString(1)));
        }
        try {
            if (resultSet != null) {
                resultSet.getStatement().close();
                resultSet = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return arrayList;
    }

    private boolean isObjUnique(String string, String string2, ArrayList<String> arrayList) {
        if (arrayList == null || arrayList == null) {
            return false;
        }
        Iterator<String> iterator = arrayList.iterator();
        String string3 = null;
        String string4 = null;
        while (iterator != null && iterator.hasNext()) {
            string4 = iterator.next();
            string3 = string4.substring(0, string4.indexOf("."));
            string4 = string4.substring(string4.indexOf(".") + 1, string4.indexOf(" "));
            if (!string3.equals(string) || !string4.equals(string2)) continue;
            return false;
        }
        return true;
    }

    private ArrayList<String> getRefTables(ArrayList<RefPair> arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Iterator<RefPair> iterator = arrayList.iterator();
        RefPair refPair = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            stringBuilder.delete(0, stringBuilder.length());
            if (this.isObjUnique(refPair.getQuotedRefTableOwner(), refPair.getQuotedRefTable(), arrayList2)) {
                stringBuilder.append(refPair.getQuotedRefTableOwner());
                stringBuilder.append(".");
                stringBuilder.append(refPair.getQuotedRefTable());
                stringBuilder.append(" ");
                stringBuilder.append(refPair.getRefAlias());
                arrayList2.add(stringBuilder.toString());
            }
            stringBuilder.delete(0, stringBuilder.length());
            if (!this.isObjUnique(refPair.getQuotedPrimTableOwner(), refPair.getQuotedPrimTable(), arrayList2)) continue;
            stringBuilder.append(refPair.getQuotedPrimTableOwner());
            stringBuilder.append(".");
            stringBuilder.append(refPair.getQuotedPrimTable());
            stringBuilder.append(" ");
            stringBuilder.append(refPair.getPrimAlias());
            arrayList2.add(stringBuilder.toString());
        }
        return arrayList2;
    }

    private ArrayList<CondObj> getConditionList(ArrayList<RefPair> arrayList) {
        Iterator<RefPair> iterator = arrayList.iterator();
        ArrayList<String> arrayList2 = null;
        ArrayList<CondObj> arrayList3 = null;
        CondObj condObj = null;
        RefPair refPair = null;
        while (iterator != null && iterator.hasNext()) {
            refPair = iterator.next();
            ArrayList<String> arrayList4 = refPair.getPrimCols();
            arrayList2 = refPair.getRefCols();
            if (arrayList4.size() != arrayList2.size()) {
                throw new IllegalStateException("Number of Pk cols(" + arrayList4.size() + ") doesn't match Fk cols(" + arrayList2.size() + ") in table " + refPair.getRefTableOwner() + "." + refPair.getRefTable());
            }
            Iterator<String> iterator2 = arrayList4.iterator();
            Iterator<String> iterator3 = arrayList2.iterator();
            while (iterator2 != null && iterator3 != null && iterator2.hasNext() && iterator3.hasNext()) {
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList<CondObj>();
                }
                condObj = new CondObj();
                condObj.setCol1(refPair.getPrimAlias() + "." + DBUtil.enquote((String)iterator2.next()));
                condObj.setCol2(refPair.getRefAlias() + "." + DBUtil.enquote((String)iterator3.next()));
                arrayList3.add(condObj);
            }
        }
        return arrayList3;
    }

    private String constructJoinSQL(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<CondObj> arrayList3) {
        String string = null;
        StringTemplate stringTemplate = null;
        stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
        stringTemplate.setAttribute("colList", arrayList);
        stringTemplate.setAttribute("objectNames", arrayList2);
        stringTemplate.setAttribute("cond", (Object)(arrayList3 != null && arrayList3.size() > 0 ? 1 : 0));
        stringTemplate.setAttribute("condList", arrayList3);
        string = stringTemplate.toString();
        if (string.endsWith(" AND ;")) {
            string = string.substring(0, string.lastIndexOf(" AND ;")) + ";";
        }
        return string;
    }

    private void ensureAliasPrefixForColumns(ArrayList<String> arrayList, ArrayList<RefPair> arrayList2) {
        if (arrayList == null || arrayList2 == null) {
            return;
        }
        ListIterator<String> listIterator = arrayList.listIterator();
        Iterator<RefPair> iterator = null;
        RefPair refPair = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        block0: while (listIterator != null && listIterator.hasNext()) {
            string3 = listIterator.next();
            string = string3.substring(0, string3.indexOf("."));
            string2 = string3.substring(string3.indexOf(".") + 1, string3.lastIndexOf("."));
            string3 = string3.substring(string3.lastIndexOf(".") + 1);
            iterator = arrayList2.iterator();
            while (iterator != null && iterator.hasNext()) {
                refPair = iterator.next();
                if (string.equals(refPair.getQuotedPrimTableOwner()) && string2.equals(refPair.getQuotedPrimTable())) {
                    listIterator.set(refPair.getPrimAlias() + "." + string3);
                    continue block0;
                }
                if (!string.equals(refPair.getQuotedRefTableOwner()) || !string2.equals(refPair.getQuotedRefTable())) continue;
                listIterator.set(refPair.getRefAlias() + "." + string3);
                continue block0;
            }
        }
    }

    private String getJoinSql(ArrayList<ObjectNode> arrayList) throws SQLException {
        Object object;
        ArrayList<RefPair> arrayList2 = new ArrayList<RefPair>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<CondObj> arrayList6 = null;
        ArrayList<RefPair> arrayList7 = null;
        Connections connections = Connections.getInstance();
        String string = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            try {
                string = connections.getDatabase(((ObjectNode)object).getConnectionName()).getUserName();
            }
            catch (DBException dBException) {
                throw new SQLException(dBException.getMessage());
            }
            arrayList7 = this.getRefPairsForObjectName(((ObjectNode)object).getConnectionName(), string, ((ObjectNode)object).getObjectName(), arrayList, arrayList2);
            if (arrayList7 != null) {
                arrayList2.addAll(arrayList7);
            } else if (!this.isObjectPartOfRefPair(((ObjectNode)object).getObjectName(), arrayList2)) {
                arrayList3.add(DBUtil.enquote((String)string) + "." + DBUtil.enquote((String)((ObjectNode)object).getObjectName()));
            }
            arrayList5.addAll(this.getTableColumns(((ObjectNode)object).getConnectionName(), string, ((ObjectNode)object).getObjectName()));
        }
        ArrayList<String> arrayList8 = this.getRefTables(arrayList2);
        arrayList4.addAll(arrayList8);
        object = null;
        object = arrayList3.listIterator();
        while (object != null && object.hasNext()) {
            if (this.isUnique(arrayList2, (String)object.next())) continue;
            object.remove();
        }
        arrayList4.addAll(arrayList3);
        this.ensureAliasPrefixForColumns(arrayList5, arrayList2);
        arrayList6 = this.getConditionList(arrayList2);
        return this.constructJoinSQL(arrayList5, arrayList4, arrayList6);
    }

    private boolean isUnique(ArrayList<RefPair> arrayList, String string) {
        RefPair refPair = null;
        String string2 = null;
        String string3 = null;
        if (string == null || arrayList == null) {
            return true;
        }
        string2 = string.substring(0, string.indexOf("."));
        string3 = string.substring(string.indexOf(".") + 1);
        ListIterator<RefPair> listIterator = arrayList.listIterator();
        while (listIterator != null && listIterator.hasNext()) {
            refPair = listIterator.next();
            if ((!string2.equals(refPair.getQuotedPrimTableOwner()) || !string3.equals(refPair.getQuotedPrimTable())) && (!string2.equals(refPair.getQuotedRefTableOwner()) || !string3.equals(refPair.getQuotedRefTable()))) continue;
            return false;
        }
        return true;
    }

    private String getJoinStatement(ArrayList arrayList) throws IOException, UnsupportedFlavorException, SQLException {
        String string = null;
        ArrayList<ObjectNode> arrayList2 = new ArrayList<ObjectNode>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = null;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            defaultMutableTreeNode = arrayList.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)arrayList.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)arrayList.get(i);
            object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof ObjectNode)) continue;
            arrayList2.add((ObjectNode)object);
        }
        string = this.getJoinSql(arrayList2);
        return string;
    }

    protected StringBuilder generate(ArrayList arrayList) throws UnsupportedFlavorException, IOException, SQLException, AbortException {
        StringBuilder stringBuilder = new StringBuilder();
        this.loadTemplates();
        int n = DBConfig.getInstance().getInt("DRAG_N_DROP_PROMPT");
        this.m_option = n == 0 ? this.getOption(arrayList) : DBConfig.getInstance().getInt("DRAG_N_DROP_CHOICES");
        if (this.m_option == 2 && arrayList.size() > 1) {
            stringBuilder.append(this.getJoinStatement(arrayList));
            return stringBuilder;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object = null;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            defaultMutableTreeNode = arrayList.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)arrayList.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)arrayList.get(i);
            object = defaultMutableTreeNode.getUserObject();
            if (object instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)object;
                String string = (String)objectNode.getProperty("TYPE");
                stringBuilder.append(this.getDropStatement(objectNode, string, this.m_option));
                continue;
            }
            stringBuilder.append(object.toString() + ",");
        }
        return stringBuilder;
    }

    private String getDropStatement(ObjectNode objectNode, String string, int n) throws SQLException, AbortException {
        String string2 = "";
        List<DBChildInstance> list = null;
        objectNode.ensureOpen();
        DBObjectInstance dBObjectInstance = objectNode.getNodeInstance();
        list = string.equals("VIEW") ? objectNode.getNodeInstance().listChildren("VIEW_COLUMN") : objectNode.getNodeInstance().listChildren("COLUMN");
        String[] stringArray = new String[list.size()];
        int n2 = 0;
        if (list != null && list.size() > 0) {
            for (DBChildInstance dBChildInstance : list) {
                stringArray[n2] = DBUtil.enquote((String)((String)dBChildInstance.getProperty("NAME")));
                ++n2;
            }
        }
        StringTemplate stringTemplate = null;
        switch (n) {
            case 1: {
                stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
                stringTemplate.setAttribute("objectNames", (Object)DBUtil.enquote((String)objectNode.getObjectName()));
                stringTemplate.setAttribute("colList", (Object)stringArray);
                break;
            }
            case 2: {
                stringTemplate = this.getTemplateGroup().getInstanceOf("SelectStatement");
                stringTemplate.setAttribute("objectNames", (Object)DBUtil.enquote((String)objectNode.getObjectName()));
                stringTemplate.setAttribute("colList", (Object)stringArray);
                break;
            }
            case 3: {
                stringTemplate = this.getTemplateGroup().getInstanceOf("InsertStatement");
                stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)objectNode.getObjectName()));
                stringTemplate.setAttribute("valList", (Object)new String[stringArray.length]);
                stringTemplate.setAttribute("colList", (Object)stringArray);
                break;
            }
            case 5: {
                stringTemplate = this.getTemplateGroup().getInstanceOf("DeleteStatement");
                stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)objectNode.getObjectName()));
                break;
            }
            case 4: {
                stringTemplate = this.getTemplateGroup().getInstanceOf("UpdateStatement");
                stringTemplate.setAttribute("tableName", (Object)DBUtil.enquote((String)objectNode.getObjectName()));
                break;
            }
        }
        if (stringTemplate != null) {
            string2 = stringTemplate.toString() + "\n";
        }
        return string2;
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/raptor/controls/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        this.setTemplateName(DEFAULT_TEMPLATE);
    }

    public void setTemplateName(String string) {
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    private static class AliasGenerator {
        private int cloneCount = 0;
        private int pos = 0;
        private String aliasString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        private StringBuilder sb = new StringBuilder();
        private static AliasGenerator inst = null;

        static AliasGenerator getInstance() {
            if (inst == null) {
                inst = new AliasGenerator();
            }
            return inst;
        }

        private AliasGenerator() {
        }

        String getNextAlias() {
            String string = null;
            this.sb.delete(0, this.sb.length());
            if (this.pos < this.aliasString.length() - 1) {
                this.sb.append(this.aliasString.substring(this.pos, this.pos + 1));
            } else {
                this.sb.append(this.aliasString.substring(this.pos));
            }
            ++this.pos;
            string = this.sb.toString();
            for (int i = 0; i < this.cloneCount; ++i) {
                this.sb.append(string);
            }
            if (this.pos > this.aliasString.length() - 1) {
                this.pos %= this.aliasString.length();
                ++this.cloneCount;
            }
            return this.sb.toString();
        }
    }

    private static class CondObj {
        private String col1;
        private String col2;

        private CondObj() {
        }

        public String getCol1() {
            return this.col1;
        }

        public String getCol2() {
            return this.col2;
        }

        void setCol1(String string) {
            this.col1 = string;
        }

        void setCol2(String string) {
            this.col2 = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RefPair {
        private String ref_Tab_Owner;
        private String ref_TableName;
        private String ref_Constraint_Name;
        private ArrayList<String> ref_Tab_Col;
        private String ref_Tab_Alias;
        private String prim_Tab_Owner;
        private String prim_TableName;
        private String prim_Constraint_Name;
        private ArrayList<String> prim_Tab_Col;
        private String prim_Tab_Alias;

        private RefPair() {
        }

        String getRefTableOwner() {
            return this.ref_Tab_Owner;
        }

        String getQuotedRefTableOwner() {
            return DBUtil.enquote((String)this.ref_Tab_Owner);
        }

        String getRefTable() {
            return this.ref_TableName;
        }

        String getQuotedRefTable() {
            return DBUtil.enquote((String)this.ref_TableName);
        }

        String getRefConstName() {
            return this.ref_Constraint_Name;
        }

        ArrayList<String> getRefCols() {
            return this.ref_Tab_Col;
        }

        String getRefAlias() {
            return this.ref_Tab_Alias;
        }

        String getPrimTableOwner() {
            return this.prim_Tab_Owner;
        }

        String getQuotedPrimTableOwner() {
            return DBUtil.enquote((String)this.prim_Tab_Owner);
        }

        String getPrimTable() {
            return this.prim_TableName;
        }

        String getQuotedPrimTable() {
            return DBUtil.enquote((String)this.prim_TableName);
        }

        ArrayList<String> getPrimCols() {
            return this.prim_Tab_Col;
        }

        String getPrimAlias() {
            return this.prim_Tab_Alias;
        }

        String getPrimConstName() {
            return this.prim_Constraint_Name;
        }

        void setRefTableOwner(String string) {
            this.ref_Tab_Owner = string;
        }

        void setRefTable(String string) {
            this.ref_TableName = string;
        }

        void setRefConstName(String string) {
            this.ref_Constraint_Name = string;
        }

        void setRefCols(ArrayList<String> arrayList) {
            this.ref_Tab_Col = arrayList;
        }

        void addRefCol(String string) {
            this.ref_Tab_Col.add(string);
        }

        void setRefAlias(String string) {
            this.ref_Tab_Alias = string;
        }

        void setPrimTableOwner(String string) {
            this.prim_Tab_Owner = string;
        }

        void setPrimTable(String string) {
            this.prim_TableName = string;
        }

        void addPrimCol(String string) {
            this.prim_Tab_Col.add(string);
        }

        void setPrimCols(ArrayList<String> arrayList) {
            this.prim_Tab_Col = arrayList;
        }

        void setPrimAlias(String string) {
            this.prim_Tab_Alias = string;
        }

        void setPrimConstName(String string) {
            this.prim_Constraint_Name = string;
        }

        String getQualifiedPrimTableCol(String string) {
            return this.prim_Tab_Alias + "." + this.prim_TableName + "." + string;
        }

        String getQualifiedRefTableCol(String string) {
            return this.ref_Tab_Alias + "." + this.ref_TableName + "." + this.ref_Tab_Col;
        }
    }
}

