/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;

public class BindInfo
extends JPanel {
    private static final long serialVersionUID = 1L;
    JList list;
    DefaultListModel model;
    List<Bind> binds;
    int sel;
    JLabel fName = new JLabel();
    JTextArea fDesc = new JTextArea();
    JTextField fType = new JTextField();
    JTextArea fValue = new JTextArea();
    JCheckBox fNull = new JCheckBox("NULL");
    Query query;

    public BindInfo(Query query) {
        this.query = query;
        this.binds = this.query.getBinds();
        this.setLayout(new GridBagLayout());
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        if (this.binds.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.binds.size(); ++i) {
            if (this.binds.get(i).getPrompt() == null || this.binds.get(i).getPrompt().equals("")) {
                this.model.addElement(this.binds.get(i).getName());
                this.binds.get(i).setPrompt(this.binds.get(i).getName());
                this.query.setBinds(this.binds);
                continue;
            }
            this.model.addElement(this.binds.get(i).getPrompt());
        }
        this.fName.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fDesc.setLineWrap(true);
        this.fDesc.setWrapStyleWord(true);
        this.fDesc.setBackground(this.getBackground());
        this.fValue.setToolTipText("Value");
        this.fValue.setColumns(20);
        this.fValue.setRows(1);
        this.fValue.setBorder(BorderFactory.createEtchedBorder());
        this.fValue.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\t') {
                    keyEvent.consume();
                    BindInfo.this.fValue.transferFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                BindInfo.this.binds.get(BindInfo.this.sel).setValue(BindInfo.this.fValue.getText());
                BindInfo.this.query.setBinds(BindInfo.this.binds);
                if (BindInfo.this.fNull.isSelected()) {
                    BindInfo.this.fNull.doClick();
                }
            }
        });
        this.fNull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (BindInfo.this.fNull.isSelected()) {
                    BindInfo.this.binds.get(BindInfo.this.sel).setValue("NULL_VALUE");
                    BindInfo.this.fValue.setText("");
                    BindInfo.this.query.setBinds(BindInfo.this.binds);
                } else {
                    BindInfo.this.binds.get(BindInfo.this.sel).setValue("");
                    BindInfo.this.query.setBinds(BindInfo.this.binds);
                }
            }
        });
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(0);
        defaultListSelectionModel.setLeadAnchorNotificationEnabled(false);
        this.list.setSelectionModel(defaultListSelectionModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JList jList = (JList)listSelectionEvent.getSource();
                BindInfo.this.sel = jList.getSelectedIndex();
                if (BindInfo.this.binds.get(BindInfo.this.sel) != null && BindInfo.this.binds.get(BindInfo.this.sel).getPrompt() != null) {
                    BindInfo.this.fName.setText(BindInfo.this.binds.get(BindInfo.this.sel).getPrompt());
                } else {
                    BindInfo.this.fName.setText(BindInfo.this.binds.get(BindInfo.this.sel).getName());
                }
                if (BindInfo.this.binds.get(BindInfo.this.sel) != null && BindInfo.this.binds.get(BindInfo.this.sel).getTooltip() != null) {
                    BindInfo.this.fName.setToolTipText(BindInfo.this.binds.get(BindInfo.this.sel).getTooltip().trim());
                    BindInfo.this.fValue.setToolTipText(BindInfo.this.binds.get(BindInfo.this.sel).getTooltip().trim());
                }
                if (BindInfo.this.binds.get(BindInfo.this.sel).getValue() == null || BindInfo.this.binds.get(BindInfo.this.sel).getValue().equals("NULL_VALUE")) {
                    BindInfo.this.fValue.setText("");
                    BindInfo.this.fNull.setSelected(true);
                } else {
                    BindInfo.this.fValue.setText(BindInfo.this.binds.get(BindInfo.this.sel).getValue());
                    BindInfo.this.fNull.setSelected(false);
                }
            }
        });
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 5, 2.0, 2.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Name: "), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.fName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.fNull, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Value: "), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.fValue, new GridBagConstraints(2, 2, 1, 3, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.list.setSelectedIndex(0);
    }

    public void setDescr(String string) {
        if (string == null || string.trim().length() == 0) {
            this.remove(this.fDesc);
        } else {
            this.add((Component)this.fDesc, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        }
    }
}

