/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ProxyConnectionPanel
extends DefaultTraversablePanel {
    JLabel _proxyUsrLbl = new JLabel();
    JLabel _proxyPwdLbl = new JLabel();
    JTextField _proxyUsr = new JTextField(30);
    JPasswordField _proxyPwd = new JPasswordField(30);
    JLabel _proxyTypeLbl = new JLabel();
    ButtonGroup _btnGroup;
    JRadioButton _btnUser;
    JRadioButton _btnDN;
    JLabel _dNameLbl = new JLabel();
    JTextField _dName = new JTextField(30);
    int padding = 0;
    public static final String PROXY_TYPE_USER_NAME = "USER NAME";
    public static final String PROXY_TYPE_DISTINGUISHED_NAME = "DISTINGUISHED NAME";
    public static final String PROXY_TYPE = "PROXY_TYPE";
    public static final String IS_PROXY = "IS_PROXY";
    public static final String PROXY_CANCELLED = "Proxy Cancelled";

    public ProxyConnectionPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_proxy_connection_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this._proxyUsrLbl, (Component)this._proxyUsr, (String)CreateDialogArb.getString(595));
        ResourceUtils.resLabel((JLabel)this._proxyPwdLbl, (Component)this._proxyPwd, (String)CreateDialogArb.getString(596));
        ResourceUtils.resLabel((JLabel)this._dNameLbl, (Component)this._dName, (String)CreateDialogArb.getString(597));
        this._proxyUsr.setColumns(30);
        ResourceUtils.resLabel((JLabel)this._proxyTypeLbl, null, (String)"Proxy Type");
        this.add(this._proxyTypeLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._btnGroup = new ButtonGroup();
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ProxyConnectionPanel.this.toggleProxyInputs();
            }
        };
        this._btnUser = new JRadioButton();
        this._btnUser.getModel().addChangeListener(changeListener);
        ResourceUtils.resButton((AbstractButton)this._btnUser, (String)CreateDialogArb.getString(594));
        this._btnGroup.add(this._btnUser);
        this._btnUser.setSelected(true);
        this._btnDN = new JRadioButton();
        this._btnDN.getModel().addChangeListener(changeListener);
        ResourceUtils.resButton((AbstractButton)this._btnDN, (String)CreateDialogArb.getString(597));
        this._btnGroup.add(this._btnDN);
        this.add(this._btnUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._btnDN, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._proxyUsrLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._proxyUsr, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.padding = this.stringWidth(this._dNameLbl, "Distinguished Name") - this.stringWidth(this._proxyPwdLbl, "Proxy Password");
        this.add(this._proxyPwdLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), this.padding, 0));
        this.add(this._proxyPwd, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
    }

    private int stringWidth(JComponent jComponent, String string) {
        return jComponent.getFontMetrics(jComponent.getFont()).stringWidth(string);
    }

    private void toggleProxyInputs() {
        if (this._btnUser.isSelected()) {
            this.remove(this._dNameLbl);
            this.remove(this._dName);
            this.add(this._proxyPwdLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), this.padding, 0));
            this.add(this._proxyPwd, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        } else {
            this.remove(this._proxyPwdLbl);
            this.remove(this._proxyPwd);
            this.add(this._dNameLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
            this.add(this._dName, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    private String getProxyTypeSelected() {
        if (this._btnUser.isSelected()) {
            return PROXY_TYPE_USER_NAME;
        }
        return PROXY_TYPE_DISTINGUISHED_NAME;
    }

    public static void showProxyPanel(final Properties properties) throws SQLException {
        final ProxyConnectionPanel proxyConnectionPanel = new ProxyConnectionPanel();
        proxyConnectionPanel.init(properties);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)((Object)proxyConnectionPanel), (Component)proxyConnectionPanel.getInitialFocus(), (String)CreateDialogArb.getString(590));
        jEWTDialog.setResizable(true);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    try {
                        proxyConnectionPanel.commit(properties);
                    }
                    catch (TraversalException traversalException) {
                        traversalException.showMessageDialog((Component)((Object)proxyConnectionPanel));
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                }
            }
        });
        if (!WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            throw new SQLException(PROXY_CANCELLED);
        }
    }

    protected void commit(Properties properties) throws TraversalException {
        String string = this.getProxyTypeSelected();
        if (properties == null) {
            properties = new Properties();
        }
        if (string != null) {
            properties.setProperty(PROXY_TYPE, string);
        }
        if (this.getProxyTypeSelected().equals(PROXY_TYPE_USER_NAME)) {
            String string2 = "";
            char[] cArray = this._proxyPwd.getPassword();
            String string3 = cArray != null ? new String(cArray) : new String();
            if ((string3 = string3.trim()).length() > 0) {
                properties.setProperty("PROXY_USER_PASSWORD", string3);
            }
            properties.setProperty("PROXY_USER_NAME", this.getProxyUser());
        } else if (this.getProxyTypeSelected().equals(PROXY_TYPE_DISTINGUISHED_NAME)) {
            properties.setProperty("PROXY_USER_NAME", this.getProxyUser());
            String string4 = this._dName.getText();
            if (string4 == null || string4.length() <= 0) {
                throw new TraversalException(CreateDialogArb.getString(592));
            }
            properties.setProperty("PROXY_DISTINGUISHED_NAME", string4);
        }
        properties.setProperty(IS_PROXY, Boolean.toString(true));
    }

    private String getProxyUser() throws TraversalException {
        String string = this._proxyUsr.getText();
        if (string == null || string.length() <= 0) {
            this._proxyUsr.setText("");
            throw new TraversalException(CreateDialogArb.getString(591));
        }
        return string;
    }

    private Component getInitialFocus() {
        return null;
    }

    public void init(Properties properties) {
        String string = properties.getProperty(PROXY_TYPE);
        if (string != null && string.equals(PROXY_TYPE_DISTINGUISHED_NAME)) {
            this._btnDN.setSelected(true);
            this._dName.setText(properties.getProperty("PROXY_DISTINGUISHED_NAME"));
            this._proxyUsr.setText(properties.getProperty("PROXY_USER_NAME"));
        } else {
            this._btnUser.setSelected(true);
            this._proxyUsr.setText(properties.getProperty("PROXY_USER_NAME"));
            if (properties.getProperty("PROXY_USER_PASSWORD") != null) {
                this._proxyPwd.setText(properties.getProperty("PROXY_USER_PASSWORD"));
            }
        }
    }
}

