/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.OracleConnectionPanel;
import oracle.dbtools.raptor.connections.OracleConnectionType;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.LDAPHelper;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.ide.util.ResourceUtils;

public class LDAPConnectionPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 671332892390943229L;
    private final OracleConnectionPanel _panel;
    private JLabel ldapServerLbl = new JLabel();
    private JComboBox ldapServerCbx;
    private DataModel _model;
    private JComboBox dbServiceCbx;
    private DataModel _dbModel;
    private JLabel userLbl = new JLabel();
    private JTextField userTxt;
    private JLabel passwdLbl = new JLabel();
    private JPasswordField passwdTxt;
    private static final String LDAP_SERVER = "LDAP_SERVER";
    private static final String LDAP_USER = "LDAP_USER";
    private JButton loadBtn;
    private JLabel dbServiceLbl = new JLabel();
    private JLabel ldapContextLbl = new JLabel();
    private JComboBox ldapContext;
    private DataModel contextModel;

    public LDAPConnectionPanel(OracleConnectionPanel oracleConnectionPanel) {
        this._panel = oracleConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        this._model = new DataModel();
        this.ldapServerCbx = new JComboBox(this._model);
        ResourceUtils.resLabel((JLabel)this.ldapServerLbl, (Component)this.ldapServerCbx, (String)ConnectionDialogArb.getString(37));
        this._model.setData(LDAPHelper.getLDAPServers());
        this.ldapServerCbx.setEditable(true);
        this.ldapServerCbx.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        LDAPConnectionPanel.this.contextModel.setData(LDAPHelper.getLDAPContexts((String)((String)LDAPConnectionPanel.this.ldapServerCbx.getSelectedItem())));
                    }
                    catch (Exception exception) {
                        LDAPConnectionPanel.this._panel.setErrorStatus(ConnectionDialogArb.getString(28) + exception.getMessage());
                    }
                }
            }
        });
        this._dbModel = new DataModel();
        this.dbServiceCbx = new JComboBox(this._dbModel);
        this.userTxt = new JTextField();
        this.passwdTxt = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this.userLbl, (Component)this.userTxt, (String)ConnectionDialogArb.getString(38));
        ResourceUtils.resLabel((JLabel)this.passwdLbl, (Component)this.passwdTxt, (String)ConnectionDialogArb.getString(39));
        this.ldapContextLbl.setText(ConnectionDialogArb.getString(43));
        this.contextModel = new DataModel();
        this.ldapContext = new JComboBox(this.contextModel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.dbServiceCbx, "Center");
        this.loadBtn = new JButton("Load");
        jPanel.add((Component)this.loadBtn, "East");
        this.dbServiceLbl.setText("DB Service");
        this.loadBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ArrayList arrayList = LDAPHelper.getOrclServiceEntries((String)((String)LDAPConnectionPanel.this.ldapServerCbx.getSelectedItem()), (String)((String)LDAPConnectionPanel.this.ldapContext.getSelectedItem()));
                    Collections.sort(arrayList, new LDAPServiceComparator());
                    LDAPConnectionPanel.this._dbModel.setData(arrayList);
                    LDAPConnectionPanel.this.dbServiceCbx.setSelectedIndex(0);
                    LDAPConnectionPanel.this._panel.setStatus(ConnectionDialogArb.getString(26));
                }
                catch (Exception exception) {
                    LDAPConnectionPanel.this._panel.setErrorStatus(ConnectionDialogArb.getString(28) + exception.getMessage());
                }
            }
        });
        this.add((Component)this.ldapServerLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapServerCbx, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapContextLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.ldapContext, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)this.dbServiceLbl, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 22, 2, new Insets(2, 5, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 5, 0, 0), 0, 0));
    }

    private String getLDAPUser() {
        String string = this.userTxt.getText();
        if (string == null || string.trim().length() <= 0) {
            this._panel.setErrorStatus(ConnectionDialogArb.getString(41));
        }
        return string;
    }

    private String getLDAPPassword() {
        char[] cArray = this.passwdTxt.getPassword();
        String string = "";
        if (cArray != null && cArray.length > 0) {
            string = new String(cArray);
        } else {
            this._panel.setErrorStatus(ConnectionDialogArb.getString(42));
        }
        return string;
    }

    public void clear() {
    }

    public void populateComponent(Properties properties) {
        if (this.ldapServerCbx.getSelectedItem() != null) {
            properties.setProperty(LDAP_SERVER, (String)this.ldapServerCbx.getSelectedItem());
        }
        properties.setProperty(LDAP_USER, this.userTxt.getText());
        if (this.dbServiceCbx.getSelectedItem() != null) {
            properties.setProperty("serviceName", (String)this.dbServiceCbx.getSelectedItem());
            TCPTNSEntry tCPTNSEntry = LDAPHelper.getEntry((String)((String)this.dbServiceCbx.getSelectedItem()));
            if (tCPTNSEntry != null) {
                properties.setProperty("customUrl", tCPTNSEntry.getJDBCUrl());
                properties.setProperty("hostname", tCPTNSEntry.getHostname());
                properties.setProperty("port", tCPTNSEntry.getPortno());
            }
        }
        properties.setProperty("OracleConnectionType", OracleConnectionType.LDAP.name());
    }

    public void setDefaultPrompts() {
    }

    public void updatePrompts(Properties properties) {
        this._model.setSelectedItem(properties.getProperty(LDAP_SERVER));
        this.userTxt.setText(properties.getProperty(LDAP_USER));
        this._dbModel.setSelectedItem(properties.getProperty("serviceName"));
    }

    private class LDAPServiceComparator
    implements Comparator {
        private LDAPServiceComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareToIgnoreCase(string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataModel
    extends DefaultComboBoxModel {
        ArrayList<String> data = null;

        private DataModel() {
        }

        public void setData(ArrayList<String> arrayList) {
            assert (arrayList != null);
            this.data = arrayList;
        }

        public List getData() {
            return this.data;
        }

        public String getRowData(int n) {
            return this.data.get(n);
        }

        @Override
        public Object getElementAt(int n) {
            return this.getRowData(n);
        }

        @Override
        public int getSize() {
            return this.data != null ? this.data.size() : 0;
        }
    }
}

