/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JOptionPane;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.ImportExportPanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdeveloper.db.migration.CMConnectionsReader;
import oracle.jdevimpl.db.adapter.CMHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionGrinder {
    public static final String IMPORT = "IMPORT";
    public static final String EXPORT = "EXPORT";

    public static boolean invoke(String string) {
        String string2 = ConnectionArb.getString(string == EXPORT ? 11 : 12);
        final ImportExportPanel importExportPanel = new ImportExportPanel();
        importExportPanel.setMode(string);
        Component component = importExportPanel.getDefaultFocus();
        VetoableChangeListener vetoableChangeListener = EXPORT.equals(string) ? new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    URL uRL = importExportPanel.getSelectedURL();
                    if (URLFileSystem.isDirectoryPath((URL)uRL)) {
                        MessageDialog.error((Component)importExportPanel, (Object)ConnectionArb.format(19, URLFileSystem.getPlatformPathName((URL)uRL)), (String)ConnectionArb.getString(18), null);
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                    if (!ImportExportPanel.XML_FILTER.accept(uRL)) {
                        MessageDialog.error((Component)importExportPanel, (Object)ConnectionArb.format(20, URLFileSystem.getPlatformPathName((URL)uRL)), (String)ConnectionArb.getString(18), null);
                        throw new PropertyVetoException("bogus", propertyChangeEvent);
                    }
                    if (URLFileSystem.exists((URL)uRL) && !MessageDialog.confirm((Component)importExportPanel, (Object)ConnectionArb.format(21, URLFileSystem.getPlatformPathName((URL)uRL)), (String)ConnectionArb.getString(23), null, (boolean)true)) {
                        throw new PropertyVetoException("no", propertyChangeEvent);
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = URLFileSystem.openOutputStream((URL)uRL);
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        String string = iOException.getLocalizedMessage().replace('\n', ' ');
                        MessageDialog.error((Component)importExportPanel, (Object)ConnectionArb.format(22, string), (String)ConnectionArb.getString(23), null);
                        throw new PropertyVetoException("bogus", propertyChangeEvent);
                    }
                }
            }
        } : null;
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)importExportPanel, (Component)component, (String)string2, (int)7, (VetoableChangeListener)vetoableChangeListener);
        if (bl) {
            Object[] objectArray = importExportPanel.getSelectedValues();
            HashSet<String> hashSet = new HashSet<String>();
            for (Object object : objectArray) {
                hashSet.add((String)object);
            }
            ConnectionGrinder.doImportExport(importExportPanel.getSelectedURL(), hashSet, string, importExportPanel.oldCM);
        }
        return true;
    }

    private static boolean _isStringInArray(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean doImportExport(URL uRL, Set<String> set, String string, boolean bl) {
        DatabaseConnections databaseConnections = null;
        if (set.size() > 0) {
            if (string.equals(EXPORT)) {
                try {
                    File file = new File(uRL.getFile());
                    if (file.exists()) {
                        try {
                            file.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    DatabaseConnections databaseConnections2 = DatabaseConnections.getPrivateInstance((URL)uRL);
                    String string2 = URLFileSystem.getPlatformPathName((URL)uRL);
                    databaseConnections = DatabaseConnectionStores.getInstance().getCurrentStore();
                    for (String string3 : databaseConnections.listConnections()) {
                        if (!set.contains(string3)) continue;
                        Properties properties = databaseConnections.getProperties(string3);
                        databaseConnections2.addConnection(string3, properties);
                    }
                    databaseConnections2.saveConnections();
                    MessageDialog.information(null, (Object)ConnectionArb.format(25, string2), (String)ConnectionArb.getString(24), null);
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)null, (Exception)exception, (String)ConnectionArb.getString(26));
                }
            } else {
                String[] stringArray = null;
                databaseConnections = DatabaseConnectionStores.getInstance().getCurrentStore();
                stringArray = databaseConnections == null || databaseConnections.listConnections() == null ? new String[]{} : databaseConnections.listConnections().toArray(new String[databaseConnections.listConnections().size()]);
                try {
                    Object object2;
                    HashMap<Object, Properties> hashMap = new HashMap<Object, Properties>();
                    if (bl) {
                        object2 = new CMConnectionsReader(uRL.getFile(), true);
                        List object3 = object2.read();
                        for (Properties properties : object3) {
                            String string4 = properties.getProperty("ConnectionName");
                            if (!set.contains(string4)) continue;
                            hashMap.put(string4, ConnectionGrinder.convertProps(properties));
                        }
                    } else {
                        object2 = DatabaseConnections.getPrivateInstance((URL)uRL);
                        for (Object object : object2.listConnections()) {
                            if (!set.contains(object)) continue;
                            hashMap.put(object, object2.getProperties((String)object));
                        }
                    }
                    for (String string5 : set) {
                        Object object;
                        object = (Properties)hashMap.get(string5);
                        if (object == null) continue;
                        boolean bl2 = true;
                        boolean bl3 = ConnectionGrinder._isStringInArray(string5, stringArray);
                        if (bl3) {
                            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), ConnectionArb.format(2, string5), ConnectionArb.getString(17), 0);
                            boolean bl4 = bl2 = n != 1;
                        }
                        if (!bl2) continue;
                        DatabaseConnections databaseConnections2 = DatabaseConnectionStores.getInstance().getCurrentStore();
                        if (bl3) {
                            databaseConnections2.updateConnection(string5, string5, (Properties)object);
                            continue;
                        }
                        databaseConnections2.addConnection(string5, (Properties)object);
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)null, (Exception)exception, (String)ConnectionArb.getString(26));
                }
            }
        }
        return true;
    }

    private static Properties convertProps(Properties properties) {
        Properties properties2 = ((DatabaseProvider)CMHelper.createReferenceFromDescriptor((Properties)properties)).getProperties();
        if ("oraJDBC".equals(properties2.getProperty("subtype"))) {
            String string = properties2.getProperty("password");
            String string2 = properties2.getProperty("SavePassword");
            if (!ModelUtil.hasLength((String)string) && string2 == null) {
                properties2.setProperty("SavePassword", Boolean.FALSE.toString());
            }
        }
        return properties2;
    }
}

