/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.SQLPlusFileChooser;
import oracle.dbtools.raptor.config.WorksheetDndOptionPanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class WorkSheetInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    private JCheckBox m_chkAutocommit = new JCheckBox();
    private JCheckBox m_openWorkSheet = new JCheckBox();
    private JTextField m_maxScriptRows = new JTextField();
    private SQLPlusFileChooser m_sqlPlusOptions = new SQLPlusFileChooser();
    private JCheckBox m_saveBinds = new JCheckBox();
    private JCheckBox m_closeWorksheet = new JCheckBox();
    private JCheckBox m_promptWhenClose = new JCheckBox();
    private WorksheetDndOptionPanel m_worksheetPanel = new WorksheetDndOptionPanel();

    public WorkSheetInfo() {
        this.setHelpID("f1_dbworksheetparams_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_chkAutocommit.setSelected(dBConfig.getBoolean("AUTOCOMMIT"));
        this.m_openWorkSheet.setSelected(dBConfig.getBoolean("WORKSHEETOPEN"));
        this.m_closeWorksheet.setSelected(dBConfig.getBoolean("WORKSHEETCLOSE"));
        this.m_promptWhenClose.setSelected(dBConfig.getBoolean("PROMPTWHENCLOSE"));
        this.m_maxScriptRows.setText(dBConfig.getString("MAXSCRIPTROWS"));
        this.m_saveBinds.setSelected(dBConfig.getBoolean("SAVEBINDS"));
        this.m_worksheetPanel.setDragType(dBConfig.getInt("DRAG_N_DROP_CHOICES"));
        this.m_worksheetPanel.setPrompt(dBConfig.getInt("DRAG_N_DROP_PROMPT"));
        this.m_sqlPlusOptions.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTOCOMMIT", this.m_chkAutocommit.isSelected());
        dBConfig.putBoolean("WORKSHEETOPEN", this.m_openWorkSheet.isSelected());
        dBConfig.putBoolean("WORKSHEETCLOSE", this.m_closeWorksheet.isSelected());
        dBConfig.putBoolean("PROMPTWHENCLOSE", this.m_promptWhenClose.isSelected());
        dBConfig.putString("MAXSCRIPTROWS", this.m_maxScriptRows.getText());
        dBConfig.putBoolean("SAVEBINDS", this.m_saveBinds.isSelected());
        dBConfig.putInt("DRAG_N_DROP_CHOICES", this.m_worksheetPanel.getDragType());
        dBConfig.putInt("DRAG_N_DROP_PROMPT", this.m_worksheetPanel.getPrompt());
        this.m_sqlPlusOptions.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkAutocommit, (String)PreferencesArb.getString(4));
        ResourceUtils.resButton((AbstractButton)this.m_openWorkSheet, (String)PreferencesArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.m_closeWorksheet, (String)PreferencesArb.getString(1));
        ResourceUtils.resButton((AbstractButton)this.m_promptWhenClose, (String)PreferencesArb.getString(2));
        ResourceUtils.resButton((AbstractButton)this.m_saveBinds, (String)PreferencesArb.getString(8));
        this.add(this.m_chkAutocommit, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_openWorkSheet, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_closeWorksheet, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_promptWhenClose, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(3)), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_maxScriptRows, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_sqlPlusOptions), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_saveBinds, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_maxScriptRows.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == 'u') {
                    WorkSheetInfo.this.m_maxScriptRows.setText("unlimited");
                    keyEvent.consume();
                } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    WorkSheetInfo.this.getToolkit().beep();
                    keyEvent.consume();
                }
            }
        });
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 2;
        this.add(jLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridy = 9;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.fill = 2;
        this.add(this.m_worksheetPanel, gridBagConstraints2);
    }
}

