/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class PlSqlCompilerOptionsPanel
extends oracle.ide.db.panels.plsql.PlSqlCompilerOptionsPanel {
    private JTextField profilerDir = new JTextField();
    private JComboBox optimLevel = new JComboBox();
    private JComboBox plScopeSettings = new JComboBox();
    private static String[] levels = new String[]{"1", "2", "3"};
    private static String[] identifiers = new String[]{"All", "None"};

    public PlSqlCompilerOptionsPanel() throws Exception {
        this.setHelpID("f1_idedidesetplsqlcompiler_html");
        this.jbInit();
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.profilerDir.setText(dBConfig.getString("PLSQLPROFILERDIR"));
        this.optimLevel.setModel(new DefaultComboBoxModel<String>(levels));
        this.optimLevel.setSelectedItem(dBConfig.getString("PLSQLOPTIMLEVEL"));
        this.plScopeSettings.setModel(new DefaultComboBoxModel<String>(identifiers));
        this.plScopeSettings.setSelectedItem(dBConfig.getString("PLSQLSCOPE"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("PLSQLPROFILERDIR", this.profilerDir.getText());
        dBConfig.putString("PLSQLOPTIMLEVEL", (String)this.optimLevel.getSelectedItem());
        dBConfig.putString("PLSQLSCOPE", (String)this.plScopeSettings.getSelectedItem());
        Connections connections = Connections.getInstance();
        if ("All".equals(this.plScopeSettings.getSelectedItem())) {
            for (String string : connections.getConnNames()) {
                if (!connections.isConnectionOpen(string)) continue;
                try {
                    int n = connections.getConnection(string).getMetaData().getDatabaseMajorVersion();
                    if (n < 11) continue;
                    DBUtil.getInstance().execute(string, "alter session set PLSCOPE_SETTINGS='identifiers:all'", new ArrayList());
                }
                catch (SQLException sQLException) {
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        } else {
            for (String string : connections.getConnNames()) {
                if (!connections.isConnectionOpen(string)) continue;
                try {
                    int n = connections.getConnection(string).getMetaData().getDatabaseMajorVersion();
                    if (n < 11) continue;
                    DBUtil.getInstance().execute(string, "alter session set PLSCOPE_SETTINGS='identifiers:none'", new ArrayList());
                }
                catch (SQLException sQLException) {
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        super.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        int n = 6;
        this.add(new JLabel("Optimization Level:"), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.optimLevel, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel("PLScope identifiers:"), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.plScopeSettings, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

