/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFileSystem;

public class DataEditorOptionPanel
extends JPanel {
    private static final long serialVersionUID = -7860081933092101605L;
    private JCheckBox m_AutoCommit = new JCheckBox();
    private JCheckBox m_commitChangesRB = new JCheckBox();
    private JButton m_clearSettingsButton = new JButton();

    public DataEditorOptionPanel() {
        try {
            this.initGUI();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(PreferencesArb.getString(77)));
        this.m_commitChangesRB.setText(PreferencesArb.getString(79));
        this.m_AutoCommit.setText(PreferencesArb.getString(80));
        this.m_clearSettingsButton.setText(PreferencesArb.getString(82));
        this.m_AutoCommit.setEnabled(false);
        this.add((Component)new JLabel(PreferencesArb.getString(78)), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_commitChangesRB, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_AutoCommit, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel(PreferencesArb.getString(81)), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.m_clearSettingsButton, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_clearSettingsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URL uRL;
                ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
                if (extensionRegistry.findExtension("oracle.sqldeveloper") != null && (uRL = extensionRegistry.getSystemDirectory("oracle.sqldeveloper")) != null && URLFileSystem.isDirectory((URL)uRL)) {
                    URL[] uRLArray;
                    for (URL uRL2 : uRLArray = URLFileSystem.list((URL)uRL)) {
                        if (!uRL2.getFile().endsWith("TableSettings.xml") && !uRL2.getFile().endsWith("SavedFilters.xml")) continue;
                        URLFileSystem.delete((URL)uRL2);
                    }
                }
            }
        });
        this.m_commitChangesRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataEditorOptionPanel.this.m_commitChangesRB.isSelected()) {
                    DataEditorOptionPanel.this.m_AutoCommit.setEnabled(true);
                } else {
                    DataEditorOptionPanel.this.m_AutoCommit.setSelected(false);
                    DataEditorOptionPanel.this.m_AutoCommit.setEnabled(false);
                }
            }
        });
    }

    public void setFromPreferences(DBConfig dBConfig) {
        boolean bl = dBConfig.getBoolean("DATAEDITOR_POSTONROWCHANGE");
        this.m_AutoCommit.setEnabled(bl);
        this.m_commitChangesRB.setSelected(bl);
        this.m_AutoCommit.setSelected(dBConfig.getBoolean("DATAEDITOR_AUTOCOMMIT"));
    }

    public void savePreferences(DBConfig dBConfig) {
        dBConfig.putBoolean("DATAEDITOR_POSTONROWCHANGE", this.m_commitChangesRB.isSelected());
        dBConfig.putBoolean("DATAEDITOR_AUTOCOMMIT", this.m_AutoCommit.isSelected());
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        DataEditorOptionPanel dataEditorOptionPanel = new DataEditorOptionPanel();
        jDialog.add((Component)dataEditorOptionPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }
}

