/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConfig
extends HashStructureAdapter
implements Copyable {
    public static final String KEY = "DBConfig";
    public static final String WORKSHEETOPEN = "WORKSHEETOPEN";
    public static final String WORKSHEETCLOSE = "WORKSHEETCLOSE";
    public static final String REPORTCLOSE = "REPORTCLOSE";
    public static final String MAXSCRIPTROWS = "MAXSCRIPTROWS";
    public static final String AUTOCOMMIT = "AUTOCOMMIT";
    public static final String DEFAULTPATH = "DEFAULTPATH";
    public static final String SAVEBINDS = "SAVEBINDS";
    public static final String PROMPT_WHEN_CLOSE = "PROMPTWHENCLOSE";
    public static final String EXPL_OBJECT_NAME = "EXPL_OBJECT_NAME";
    public static final String EXPL_OPTIONS = "EXPL_OPTIONS";
    public static final String EXPL_COST = "EXPL_COST";
    public static final String EXPL_CARDINALITY = "EXPL_CARDINALITY";
    public static final String AUTO_OBJECT_NAME = "AUTO_OBJECT_NAME";
    public static final String AUTO_OPTIONS = "AUTO_OPTIONS";
    public static final String AUTO_COST = "AUTO_COST";
    public static final String AUTO_CARDINALITY = "AUTO_CARDINALITY";
    public static final String LAST_OUTPUT_ROWS = "LAST_OUTPUT_ROWS";
    public static final String LAST_CR_BUFFER_GETS = "LAST_CR_BUFFER_GETS";
    public static final String LAST_ELAPSED_TIME = "LAST_ELAPSED_TIME";
    public static final String LAST_STARTS = "LAST_STARTS";
    public static final String EXPL_PREDICATES = "EXPL_PREDICATES";
    public static final String EXPL_PROJECTION = "EXPL_PROJECTION";
    public static final String EXPL_OTHER_XML = "EXPL_OTHER_XML";
    public static final String AUTO_PREDICATES = "AUTO_PREDICATES";
    public static final String AUTO_PROJECTION = "AUTO_PROJECTION";
    public static final String AUTO_OTHER_XML = "AUTO_OTHER_XML";
    public static final String MYSTAT = "V$MYSTAT";
    public static final String AUTOPIN = "AUTOPIN";
    public static final String DDL_SEGMENTS = "DDL_SEGMENTS";
    public static final String DDL_TERMINATOR = "DDL_TERMINATOR";
    public static final String DDL_PRETTY = "DDL_PRETTY";
    public static final String DDL_BYTE = "DDL_BYTE";
    public static final String DDL_FORCE = "DDL_FORCE";
    public static final String DDL_ALTER = "DDL_ALTER";
    public static final String DDL_SCHEMA = "DDL_SCHEMA";
    public static final String NLS_LANG = "NLS_LANG";
    public static final String NLS_TERR = "NLS_TERR";
    public static final String NLS_SORT = "NLS_SORT";
    public static final String NLS_COMP = "NLS_COMP";
    public static final String NLS_DATE_LANG = "NLS_DATE_LANG";
    public static final String NLS_DATE_FORM = "NLS_DATE_FORM";
    public static final String NLS_TS_FORM = "NLS_TS_FORM";
    public static final String NLS_TS_TZ_FORM = "NLS_TS_TZ_FORM";
    public static final String NLS_DEC_SEP = "NLS_DEC_SEP";
    public static final String NLS_GRP_SEP = "NLS_GRP_SEP";
    public static final String NLS_CURR = "NLS_CURR";
    public static final String NLS_ISO_CURR = "NLS_ISO_CURR";
    public static final String NLS_LENGTH = "NLS_LENGTH";
    public static final String ARRAYFETCHSIZE = "ARRAYFETCHSIZE";
    public static final String NULLDISPLAY = "NULLDISPLAY";
    public static final String NULLCOLOR = "NULLCOLOR";
    public static final String EXPORTDIR = "EXPORTDIR";
    private static final String EXTENSION = "EXTENSION";
    private static final String TPDRIVER = "TPDRIVER";
    public static final String TEMPLATES = "TEMPLATES";
    public static final String PLSQLPROFILERDIR = "PLSQLPROFILERDIR";
    public static final String PLSQLOPTIMLEVEL = "PLSQLOPTIMLEVEL";
    public static final String PLSQLSCOPE = "PLSQLSCOPE";
    public static final String SINGLE_CLICK_TREE = "OPEN_ON_SINGLE_CLICK";
    public static final String SEARCH_AUTO_WILDCARD = "SEARCH_AUTO_WILDCARD";
    public static final String EXPORT_DELIMITER = "EXPORT_DELIMITER";
    public static final String IMPORT_SQLGEN_CASE_SENSITIVITY = "IMPORT_SQLGEN_CASE_SENSITIVITY";
    public static final String DRAG_N_DROP_CHOICES = "DRAG_N_DROP_CHOICES";
    public static final String DRAG_N_DROP_PROMPT = "DRAG_N_DROP_PROMPT";
    public static final int DRAG_N_DROP_SELECT = 1;
    public static final int DRAG_N_DROP_JOIN = 2;
    public static final int DRAG_N_DROP_INSERT = 3;
    public static final int DRAG_N_DROP_UPDATE = 4;
    public static final int DRAG_N_DROP_DELETE = 5;
    public static final String AUTO_READONLY_FORMAT = "AUTO_READONLY_FORMAT";
    public static final String GLOGIN = "GLOGIN";
    public static final String GLOGIN_FILE = "";
    public static final String USE_THICK_DRIVER = "USE_THICK_DRIVER";
    public static final String DATAEDITOR_AUTOCOMMIT = "DATAEDITOR_AUTOCOMMIT";
    public static final String DATAEDITOR_POSTONROWCHANGE = "DATAEDITOR_POSTONROWCHANGE";
    public static final String CSV_DATE_FORMAT = "CSV_DATE_FORMAT";
    public static final String DATA_IMPORT_TRUE = "DATA_IMPORT_TRUE";
    public static final String DATA_IMPORT_FALSE = "DATA_IMPORT_FALSE";
    public static final String DATA_IMPORT_DATE_FORMAT = "DATA_IMPORT_DATE_FORMAT";
    private static Map<String, Object> s_defaults = new HashMap<String, Object>();

    private static Integer getIntegerDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    private static String getStringDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    private Boolean getBooleanDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.valueOf(object.toString()) : null);
    }

    private DBConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static DBConfig getInstance(PropertyStorage propertyStorage) {
        return new DBConfig(DBConfig.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static DBConfig getInstance(TraversableContext traversableContext) {
        return DBConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static DBConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return DBConfig.getInstance((PropertyStorage)preferences);
    }

    public Map<String, String> getNLSMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : s_defaults.keySet()) {
            if (string.indexOf("NLS_") != 0) continue;
            hashMap.put(string, this._hash.getString(string) == null ? s_defaults.get(string).toString() : this._hash.getString(string));
        }
        return hashMap;
    }

    public void addStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.addStructureChangeListener(structureChangeListener);
    }

    public void removeStructureChangeListener(StructureChangeListener structureChangeListener) {
        this._hash.removeStructureChangeListener(structureChangeListener);
    }

    public String getString(String string) {
        return this._hash.getString(string, DBConfig.getStringDefault(string));
    }

    public void putString(String string, String string2) {
        this._hash.putString(string, string2);
    }

    public int getInt(String string) {
        return this._hash.getInt(string, DBConfig.getIntegerDefault(string).intValue());
    }

    public void putInt(String string, int n) {
        this._hash.putInt(string, n);
    }

    public Boolean getBoolean(String string) {
        return this._hash.getBoolean(string, this.getBooleanDefault(string).booleanValue());
    }

    public void putBoolean(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    public Set<String> getPropertyKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(s_defaults.keySet());
        hashSet.addAll(this._hash.keySet());
        return hashSet;
    }

    public ArrayList<String> getExtensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, List<String>> map = this.getExtensions();
        List<String> list = map.get(string);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public void putExtensions(Map<String, List<String>> map) {
        HashStructure hashStructure = HashStructure.newInstance();
        for (String string : map.keySet()) {
            List<String> list = map.get(string);
            ListStructure listStructure = ListStructure.newInstance();
            for (String string2 : list) {
                listStructure.add((Object)string2);
            }
            hashStructure.putListStructure(string, listStructure);
        }
        this._hash.putHashStructure(EXTENSION, hashStructure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getExtensions() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Object object = this._hash.getObject(EXTENSION);
        if (object instanceof HashStructure) {
            HashStructure hashStructure = (HashStructure)object;
            for (String string : hashStructure.keySet()) {
                ListStructure listStructure = hashStructure.getOrCreateListStructure(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                Object object2 = listStructure.iteratorLock();
                synchronized (object2) {
                    for (Object e : listStructure) {
                        arrayList.add((String)e);
                    }
                }
                hashMap.put(string, arrayList);
            }
        } else {
            String string;
            if (object instanceof String && (string = (String)object) != null && string.length() > 5) {
                try {
                    DOMParser dOMParser = new DOMParser();
                    dOMParser.setPreserveWhitespace(false);
                    dOMParser.parse((InputStream)new ByteArrayInputStream(string.getBytes()));
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    NodeList nodeList = xMLDocument.getChildNodes();
                    NodeList nodeList2 = nodeList.item(0).getChildNodes();
                    for (int i = 0; i < nodeList2.getLength(); ++i) {
                        NodeList nodeList3 = nodeList2.item(i).getChildNodes();
                        String string2 = nodeList3.item(0).getTextContent();
                        String string3 = nodeList3.item(1).getTextContent();
                        ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string2);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            hashMap.put(string2, arrayList);
                        }
                        arrayList.add(string3);
                    }
                }
                catch (SAXException sAXException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
                }
                catch (IOException iOException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
            this.putExtensions(hashMap);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLPath getThirdPartyPath() {
        URLPath uRLPath = new URLPath();
        Object object = this._hash.getObject(TPDRIVER);
        if (object instanceof ListStructure) {
            ListStructure listStructure = this._hash.getOrCreateListStructure(TPDRIVER);
            Object object2 = listStructure.iteratorLock();
            synchronized (object2) {
                for (Object e : listStructure) {
                    URL uRL = (URL)e;
                    uRLPath.add(uRL);
                }
            }
        } else if (object instanceof String) {
            uRLPath.add(this.parsePathFromXML((String)object));
            this.setThirdPartyPath(uRLPath);
        }
        return uRLPath;
    }

    public void setThirdPartyPath(URLPath uRLPath) {
        ListStructure listStructure = ListStructure.newInstance();
        for (URL uRL : uRLPath.getEntries()) {
            listStructure.add((Object)uRL);
        }
        this._hash.putListStructure(TPDRIVER, listStructure);
    }

    private URLPath parsePathFromXML(String string) {
        URLPath uRLPath = new URLPath();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (string != null && string.length() > 5) {
            try {
                dOMParser.parse((InputStream)new ByteArrayInputStream(string.getBytes()));
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getTextContent();
                    URL uRL = new URL(string2);
                    uRLPath.add(uRL);
                }
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return uRLPath;
    }

    public DBConfig() {
        super(HashStructure.newInstance());
    }

    public HashMap<String, Object> getAllParameters() {
        return new HashMap<String, Object>();
    }

    public void setAllParameters(HashMap<String, Object> hashMap) {
        for (String string : hashMap.keySet()) {
            Object object = hashMap.get(string);
            if (object instanceof Boolean) {
                this.putBoolean(string, (Boolean)object);
                continue;
            }
            if (object instanceof Integer) {
                this.putInt(string, (Integer)object);
                continue;
            }
            if (object == null) continue;
            this.putString(string, object.toString());
        }
    }

    static {
        s_defaults.put(WORKSHEETOPEN, true);
        s_defaults.put(WORKSHEETCLOSE, false);
        s_defaults.put(REPORTCLOSE, false);
        s_defaults.put(MAXSCRIPTROWS, 5000);
        s_defaults.put(AUTOCOMMIT, false);
        s_defaults.put(DEFAULTPATH, null);
        s_defaults.put(SAVEBINDS, false);
        s_defaults.put(EXPL_OBJECT_NAME, true);
        s_defaults.put(EXPL_OPTIONS, true);
        s_defaults.put(EXPL_COST, true);
        s_defaults.put(EXPL_CARDINALITY, false);
        s_defaults.put(AUTO_OBJECT_NAME, true);
        s_defaults.put(AUTO_OPTIONS, false);
        s_defaults.put(AUTO_COST, true);
        s_defaults.put(AUTO_CARDINALITY, false);
        s_defaults.put(LAST_OUTPUT_ROWS, false);
        s_defaults.put(LAST_CR_BUFFER_GETS, true);
        s_defaults.put(LAST_ELAPSED_TIME, false);
        s_defaults.put(LAST_STARTS, false);
        s_defaults.put(EXPL_PREDICATES, true);
        s_defaults.put(EXPL_PROJECTION, false);
        s_defaults.put(EXPL_OTHER_XML, false);
        s_defaults.put(AUTO_PREDICATES, true);
        s_defaults.put(AUTO_PROJECTION, false);
        s_defaults.put(AUTO_OTHER_XML, false);
        s_defaults.put(MYSTAT, true);
        s_defaults.put(AUTOPIN, false);
        s_defaults.put(DDL_SEGMENTS, true);
        s_defaults.put(DDL_TERMINATOR, true);
        s_defaults.put(DDL_PRETTY, true);
        s_defaults.put(DDL_BYTE, true);
        s_defaults.put(DDL_FORCE, true);
        s_defaults.put(DDL_ALTER, false);
        s_defaults.put(DDL_SCHEMA, true);
        s_defaults.put(NLS_LANG, LocaleMapper.getOraLanguage((Locale)Locale.getDefault()));
        s_defaults.put(NLS_TERR, LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)LocaleMapper.getOraLanguage((Locale)Locale.getDefault()), (String)LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        OraTerritory oraTerritory = OraTerritory.getInstance((String)LocaleMapper.getOraLanguage((Locale)Locale.getDefault()), (String)LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        if (oraLocaleInfo.getLinguisticSort().indexOf("BINARY") > -1) {
            s_defaults.put(NLS_SORT, "BINARY");
        } else {
            s_defaults.put(NLS_SORT, oraLocaleInfo.getLinguisticSort());
        }
        s_defaults.put(NLS_COMP, "BINARY");
        s_defaults.put(NLS_DATE_LANG, LocaleMapper.getOraLanguage((Locale)Locale.getDefault()));
        s_defaults.put(NLS_DATE_FORM, oraTerritory.getOracleDateFormatString());
        s_defaults.put(NLS_TS_FORM, oraTerritory.getNLSTimestampFormatString());
        s_defaults.put(NLS_TS_TZ_FORM, oraTerritory.getNLSTimestampAndTimezoneFormatString());
        s_defaults.put(NLS_DEC_SEP, oraTerritory.getDecimalCharacter());
        s_defaults.put(NLS_GRP_SEP, oraTerritory.getGroupSeparator());
        s_defaults.put(NLS_CURR, oraTerritory.getLocalCurrencySymbol());
        s_defaults.put(NLS_ISO_CURR, LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        s_defaults.put(NLS_LENGTH, "BYTE");
        s_defaults.put(ARRAYFETCHSIZE, 50);
        s_defaults.put(NULLCOLOR, "NONE");
        s_defaults.put(NULLDISPLAY, "(null)");
        if (RaptorExtensionConstants.isStandAlone()) {
            s_defaults.put(SINGLE_CLICK_TREE, true);
        } else {
            s_defaults.put(SINGLE_CLICK_TREE, false);
        }
        s_defaults.put(SEARCH_AUTO_WILDCARD, false);
        s_defaults.put(EXPORTDIR, null);
        s_defaults.put(EXTENSION, null);
        s_defaults.put(TPDRIVER, null);
        s_defaults.put(EXPORT_DELIMITER, ",");
        s_defaults.put(IMPORT_SQLGEN_CASE_SENSITIVITY, Boolean.FALSE);
        s_defaults.put(PLSQLSCOPE, "All");
        s_defaults.put(DRAG_N_DROP_CHOICES, 1);
        s_defaults.put(DRAG_N_DROP_PROMPT, 1);
        s_defaults.put(USE_THICK_DRIVER, false);
        s_defaults.put(AUTO_READONLY_FORMAT, false);
        s_defaults.put(GLOGIN, false);
        s_defaults.put(GLOGIN_FILE, GLOGIN_FILE);
        s_defaults.put(DATAEDITOR_POSTONROWCHANGE, false);
        s_defaults.put(DATAEDITOR_AUTOCOMMIT, false);
        s_defaults.put(PROMPT_WHEN_CLOSE, true);
        s_defaults.put(DATA_IMPORT_TRUE, "True");
        s_defaults.put(DATA_IMPORT_FALSE, "False");
    }
}

