/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.format.CSVFormatter;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public class ConfigChangeListener
extends StructureChangeListener {
    public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
        HashMap<String, String> hashMap = null;
        String string = "";
        for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
            string = changeInfo.getPropertyLocalName();
            if ("MAXSCRIPTROWS".equals(string)) {
                ResultSetFormatter.setMaxRows((int)changeInfo.getNewValueAsInt());
                continue;
            }
            if ("EXPORT_DELIMITER".equals(string)) {
                CSVFormatter.setDelimiter((String)changeInfo.getNewValueAsString());
                continue;
            }
            if (string.startsWith("NLS_")) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, String>();
                }
                hashMap.put(string, changeInfo.getNewValueAsString());
                continue;
            }
            if (!"AUTOCOMMIT".equals(string) && !"ARRAYFETCHSIZE".equals(string)) continue;
            RaptorDBAddin.setAutoCommit(changeInfo.getNewValueAsBoolean());
        }
        if (hashMap != null) {
            Connections connections = Connections.getInstance();
            for (String string2 : connections.getConnNames()) {
                try {
                    if (!connections.isConnectionOpen(string2)) continue;
                    Connection connection = connections.getConnection(string2);
                    DefaultNLSProvider defaultNLSProvider = NLSProvider.getProvider((String)string2);
                    if (defaultNLSProvider == null) continue;
                    defaultNLSProvider.updateDefaults(hashMap);
                    defaultNLSProvider.initConnection();
                }
                catch (Exception exception) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
    }
}

