/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.apex.importer.ApexDeployToConnectionPanel;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImportFilePanel;
import oracle.dbtools.raptor.apex.importer.ApexImportFinalPanel;
import oracle.dbtools.raptor.apex.importer.ApexImportIDPanel;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.jdbc.OraclePreparedStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApexImporter {
    public static final String CONNECTION = "connection";
    public static final String APEX_NAME = "p_name";
    public static final String APEX_ALIAS = "p_alias";
    public static final String APEX_ID = "p_id";
    public static final String APEX_BUILD = "p_build_status";
    public static final String APEX_OWNER = "p_owner";
    public static final String APEX_OFFSET = "offset";
    public static final String APEX_SGID = "sgid";
    public static final String APEX_WORKSPACE = "workspace_name";
    public static final String CONTEXT_KEY = "CONTEXT";
    public static final String WIZARD_KEY = "WIZ";
    public static final String FILE_KEY = "FILENAME";
    public static final String SCRIPT_STATUS_KEY = "SCRIPT.STATUS";
    public static final String RUN_SCRIPT_KEY = "SCRIPT.RUN";
    private static final Logger LOGGER = Logger.getLogger(ApexImporter.class.getName());

    public static void showWizard(Context context) {
        DBObject dBObject = new DBObject(context.getSelection()[0]);
        context.setProperty("DB_OBJECT", (Object)dBObject);
        Step[] stepArray = new Step[3];
        stepArray[0] = new Step(ApexImportArb.getString(1), ApexImportFilePanel.class);
        stepArray[0].setHelpID("f1_apeximport_file");
        stepArray[1] = new Step(ApexImportArb.getString(2), ApexImportIDPanel.class);
        stepArray[1].setHelpID("f1_apeximport_id");
        stepArray[2] = new Step(ApexImportArb.getString(3), ApexImportFinalPanel.class);
        stepArray[2].setHelpID("f1_apeximport_finish");
        Namespace namespace = new Namespace();
        namespace.put(CONTEXT_KEY, (Object)context);
        FSMWizard fSMWizard = new FSMWizard(stepArray, namespace);
        fSMWizard.setWizardTitle(ApexImportArb.getString(0));
        fSMWizard.setWelcomePageAdded(false);
        fSMWizard.setFinishPageAdded(true);
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ApexImportArb.getImage(16));
        fSMWizard.setRoadmapVisible(false);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put(WIZARD_KEY, (Object)wizardDialog);
        boolean bl = WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.dispose();
    }

    public static void showDeployWizard(Context context) {
        final DBObject dBObject = new DBObject(context.getSelection()[0]);
        context.setProperty("DB_OBJECT", (Object)dBObject);
        Step[] stepArray = new Step[3];
        stepArray[0] = new Step(ApexImportArb.getString(28), ApexDeployToConnectionPanel.class);
        stepArray[0].setHelpID("f1_apexdeployto_id");
        stepArray[1] = new Step(ApexImportArb.getString(2), ApexImportIDPanel.class);
        stepArray[1].setHelpID("f1_apeximport_id");
        stepArray[2] = new Step(ApexImportArb.getString(3), ApexImportFinalPanel.class);
        stepArray[2].setHelpID("f1_apeximport_finish");
        Namespace namespace = new Namespace();
        namespace.put(CONTEXT_KEY, (Object)context);
        File file = null;
        Ide.getMainWindow().setCursor(new Cursor(3));
        try {
            file = File.createTempFile("apex", ".sql");
        }
        catch (IOException iOException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        final File file2 = file;
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public void cancel() {
            }

            public Object doWork() {
                ApexImporter.saveToFile(dBObject, file2);
                return null;
            }

            public void finish(Object object) {
            }

            public void preWork() {
            }
        };
        ApexImporter.saveToFile(dBObject, file2);
        namespace.put(FILE_KEY, (Object)file.getAbsolutePath());
        FSMWizard fSMWizard = new FSMWizard(stepArray, namespace);
        fSMWizard.setWizardTitle(ApexImportArb.getString(29));
        fSMWizard.setWelcomePageAdded(false);
        fSMWizard.setFinishPageAdded(true);
        fSMWizard.setShowStepNumber(true);
        fSMWizard.updateImage(ApexImportArb.getImage(16));
        fSMWizard.setRoadmapVisible(false);
        WizardDialog wizardDialog = fSMWizard.getDialog((Frame)Ide.getMainWindow());
        namespace.put(WIZARD_KEY, (Object)wizardDialog);
        boolean bl = WizardLauncher.runDialog((JDialog)wizardDialog);
        wizardDialog.dispose();
        Ide.getMainWindow().setCursor(new Cursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInfo(String string) {
        BufferedReader bufferedReader = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            boolean bl = false;
            int n = 0;
            while (true) {
                ++n;
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    break;
                }
                if (bl) {
                    if (string2.trim().toLowerCase().startsWith("end")) {
                        break;
                    }
                    String[] stringArray = string2.split("=>");
                    if (stringArray.length > 1) {
                        String string3 = stringArray[1].trim();
                        if (string3.charAt(string3.length() - 1) == ',') {
                            string3 = string3.substring(0, string3.length() - 1);
                        }
                        string3 = string3.trim().replaceAll("'", "");
                        hashMap.put(stringArray[0].trim(), string3);
                    }
                }
                if (!string2.trim().toLowerCase().startsWith("wwv_flow_api.create_flow")) continue;
                bl = true;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe("Could not find:" + string);
        }
        catch (IOException iOException) {
            LOGGER.severe("Could read find:" + string);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFile(File file, File file2, Map<String, String> map) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        Map<String, String> map2 = ApexImporter.getInfo(file.getAbsolutePath());
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            bufferedWriter.write("set scan off");
            bufferedWriter.newLine();
            boolean bl = true;
            boolean bl2 = false;
            int n = 0;
            while (true) {
                ++n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if (bl) {
                    if (string.trim().toLowerCase().startsWith("wwv_flow_api.create_flow")) {
                        bl2 = true;
                    }
                    if (bl2 && string.trim().toLowerCase().startsWith("end")) {
                        bl = false;
                    }
                    boolean bl3 = false;
                    String[] stringArray = string.split("=>|,");
                    if (stringArray.length > 1 && map.containsKey(stringArray[0].trim())) {
                        boolean bl4 = false;
                        if (string.trim().lastIndexOf(",") == string.trim().length() - 1) {
                            bl4 = true;
                        }
                        string = stringArray[0] + " => " + "'" + map.get(stringArray[0].trim()) + "'";
                        if (bl4) {
                            string = string + ",";
                        }
                        bl3 = true;
                    }
                    if (string.indexOf("wwv_flow.g_flow_id := ") > 0) {
                        string = "wwv_flow.g_flow_id := " + map.get(APEX_ID) + ";";
                        bl3 = true;
                    }
                    if (string.indexOf("wwv_flow_api.g_id_offset :=") > 0) {
                        string = "wwv_flow_api.g_id_offset :=" + map.get(APEX_OFFSET) + ";";
                        bl3 = true;
                    }
                    if (string.indexOf("wwv_flow_api.set_security_group_id(p_security_group_id=>") > 0) {
                        string = "wwv_flow_api.set_security_group_id(p_security_group_id=>" + map.get(APEX_SGID) + ");";
                        bl3 = true;
                    }
                    if (!bl3) {
                        for (String string2 : map.keySet()) {
                            if (map2.get(string2) == null || string.indexOf(map2.get(string2)) <= 0) continue;
                            String string3 = map2.get(string2);
                            String string4 = map.get(string2);
                            string = string.replaceAll(string3, string4);
                        }
                        bl3 = true;
                    }
                }
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe("Could not find:" + file2);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            LOGGER.severe("Could read find:" + file2);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(DBObject dBObject, File file) {
        if (dBObject != null) {
            DDLGenerator.getInstance().setFile(file.getAbsolutePath(), null);
            Ide.getMainWindow().setCursor(new Cursor(3));
            try {
                DDLGenerator.getInstance().openFile();
                DDLGenerator.getInstance().getWriter().write(DDLGenerator.getInstance().getDDL(dBObject));
                DDLGenerator.getInstance().closeFile();
            }
            catch (IOException iOException) {
                Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            catch (Exception exception) {
                Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Ide.getMainWindow().setCursor(new Cursor(0));
            }
        }
    }

    public static ScriptStatus getScriptStatus(String string) {
        ScriptStatus scriptStatus = ScriptStatus.NONE;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string3 = null;
            while (scriptStatus == ScriptStatus.NONE && scriptStatus != ScriptStatus.CONDTIONAL && (string2 = bufferedReader.readLine()) != null) {
                if (string2.indexOf("wwv_flow_api.create_install_script") <= -1) continue;
                if (scriptStatus != ScriptStatus.CONDTIONAL) {
                    scriptStatus = ScriptStatus.NONCONDITIONAL;
                }
                string3 = bufferedReader.readLine();
                while (string3.indexOf("end;") == -1) {
                    if (string3.indexOf("p_condition") > 0) {
                        scriptStatus = ScriptStatus.CONDTIONAL;
                    }
                    string3 = bufferedReader.readLine();
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (IOException iOException) {
            Logger.getLogger(ApexImporter.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return scriptStatus;
    }

    public static String getUnInstallScript(Connection connection, BigDecimal bigDecimal) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement("select  DEINSTALLATION_SCRIPT||chr(10) script  from APEX_APPLICATION_SUPP_OBJECTS    where application_id = :APPLICATION_ID");
            oraclePreparedStatement.setBigDecimalAtName("APPLICATION_ID", bigDecimal);
            ResultSet resultSet = oraclePreparedStatement.executeQuery();
            while (resultSet.next()) {
                stringBuilder.append(resultSet.getString(1));
                stringBuilder.append("\n");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScriptStatus {
        NONE,
        NONCONDITIONAL,
        CONDTIONAL;

    }
}

