/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.proformatter.FormatCtxMenuListener;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.raptor.ISQLEditor;
import oracle.dbtools.raptor.InitializeConnectionListener;
import oracle.dbtools.raptor.config.BindConfig;
import oracle.dbtools.raptor.config.ConfigChangeListener;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.dialogs.BasicObjectModifier;
import oracle.dbtools.raptor.dialogs.CreateDialogArb;
import oracle.dbtools.raptor.dialogs.conn.ConnectionPrompt;
import oracle.dbtools.raptor.diff.ui.DiffWizMain;
import oracle.dbtools.raptor.editors.ActiveViewStatusChanger;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.export.wizard.ExportWizMain;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.insight.DatabaseInsightAddin;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorManager;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.navigator.net.DBRecognizer;
import oracle.dbtools.raptor.navigator.net.DBURLFactoryHelper;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderContextMenu;
import oracle.dbtools.raptor.queryBuilder.QueryBuilderController;
import oracle.dbtools.raptor.refactor.RefactorMenu;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizMain;
import oracle.dbtools.raptor.scriptrunner.CommandRegistry;
import oracle.dbtools.raptor.utils.ClosedConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.IdeLogImpl;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.RaptorDbDisconnectListener;
import oracle.dbtools.raptor.utils.SQLExceptionListener;
import oracle.dbtools.raptor.utils.SQLExceptionListenerRegistry;
import oracle.dbtools.raptor.utils.TNSPing;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBURLFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Recognizer;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.view.ActiveViewListener;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseFactory;
import oracle.javatools.util.Copyable;
import oracle.jdbc.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class RaptorDBAddin
implements Addin,
ShutdownHook {
    private static ISQLEditor _iSqlEditor;
    private RaptorDbDisconnectListener disconnectListener = new RaptorDbDisconnectListener();

    public void initialize() {
        IdeAction ideAction;
        Object object;
        DocumentExtensions documentExtensions;
        BindConfig bindConfig;
        Preferences preferences = Preferences.getPreferences();
        DBConfig dBConfig = DBConfig.getInstance((PropertyStorage)preferences);
        BindConfig bindConfig2 = BindConfig.getInstance((PropertyStorage)preferences);
        IdeSettings ideSettings = Ide.getSettings();
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig2 = (DBConfig)clientSetting.getData("DBConfig");
        if (dBConfig2 != null) {
            clientSetting.putData("DBConfig", (Copyable)dBConfig2);
            ideSettings.putLegacyData("DBConfig", (Copyable)dBConfig);
        }
        if ((bindConfig = (BindConfig)clientSetting.getData("BindConfig")) != null) {
            clientSetting.putData("BindConfig", (Copyable)bindConfig);
            ideSettings.putLegacyData("BindConfig", (Copyable)bindConfig2);
        }
        if ((documentExtensions = (DocumentExtensions)clientSetting.getData("document-extensions-options")) != null) {
            clientSetting.putData("document-extensions-options", (Copyable)documentExtensions);
        }
        dBConfig.addStructureChangeListener(new ConfigChangeListener());
        ResultSetFormatter.setMaxRows((int)dBConfig.getInt("MAXSCRIPTROWS"));
        ExitCommand.addShutdownHook((ShutdownHook)this);
        Recognizer.mapExtensionToClass((String)".jpr", Project.class);
        Recognizer.mapExtensionToClass((String)".jws", Workspace.class);
        this.initConnectionStore();
        this.initNavigator();
        Recognizer.registerLowPriorityRecognizer((Recognizer)new DBRecognizer());
        DBURLFactory.registerHelper((DBURLFactory.Helper)new DBURLFactoryHelper());
        EditorManager editorManager = EditorManager.getEditorManager();
        Connections.getInstance().addConnectionListener(new InitializeConnectionListener());
        ConnectionPrompt connectionPrompt = new ConnectionPrompt();
        DatabaseProviderHelper.setPasswordPrompter((PasswordPrompter)connectionPrompt);
        this.initSettings(clientSetting);
        IdeAction ideAction2 = IdeAction.find((int)66);
        if (ideAction2 != null) {
            object = CreateDialogArb.getString(571);
            ideAction2.putValue("Name", (Object)StringUtils.stripMnemonic((String)object));
            ideAction2.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)object)));
        }
        if ((object = Ide.findCmdID((String)"ConnectionNavigator.TOGGLE_TOOLBAR_CMD_ID")) != null && (ideAction = IdeAction.find((int)((Integer)object))) != null) {
            String string = CreateDialogArb.getString(572);
            ideAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string));
            ideAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)string)));
        }
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)new ActiveViewStatusChanger());
        editorManager.getContextMenu().addContextMenuListener((ContextMenuListener)QueryBuilderContextMenu.getInstance());
        QueryBuilderController.getInstance();
        CommandRegistry.addListener(DataMover.class);
        CommandRegistry.addListener(TNSPing.class);
        CodeEditor.registerFactory((EditorPluginsFactory)new DatabaseInsightAddin());
        this.initMenus();
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
            }

            public void mainWindowOpened(IdeEvent ideEvent) {
                Log.setLogImpl((Log.ILog)new IdeLogImpl());
                Ide.removeIdeListener((IdeListener)this);
                this.cleanupConns();
                DatabaseConnections.getInstance().addDisconnectListener((DisconnectListener)RaptorDBAddin.this.disconnectListener);
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            private void cleanupConns() {
                try {
                    String[] stringArray;
                    for (String string : stringArray = Connections.getInstance().getConnNames()) {
                        if (!Connections.isUnsharedWorksheetConnection(string)) continue;
                        DatabaseNavigatorController.deleteConnectionSilent(Databases.getConnectionNode(string, true), null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.initializeFormatter();
        SQLExceptionListenerRegistry.addListener((SQLExceptionListener)new ClosedConnectionListener());
        NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

            public DefaultNLSProvider getNLSProvider(Connection connection) {
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }

            public DefaultNLSProvider getNLSProvider(String string) {
                Connection connection = null;
                try {
                    connection = Connections.getInstance().getConnection(string);
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                return ConnectionTypeDetails.getTypeDetails("", connection).getNLSProvider(connection);
            }
        });
    }

    private void initializeFormatter() {
        String string = null;
        String string2 = null;
        IdeAction ideAction = IdeAction.get((int)SQLFormatter.FORMAT_ID, string, (String)SQLFormatterArb.getString(0), string2, null, (ResourceBundle)SQLFormatterArb.getInstance(), (String)SQLFormatterArb.getString(1), null, (boolean)true);
        ideAction.addController((Controller)SQLFormatter.getInstance());
        JMenuItem jMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)ideAction);
        FormatCtxMenuListener formatCtxMenuListener = new FormatCtxMenuListener(jMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)formatCtxMenuListener);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/dbtools/proformatter/accelerators.xml");
    }

    private void initMenus() {
        CopyWizMain.initMenu();
        ExportWizMain.initMenu();
        DiffWizMain.initMenu();
        RefactorMenu.init();
    }

    private void initNavigator() {
        NavigatorManager navigatorManager = DatabaseNavigatorManager.getInstance();
        navigatorManager.initialize();
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), ObjectFolder.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), DatabaseNode.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance(), DatabaseNode.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), DatabaseConnection.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), OtherSchemasFolder.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), SchemaFolder.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)BasicObjectModifier.getInstance(), ChildObjectElement.class);
        NavHelpListener navHelpListener = new NavHelpListener();
        navigatorManager.addContextMenuListener((ContextMenuListener)navHelpListener, ObjectFolder.class);
        navigatorManager.addContextMenuListener((ContextMenuListener)navHelpListener, OtherSchemasFolder.class);
    }

    private void initConnectionStore() {
        DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        DatabaseConnections.getInstance().addListener(new ConnectionsListener(){

            public void connectionAdded(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionRemoved(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            public void connectionUpdated(ConnectionsEvent connectionsEvent) {
                this.saveConnections();
            }

            private void saveConnections() {
                try {
                    DatabaseConnections.getInstance().saveConnections();
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
            }
        });
    }

    private void initSettings(ClientSetting clientSetting) {
        OracleDatabaseFactory.setDefaultAutocommit((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConnectionPanel(String string) {
        URL uRL = RaptorDBAddin.class.getClassLoader().getResource(string);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = string2.trim();
                ++n;
                if (string2.length() <= 0) continue;
                int n2 = string2.indexOf(61);
                if (n2 < 0) {
                    throw new RuntimeException("Invalid INI file format at line " + n + " -- Expected key=value found " + string2);
                }
                String string3 = string2.substring(0, n2).trim();
                String string4 = string2.substring(n2 + 1, string2.length()).trim();
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, classNotFoundException.getStackTrace()[0].toString(), classNotFoundException);
                }
                ConnectionTypeRegistry.registerConnectionType(string3, clazz, null);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(RaptorDBAddin.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
        }
    }

    public static synchronized void registerSqlOpener(ISQLEditor iSQLEditor) {
        _iSqlEditor = iSQLEditor;
    }

    public static ISQLEditor getSqlOpener() {
        return _iSqlEditor;
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig = DBConfig.getInstance();
        if (!dBConfig.getBoolean("SAVEBINDS").booleanValue()) {
            BindConfig.getInstance().clearBinds();
        }
        DatabaseConnections.getInstance().removeDisconnectListener((DisconnectListener)this.disconnectListener);
    }

    public static void setAutoCommit(boolean bl) {
        Connections connections = Connections.getInstance();
        for (String string : connections.getConnNames()) {
            try {
                Connection connection;
                ConnectionTypeDetails connectionTypeDetails;
                if (!connections.isConnectionOpen(string) || (connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection = connections.getConnection(string))) == null || !connectionTypeDetails.isSupportsAutocommit()) continue;
                if (Connections.getInstance().isOracle(string)) {
                    OracleDatabaseFactory.setDefaultAutocommit((boolean)bl);
                    ((OracleConnection)connection).setDefaultRowPrefetch(DBConfig.getInstance().getInt("ARRAYFETCHSIZE"));
                }
                connection.setAutoCommit(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final class NavHelpListener
    implements ContextMenuListener,
    Controller {
        public static final int HELP_COMMAND_NAME = Ide.findOrCreateCmdID((String)"oracle.dbtools.raptor.RaptorDBAddin.HELP");
        private static final IdeAction actionHelp = IdeAction.get((int)HELP_COMMAND_NAME, (String)StringUtils.stripMnemonic((String)CreateDialogArb.getString(528)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)CreateDialogArb.getString(528))));
        static JMenuItem MENU_HELP = null;
        private static String HELP_PREFIX = "f1_raptorconnectionnav_";

        private NavHelpListener() {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (MENU_HELP == null) {
                actionHelp.addController((Controller)this);
                MENU_HELP = contextMenu.createMenuItem((ToggleAction)actionHelp);
            }
            contextMenu.add((Component)MENU_HELP);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.equals(actionHelp)) {
                Element element = context.getElement();
                if (element instanceof ObjectFolder) {
                    ObjectFolder objectFolder = (ObjectFolder)element;
                    String string = objectFolder.getObjectType().replaceAll(" ", "_");
                    this.showHelp(string);
                } else if (element instanceof OtherSchemasFolder) {
                    this.showHelp("USER");
                }
                return true;
            }
            return false;
        }

        private void showHelp(String string) {
            HelpInfo helpInfo = new HelpInfo(HELP_PREFIX + string);
            HelpSystem.getHelpSystem().showHelp(helpInfo);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return false;
        }
    }
}

