/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.dbtools.proformatter.ConfigPanelData;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.proformatter.SpacingType;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public final class WhiteSpacesPanel
extends DefaultTraversablePanel {
    public static final long serialVersionUID = 1694L;
    public static final String TITLE = "WhiteSpace";
    private JPanel whiteSpaceOptionPanel;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel9;
    private JRadioButton m_radBracketNoSpace;
    private JRadioButton m_radCommaNoSpace;
    private JRadioButton m_radEqualNoSpace;
    private ButtonGroup spacesBracketGroup;
    private ButtonGroup spacesCommaGroup;
    private ButtonGroup spacesEqualGroup;
    private JRadioButton m_radCommaUnchanged;
    private JRadioButton m_radEqualUnchanged;
    private JRadioButton m_radBracketUnchanged;
    private JRadioButton m_radCommaAfter;
    private JRadioButton m_radBracketAround;
    private JRadioButton m_radCommaAround;
    private JRadioButton m_radEqualAround;
    private JRadioButton m_radCommaBefore;
    private JRadioButton m_radBracketInside;
    private JRadioButton m_radBracketOutside;
    private JLabel sourceSQLjLabel1;

    public WhiteSpacesPanel() {
        this.setHelpID("f1_idedidesetproformat_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Color getColor() {
        new ConfigPanelData();
        return ConfigPanelData.getColor();
    }

    private void load(ConfigProFormat configProFormat) {
        WhiteSpacesPanel.setSelection(this.spacesEqualGroup, configProFormat.getOperatorSpacing());
        WhiteSpacesPanel.setSelection(this.spacesBracketGroup, configProFormat.getBracketSpacing());
        WhiteSpacesPanel.setSelection(this.spacesCommaGroup, configProFormat.getCommaSpacing());
    }

    private void commit(ConfigProFormat configProFormat) {
        configProFormat.setSuppressSpacescheckboxOpt(true);
        configProFormat.setBracketSpacing(WhiteSpacesPanel.getSelectedCommand(this.spacesBracketGroup));
        configProFormat.setCommaSpacing(WhiteSpacesPanel.getSelectedCommand(this.spacesCommaGroup));
        configProFormat.setOperatorSpacing(WhiteSpacesPanel.getSelectedCommand(this.spacesEqualGroup));
    }

    private static void setSelection(ButtonGroup buttonGroup, SpacingType spacingType) {
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!spacingType.name().equals(abstractButton.getActionCommand())) continue;
            buttonGroup.setSelected(abstractButton.getModel(), true);
            break;
        }
    }

    private static SpacingType getSelectedCommand(ButtonGroup buttonGroup) {
        ButtonModel buttonModel = buttonGroup.getSelection();
        return SpacingType.valueOf(buttonModel.getActionCommand());
    }

    private void jbInit() throws Exception {
        this.whiteSpaceOptionPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.m_radBracketUnchanged = new JRadioButton();
        this.m_radBracketNoSpace = new JRadioButton();
        this.m_radBracketInside = new JRadioButton();
        this.m_radBracketAround = new JRadioButton();
        this.m_radBracketOutside = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.m_radCommaUnchanged = new JRadioButton();
        this.m_radCommaNoSpace = new JRadioButton();
        this.m_radCommaAfter = new JRadioButton();
        this.m_radCommaBefore = new JRadioButton();
        this.m_radCommaAround = new JRadioButton();
        this.jLabel11 = new JLabel();
        this.m_radEqualNoSpace = new JRadioButton();
        this.m_radEqualAround = new JRadioButton();
        this.m_radEqualUnchanged = new JRadioButton();
        this.sourceSQLjLabel1 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel17 = new JLabel();
        this.jLabel21 = new JLabel();
        this.spacesBracketGroup = new ButtonGroup();
        this.spacesCommaGroup = new ButtonGroup();
        this.spacesEqualGroup = new ButtonGroup();
        this.whiteSpaceOptionPanel.setLayout(null);
        this.whiteSpaceOptionPanel.setAlignmentY(0.0f);
        this.whiteSpaceOptionPanel.setMaximumSize(new Dimension(150, 500));
        this.whiteSpaceOptionPanel.setMinimumSize(new Dimension(150, 500));
        this.whiteSpaceOptionPanel.setPreferredSize(new Dimension(150, 500));
        this.jLabel9.setForeground(this.getColor());
        this.jLabel9.setText("Spaces around brackets");
        this.jLabel9.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel9);
        this.jLabel9.setBounds(20, 230, 147, 16);
        this.spacesBracketGroup.add(this.m_radBracketUnchanged);
        this.m_radBracketUnchanged.setForeground(this.getColor());
        this.m_radBracketUnchanged.setText("Keep unchanged");
        this.m_radBracketUnchanged.setActionCommand(SpacingType.UNCHANGED.name());
        this.m_radBracketUnchanged.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radBracketUnchanged.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radBracketUnchanged);
        this.m_radBracketUnchanged.setBounds(20, 250, 140, 17);
        this.spacesBracketGroup.add(this.m_radBracketNoSpace);
        this.m_radBracketNoSpace.setForeground(this.getColor());
        this.m_radBracketNoSpace.setText("No Spaces");
        this.m_radBracketNoSpace.setActionCommand(SpacingType.NONE.name());
        this.m_radBracketNoSpace.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radBracketNoSpace.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radBracketNoSpace);
        this.m_radBracketNoSpace.setBounds(20, 270, 110, 17);
        this.spacesBracketGroup.add(this.m_radBracketInside);
        this.m_radBracketInside.setForeground(this.getColor());
        this.m_radBracketInside.setText("One Space inside");
        this.m_radBracketInside.setActionCommand(SpacingType.AFTER.name());
        this.m_radBracketInside.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radBracketInside.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radBracketInside);
        this.m_radBracketInside.setBounds(20, 290, 130, 17);
        this.spacesBracketGroup.add(this.m_radBracketAround);
        this.m_radBracketAround.setForeground(this.getColor());
        this.m_radBracketAround.setText("One Space around");
        this.m_radBracketAround.setActionCommand(SpacingType.AROUND.name());
        this.m_radBracketAround.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radBracketAround.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radBracketAround);
        this.m_radBracketAround.setBounds(20, 330, 130, 17);
        this.jLabel10.setForeground(this.getColor());
        this.jLabel10.setText("Spaces around commas");
        this.jLabel10.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel10);
        this.jLabel10.setBounds(20, 110, 146, 16);
        this.spacesCommaGroup.add(this.m_radCommaUnchanged);
        this.m_radCommaUnchanged.setForeground(this.getColor());
        this.m_radCommaUnchanged.setText("Keep unchanged");
        this.m_radCommaUnchanged.setActionCommand(SpacingType.UNCHANGED.name());
        this.m_radCommaUnchanged.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radCommaUnchanged.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radCommaUnchanged);
        this.m_radCommaUnchanged.setBounds(20, 130, 114, 17);
        this.spacesCommaGroup.add(this.m_radCommaNoSpace);
        this.m_radCommaNoSpace.setForeground(this.getColor());
        this.m_radCommaNoSpace.setText("No Spaces");
        this.m_radCommaNoSpace.setActionCommand(SpacingType.NONE.name());
        this.m_radCommaNoSpace.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radCommaNoSpace.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radCommaNoSpace);
        this.m_radCommaNoSpace.setBounds(20, 150, 77, 17);
        this.spacesCommaGroup.add(this.m_radCommaAfter);
        this.m_radCommaAfter.setForeground(this.getColor());
        this.m_radCommaAfter.setText("One Space after");
        this.m_radCommaAfter.setActionCommand(SpacingType.AFTER.name());
        this.m_radCommaAfter.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radCommaAfter.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radCommaAfter);
        this.m_radCommaAfter.setBounds(20, 190, 109, 17);
        this.spacesCommaGroup.add(this.m_radCommaBefore);
        this.m_radCommaBefore.setForeground(this.getColor());
        this.m_radCommaBefore.setSelected(true);
        this.m_radCommaBefore.setText("One Space before");
        this.m_radCommaBefore.setActionCommand(SpacingType.BEFORE.name());
        this.m_radCommaBefore.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radCommaBefore.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radCommaBefore);
        this.m_radCommaBefore.setBounds(20, 170, 120, 17);
        this.spacesCommaGroup.add(this.m_radCommaAround);
        this.m_radCommaAround.setForeground(this.getColor());
        this.m_radCommaAround.setSelected(true);
        this.m_radCommaAround.setText("One Space around");
        this.m_radCommaAround.setActionCommand(SpacingType.AROUND.name());
        this.m_radCommaAround.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radCommaAround.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radCommaAround);
        this.m_radCommaAround.setBounds(20, 210, 123, 17);
        this.jLabel11.setForeground(this.getColor());
        this.jLabel11.setText("Spaces around operators ( = <  > + - * / )");
        this.jLabel11.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel11);
        this.jLabel11.setBounds(20, 30, 263, 16);
        this.spacesEqualGroup.add(this.m_radEqualNoSpace);
        this.m_radEqualNoSpace.setForeground(this.getColor());
        this.m_radEqualNoSpace.setText("No Spaces");
        this.m_radEqualNoSpace.setActionCommand(SpacingType.NONE.name());
        this.m_radEqualNoSpace.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radEqualNoSpace.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radEqualNoSpace);
        this.m_radEqualNoSpace.setBounds(20, 70, 77, 17);
        this.spacesEqualGroup.add(this.m_radEqualAround);
        this.m_radEqualAround.setForeground(this.getColor());
        this.m_radEqualAround.setText("One Space");
        this.m_radEqualAround.setActionCommand(SpacingType.SINGLE.name());
        this.m_radEqualAround.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radEqualAround.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radEqualAround);
        this.m_radEqualAround.setBounds(20, 90, 78, 17);
        this.spacesEqualGroup.add(this.m_radEqualUnchanged);
        this.m_radEqualUnchanged.setForeground(this.getColor());
        this.m_radEqualUnchanged.setText("Keep unchanged");
        this.m_radEqualUnchanged.setActionCommand(SpacingType.UNCHANGED.name());
        this.m_radEqualUnchanged.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radEqualUnchanged.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radEqualUnchanged);
        this.m_radEqualUnchanged.setBounds(20, 50, 114, 17);
        this.sourceSQLjLabel1.setForeground(this.getColor());
        this.sourceSQLjLabel1.setText("White Spaces");
        this.sourceSQLjLabel1.setVerticalAlignment(3);
        this.whiteSpaceOptionPanel.add(this.sourceSQLjLabel1);
        this.sourceSQLjLabel1.setBounds(20, 10, 81, 16);
        this.jLabel12.setForeground(this.getColor());
        this.jLabel12.setText("WHERE a=b+c");
        this.jLabel12.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel12);
        this.jLabel12.setBounds(160, 70, 120, 14);
        this.jLabel13.setForeground(this.getColor());
        this.jLabel13.setText("WHERE a = b + c");
        this.jLabel13.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel13);
        this.jLabel13.setBounds(160, 90, 108, 14);
        this.jLabel14.setForeground(this.getColor());
        this.jLabel14.setText("SELECT a,b,c,");
        this.jLabel14.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel14);
        this.jLabel14.setBounds(160, 150, 100, 14);
        this.jLabel15.setForeground(this.getColor());
        this.jLabel15.setText("SELECT a, b, c, ");
        this.jLabel15.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel15);
        this.jLabel15.setBounds(160, 190, 110, 14);
        this.jLabel16.setForeground(this.getColor());
        this.jLabel16.setText("SELECT a ,b ,c ,");
        this.jLabel16.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel16);
        this.jLabel16.setBounds(160, 170, 110, 14);
        this.jLabel18.setForeground(this.getColor());
        this.jLabel18.setText("max(c1) + ...");
        this.jLabel18.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel18);
        this.jLabel18.setBounds(160, 270, 110, 14);
        this.jLabel19.setForeground(this.getColor());
        this.jLabel19.setText("max ( c1 ) + ...");
        this.jLabel19.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel19);
        this.jLabel19.setBounds(160, 330, 120, 14);
        this.jLabel20.setForeground(this.getColor());
        this.jLabel20.setText("max( c1 )+ ...");
        this.jLabel20.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel20);
        this.jLabel20.setBounds(160, 290, 120, 14);
        this.jLabel17.setForeground(this.getColor());
        this.jLabel17.setText("SELECT a , b , c , ");
        this.jLabel17.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel17);
        this.jLabel17.setBounds(160, 210, 150, 14);
        this.jLabel21.setForeground(this.getColor());
        this.jLabel21.setText("max (c1) + ...");
        this.jLabel21.setInheritsPopupMenu(false);
        this.whiteSpaceOptionPanel.add(this.jLabel21);
        this.jLabel21.setBounds(160, 310, 100, 14);
        this.spacesBracketGroup.add(this.m_radBracketOutside);
        this.m_radBracketOutside.setForeground(this.getColor());
        this.m_radBracketOutside.setText("One Space outside");
        this.m_radBracketOutside.setActionCommand(SpacingType.BEFORE.name());
        this.m_radBracketOutside.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_radBracketOutside.setMargin(new Insets(0, 0, 0, 0));
        this.whiteSpaceOptionPanel.add(this.m_radBracketOutside);
        this.m_radBracketOutside.setBounds(20, 310, 130, 17);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.whiteSpaceOptionPanel);
    }

    public void onEntry(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.load(configProFormat);
    }

    public void onExit(TraversableContext traversableContext) {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance(traversableContext.getPropertyStorage());
        this.commit(configProFormat);
    }
}

