/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import SQLinForm_200.SQLForm;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.editor.Editor;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.proformatter.ProFormatOptions;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Command;
import oracle.ide.db.model.SqlNode;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;

public class SQLFormatCommand
extends Command {
    private UndoableEdit _undoableEdit;

    public SQLFormatCommand(Context context) {
        super(-1, 0, "Pro Format SQL Command");
        this.setContext(context);
    }

    public SQLFormatCommand() {
        super(-1, 0, "Pro Format SQL Command");
    }

    public int doit() {
        if (this._undoableEdit == null) {
            TextNode textNode;
            TextBuffer textBuffer;
            block16: {
                textBuffer = null;
                textNode = null;
                Node node = this.context.getNode();
                View view = this.context.getView();
                if (node.getClass().getName().endsWith("sqlview.SqlEditorNode")) {
                    try {
                        List list = (List)node;
                        String string = (String)list.get(0);
                        if (string == null | string.trim().equals("")) {
                            return 1;
                        }
                        ConfigProFormat configProFormat = (ConfigProFormat)((Object)Ide.getSettings().getData("oracle.dbtools.proformatter.ConfigProFormat"));
                        String string2 = this.formatScript(string);
                        list.add(string2);
                        return 0;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        return 1;
                    }
                }
                if (view instanceof Editor) {
                    try {
                        String string = ((BasicEditorPane)view).getText();
                        if (string == null || string.trim().equals("")) {
                            return 1;
                        }
                        String string3 = this.formatScript(string);
                        ((BasicEditorPane)view).setText(string3);
                        return 0;
                    }
                    catch (Exception exception) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        return 1;
                    }
                }
                if (node.getClass().getName().endsWith("PlSqlNode") || node.getClass().getName().endsWith("PlSqlBaseNode") || node.getClass().getName().endsWith("TriggerNode") || node instanceof SqlNode) {
                    try {
                        textNode = (TextNode)node;
                        textBuffer = textNode.acquireTextBuffer();
                        if (textBuffer.getLength() == 0) {
                            return 1;
                        }
                        break block16;
                    }
                    catch (Exception exception) {
                        return 1;
                    }
                }
                if (view.getClass().getName().endsWith("XMLBasedEditor0")) {
                    FindableEditor findableEditor = (FindableEditor)view;
                    BasicEditorPane basicEditorPane = findableEditor.getFocusedEditorPane();
                    String string = basicEditorPane.getText();
                    ProFormatOptions proFormatOptions = this.getFormatOptions();
                    proFormatOptions.setSQLPlus(false);
                    if (string == null || string.trim().equals("")) {
                        return 1;
                    }
                    String string4 = this.reallyDoIt(string, proFormatOptions);
                    basicEditorPane.setEditable(true);
                    basicEditorPane.setText(string4);
                    basicEditorPane.setEditable(false);
                    return 0;
                }
                return 1;
            }
            textBuffer.beginEdit();
            String string = this.formatSQL(textBuffer);
            textBuffer.removeToEnd(0);
            textBuffer.append(string.toCharArray());
            this._undoableEdit = textBuffer.endEdit();
            textNode.markDirty(true);
            textNode.releaseTextBuffer();
        } else {
            this._undoableEdit.redo();
        }
        return 0;
    }

    public String reallyDoIt(String string, ProFormatOptions proFormatOptions) {
        SQLForm sQLForm = new SQLForm();
        sQLForm.setCase(proFormatOptions.getUCChoiceOpt().equals("Keywords Uppercase"), proFormatOptions.getUCChoiceOpt().equals("Whole SQL Uppercase"));
        sQLForm.setLowerCase(proFormatOptions.getUCChoiceOpt().equals("Whole SQL Lowercase"));
        sQLForm.setGraphLevel(proFormatOptions.isGraphLevelcheckboxOpt());
        sQLForm.setSuppressSpace(true);
        sQLForm.setQuoteCharacter(proFormatOptions.getQuoteCharactertextFieldOpt());
        sQLForm.setdoubleIndentionMasterKeyword(proFormatOptions.isDoubleIndentionCheckboxOpt());
        sQLForm.setAndOrIndention(proFormatOptions.isAndOrIndentionCheckboxOpt());
        int n = proFormatOptions.getNumSpaceschoiceOpt();
        int n2 = proFormatOptions.getNumCommaschoiceOpt();
        sQLForm.setIndention(n, proFormatOptions.isUseTabCheckboxOpt());
        sQLForm.setNumCommas(n2);
        sQLForm.setSuppressEmptyLine(proFormatOptions.isEmptyLinecheckboxOpt());
        sQLForm.setLinebreakBeforeLineComment(proFormatOptions.isLinebreakBeforeLineCommentOpt());
        sQLForm.setLinebreakBeforeConcat(proFormatOptions.isLinebreakBeforeConcatCheckboxOpt());
        sQLForm.setLinebreakAfterConcat(proFormatOptions.isLinebreakAfterConcatCheckboxOpt());
        sQLForm.setLineBreak(proFormatOptions.isLinebreakBeforeCommaCheckboxOpt(), proFormatOptions.isLinebreakAfterCommaCheckboxOpt(), proFormatOptions.isLinebreakBeforeANDCheckboxOpt(), proFormatOptions.isLinebreakAfterANDCheckboxOpt(), proFormatOptions.isLinebreakSelectBracketCheckboxOpt(), proFormatOptions.isLinebreakConditionBracketCheckboxOpt());
        if (proFormatOptions.getVariableNameTextFieldOpt().equalsIgnoreCase("") || proFormatOptions.getVariableNameTextFieldOpt().equalsIgnoreCase(" ")) {
            proFormatOptions.setVariableNameTextFieldOpt("SQL");
        }
        sQLForm.setVariableName(proFormatOptions.getVariableNameTextFieldOpt());
        sQLForm.setFormatLanguage(proFormatOptions.getTargetSQLChoiceOpt());
        sQLForm.setOneLineSQL(proFormatOptions.getLinebreakSchemaChoiceOpt().equals("1-line SQL"));
        sQLForm.setSourceSQL(proFormatOptions.isSourceSQLEnclosedCheckboxOpt(), proFormatOptions.getSourceSQLEnclosedTextFieldOpt());
        sQLForm.setti("Only for Administrator");
        sQLForm.setSourceSQLLanguage(proFormatOptions.getSourceSQLChoiceOpt());
        int n3 = proFormatOptions.getLineWidthTextFieldOpt();
        if (n3 < 30) {
            n3 = 30;
        }
        sQLForm.setPageWidth(n3);
        sQLForm.setColor(proFormatOptions.isColorCheckboxOpt());
        sQLForm.setLineNumber(proFormatOptions.isLineNumberCheckboxOpt());
        sQLForm.setLinebreakKeyword(proFormatOptions.isLinebreakKeywordCheckboxOpt());
        sQLForm.setLinebreakCase(proFormatOptions.isLinebreakCaseCheckboxOpt());
        sQLForm.setLinebreakCaseThen(proFormatOptions.isLinebreakCaseThenCheckboxOpt());
        sQLForm.setLinebreakCaseWhen(proFormatOptions.isLinebreakCaseWhenCheckboxOpt());
        sQLForm.setLinebreakCaseAndOr(proFormatOptions.isLinebreakCaseAndOrCheckboxOpt());
        sQLForm.setLinebreakCaseElse(proFormatOptions.isLinebreakCaseElseCheckboxOpt());
        sQLForm.setLinebreakJoin(proFormatOptions.isLinebreakJoinCheckboxOpt());
        sQLForm.setLinebreakJoinJoin(proFormatOptions.isLinebreakJoinJoinCheckboxOpt());
        sQLForm.setLinebreakJoinOn(proFormatOptions.isLinebreakJoinOnCheckboxOpt());
        sQLForm.setAlignmentEqual(proFormatOptions.isAlignmentEqualCheckboxOpt());
        sQLForm.setAlignmentOperator(proFormatOptions.isAlignmentOperatorCheckboxOpt());
        sQLForm.setAlignmentAs(proFormatOptions.isAlignmentAsCheckboxOpt());
        sQLForm.setAlignmentComma(proFormatOptions.isAlignmentCommaCheckboxOpt());
        sQLForm.setAlignmentComment(proFormatOptions.isAlignmentCommentCheckboxOpt());
        sQLForm.setAlignmentConcat(proFormatOptions.isAlignmentConcatCheckboxOpt());
        sQLForm.setAlignmentDeclaration(proFormatOptions.isAlignmentDeclarationCheckboxOpt());
        sQLForm.setAlignmentKeyword(proFormatOptions.isAlignmentKeywordCheckboxOpt());
        sQLForm.setSuppressComment(proFormatOptions.isSuppressCommentCheckboxOpt());
        sQLForm.setSuppressLinebreak(proFormatOptions.isSuppressLinebreakCheckboxOpt());
        sQLForm.setReplaceComment(proFormatOptions.isReplaceCommentCheckboxOpt());
        if (proFormatOptions.isUnchangedSpaceInsideBracketjRadioButtonOpt()) {
            sQLForm.setBracketSpaces("unchangedSpaceInsideBracket");
        }
        if (proFormatOptions.isOneSpaceAroundBracketjRadioButtonOpt()) {
            sQLForm.setBracketSpaces("oneSpaceAroundBracket");
        }
        if (proFormatOptions.isOneSpaceInsideBracketjRadioButtonOpt()) {
            sQLForm.setBracketSpaces("oneSpaceInsideBracket");
        }
        if (proFormatOptions.isOneSpaceOutsideBracketjRadioButtonOpt()) {
            sQLForm.setBracketSpaces("oneSpaceOutsideBracket");
        }
        if (proFormatOptions.isNoSpacesAroundBracketjRadioButtonOpt()) {
            sQLForm.setBracketSpaces("noSpacesAroundBracket");
        }
        if (proFormatOptions.isUnchangedSpaceCommajRadioButtonOpt()) {
            sQLForm.setCommaSpaces("unchangedSpaceComma");
        }
        if (proFormatOptions.isNoSpacesAroundCommajRadioButtonOpt()) {
            sQLForm.setCommaSpaces("noSpacesAroundComma");
        }
        if (proFormatOptions.isOneSpaceAfterCommajRadioButtonOpt()) {
            sQLForm.setCommaSpaces("oneSpaceAfterComma");
        }
        if (proFormatOptions.isOneSpaceBeforeCommajRadioButtonOpt()) {
            sQLForm.setCommaSpaces("oneSpaceBeforeComma");
        }
        if (proFormatOptions.isOneSpaceAroundCommajRadioButtonOpt()) {
            sQLForm.setCommaSpaces("oneSpaceAroundComma");
        }
        if (proFormatOptions.isUnchangedSpaceEqualjRadioButtonOpt()) {
            sQLForm.setEqualSpaces("unchangedSpaceEqual");
        }
        if (proFormatOptions.isNoSpacesAroundEqualjRadioButtonOpt()) {
            sQLForm.setEqualSpaces("noSpacesAroundEqual");
        }
        if (proFormatOptions.isOneSpaceAroundEqualjRadioButtonOpt()) {
            sQLForm.setEqualSpaces("oneSpaceAroundEqual");
        }
        if ((n3 = proFormatOptions.getSmallSQLTextFieldOpt()) < 0) {
            n3 = 80;
        }
        sQLForm.setSmallSQLWidth(n3);
        String string2 = sQLForm.formatSQLAsString(string);
        if (!(proFormatOptions.isReplaceCommentCheckboxOpt() || proFormatOptions.isSuppressCommentCheckboxOpt() || !proFormatOptions.getTargetSQLChoiceOpt().equalsIgnoreCase("sql") || proFormatOptions.isSourceSQLEnclosedCheckboxOpt() || proFormatOptions.isForceDifferenceCheckboxOpt() || this.verifyResult(string, string2))) {
            Ide.getStatusBar().setText("Formatting Failed");
            return string;
        }
        Ide.getStatusBar().setText("Formatting Succeeded");
        return string2;
    }

    public boolean verifyResult(String string, String string2) {
        String string3;
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        String string4 = this.removeWhiteSpace(string);
        return string4.equals(string3 = this.removeWhiteSpace(string2));
    }

    public String removeWhiteSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            stringBuffer = stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String formatScript(String string) {
        String string2 = "";
        ProFormatOptions proFormatOptions = this.getFormatOptions();
        string2 = this.reallyDoIt(string, proFormatOptions);
        return string2;
    }

    private String getSubStr(String string, int n) {
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = string.indexOf("\n", n2 + 1);
        }
        if (n2 != -1) {
            string2 = string.substring(n2);
        }
        return string2;
    }

    private String getSubStr(String string, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n4 = string.indexOf("\n", n4 + 1);
        }
        for (n3 = 0; n3 <= n2; ++n3) {
            if ((n5 = string.indexOf("\n", n5 + 1)) != -1) continue;
            n3 = n2 + 1;
        }
        String string2 = "";
        try {
            string2 = n5 != -1 ? string.substring(n4, n5) : string.substring(n4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private String processFormatScript(String string, boolean bl) {
        String string2 = "";
        ProFormatOptions proFormatOptions = this.getFormatOptions();
        if (string.trim().length() != 0) {
            proFormatOptions.setSQLPlus(false);
            string2 = string2 + this.addGaps(this.formatSubScript(string, proFormatOptions));
        }
        return string2;
    }

    private String addGaps(String string) {
        string = string.trim() + "\n\n";
        return string;
    }

    private String formatSubScript(String string, ProFormatOptions proFormatOptions) {
        String string2 = "";
        if (string == null || string.trim().equals("")) {
            return string;
        }
        try {
            string2 = this.reallyDoIt(string, proFormatOptions);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string2;
    }

    public int undo() {
        if (this._undoableEdit != null) {
            this._undoableEdit.undo();
        }
        return 0;
    }

    private String formatSQL(TextBuffer textBuffer) {
        int n = textBuffer.getLength();
        char[] cArray = textBuffer.getChars(0, n);
        String string = new String(cArray);
        ProFormatOptions proFormatOptions = this.getFormatOptions();
        proFormatOptions.setSQLPlus(false);
        if (string == null || string.trim().equals("")) {
            return string;
        }
        String string2 = this.reallyDoIt(string, proFormatOptions);
        return string2;
    }

    private ProFormatOptions getFormatOptions() {
        ConfigProFormat configProFormat = ConfigProFormat.getInstance();
        ProFormatOptions proFormatOptions = new ProFormatOptions();
        if (configProFormat != null && (proFormatOptions = configProFormat.getAdvancedFormatOptions()) == null) {
            proFormatOptions = new ProFormatOptions();
        }
        return proFormatOptions;
    }
}

