/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.SqlRules;
import oracle.dbtools.util.Util;

public class VolumeTest {
    static boolean isSQL = false;
    private static Connection c = null;
    private static String query = null;
    private static ResultSet rs = null;

    public static String nextPLSQL() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = rs.getInt("line")) == 1) {
                System.out.println(">>>> " + rs.getString("name"));
            }
            if (n2 == 1 && n != 0) break;
            stringBuffer.append(rs.getString("text"));
            if (!rs.next()) break;
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String nextSQL() throws Exception {
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public static String next() throws Exception {
        if (isSQL) {
            return VolumeTest.nextSQL();
        }
        return VolumeTest.nextPLSQL();
    }

    public static void main(String[] stringArray) throws Exception {
        if (isSQL) {
            SqlRules.main(stringArray);
        }
        String string = null;
        int n = 0;
        while ((string = VolumeTest.next()) != null) {
            if (++n % 1000 == 0) {
                System.out.println("============== " + n + " ==============");
            }
            try {
                int[] nArray = VolumeTest.parse(string);
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                if (isSQL) {
                    treeSet.add(CYK.symbolIndexes.get("select"));
                    treeSet.add(CYK.symbolIndexes.get("insert"));
                    treeSet.add(CYK.symbolIndexes.get("update"));
                    treeSet.add(CYK.symbolIndexes.get("delete"));
                    treeSet.add(CYK.symbolIndexes.get("merge"));
                } else {
                    treeSet.add(CYK.symbolIndexes.get("compilation_unit"));
                }
                boolean bl = false;
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    for (int n3 : nArray) {
                        if (n3 != n2) continue;
                        bl = true;
                    }
                }
                if (bl) continue;
                System.out.println(string);
                return;
            }
            catch (Exception exception) {
                System.out.println(n);
                System.out.println(exception.getMessage());
                if (exception.getMessage() != null && exception.getMessage().contains("Skipped")) continue;
                System.out.println(string);
                return;
            }
        }
    }

    static int[] parse(String string) throws Exception {
        LinkedList<LexerToken> linkedList = LexerToken.parse(string);
        long l = System.currentTimeMillis();
        Matrix matrix = CYK.initArray(linkedList);
        int n = 0;
        int n2 = matrix.size();
        int n3 = matrix.size();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        l = System.currentTimeMillis();
        CYK.closure(matrix, 0, n3 + 1, treeMap);
        long l2 = System.currentTimeMillis();
        int[] nArray = (int[])matrix.get(Util.pair((int)n, (int)n2));
        System.out.print("txt.length=" + string.length());
        System.out.print(", #tokens=" + n2);
        System.out.println(", time = " + (l2 - l));
        return nArray;
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            if (isSQL) {
                c = DriverManager.getConnection("jdbc:oracle:thin:@stbbb08:1526:VIS", "sqlrepo", "sqlrepo");
                query = "select sql_text||';' from statements\nwhere sql_id between 0 and 20000\nand length(sql_text) between 1000 and 5000\nand sql_text not like '%:symbolic_arguments:i_symargs%'\nand sql_text not like '%for update of order_number%'\nand sql_text not like '%and service_line_id = :B2 for update of unit_effectivity_id%'\norder by sql_id";
            } else {
                c = DriverManager.getConnection("jdbc:oracle:thin:@ap668sdb:5025:seed120", "apps_read_only", "apps");
                query = "select * from all_source\nwhere owner = 'APPS'\nand type = 'PACKAGE BODY' and name like 'FND%'order by name,line";
            }
            PreparedStatement preparedStatement = c.prepareStatement(query);
            rs = preparedStatement.executeQuery();
            rs.next();
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to connect to database");
        }
    }
}

