/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.text.html.HTMLEditorKit;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visual {
    static boolean[][] skipped = null;
    List<LexerToken> src;

    public Visual(List<LexerToken> list) {
        this.src = list;
        skipped = new boolean[this.src.size() + 1][this.src.size() + 1];
    }

    void draw(final Matrix matrix) {
        Object object;
        int n;
        int n2 = this.src.size();
        final int n3 = n2 + 1;
        final int n4 = n2 + 1;
        byte[] byArray = new byte[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            for (n = 0; n < n3; ++n) {
                int n5 = i * n3 + n;
                object = (int[])matrix.get(Util.pair((int)n, (int)i));
                byArray[n5] = object != null ? 0 : (skipped[n][i] || i <= n ? 1 : 4);
            }
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n3 * n4, 0);
        n = dataBufferByte.getNumBanks();
        int[] nArray = new int[]{15};
        object = new SinglePixelPackedSampleModel(0, n3, n4, nArray);
        WritableRaster writableRaster = Raster.createWritableRaster((SampleModel)object, dataBufferByte, null);
        ColorModel colorModel = Visual.generateColorModel();
        final BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        JFrame jFrame = new JFrame("CYK Matrix");
        jFrame.setDefaultCloseOperation(3);
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditorKit(new HTMLEditorKit());
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(10, 300));
        jScrollPane.setMinimumSize(new Dimension(10, 50));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ScrollablePicture
        extends JLabel
        implements Scrollable,
        MouseMotionListener {
            int x0;
            int y0;
            int mid;

            public ScrollablePicture() {
                super(new Icon(){

                    public int getIconHeight() {
                        return n;
                    }

                    public int getIconWidth() {
                        return n2;
                    }

                    public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                        graphics.drawImage(bufferedImage2, 0, 0, Color.orange, null);
                    }
                });
                this.x0 = -1;
                this.y0 = -1;
                this.mid = -1;
                this.setAutoscrolls(true);
                this.addMouseMotionListener(this);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 10, 10);
                this.scrollRectToVisible(rectangle);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                mouseEvent.consume();
                int[] nArray = (int[])matrix.get(Util.pair((int)n, (int)n2));
                if (nArray != null) {
                    StringBuffer stringBuffer = new StringBuffer("<html><font color=red>[" + n + "," + n2 + ")</font><br><b>");
                    for (int n32 : nArray) {
                        int n42 = Util.X((int)n32);
                        if (n42 == -1) {
                            stringBuffer.append("-1");
                            continue;
                        }
                        stringBuffer.append("  " + CYK.allSymbols[n42]);
                    }
                    stringBuffer.append("</b><font color=green><br><br>");
                    for (int i = n; i < n2; ++i) {
                        stringBuffer.append(" " + Visual.this.src.get((int)i).content);
                    }
                    jEditorPane.setText(stringBuffer.toString());
                    this.x0 = n;
                    this.y0 = n2;
                    this.mid = Util.Y((int)nArray[0]);
                    this.repaint();
                } else if (this.x0 != -1) {
                    this.repaint();
                    this.x0 = -1;
                    this.y0 = -1;
                    this.mid = -1;
                }
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return null;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
                return 0;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return false;
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                return 0;
            }

            @Override
            public void paint(Graphics graphics) {
                super.paint(graphics);
                if (this.x0 != -1) {
                    graphics.setColor(Color.red);
                    graphics.drawLine(this.x0, this.mid, this.x0, this.y0);
                    graphics.drawLine(this.x0, this.y0, this.mid, this.y0);
                }
            }
        }
        JScrollPane jScrollPane2 = new JScrollPane(new ScrollablePicture());
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setPreferredSize(new Dimension(900, 900));
        jScrollPane2.setMinimumSize(new Dimension(50, 50));
        jFrame.getContentPane().add((Component)jScrollPane2, "Center");
        jFrame.getContentPane().add((Component)jScrollPane, "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static ColorModel generateColorModel() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        byArray[0] = 0;
        byArray2[0] = 0;
        byArray3[0] = 0;
        byArray[1] = 0;
        byArray2[1] = 0;
        byArray3[1] = -64;
        byArray[2] = 0;
        byArray2[2] = 0;
        byArray3[2] = -1;
        byArray[3] = 0;
        byArray2[3] = -64;
        byArray3[3] = 0;
        byArray[4] = 0;
        byArray2[4] = -1;
        byArray3[4] = 0;
        byArray[5] = 0;
        byArray2[5] = -64;
        byArray3[5] = -64;
        byArray[6] = 0;
        byArray2[6] = -1;
        byArray3[6] = -1;
        byArray[7] = -64;
        byArray2[7] = 0;
        byArray3[7] = 0;
        byArray[8] = -1;
        byArray2[8] = 0;
        byArray3[8] = 0;
        byArray[9] = -64;
        byArray2[9] = 0;
        byArray3[9] = -64;
        byArray[10] = -1;
        byArray2[10] = 0;
        byArray3[10] = -1;
        byArray[11] = -64;
        byArray2[11] = -64;
        byArray3[11] = 0;
        byArray[12] = -1;
        byArray2[12] = -1;
        byArray3[12] = 0;
        byArray[13] = 80;
        byArray2[13] = 80;
        byArray3[13] = 80;
        byArray[14] = -64;
        byArray2[14] = -64;
        byArray3[14] = -64;
        byArray[15] = -1;
        byArray2[15] = -1;
        byArray3[15] = -1;
        return new IndexColorModel(4, 16, byArray, byArray2, byArray3);
    }
}

