/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.insight.IdentifiersDb;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabCol {
    public static void main(String[] stringArray) throws Exception {
        String string = "select d2.dname, scott.emp.empno e, empno, dummy \nFROM dept d1, dept d2, dual, scott.emp\nwhere d1.deptno = scott.emp.deptno";
        List<LexerToken> list = TabCol.lex(string);
        ParseNode parseNode = TabCol.parse(list);
        Map<String, String> map = TabCol.tblNames(parseNode, list);
        for (String object : map.keySet()) {
            System.out.println(object + "->" + map.get(object));
        }
        System.out.println("--------------------");
        TabCol.initConnection();
        TabCol.colNames(parseNode, list, map, "IdeConnections%234");
        Map<String, String> map2 = TabCol.colNames(parseNode, list, map, "IdeConnections%234");
        for (String string2 : map2.keySet()) {
            System.out.println(string2 + "->" + (String)map2.get(string2));
        }
    }

    private static void initConnection() {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
        }
        catch (Exception exception) {
            Logger.getLogger(TabCol.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
        DBUtil.setConnectionResolver((ConnectionResolver)new ConnectionResolver(){
            Connection conn = null;

            public String[] getConnNames() {
                return new String[]{"1"};
            }

            public String[] getConnNames(String[] stringArray) {
                return null;
            }

            public Connection getConnection(String string) throws DBException {
                if (this.conn == null) {
                    try {
                        this.conn = DriverManager.getConnection("jdbc:oracle:thin:@stadh06:1524:x4", "scott", "tiger");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return this.conn;
            }

            public Properties getConnectionInfo(String string) {
                return null;
            }

            public String getConnectionName(Connection connection) {
                return null;
            }

            public Database getDatabase(Connection connection) {
                return null;
            }

            public boolean isOracle(String string) {
                return false;
            }

            public boolean isOracle(Connection connection) {
                return true;
            }

            public boolean isTimesTen(String string) {
                return false;
            }

            public boolean isTimesTen(Connection connection) {
                return false;
            }

            public boolean lock(String string) {
                return false;
            }

            public boolean lock(Connection connection) {
                return false;
            }

            public void unlock(String string) {
            }

            public void unlock(Connection connection) {
            }
        });
    }

    public static List<LexerToken> lex(String string) {
        return LexerToken.parse(string);
    }

    public static ParseNode parse(List<LexerToken> list) {
        Matrix matrix = CYK.initArray1(list);
        CYK.closure(matrix, 0, list.size() + 1, null);
        return CYK.forest(list.size(), matrix);
    }

    public static Map<String, String> tblNames(ParseNode parseNode, List<LexerToken> list) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (ParseNode parseNode2 : parseNode.descendants()) {
            if (!parseNode2.contains(IdentifiersDb.instance.from_table_reference_or_subquery)) continue;
            ParseNode parseNode3 = parseNode2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode3.from; i < parseNode3.to; ++i) {
                stringBuffer.append(list.get((int)i).content);
            }
            Pair<ParseNode, ParseNode> pair = CompletionInsight.findTableAlias(parseNode3);
            if (pair != null) {
                int n;
                StringBuffer stringBuffer2 = new StringBuffer();
                for (n = ((ParseNode)pair.getFirst()).from; n < ((ParseNode)pair.getFirst()).to; ++n) {
                    stringBuffer2.append(list.get((int)n).content);
                }
                stringBuffer = new StringBuffer();
                for (n = ((ParseNode)pair.getSecond()).from; n < ((ParseNode)pair.getSecond()).to; ++n) {
                    stringBuffer.append(list.get((int)n).content);
                }
                treeMap.put(stringBuffer2.toString(), stringBuffer.toString());
                continue;
            }
            treeMap.put(stringBuffer.toString(), stringBuffer.toString());
        }
        return treeMap;
    }

    public static Map<String, String> colNames(ParseNode parseNode, List<LexerToken> list, Map<String, String> map, String string) {
        int n;
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (ParseNode object2 : parseNode.descendants()) {
            if (object2.contains(IdentifiersDb.instance.sim_expr)) {
                StringBuffer stringBuffer = new StringBuffer();
                for (n = object2.from; n < object2.to; ++n) {
                    stringBuffer.append(list.get((int)n).content);
                }
                treeSet.add(stringBuffer.toString());
                continue;
            }
            if (!object2.contains(IdentifiersDb.instance.sim_expr_d_o_tidd_o_t) || object2.to != object2.from + 1) continue;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = object2.from; n < object2.to; ++n) {
                stringBuffer.append(list.get((int)n).content);
            }
            treeSet2.add(stringBuffer.toString());
        }
        TreeMap treeMap = new TreeMap();
        for (String string2 : treeSet) {
            n = string2.lastIndexOf(46);
            treeMap.put(string2, string2.substring(0, n));
        }
        if (string == null) {
            for (String string3 : treeSet2) {
                treeMap.put(string3, "?");
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string4 : map.keySet()) {
                if (!string4.equals(map.get(string4))) continue;
                arrayList.add(string4);
            }
            InsightableOracleDatabase insightableOracleDatabase = new InsightableOracleDatabase(string);
            insightableOracleDatabase.limit = 99999;
            insightableOracleDatabase.setTableAliases(map);
            throw new RuntimeException("FIXME");
        }
        return treeMap;
    }
}

