/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.PlsqlRules;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRules {
    private static final String fname = "serializedSQL.xml";
    private static final String path = "/oracle/dbtools/parser/";
    public static int PRE = -1;
    public static int WS = -1;
    public static int QUOTED_STRING = -1;
    public static int OPERATION = -1;
    public static int IDENTIFIER = -1;
    public static String[] lexTypes;
    private static Pattern[] patterns;

    public static void main(String[] stringArray) throws Exception {
        boolean bl = true;
        if (bl) {
            SqlRules.memorizeRules();
            return;
        }
        Set<RuleTuple> set = SqlRules.getRules();
        try {
            CYK.rules = CYK.getChomskyRules(set);
            CYK.keywords = new TreeSet<Integer>();
        }
        catch (Exception exception) {
            Logger.getLogger(SqlRules.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
        CYK.singleRhsRules = CYK.filterSingleRhsRules();
        CYK.doubleRhsRules = CYK.filterDoubleRhsRules();
        CYK.printSelectedChomskiRules("insert");
        String string = "select 1 from dual";
        LinkedList<LexerToken> linkedList = LexerToken.parse(string);
        LexerToken.print(linkedList);
        long l = System.currentTimeMillis();
        Matrix matrix = CYK.initArray(linkedList);
        long l2 = System.currentTimeMillis();
        System.out.println("Init array time = " + (l2 - l));
        TreeMap treeMap = new TreeMap();
        TreeMap treeMap2 = new TreeMap();
        int n = matrix.size();
        l = System.currentTimeMillis();
        CYK.closure(matrix, 0, n + 1, null);
        l2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (l2 - l));
        CYK.print(matrix);
        l = System.currentTimeMillis();
        ParseNode parseNode = CYK.forest(n, matrix);
        l2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (l2 - l));
        parseNode.printTree();
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        treeSet.add(new RuleTuple("block", new String[]{lexTypes[IDENTIFIER]}));
        treeSet.add(new RuleTuple("block", new String[]{lexTypes[QUOTED_STRING]}));
        treeSet.add(new RuleTuple("block", new String[]{"'['", "bnf", "']'"}));
        treeSet.add(new RuleTuple("block", new String[]{"'{'", "bnf", "'}'"}));
        treeSet.add(new RuleTuple("block", new String[]{"'{'", "bnf", "'}'", "'...'"}));
        treeSet.add(new RuleTuple("block", new String[]{"'['", "bnf", "']'", "'...'"}));
        treeSet.add(new RuleTuple("concat", new String[]{"block"}));
        treeSet.add(new RuleTuple("concat", new String[]{"block", "concat"}));
        treeSet.add(new RuleTuple("bnf", new String[]{"concat"}));
        treeSet.add(new RuleTuple("bnf", new String[]{"concat", "'|'", "bnf"}));
        try {
            CYK.rules = CYK.getChomskyRules(treeSet);
        }
        catch (Exception exception) {
            Logger.getLogger(SqlRules.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
        CYK.singleRhsRules = CYK.filterSingleRhsRules();
        CYK.doubleRhsRules = CYK.filterDoubleRhsRules();
        TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
        SqlRules.recursiveCollectBNF(treeSet2, "select");
        SqlRules.recursiveCollectBNF(treeSet2, "insert");
        SqlRules.recursiveCollectBNF(treeSet2, "delete");
        SqlRules.recursiveCollectBNF(treeSet2, "update");
        SqlRules.recursiveCollectBNF(treeSet2, "merge");
        SqlRules.recursiveCollectBNF(treeSet2, "alter_table");
        treeSet2.add(new RuleTuple("alias", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("c_alias", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("t_alias", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("attribute", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("table", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("column", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("column", new String[]{"identifier", "'.'", "identifier"}));
        treeSet2.add(new RuleTuple("column", new String[]{"column", "'('", "'+'", "')'"}));
        treeSet2.add(new RuleTuple("function_expression", new String[]{"user_defined_function"}));
        SqlRules.recursiveCollectBNF(treeSet2, "user_defined_function");
        treeSet2.add(new RuleTuple("function_expression", new String[]{"count"}));
        SqlRules.recursiveCollectBNF(treeSet2, "count");
        treeSet2.add(new RuleTuple("function", new String[]{"identifier"}));
        treeSet2.remove(new RuleTuple("analytic_function[0,10)", new String[]{"analytic_function", "analytic_function[1,10)"}));
        treeSet2.add(new RuleTuple("analytic_function[0,10)", new String[]{"function", "analytic_function[1,10)"}));
        treeSet2.add(new RuleTuple("arguments", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("arguments", new String[]{"expr", "','", "expr"}));
        treeSet2.add(new RuleTuple("arguments", new String[]{"expr", "',' ", "expr", "','", "expr"}));
        treeSet2.add(new RuleTuple("argument", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("schema", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("package", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("dblink", new String[]{"identifier"}));
        treeSet2.add(new RuleTuple("variable_expression", new String[]{"':'", "identifier"}));
        treeSet2.add(new RuleTuple("variable_expression", new String[]{"':'", "number"}));
        treeSet2.add(new RuleTuple("scalar_subquery_expression", new String[]{"'('", "subquery", "')'"}));
        treeSet2.add(new RuleTuple("comparison_condition", new String[]{"simple_comparison_condition"}));
        SqlRules.recursiveCollectBNF(treeSet2, "simple_comparison_condition");
        treeSet2.add(new RuleTuple("comparison_condition", new String[]{"group_comparison_condition"}));
        SqlRules.recursiveCollectBNF(treeSet2, "group_comparison_condition");
        treeSet2.add(new RuleTuple("comparison_expr", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("return_expr", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("else_expr", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("value_expr", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("pattern_matching_condition", new String[]{"like_condition"}));
        SqlRules.recursiveCollectBNF(treeSet2, "like_condition");
        treeSet2.add(new RuleTuple("char1", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("char2", new String[]{"expr"}));
        treeSet2.add(new RuleTuple("esc_char", new String[]{"string_literal"}));
        PlsqlRules.numberRules(treeSet2);
        treeSet2.add(new RuleTuple("number", new String[]{"numeric_literal"}));
        treeSet2.add(new RuleTuple("string", new String[]{"string_literal"}));
        return treeSet2;
    }

    public static void memorizeRules() throws Exception {
        Set<RuleTuple> set = SqlRules.extractRules();
        PlsqlRules.eliminateTrivialRules(set);
        FileOutputStream fileOutputStream = new FileOutputStream("db/src/oracle/dbtools/parser/serializedSQL.xml");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL uRL = SqlRules.class.getResource("/oracle/dbtools/parser/serializedSQL.xml");
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    private static void recursiveCollectBNF(Set<RuleTuple> set, String string) throws Exception {
        Set<RuleTuple> set2 = SqlRules.convert2BNF(string);
        set.addAll(set2);
        for (RuleTuple ruleTuple : set2) {
            for (String string2 : ruleTuple.rhs) {
                if (string2.startsWith("'") || string2.endsWith(")")) continue;
                boolean bl = false;
                for (RuleTuple ruleTuple2 : set) {
                    if (!ruleTuple2.head.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                try {
                    SqlRules.recursiveCollectBNF(set, string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    private static Set<RuleTuple> convert2BNF(String string) throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        String string2 = null;
        try {
            string2 = SqlRules.readURL("http://st-doc.us.oracle.com/sql_grammar/sqlbnf/bnffiles/" + string + ".htm");
        }
        catch (Exception exception) {
            string2 = SqlRules.readURL("http://st-doc.us.oracle.com/sql_grammar/sqlbnf/bnffiles/" + string + "s.htm");
        }
        if (string.contains("partition")) {
            return treeSet;
        }
        if ("hint".equals(string)) {
            return treeSet;
        }
        if ("multi_column_for_loop".equals(string)) {
            string2 = "<pre><b>FOR</b> (dimension_column   [, dimension_column ]...) <b>IN</b> ( { (literal [, literal ]...)  [ (literal [, literal ]...) ]... | subquery } )</pre>";
        } else if ("list_values_clause".equals(string)) {
            string2 = "<PRE><B>VALUES</B> ({ literal | <B>NULL</B> } [, { literal | <B>NULL</B> }]...) | <b>DEFAULT</b>)</PRE>";
        } else if ("modify_col_properties".equals(string)) {
            string2 = "<pre>column [ datatype ]] [ <B>DEFAULT</B> expr ][ { <B>ENCRYPT</b> encryption_spec | <B>DECRYPT</b> } ][ inline_constraint ] ...[ LOB_storage_clause ][ alter_XMLSchemas_clause ]</pre>";
        }
        int n = string2.indexOf("Note:");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        List<LexerToken> list = SqlRules.parse(string2);
        Matrix matrix = SqlRules.initArray(list);
        int n2 = matrix.size();
        CYK.closure(matrix, 0, n2 + 1, null);
        ParseNode parseNode = CYK.forest(n2, matrix);
        SqlRules.evaluate(treeSet, parseNode, string, list);
        treeSet.add(new RuleTuple(string, new String[]{SqlRules.ruleName(string, parseNode)}));
        return treeSet;
    }

    private static void evaluate(Set<RuleTuple> set, ParseNode parseNode, String string, List<LexerToken> list) {
        if (parseNode.to == parseNode.from + 1) {
            set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{list.get((int)parseNode.from).content}));
        } else {
            BnfTypes bnfTypes = SqlRules.type(parseNode);
            if (bnfTypes == null) {
                // empty if block
            }
            bnfTypes.eval(set, parseNode, string, list);
        }
    }

    private static Matrix initArray(List<LexerToken> list) {
        Matrix matrix = new Matrix();
        int n = 0;
        for (LexerToken lexerToken : list) {
            Integer n2 = CYK.symbolIndexes.get("'" + lexerToken.content.toUpperCase() + "'");
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            if (n2 != null) {
                treeSet.addAll(CYK.singleRhsRules[n2]);
            } else if (lexerToken.type == Token.IDENTIFIER) {
                int n3 = CYK.symbolIndexes.get(lexTypes[IDENTIFIER]);
                treeSet.addAll(CYK.singleRhsRules[n3]);
            } else if (lexerToken.type == Token.QUOTED_STRING) {
                int n4 = CYK.symbolIndexes.get(lexTypes[QUOTED_STRING]);
                treeSet.addAll(CYK.singleRhsRules[n4]);
            }
            int[] nArray = new int[treeSet.size()];
            int n5 = 0;
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n6 = (Integer)iterator.next();
                nArray[n5++] = n6;
            }
            matrix.put(Util.pair((int)n, (int)(n + 1)), nArray);
            ++n;
        }
        return matrix;
    }

    static String ruleName(String string, ParseNode parseNode) {
        return string + "[" + parseNode.from + "," + parseNode.to + ")";
    }

    static BnfTypes type(ParseNode parseNode) {
        ParseNode[] parseNodeArray = parseNode.children().toArray(new ParseNode[0]);
        ParseNode parseNode2 = parseNodeArray[0];
        if (parseNode2.contains(CYK.symbolIndexes.get("'['"))) {
            parseNode2 = parseNodeArray[2];
            if (!parseNode2.contains(CYK.symbolIndexes.get("']'"))) {
                return null;
            }
            if (parseNodeArray.length == 4) {
                parseNode2 = parseNodeArray[3];
                if (!parseNode2.contains(CYK.symbolIndexes.get("'...'"))) {
                    return null;
                }
                return BnfTypes.ITER0;
            }
            return BnfTypes.OPT;
        }
        if (parseNode2.contains(CYK.symbolIndexes.get("'{'"))) {
            parseNode2 = parseNodeArray[2];
            if (!parseNode2.contains(CYK.symbolIndexes.get("'}'"))) {
                return null;
            }
            if (parseNodeArray.length == 3) {
                return BnfTypes.GRP;
            }
            if (parseNodeArray.length == 4) {
                parseNode2 = parseNodeArray[3];
                if (!parseNode2.contains(CYK.symbolIndexes.get("'...'"))) {
                    return null;
                }
                return BnfTypes.ITER1;
            }
        } else {
            parseNode2 = parseNodeArray[1];
            if (parseNodeArray.length == 3 && parseNode2.contains(CYK.symbolIndexes.get("'|'"))) {
                return BnfTypes.UNION;
            }
            if (parseNodeArray.length == 2) {
                return BnfTypes.JOIN;
            }
        }
        return null;
    }

    static String readURL(String string) throws Exception {
        byte[] byArray = new byte[4096];
        int n = 0;
        URL uRL = new URL(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        StringBuffer stringBuffer = new StringBuffer();
        n = bufferedInputStream.read(byArray, 0, byArray.length);
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n != -1) {
            stringBuffer2.append(new String(byArray).substring(0, n));
            n = bufferedInputStream.read(byArray, 0, byArray.length);
        }
        return stringBuffer2.toString();
    }

    private static Pattern[] initPatterns() {
        int n;
        Pattern[] patternArray = new Pattern[5];
        lexTypes = new String[patternArray.length];
        PRE = n = 0;
        SqlRules.lexTypes[n] = "PRE";
        patternArray[n++] = Pattern.compile("<PRE>|</PRE>|<pre>|</pre>|<p>");
        WS = n;
        SqlRules.lexTypes[n] = "WS";
        patternArray[n++] = Pattern.compile("\\s");
        QUOTED_STRING = n;
        SqlRules.lexTypes[n] = "QUOTED_STRING";
        patternArray[n++] = Pattern.compile("<B>.*?</B>|<b>.*?</b>|<b>.*?</B>|<B>.*?</b>");
        OPERATION = n;
        SqlRules.lexTypes[n] = "OPERATION";
        patternArray[n++] = Pattern.compile("\\[|\\]|\\{|\\}|\\||\\.\\.\\.");
        IDENTIFIER = n;
        SqlRules.lexTypes[n] = "IDENTIFIER";
        patternArray[n++] = Pattern.compile("([a-z]|[A-Z])([a-z]|[A-Z]|[0-9]|_)*|\\(|\\)|\\^|\\-|\\|\\||\\!|\\*|\\+|\\.|/|>|<|=|'|\"|,|;|:|%|@", 2);
        return patternArray;
    }

    public static List<LexerToken> parse(CharSequence charSequence) {
        int n;
        Matcher[] matcherArray = new Matcher[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            matcherArray[i] = patterns[i].matcher(charSequence);
        }
        LinkedList<LexerToken> linkedList = new LinkedList<LexerToken>();
        int n2 = 0;
        while (n2 < charSequence.length() && (n = SqlRules.nextMatch(matcherArray, n2)) >= 0) {
            Object e = null;
            if (((LexerToken)e).type == Token.QUOTED_STRING) {
                int n3;
                ((LexerToken)e).content = "'" + ((LexerToken)e).content.substring(3, ((LexerToken)e).content.length() - 4) + "'";
                if ("'||'".equals(((LexerToken)e).content)) {
                    ((LexerToken)e).content = "'|'";
                    linkedList.add((LexerToken)e);
                }
                if ((n3 = ((LexerToken)e).content.indexOf(32)) > 0) {
                    String[] stringArray;
                    for (String string : stringArray = ((LexerToken)e).content.substring(1, ((LexerToken)e).content.length() - 1).trim().split(" ")) {
                        e = null;
                        ((LexerToken)e).content = "'" + string + "'";
                        linkedList.add((LexerToken)e);
                    }
                    linkedList.remove(e);
                }
            }
            if (((LexerToken)e).type == Token.IDENTIFIER && ("(".equals(((LexerToken)e).content) || ")".equals(((LexerToken)e).content) || "*".equals(((LexerToken)e).content) || ".".equals(((LexerToken)e).content) || "^".equals(((LexerToken)e).content) || "-".equals(((LexerToken)e).content) || "!".equals(((LexerToken)e).content) || "+".equals(((LexerToken)e).content) || "/".equals(((LexerToken)e).content) || "<".equals(((LexerToken)e).content) || ">".equals(((LexerToken)e).content) || "=".equals(((LexerToken)e).content) || ",".equals(((LexerToken)e).content) || ";".equals(((LexerToken)e).content) || ":".equals(((LexerToken)e).content) || "%".equals(((LexerToken)e).content) || "@".equals(((LexerToken)e).content))) {
                ((LexerToken)e).content = "'" + ((LexerToken)e).content + "'";
            }
            if (((LexerToken)e).type != Token.WS) {
                linkedList.add((LexerToken)e);
            }
            n2 = matcherArray[n].end();
        }
        return linkedList;
    }

    static int forward(Matcher matcher, int n) {
        try {
            if (matcher.start() >= n) {
                return matcher.start();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (matcher.find()) {
            if (matcher.start() < n) continue;
            return matcher.start();
        }
        return -1;
    }

    static int nextMatch(Matcher[] matcherArray, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < matcherArray.length; ++i) {
            Matcher matcher = matcherArray[i];
            int n4 = SqlRules.forward(matcher, n);
            if (n4 < 0) continue;
            n3 = n4 < n2 ? i : n3;
            n2 = n4 < n2 ? n4 : n2;
        }
        return n3;
    }

    static {
        patterns = SqlRules.initPatterns();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BnfTypes {
        UNION,
        JOIN,
        OPT,
        ITER0,
        ITER1,
        GRP;


        void eval(Set<RuleTuple> set, ParseNode parseNode, String string, List<LexerToken> list) {
            ParseNode[] parseNodeArray = parseNode.children().toArray(new ParseNode[0]);
            switch (this) {
                case UNION: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[0])}));
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[2])}));
                    SqlRules.evaluate(set, parseNodeArray[0], string, list);
                    SqlRules.evaluate(set, parseNodeArray[2], string, list);
                    return;
                }
                case JOIN: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[0]), SqlRules.ruleName(string, parseNodeArray[1])}));
                    SqlRules.evaluate(set, parseNodeArray[0], string, list);
                    SqlRules.evaluate(set, parseNodeArray[1], string, list);
                    return;
                }
                case OPT: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[1])}));
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[0]));
                    SqlRules.evaluate(set, parseNodeArray[1], string, list);
                    return;
                }
                case ITER0: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[1])}));
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{string, string}));
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[0]));
                    SqlRules.evaluate(set, parseNodeArray[1], string, list);
                    return;
                }
                case ITER1: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[1])}));
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{string, string}));
                    SqlRules.evaluate(set, parseNodeArray[1], string, list);
                    return;
                }
                case GRP: {
                    set.add(new RuleTuple(SqlRules.ruleName(string, parseNode), new String[]{SqlRules.ruleName(string, parseNodeArray[1])}));
                    SqlRules.evaluate(set, parseNodeArray[1], string, list);
                    return;
                }
            }
            throw new RuntimeException("Unknown op: " + (Object)((Object)this));
        }
    }
}

