/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlsqlRules {
    private static final String raptorTrunkBaseDir = "C:\\raptor_trunk_151\\";
    private static final String parserBaseDir = "C:\\raptor_trunk_151\\oracleparser\\src\\main\\antlr\\";
    private static final String parserPackagedDir = "C:\\raptor_trunk_151\\oracleparser\\src\\main\\antlr\\oracle\\dbtools\\parser\\";
    public static final String bnfFile = "C:\\raptor_trunk_151\\oracleparser\\src\\main\\antlr\\oracle\\dbtools\\parser\\plsql.y";
    private static final String fname = "serializedBNF.xml";
    private static final String path = "/oracle/dbtools/parser/";
    static Map<Integer, String> tokenTypes = new HashMap<Integer, String>();

    public static void main(String[] stringArray) throws Exception {
        PlsqlRules.memorizeRules();
    }

    public static void memorizeRules() throws Exception {
        Set<RuleTuple> set = PlsqlRules.extractRules();
        FileOutputStream fileOutputStream = new FileOutputStream("db/src/oracle/dbtools/parser/serializedBNF.xml");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(set);
        objectOutputStream.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL uRL = PlsqlRules.class.getResource("/oracle/dbtools/parser/serializedBNF.xml");
        InputStream inputStream = uRL.openStream();
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Set set = (Set)objectInputStream.readObject();
        objectInputStream.close();
        return set;
    }

    static void fillTokenTypesMap(String string) throws Exception {
        byte[] byArray = new byte[4096];
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        StringBuffer stringBuffer = new StringBuffer();
        n = bufferedInputStream.read(byArray, 0, byArray.length);
        while (n != -1) {
            stringBuffer.append(new String(byArray).substring(0, n));
            n = bufferedInputStream.read(byArray, 0, byArray.length);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), "\n\r", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(61);
            tokenTypes.put(Integer.parseInt(string2.substring(n2 + 1)), string2.substring(0, n2));
        }
    }

    public static Set<RuleTuple> parseBNFtext(String string) throws Exception {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        string = string.replace("':'", "MYCOL");
        string = string.replace("';'", "MYSEMICOL");
        string = string.replace("'|'", "MYVERTBAR");
        string = string.replace(":", " : ");
        string = string.replace(";", " ; ");
        string = string.replace("|", " | ");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r ", false);
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (":".equals(string4)) {
                string2 = string3;
                arrayList = new ArrayList();
            } else if (";".equals(string4)) {
                treeSet.add(new RuleTuple(string2, arrayList));
                string2 = null;
            } else if ("|".equals(string4)) {
                treeSet.add(new RuleTuple(string2, arrayList));
                arrayList = new ArrayList();
            } else if (string2 != null) {
                if ("MYCOL".equals(string4)) {
                    arrayList.add("':'");
                } else if ("MYSEMICOL".equals(string4)) {
                    arrayList.add("';'");
                } else if ("MYVERTBAR".equals(string4)) {
                    arrayList.add("'|'");
                } else if (string4.charAt(0) != '.' && string4.charAt(0) != '_' && string4.charAt(string4.length() - 1) == '_') {
                    arrayList.add("'" + string4.substring(0, string4.length() - 1).toUpperCase() + "'");
                } else {
                    arrayList.add(string4);
                }
            }
            string3 = string4;
        }
        return treeSet;
    }

    public static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> set = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile(bnfFile));
        PlsqlRules.numberRules(set);
        PlsqlRules.removeRule("dml_start", set);
        PlsqlRules.removeRule("ddl_start", set);
        set.remove(new RuleTuple("mark_sql_stmt", new String[0]));
        set.remove(new RuleTuple("library_unit", new String[]{"'TABLE'", "idents", "tbl_ty_def", "';'"}));
        set.add(new RuleTuple("library_unit", new String[]{"'TABLE'", "idents", "cmpons_pls", "';'"}));
        set.remove(new RuleTuple("bulk_executable_stmt", new String[]{"static_dml_stmt"}));
        set.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_dml_stmt", "';'"}));
        set.remove(new RuleTuple("static_dml_stmt", new String[]{"dml_start", "'SQL_STMT'"}));
        set.remove(new RuleTuple("static_dml_stmt", new String[]{"'MERGE'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_ddl_stmt", "';'"}));
        set.remove(new RuleTuple("static_ddl_stmt", new String[]{"ddl_start", "'SQL_STMT'"}));
        set.remove(new RuleTuple("loop_prm_spec", new String[]{"'SQL_STMT'"}));
        set.remove(new RuleTuple("curs_body", new String[]{"'SQL_STMT'"}));
        set.remove(new RuleTuple("cursor_open_statement", new String[]{"'SELECT'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("cursor_open_statement", new String[]{"'WITH'", "'SQL_STMT'"}));
        set.remove(new RuleTuple("id_or_reserved", new String[]{"reserved_id"}));
        set.remove(new RuleTuple("selector", new String[]{"reserved_id"}));
        PlsqlRules.removeRule("reserved_id", set);
        PlsqlRules.removeRule("identifier", set);
        set.remove(new RuleTuple("binary_add_op", new String[]{"'&'"}));
        set.remove(new RuleTuple("binary_add_op", new String[]{"'CAT'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'MOD'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'REM'"}));
        set.remove(new RuleTuple("mult_op", new String[]{"'REMAINDER'"}));
        set.add(new RuleTuple("bind_var", new String[]{"':'", "identifier"}));
        set.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "compilation_unit"}));
        set.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "compilation"}));
        set.add(new RuleTuple("exec", new String[]{"'EXEC'", "stmt"}));
        set.add(new RuleTuple("exec", new String[]{"'EXECUTE'", "stmt"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"'('", "from_table_reference_or_subquery", "')'"}));
        set.add(new RuleTuple("outer_join_type", new String[]{"'OUTER'"}));
        set.add(new RuleTuple("outer_join_type", new String[]{"'FULL'", "'OUTER'"}));
        set.add(new RuleTuple("outer_join_type", new String[]{"'LEFT'", "'OUTER'"}));
        set.add(new RuleTuple("outer_join_type", new String[]{"'RIGHT'", "'OUTER'"}));
        set.add(new RuleTuple("join_type", new String[]{"'CROSS'"}));
        set.add(new RuleTuple("join_type", new String[]{"'NATURAL'"}));
        set.add(new RuleTuple("join_type", new String[]{"'NATURAL'", "'INNER'"}));
        set.add(new RuleTuple("on_condition", new String[]{"'ON'", "expr"}));
        set.add(new RuleTuple("on_condition", new String[]{"'USING'", "insupd_column_list"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "'JOIN'", "from_table_reference_or_subquery", "on_condition"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "'INNER'", "'JOIN'", "from_table_reference_or_subquery", "on_condition"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "join_type", "'JOIN'", "from_table_reference_or_subquery"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "outer_join_type", "'JOIN'", "from_table_reference_or_subquery", "on_condition"}));
        set.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "'NATURAL'", "outer_join_type", "'JOIN'", "from_table_reference_or_subquery"}));
        set.add(new RuleTuple("sel_expr", new String[]{"plain_subquery"}));
        set.add(new RuleTuple("cmpon_asc", new String[]{"plain_subquery"}));
        set.add(new RuleTuple("comparison_predicate", new String[]{"old_subquery", "relal_op", "sim_expr"}));
        PlsqlRules.removeRule("insert_statement", set);
        set.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery", "insupd_column_list"}));
        set.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery"}));
        set.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause"}));
        set.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause", "insert_stmt_values_seq"}));
        set.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause"}));
        set.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause", "insert_into_values*"}));
        set.add(new RuleTuple(".all_first.", new String[]{"'ALL'"}));
        set.add(new RuleTuple(".all_first.", new String[]{"'FIRST'"}));
        set.add(new RuleTuple(".all_first.", new String[0]));
        set.add(new RuleTuple("when_condition_clause", new String[]{"'WHEN'", "cond", "'THEN'", "insert_into_values*"}));
        set.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause"}));
        set.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause", "when_condition*"}));
        set.add(new RuleTuple(".else_insert_clause.", new String[0]));
        set.add(new RuleTuple(".else_insert_clause.", new String[]{"'ELSE'", "insert_into_values*"}));
        set.add(new RuleTuple("conditional_insert_clause", new String[]{".all_first.", "when_condition*", ".else_insert_clause."}));
        set.add(new RuleTuple("multi_table_insert", new String[]{"conditional_insert_clause", "query_expression"}));
        set.add(new RuleTuple("multi_table_insert", new String[]{"'ALL'", "insert_into_values*", ".else_insert_clause.", "query_expression"}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "insert_stmt_values_seq", ".returning_into_clause."}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "query_expression"}));
        set.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "multi_table_insert"}));
        set.add(new RuleTuple("pri", new String[]{"procedure_call", "'OVER'", "'('", "analytic_clause", "')'"}));
        set.add(new RuleTuple("analytic_clause", new String[]{"analytic_clause[0,3)", "analytic_clause[3,9)"}));
        set.add(new RuleTuple("analytic_clause[0,3)", new String[0]));
        set.add(new RuleTuple("analytic_clause[0,3)", new String[]{"query_partition_clause"}));
        set.add(new RuleTuple("analytic_clause[3,9)", new String[0]));
        set.add(new RuleTuple("analytic_clause[3,9)", new String[]{"analytic_clause[4,8)"}));
        set.add(new RuleTuple("analytic_clause[4,8)", new String[]{".order_by_clause.", "analytic_clause[5,8)"}));
        set.add(new RuleTuple("analytic_clause[5,8)", new String[0]));
        set.add(new RuleTuple("analytic_clause[5,8)", new String[]{"windowing_clause"}));
        set.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "sim_expr", "...sim_expr.."}));
        set.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "'('", "sim_expr", "...sim_expr..", "')'"}));
        set.add(new RuleTuple("windowing_clause", new String[]{"windowing_clause[1,4)", "windowing_clause[6,47)"}));
        set.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'RANGE'"}));
        set.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'ROWS'"}));
        set.add(new RuleTuple("windowing_clause[11,13)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[11,13)"}));
        set.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[14,20)"}));
        set.add(new RuleTuple("windowing_clause[14,20)", new String[]{"expr", "windowing_clause[16,19)"}));
        set.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[21,36)", new String[]{"'AND'", "windowing_clause[23,35)"}));
        set.add(new RuleTuple("windowing_clause[23,35)", new String[]{"'UNBOUNDED'", "'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[23,35)", new String[]{"windowing_clause[26,35)"}));
        set.add(new RuleTuple("windowing_clause[26,28)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[26,28)"}));
        set.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[29,35)"}));
        set.add(new RuleTuple("windowing_clause[29,35)", new String[]{"expr", "windowing_clause[31,34)"}));
        set.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'FOLLOWING'"}));
        set.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[38,46)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[38,46)", new String[]{"windowing_clause[41,46)"}));
        set.add(new RuleTuple("windowing_clause[41,46)", new String[]{"'CURRENT'", "'ROW'"}));
        set.add(new RuleTuple("windowing_clause[41,46)", new String[]{"windowing_clause[44,46)"}));
        set.add(new RuleTuple("windowing_clause[44,46)", new String[]{"expr", "'PRECEDING'"}));
        set.add(new RuleTuple("windowing_clause[6,36)", new String[]{"'BETWEEN'", "windowing_clause[7,36)"}));
        set.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[38,46)"}));
        set.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[6,36)"}));
        set.add(new RuleTuple("windowing_clause[7,36)", new String[]{"windowing_clause[8,20)", "windowing_clause[21,36)"}));
        set.add(new RuleTuple("windowing_clause[8,20)", new String[]{"windowing_clause[11,20)"}));
        set.add(new RuleTuple("windowing_clause[8,20)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        PlsqlRules.removeRule("sort_specification", set);
        set.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'FIRST'"}));
        set.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'LAST'"}));
        set.add(new RuleTuple(".nulls_first_last.", new String[0]));
        set.add(new RuleTuple(".asc_desc.", new String[]{"'ASC'"}));
        set.add(new RuleTuple(".asc_desc.", new String[]{"'DESC'"}));
        set.add(new RuleTuple(".asc_desc.", new String[0]));
        set.add(new RuleTuple("sort_specification", new String[]{"sim_expr", ".asc_desc.", ".nulls_first_last."}));
        PlsqlRules.substituteAll(set);
        return set;
    }

    private static void removeRule(String string, Set<RuleTuple> set) {
        TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
        for (RuleTuple ruleTuple : set) {
            if (!string.equals(ruleTuple.head)) continue;
            treeSet.add(ruleTuple);
        }
        set.removeAll(treeSet);
    }

    private static void substituteSymbol(String string, String string2, Set<RuleTuple> set) {
        for (RuleTuple ruleTuple : set) {
            for (int i = 0; i < ruleTuple.rhs.length; ++i) {
                if (!ruleTuple.rhs[i].equals(string)) continue;
                ruleTuple.rhs[i] = string2;
            }
        }
        PlsqlRules.removeRule(string, set);
    }

    private static void substituteAll(Set<RuleTuple> set) {
        while (true) {
            String string = null;
            String string2 = null;
            for (RuleTuple ruleTuple : set) {
                boolean bl = true;
                for (RuleTuple ruleTuple2 : set) {
                    if (!ruleTuple.head.equals(ruleTuple2.head) || ruleTuple.equals(ruleTuple2)) continue;
                    bl = false;
                    break;
                }
                if (!bl || ruleTuple.rhs.length != 1) continue;
                string = ruleTuple.head;
                string2 = ruleTuple.rhs[0];
                System.out.println(ruleTuple.head + ":" + ruleTuple.rhs[0]);
                break;
            }
            if (string == null || string2 == null) break;
            PlsqlRules.substituteSymbol(string, string2, set);
        }
    }

    public static void numberRules(Set<RuleTuple> set) {
        set.add(new RuleTuple(".fd.", new String[0]));
        set.add(new RuleTuple(".fd.", new String[]{"'f'"}));
        set.add(new RuleTuple(".fd.", new String[]{"'d'"}));
        set.add(new RuleTuple(".+-.", new String[0]));
        set.add(new RuleTuple(".+-.", new String[]{"'+'"}));
        set.add(new RuleTuple(".+-.", new String[]{"'-'"}));
        set.add(new RuleTuple(".exp.", new String[0]));
        set.add(new RuleTuple(".exp.", new String[]{"'E'", ".+-.", "digits"}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"'.'", "digits", ".exp.", ".fd."}));
        set.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", "digits", ".exp.", ".fd."}));
    }

    public static Set<String> getKeywords(Set<RuleTuple> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RuleTuple ruleTuple : set) {
            for (String string : ruleTuple.rhs) {
                if (!string.startsWith("'")) continue;
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    private static String readBNFfile(String string) throws Exception {
        String string2 = Util.readFile((String)string);
        string2 = string2.substring(string2.indexOf("/*---------------------------- Start of Rules -------------------------------*/") + "/*---------------------------- Start of Rules -------------------------------*/".length());
        string2 = PlsqlRules.removeNestedBlock(string2, "/*", "*/");
        string2 = PlsqlRules.removeNestedBlock(string2, "{", "}");
        string2 = PlsqlRules.removeNestedBlock(string2, "{", "}");
        string2 = PlsqlRules.removeNestedBlock(string2, "{", "}");
        string2 = PlsqlRules.removeNestedBlock(string2, "{", "}");
        string2 = string2.replace("ASSIGN_", "':' '='");
        string2 = string2.replace("LTEQ_", "'<' '='");
        string2 = string2.replace("GTEQL_", "'>' '='");
        string2 = string2.replace("NOTEQL_", "'!' '='");
        string2 = string2.replace("BOX_", "'<' '>'");
        string2 = string2.replace("CAT_", "'|' '|'");
        string2 = string2.replace(" DBLDOT_ ", " '.' '.' ");
        string2 = string2.replace("ARROW_", "'=' '>'");
        string2 = string2.replace("EXP_ pri", "'*' '*' pri");
        string2 = string2.replace("L_LBL_", "'<' '<'");
        string2 = string2.replace("R_LBL_", "'>' '>'");
        string2 = string2.replace(" INDICATOR_ ", " ':' ");
        string2 = string2.replace("ph1psh_", " ");
        string2 = string2.replace("')'", " ')' ");
        string2 = string2.replace("'('", " '(' ");
        return string2;
    }

    static String removeNestedBlock(String string, String string2, String string3) {
        int n = string2.length();
        int n2 = string3.length();
        int n3 = 0;
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < string.length()) {
            n3 = string.indexOf(string2, n4);
            int n5 = string.indexOf(string2, n3 + n);
            int n6 = string.indexOf(string3, n3 + n) + n2;
            if (n3 > 0 && n3 < n5 && n5 < n6) {
                stringBuffer.append(string.substring(n4, n3 + n));
                n4 = n3 + n;
                continue;
            }
            if (n3 < 0) {
                n3 = string.length();
            }
            stringBuffer.append(string.substring(n4, n3));
            n4 = string.indexOf(string3, n3 + n) + n2;
            if (n4 >= n2) continue;
            stringBuffer.append(string.substring(n3));
            break;
        }
        return stringBuffer.toString();
    }

    public static void print(Set<RuleTuple> set) {
        for (RuleTuple ruleTuple : set) {
            System.out.println(ruleTuple.toString() + ";");
        }
    }

    public static RuleTuple trivialRule(Set<RuleTuple> set) {
        for (RuleTuple ruleTuple : set) {
            if (ruleTuple.rhs.length != 1) continue;
            boolean bl = false;
            for (RuleTuple ruleTuple2 : set) {
                if (ruleTuple2.equals(ruleTuple) || !ruleTuple2.head.equals(ruleTuple.head)) continue;
                bl = true;
            }
            if (bl || "select".equals(ruleTuple.head) || "insert".equals(ruleTuple.head) || "update".equals(ruleTuple.head) || "delete".equals(ruleTuple.head) || "merge".equals(ruleTuple.head)) continue;
            return ruleTuple;
        }
        return null;
    }

    public static void eliminateTrivialRules(Set<RuleTuple> set) {
        RuleTuple ruleTuple;
        while ((ruleTuple = PlsqlRules.trivialRule(set)) != null) {
            set.remove(ruleTuple);
            TreeSet<RuleTuple> treeSet = new TreeSet<RuleTuple>();
            TreeSet<RuleTuple> treeSet2 = new TreeSet<RuleTuple>();
            for (RuleTuple ruleTuple2 : set) {
                String[] stringArray = new String[ruleTuple2.rhs.length];
                boolean bl = false;
                for (int i = 0; i < ruleTuple2.rhs.length; ++i) {
                    if (ruleTuple2.rhs[i].equals(ruleTuple.head)) {
                        stringArray[i] = ruleTuple.rhs[0];
                        bl = true;
                        continue;
                    }
                    stringArray[i] = ruleTuple2.rhs[i];
                }
                if (!bl) continue;
                treeSet.add(new RuleTuple(ruleTuple2.head, stringArray));
                treeSet2.add(ruleTuple2);
            }
            set.removeAll(treeSet2);
            set.addAll(treeSet);
        }
        return;
    }
}

