/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseNode
implements Comparable {
    public int from;
    public int to;
    ParseNode lft = null;
    ParseNode rgt = null;
    private int payloadIn;
    int payloadOut;
    public Set<ParseNode> topLevel = null;

    public int compareTo(Object object) {
        ParseNode parseNode = (ParseNode)object;
        if (this.from != parseNode.from) {
            return this.from - parseNode.from;
        }
        return this.to - parseNode.to;
    }

    public String toString() {
        return this.toString(0);
    }

    public List<ParseNode> descendants() {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        arrayList.add(this);
        for (ParseNode parseNode : this.children()) {
            arrayList.addAll(parseNode.descendants());
        }
        return arrayList;
    }

    public List<ParseNode> ancestors(int n) {
        return this.intermediates(n, n + 1);
    }

    public List<ParseNode> intermediates(int n, int n2) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        if (this.from <= n && n2 <= this.to) {
            arrayList.add(this);
        }
        for (ParseNode parseNode : this.children()) {
            if (parseNode.from > n || n2 > parseNode.to) continue;
            arrayList.addAll(parseNode.intermediates(n, n2));
        }
        return arrayList;
    }

    public ParseNode parent(int n, int n2) {
        for (ParseNode parseNode : this.intermediates(n, n2)) {
            for (ParseNode parseNode2 : parseNode.children()) {
                if (parseNode2.from != n || parseNode2.to != n2) continue;
                return parseNode;
            }
        }
        return null;
    }

    void print(int n) {
        System.out.println(this.toString(n));
    }

    public ParseNode leafAtPos(int n) {
        if (this.children().size() == 0 && n == this.from) {
            return this;
        }
        for (ParseNode parseNode : this.children()) {
            if (parseNode.from > n || n >= parseNode.to) continue;
            return parseNode.leafAtPos(n);
        }
        return null;
    }

    private void calculateDepth(Map<Integer, Integer> map, int n) {
        map.put(Util.pair((int)this.from, (int)this.to), n);
        for (ParseNode parseNode : this.children()) {
            parseNode.calculateDepth(map, n + 1);
        }
    }

    Map<Integer, Integer> calculateDepth() {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        this.calculateDepth(treeMap, 0);
        return treeMap;
    }

    public void printTree() {
        Map<Integer, Integer> map = this.calculateDepth();
        int n = 0;
        for (ParseNode parseNode : this.descendants()) {
            if (n++ > 500) {
                return;
            }
            int n2 = map.get(Util.pair((int)parseNode.from, (int)parseNode.to));
            parseNode.print(n2);
        }
    }

    public void printBinaryTree(int n) {
        this.print(n);
        if (this.lft != null) {
            this.lft.printBinaryTree(n + 1);
        }
        if (this.rgt != null) {
            this.rgt.printBinaryTree(n + 1);
        }
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                parseNode.printBinaryTree(n + 1);
            }
        }
    }

    public String content(List<LexerToken> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = this.from; i < this.to; ++i) {
            stringBuffer.append(list.get((int)i).content);
        }
        return stringBuffer.toString();
    }

    public Set<Integer> content() {
        if (this.payloadIn == -1 && this.payloadOut == -1) {
            return new TreeSet<Integer>();
        }
        if (this.payloadIn == -1 && this.payloadOut != -1) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(this.payloadOut);
            return treeSet;
        }
        if (this.payloadIn != -1 && this.payloadOut == -1) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.addAll(CYK.singleRhsRules[this.payloadIn]);
            return treeSet;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int n : CYK.singleRhsRules[this.payloadIn]) {
            if (!CYK.singleRhsRules[n].contains(this.payloadOut)) continue;
            treeSet.add(n);
        }
        return treeSet;
    }

    public boolean contains(int n) {
        return this.content().contains(n);
    }

    public ParseNode(int n, int n2, int n3, int n4) {
        this.from = n;
        this.to = n2;
        this.payloadIn = n3;
        this.payloadOut = n4;
    }

    String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("[" + this.from + "," + this.to + ") ");
        for (Integer n2 : this.content()) {
            if (CYK.allSymbols[n2].endsWith(")")) continue;
            stringBuffer.append("  " + CYK.allSymbols[n2]);
        }
        return stringBuffer.toString();
    }

    public boolean isAuxiliary() {
        boolean bl = true;
        for (Integer n : this.content()) {
            if (CYK.allSymbols[n].indexOf("+") >= 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public Set<ParseNode> children() {
        TreeSet<ParseNode> treeSet = new TreeSet<ParseNode>();
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                if (parseNode.isAuxiliary()) {
                    treeSet.addAll(parseNode.children());
                    continue;
                }
                treeSet.add(parseNode);
            }
            return treeSet;
        }
        if (this.lft == null) {
            return treeSet;
        }
        if (this.lft.isAuxiliary()) {
            treeSet.addAll(this.lft.children());
        } else {
            treeSet.add(this.lft);
        }
        if (this.rgt == null) {
            return treeSet;
        }
        if (this.rgt.isAuxiliary()) {
            treeSet.addAll(this.rgt.children());
        } else {
            treeSet.add(this.rgt);
        }
        return treeSet;
    }

    public void moveInterval(int n) {
        this.from += n;
        this.to += n;
        if (this.topLevel != null) {
            for (ParseNode parseNode : this.topLevel) {
                parseNode.moveInterval(n);
            }
        } else {
            if (this.lft != null) {
                this.lft.moveInterval(n);
            }
            if (this.rgt != null) {
                this.rgt.moveInterval(n);
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(CYK.allSymbols[1660]);
        System.out.println(CYK.symbolIndexes.get("'SELECT'+select_list+table_expression"));
    }
}

