/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.wizard;

import java.util.logging.Level;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectTypeNode;
import oracle.ide.model.Element;
import oracle.ide.wizard.Wizard;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;

abstract class NewDBObjectWizard
extends Wizard {
    private String m_type;

    protected NewDBObjectWizard(String type) {
        this.m_type = type;
    }

    public String getShortLabel() {
        return DBTypeDisplayRegistry.getSingularDisplayName(this.m_type);
    }

    public String getLongLabel() {
        return UIArb.format(284, this.getShortLabel());
    }

    public Icon getIcon() {
        return DBTypeDisplayRegistry.getNodeIcon(this.m_type);
    }

    public boolean isAvailable(Context context) {
        return this.createObject(context, false);
    }

    public boolean invoke(Context context) {
        return this.createObject(context, true);
    }

    private boolean createObject(Context context, boolean doit) {
        Element e = context.getElement();
        String dbName = DBObjectNodeUtil.getConnectionName(e);
        if (dbName != null) {
            String schemaName = null;
            if (e instanceof DBObjectTypeNode) {
                schemaName = ((DBObjectTypeNode)e).getSchemaName();
            }
            try {
                Database db = (Database)DBObjectProviderFactory.findProvider((Object)dbName);
                if (db == null) {
                    DBLog.getLogger().log(DBLog.getTraceLogLevel(), this.m_type + " wizard couldn't find database " + dbName);
                } else {
                    Schema s = schemaName == null ? db.getDefaultSchema() : db.getSchema(schemaName);
                    DBEditorFactory factory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)db, this.m_type);
                    if (factory != null) {
                        if (doit) {
                            boolean bl = factory.createDBObject(s, (DBObjectProvider)db, this.m_type) != null;
                            return bl;
                        }
                        boolean bl = factory.canCreateDBObject(s, (DBObjectProvider)db, this.m_type);
                        return bl;
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, this.m_type + " wizard encountered an error", dbe);
            }
        }
        return false;
    }
}

