/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Database;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;

public class EditStorageInfoVerifier
extends AbstractTableVerifier
implements StorageInfoVerifier {
    public boolean canChangeTablespace() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canEditTablespace() {
        return this.isOffline();
    }

    public boolean canChangePercentFree() {
        return this.isOffline() || !this.isIOT() || !this.isPartitioned();
    }

    public boolean canChangePercentUsed() {
        return true;
    }

    public boolean canChangeInitrans() {
        return true;
    }

    public boolean canChangeMaxtrans() {
        return true;
    }

    public boolean canChangeInitialExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeNextExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeMinExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeMaxExtent() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangePercentIncrease() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeLogging() {
        return true;
    }

    public boolean canChangeFreelists() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeFreelistGroups() {
        return this.isOffline() || !this.isPartitioned();
    }

    public boolean canChangeBufferMode() {
        return true;
    }

    public void verifyStorage(OracleStorageProperties oProps) throws TraversalException {
        if (oProps != null) {
            int i;
            int iUsed;
            int iFree;
            Integer pctFree = oProps.getPercentFree();
            int n = iFree = pctFree != null ? pctFree : 0;
            if (iFree < 0 || iFree > 99) {
                throw new TraversalException(UIArb.getString(34), UIArb.getString(344), null);
            }
            Integer pctUsed = oProps.getPercentUsed();
            int n2 = iUsed = pctUsed != null ? pctUsed : 0;
            if (iUsed < 0 || iUsed > 99) {
                throw new TraversalException(UIArb.getString(265), UIArb.getString(344), null);
            }
            if (iFree + iUsed > 100) {
                throw new TraversalException(UIArb.getString(160), UIArb.getString(344), null);
            }
            Integer iniTrans = oProps.getInitrans();
            int n3 = i = iniTrans != null ? iniTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(UIArb.getString(530), UIArb.getString(344), null);
            }
            Integer maxTrans = oProps.getMaxtrans();
            int n4 = i = maxTrans != null ? maxTrans : 1;
            if (i < 1 || i > 255) {
                throw new TraversalException(UIArb.getString(114), UIArb.getString(344), null);
            }
        }
    }

    private boolean isOffline() {
        return this.getProvider() instanceof Database ^ true;
    }

    private boolean isPartitioned() {
        Relation relation = this.getOriginalRelation() != null ? this.getOriginalRelation() : this.getModifiedRelation();
        return relation != null && Boolean.TRUE.equals(relation.getProperty("PARTITIONED TABLE"));
    }

    private boolean isIOT() {
        Relation relation = this.getOriginalRelation() != null ? this.getOriginalRelation() : this.getModifiedRelation();
        return relation != null && relation.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED;
    }
}

