/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.db.verifiers.table.AbstractIndexInfoVerifier;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;

public class EditIndexInfoVerifier
extends AbstractIndexInfoVerifier {
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
    }

    public boolean canRenameIndex(Index index) {
        return true;
    }

    public boolean canRemoveIndex(Index index) {
        boolean constraint = false;
        HashSet<Column> constraintCols = new HashSet<Column>();
        Table table = index.getTable();
        Constraint[] cons = table.getConstraints();
        int i = 0;
        while (i < cons.length) {
            if ("PKConstraint".equals(cons[i].getConstraintType()) || "UniqueConstraint".equals(cons[i].getConstraintType())) {
                constraintCols.addAll(Arrays.asList(((ColumnConstraint)cons[i]).getColumns()));
            }
            ++i;
        }
        IndexObject[] columnExpressions = index.getColumnExpressions();
        int i2 = 0;
        while (!constraint && i2 < columnExpressions.length) {
            try {
                for (String[] nameComponents : ParserUtils.getColumnNames((String)columnExpressions[i2].getExpression().getSQLText(), (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                    String colName = this.getProvider().getInternalName(nameComponents[0]);
                    if (!constraintCols.contains(table.getColumn(colName))) continue;
                    constraint = true;
                }
            }
            catch (SQLQueryException e) {
                DBLog.getLogger().warning(e.getMessage());
            }
            ++i2;
        }
        return this.isEditable() && (this.isNewIndex(index) || !constraint);
    }

    public boolean canReorderIndexes() {
        return this.isEditable();
    }

    public boolean canMoveIndexUp(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canMoveIndexDown(Index index) {
        return this.isNewIndex(index);
    }

    public boolean canAddIndexes() {
        return this.isEditable();
    }

    public boolean canAddIndex(Index index) {
        return this.isEditable();
    }
}

