/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import oracle.ide.db.verifiers.table.AbstractColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.util.ModelUtil;

public class EditColumnInfoVerifier
extends AbstractColumnInfoVerifier {
    private List _colSet;
    private Set _conColSet;
    private Set _pkColSet;

    private void $init$() {
        this._colSet = new ArrayList();
        this._conColSet = new HashSet();
        this._pkColSet = new HashSet();
    }

    public EditColumnInfoVerifier() {
        this.$init$();
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
        Table table = (Table)changed;
        Column[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            this._colSet.add(cols[i]);
            ++i;
        }
        Constraint[] constraintArray = table.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            Constraint con = constraintArray[n];
            if (con instanceof ColumnConstraint) {
                Column[] columnArray = ((ColumnConstraint)con).getColumns();
                int n2 = 0;
                while (n2 < columnArray.length) {
                    Column col = columnArray[n2];
                    this._conColSet.add(col);
                    if (con instanceof PKConstraint) {
                        this._pkColSet.add(col);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public boolean canRemoveColumn(Column col) {
        return this._conColSet.contains(col) ^ true;
    }

    public boolean canMoveColumnUp(Column col) {
        return this.isNewColumn(col);
    }

    public boolean canMoveColumnDown(Column col) {
        return this.isNewColumn(col);
    }

    public boolean canChangeColumnComment(Column col) {
        return true;
    }

    public boolean canChangeColumnDefaultValue(Column col) {
        return true;
    }

    public boolean canChangeColumnNotNullState(Column col) {
        return this._pkColSet.contains(col) ^ true;
    }

    public boolean canChangeColumnType(Column col) {
        return true;
    }

    public boolean canChangeColumnSize(Column col) {
        if (!this.isNewColumn(col)) {
            try {
                DataTypeUsage dataTypeUsage = col.getDataTypeUsage();
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                DataTypeAttribute size = dataType.getDataTypeAttribute("size");
                if (size != null && size.isDeclarable() && !size.isMandatory()) {
                    boolean bl = dataTypeUsage.getAttributeValue("size") != null;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean canRenameColumn(Column col) {
        return this.getProvider() instanceof Oracle9iR2;
    }

    private boolean isNewColumn(Column col) {
        return this._colSet.contains(col) ^ true;
    }

    public void verifyColumn(Column oldCol, Column newCol) throws TraversalException {
        super.verifyColumn(oldCol, newCol);
        if (ModelUtil.areDifferent((Object)oldCol, (Object)newCol) && !this.isNewColumn(oldCol)) {
            DataTypeUsage dataTypeUsage = newCol.getDataTypeUsage();
            DataTypeUsage oldDataTypeUsage = oldCol.getDataTypeUsage();
            DBObjectID typeID = dataTypeUsage.getDataTypeID();
            DBObjectID oldTypeID = oldDataTypeUsage.getDataTypeID();
            DataType type = null;
            try {
                type = typeID == null ? null : (DataType)typeID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (type == null) {
                throw new TraversalException(DBArb.format((int)40, (Object)newCol.getName()), DBArb.getString((int)100));
            }
        }
    }
}

