/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import javax.swing.JComboBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.util.ModelUtil;

public class CreateMViewInfoVerifier
extends AbstractSchemaObjectVerifier
implements MViewInfoVerifier {
    private MaterializedView _mview;

    public CreateMViewInfoVerifier() {
    }

    public CreateMViewInfoVerifier(DBObjectProvider prov, MaterializedView mview) {
        this.initializeVerifier(prov, null, (SchemaObject)mview);
    }

    public boolean canRefreshMethod() {
        return true;
    }

    public boolean canRefreshWhen() {
        return true;
    }

    public boolean canRefreshType() {
        return true;
    }

    public boolean canRefreshStartOn() {
        return true;
    }

    public boolean canRefreshNext() {
        return true;
    }

    public boolean canRefreshUseRollback() {
        return true;
    }

    public boolean canRefreshConstraints() {
        return true;
    }

    public boolean canMVOParallel() {
        return true;
    }

    public boolean canMVOEnableCache() {
        return true;
    }

    public boolean canMVOQueryRewrite() {
        return true;
    }

    public boolean canMVOPrebuilt() {
        return true;
    }

    public boolean canUseIndex() {
        return true;
    }

    public boolean canEditQuery() {
        return true;
    }

    public boolean canEnableQueryReWrite() {
        return this.isEditable();
    }

    public boolean canChangeName() {
        return this.isEditable();
    }

    public boolean canChangeSchema() {
        return this.isEditable();
    }

    public boolean canChangeComment() {
        return this.isEditable();
    }

    public void verifyRelation() throws TraversalException {
        DBObjectProvider prov = this.getProvider();
        try {
            if (this.getOriginalObject() == null) {
                prov.validateObject((DBObject)this.getModifiedObject());
            } else {
                prov.validateObject((DBObject)this.getOriginalObject(), (DBObject)this.getModifiedObject());
            }
        }
        catch (ValidationException ve) {
            throw new TraversalException(ve.getMessage());
        }
    }

    public void verifyObject() throws TraversalException {
        this.verifyRelation();
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this._mview = (MaterializedView)change;
    }

    public boolean canCreateSchema() {
        if (this.getProvider() instanceof Database) {
            return super.canCreateSchema();
        }
        return this.isEditable();
    }

    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(208, name), UIArb.getString(318), null);
        }
    }

    protected String getErrorTitle() {
        return UIArb.getString(318);
    }

    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 209 : 45, name);
    }

    public void verifyMView(boolean replace) throws TraversalException {
        try {
            Schema schema = this._mview.getSchema();
            String name = this._mview.getName();
            if (!replace && this.getProvider().getObject("MATERIALIZED VIEW", schema, name) != null) {
                throw new TraversalException(UIArb.format(40, name), UIArb.getString(547), null);
            }
        }
        catch (DBException ex) {
            // empty catch block
        }
    }

    public void setupRefreshCombo(JComboBox refreshWithComboBox, MaterializedView.RefreshWith refreshWith) {
        if (refreshWith == MaterializedView.RefreshWith.ROWID) {
            refreshWithComboBox.setSelectedItem(UIArb.getString(315));
        } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
            refreshWithComboBox.setSelectedItem(UIArb.getString(416));
        } else {
            refreshWithComboBox.setSelectedItem("");
        }
    }
}

