/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;

public class DBUIHelper {
    private final DBUIResourceHelper m_resHelp;
    private Property[] m_basePath;
    private AbstractDBObjectProvider m_pro;
    private Component m_parent;
    private List<Component> m_components;
    private List<Property[]> m_paths;
    private boolean m_done;
    private boolean m_editable;

    private void $init$() {
        this.m_editable = true;
    }

    public DBUIHelper(String panelName, Component parent) {
        this.$init$();
        this.m_resHelp = new DBUIResourceHelper(panelName);
        this.m_parent = parent;
    }

    public void setBasePath(Property ... basePath) {
        this.m_basePath = basePath;
    }

    private Property[] getCompletePath(Property ... path) {
        if (this.m_basePath != null) {
            Property[] retval = new Property[this.m_basePath.length + path.length];
            System.arraycopy(this.m_basePath, 0, retval, 0, this.m_basePath.length);
            System.arraycopy(path, 0, retval, this.m_basePath.length, path.length);
            return retval;
        }
        return path;
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = (AbstractDBObjectProvider)pro;
    }

    public void setEditable(boolean edit) {
        this.m_editable = edit;
    }

    public synchronized void processComponents(DBObject orig, DBObject update) {
        if (this.m_pro == null) {
            new IllegalStateException("no DBObjectProvider has been set!").printStackTrace();
        }
        if (this.m_done) {
            return;
        }
        if (this.m_pro != null && update != null && this.m_components != null) {
            this.m_done = true;
            PropertyManager pm = this.m_pro.getPropertyManager();
            String type = update.getType();
            int i = 0;
            while (i < this.m_components.size()) {
                Component comp = this.m_components.get(i);
                Property[] path = this.getCompletePath(this.m_paths.get(i));
                if (pm.supportsProperty(type, (Object)path)) {
                    boolean disable = this.m_editable ^ true;
                    if (!disable) {
                        PropertyAction action = pm.canChangeProperty(orig, update, (Object)path);
                        if (orig == null) {
                            if (action != PropertyAction.CREATE) {
                                disable = true;
                            }
                        } else if (action != PropertyAction.ALTER) {
                            if (action == PropertyAction.REPLACE) {
                                DBLog.getLogger().log(Level.FINE, "will need replace for: " + path);
                            } else {
                                disable = true;
                            }
                        }
                    }
                    comp.setEnabled(disable ^ true);
                    comp.setVisible(true);
                } else {
                    comp.setVisible(false);
                }
                ++i;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void canCommit(DBObject orig, DBObject update, TraversableContext tc) throws TraversalException {
        PropertyManager pm = this.m_pro.getPropertyManager();
        PropertyAction action = pm.canUpdateObject(orig, update);
        if (action == PropertyAction.CREATE || action == PropertyAction.REPLACE) {
            if (orig == null || tc.find("allowReplaceForUpdate") == Boolean.TRUE) return;
            StringBuilder props = new StringBuilder();
            for (String s : action.getProperties()) {
                props.append(PropertyDisplayRegistry.getDisplayName(s)).append("\n");
            }
            String propText = props.toString();
            if (!MessageDialog.confirm((Component)this.m_parent, (Object)UIArb.format(261, propText), (String)UIArb.getString(205), null, (boolean)true)) throw new TraversalException(UIArb.format(772, propText));
            tc.put("allowReplaceForUpdate", (Object)Boolean.TRUE);
            return;
        } else {
            if (action != PropertyAction.ALTER) return;
            tc.remove("allowReplaceForUpdate");
        }
    }

    public synchronized void registerComponent(Component comp, Property ... path) {
        if (this.m_components == null) {
            this.m_components = new ArrayList<Component>();
            this.m_paths = new ArrayList<Property[]>();
        }
        this.m_components.add(comp);
        this.m_paths.add(path);
    }

    public void registerComponent(Component comp, String componentName, Property ... path) {
        this.registerComponent(comp, path);
        this.m_resHelp.setName(comp, componentName);
    }

    public void registerComponent(AbstractButton button, String buttonText, Property ... propPath) {
        this.registerComponent(button, buttonText, Property.createPath((Property[])propPath), propPath);
    }

    public void registerComponent(AbstractButton button, String buttonText, String componentName, Property ... propPath) {
        this.registerComponent((Component)button, propPath);
        this.m_resHelp.resButton(button, buttonText, componentName);
    }

    public void registerComponent(JLabel label, Component component, String labelText, Property ... propPath) {
        this.registerComponent(label, component, labelText, Property.createPath((Property[])propPath), propPath);
    }

    public void registerComponent(JLabel label, Component component, String labelText, String componentName, Property ... propPath) {
        this.registerComponent(component, propPath);
        this.registerComponent((Component)label, propPath);
        this.m_resHelp.resLabel(label, component, labelText, componentName);
    }
}

