/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractTableInfoVerifier
extends AbstractTableVerifier
implements TableInfoVerifier {
    boolean m_hasMVL;

    private void $init$() {
        this.m_hasMVL = false;
    }

    public boolean canChangeName() {
        return this.m_hasMVL ^ true;
    }

    public boolean canChangeSchema() {
        return this.m_hasMVL ^ true;
    }

    public boolean canChangeTempState() {
        return this.isEditable();
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean canChangeComment() {
        return this.isEditable();
    }

    protected AbstractTableInfoVerifier() {
        this.$init$();
    }

    protected void verifyTableNotExist(Schema schema, String name) throws TraversalException {
        String altName;
        DBObjectProvider prov = this.getProvider();
        if (prov != null && ModelUtil.areDifferent((Object)name, (Object)(altName = prov.getUniqueName("TABLE", (DBObject)schema, name)))) {
            throw new TraversalException(UIArb.format(522, name), UIArb.getString(245), null);
        }
    }

    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(208, name), UIArb.getString(245), null);
        }
    }

    public void verifyObject() throws TraversalException {
        this.verifyRelation();
    }

    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        if (orig != null && change != null && change.getType().equals("TABLE")) {
            if (prov instanceof OracleDatabaseImpl) {
                QueryWrapper wrap = new QueryWrapper((Database)prov, MaterializedViewLogBuilder.getMVLForTableQuery(), new Object[]{change.getSchema(), change.getName()});
                1 r = new 1(this, wrap);
                try {
                    wrap.executeQuery((QueryWrapper.QueryRunnable)r);
                }
                catch (DBException dbe) {
                    DBLog.getLogger().log(Level.WARNING, "Error querying whether table " + orig.getName() + "has a mview log", dbe);
                }
            } else {
                SchemaObject[] mvls = null;
                String[] types = new String[]{"MATERIALIZED VIEW LOG"};
                try {
                    mvls = prov.listObjects(types, change.getSchema());
                }
                catch (DBException e) {
                    mvls = null;
                }
                if (mvls != null) {
                    int i = 0;
                    while (i < mvls.length) {
                        if (ModelUtil.areEqual((Object)change.getID(), (Object)((MaterializedViewLog)mvls[i]).getMasterTableID())) {
                            this.m_hasMVL = true;
                            break;
                        }
                        ++i;
                    }
                }
            }
        }
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ AbstractTableInfoVerifier this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.this$0.m_hasMVL = true;
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 1(AbstractTableInfoVerifier abstractTableInfoVerifier, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.this$0 = abstractTableInfoVerifier;
        }
    }
}

