/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.CommentEditor;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.verifiers.view.ViewInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.SQLQueryBuilder;

public class ViewInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private CommentEditor m_comment;
    private JRadioButton m_readOnly;
    private JRadioButton m_checkOption;
    private JCheckBox m_restrict;
    private JCheckBox m_force;

    private void $init$() {
        this.m_comment = new CommentEditor();
        this.m_readOnly = new JRadioButton();
        this.m_checkOption = new JRadioButton();
        this.m_restrict = new JCheckBox();
        this.m_force = new JCheckBox();
    }

    public ViewInfoPanel() {
        this.$init$();
        DBUIResourceHelper reshelp = new DBUIResourceHelper("ViewInfoPanel");
        reshelp.resButton(this.m_restrict, UIArb.getString(203), "Restrict");
        reshelp.resButton(this.m_readOnly, UIArb.getString(213), "ReadOnly");
        reshelp.resButton(this.m_checkOption, UIArb.getString(814), "Check");
        reshelp.resButton(this.m_force, UIArb.getString(618), "Force");
        this.setLayout(new GridBagLayout());
        this.add(this.m_restrict, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_readOnly, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add(this.m_checkOption, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add(this.m_force, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_comment, new GridBagConstraints(1, 10, 1, 1, 1.0, 1.0, 18, 1, new Insets(15, 0, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_readOnly);
        bg.add(this.m_checkOption);
        this.m_readOnly.setSelected(true);
        this.m_restrict.setSelected(false);
        this.m_readOnly.setEnabled(false);
        this.m_checkOption.setEnabled(false);
        this.m_restrict.addActionListener(this);
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        View view = (View)dataContext.find("NewObject");
        ViewInfoVerifier verifier = (ViewInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        Schema[] schemas = (Schema[])dataContext.find("SchemaList");
        SQLQueryBuilder builder = (SQLQueryBuilder)dataContext.get("SQLQueryBuilder");
        this.init(prov, view, builder, verifier, schemas);
        boolean isEditable = (Boolean)dataContext.find("DBObjectIsEditable");
        if (!isEditable) {
            this.m_comment.setEnabled(false);
            this.m_readOnly.setEnabled(false);
            this.m_checkOption.setEnabled(false);
            this.m_restrict.setEnabled(false);
            this.m_force.setEnabled(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((View)dataContext.find("NewObject"), (Schema[])dataContext.find("SchemaList"), dataContext.getDirection() != 2);
    }

    protected void init(DBObjectProvider prov, View view, SQLQueryBuilder builder, ViewInfoVerifier verifier, Schema[] schemas) {
        super.init(prov, verifier);
        verifier.setBuilder(builder);
        this.m_comment.init(prov, (DBObject)view, verifier);
        String rest = view.getQueryRestriction();
        if (rest != null) {
            this.m_restrict.setSelected(true);
            this.m_readOnly.setEnabled(true);
            this.m_checkOption.setEnabled(true);
            if (rest.equalsIgnoreCase("WITH READ ONLY")) {
                this.m_readOnly.setSelected(true);
            } else {
                this.m_checkOption.setSelected(true);
            }
        }
        this.m_force.setSelected(view.isForceOnCreate());
        if (verifier != null) {
            boolean queryChangeable = verifier.canChangeQueryRestriction();
            this.m_restrict.setEnabled(queryChangeable);
            this.m_readOnly.setEnabled(this.m_restrict.isSelected() && queryChangeable);
            this.m_checkOption.setEnabled(this.m_restrict.isSelected() && queryChangeable);
        }
    }

    protected void commit(View view, Schema[] schema, boolean isForward) throws TraversalException {
        try {
            this.m_comment.commit((DBObject)view);
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage());
        }
        if (this.m_restrict.isSelected()) {
            view.setQueryRestriction(this.m_readOnly.isSelected() ? "WITH READ ONLY" : "WITH CHECK OPTION");
        } else {
            view.setQueryRestriction(null);
        }
        view.setForceOnCreate(this.m_force.isSelected());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_restrict) {
            if (this.m_restrict.isSelected()) {
                this.m_readOnly.setEnabled(true);
                this.m_checkOption.setEnabled(true);
            } else {
                this.m_readOnly.setEnabled(false);
                this.m_checkOption.setEnabled(false);
            }
        }
    }
}

