/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.panels.trigger.DMLSubPanel;
import oracle.ide.db.panels.trigger.TriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class TableTriggerPanel
extends BaseTriggerPanel
implements ItemListener,
ActionListener {
    private GridBagLayout _layMain;
    private JLabel _lblOwner;
    private SchemaPicker _cmbOwner;
    private JLabel _lblTable;
    private SchemaObjectComboBox _cmbTable;
    private JRadioButton _radBefore;
    private JRadioButton _radAfter;
    private ButtonGroup _grpTiming;
    private JRadioButton _radStatement;
    private JRadioButton _radRow;
    private ButtonGroup _grpLevel;
    private DMLSubPanel _pnlDMLOption;
    private JLabel _lblAvail;
    private JList _lstAvail;
    private ListPicker _pckAvail;
    private JLabel _lblSel;
    private JList _lstSel;
    private ListPicker _pckSel;
    private Shuttle _shtCols;
    private JLabel _lblWhen;
    private JTextField _fldWhen;
    private Table lastTable;
    private DBUIResourceHelper _resHelper;

    private void $init$() {
        this._layMain = new GridBagLayout();
        this._lblOwner = new JLabel();
        this._cmbOwner = new SchemaPicker();
        this._lblTable = new JLabel();
        this._cmbTable = new SchemaObjectComboBox();
        this._radBefore = new JRadioButton();
        this._radAfter = new JRadioButton();
        this._grpTiming = new ButtonGroup();
        this._radStatement = new JRadioButton();
        this._radRow = new JRadioButton();
        this._grpLevel = new ButtonGroup();
        this._pnlDMLOption = new DMLSubPanel();
        this._lblAvail = new JLabel();
        this._lstAvail = new JList();
        this._pckAvail = new ListPicker(this._lstAvail);
        this._lblSel = new JLabel();
        this._lstSel = new JList();
        this._pckSel = new ListPicker(this._lstSel);
        this._shtCols = new Shuttle();
        this._lblWhen = new JLabel();
        this._fldWhen = new JTextField();
        this.lastTable = null;
        this._resHelper = new DBUIResourceHelper("TableTriggerPanel");
    }

    public TableTriggerPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commit() throws TraversalException {
        Schema tableOwner = this._cmbOwner.getSchema();
        Table table = (Table)this._cmbTable.getSchemaObject();
        String tableName = null;
        if (table != null) {
            tableName = table.getName();
        }
        if (!ModelUtil.hasLength(tableName)) {
            throw new TraversalException(UIArb.getString(244));
        }
        Trigger.Timing timing = this._radBefore.isSelected() ? Trigger.Timing.BEFORE : Trigger.Timing.AFTER;
        boolean stmtTrigger = this._radStatement.isSelected();
        ArrayList<DBObjectID> colIDs = new ArrayList<DBObjectID>();
        if (this._pnlDMLOption.isUpdateSelected() && this._lstAvail.getModel().getSize() > 0) {
            ListModel model = this._lstSel.getModel();
            int count = model.getSize();
            int i = 0;
            while (i < count) {
                colIDs.add(table.getColumn((String)model.getElementAt(i)).getID());
                ++i;
            }
        }
        Trigger trigger = this.getTrigger();
        trigger.setTableOwner(tableOwner);
        trigger.setTableID(table.getID());
        trigger.setTiming(timing);
        trigger.setStatementLevel(stmtTrigger);
        trigger.setColumnIDs(colIDs.toArray(new DBObjectID[colIDs.size()]));
        String whenClause = this._fldWhen.getText();
        if (this._fldWhen.isEnabled() && ModelUtil.hasLength((String)whenClause)) {
            trigger.setWhenClause(whenClause);
        } else {
            trigger.setWhenClause(null);
        }
        this._pnlDMLOption.commit();
    }

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        Schema schema = trigger.getTableOwner();
        if (schema == null) {
            schema = trigger.getSchema();
        }
        this._cmbOwner.init(prov, schema);
        this._cmbOwner.setEnabled(canChangeSchema);
        DBObject table = null;
        try {
            if (trigger.getTableID() != null) {
                table = trigger.getTableID().resolveID();
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        if (table != null && table instanceof Table) {
            this._cmbTable.setSchemaObject((SchemaObject)((Table)table));
            this._setColumnList(schema, (Table)table);
        }
        boolean before = trigger.getTiming() == null ? true : trigger.getTiming() == Trigger.Timing.BEFORE;
        this._radBefore.setSelected(before);
        this._radAfter.setSelected(before ^ true);
        this._radStatement.setSelected(trigger.isStatementLevel());
        this._radRow.setSelected(trigger.isStatementLevel() ^ true);
        this._pnlDMLOption.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
        this._fldWhen.setText(trigger.getWhenClause());
        if (!canEditTrigger) {
            this._lblOwner.setEnabled(false);
            this._cmbOwner.setEnabled(false);
            this._lblTable.setEnabled(false);
            this._cmbTable.setEnabled(false);
            this._radBefore.setEnabled(false);
            this._radAfter.setEnabled(false);
            this._radStatement.setEnabled(false);
            this._radRow.setEnabled(false);
            this._lblAvail.setEnabled(false);
            this._lstAvail.setEnabled(false);
            this._lblSel.setEnabled(false);
            this._lstSel.setEnabled(false);
            this._shtCols.setEnabled(false);
            this._lblWhen.setEnabled(false);
            this._fldWhen.setEnabled(false);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._resHelper.resLabel(this._lblOwner, this._cmbOwner, UIArb.getString(869), "_cmbOwner");
        this._cmbOwner.addActionListener(this);
        this._resHelper.resLabel(this._lblTable, this._cmbTable, UIArb.getString(88), "_cmbTable");
        this._cmbTable.addActionListener(this);
        this._resHelper.resButton(this._radBefore, UIArb.getString(874), "_radBefore");
        this._grpTiming.add(this._radBefore);
        this._resHelper.resButton(this._radAfter, UIArb.getString(15), "_radAfter");
        this._grpTiming.add(this._radAfter);
        this._radBefore.setSelected(true);
        this._resHelper.resButton(this._radStatement, UIArb.getString(509), "_radStatement");
        this._grpLevel.add(this._radStatement);
        this._radStatement.addItemListener(this);
        this._resHelper.resButton(this._radRow, UIArb.getString(520), "_radRow");
        this._grpLevel.add(this._radRow);
        this._radStatement.setSelected(true);
        this._pnlDMLOption.addUpdateItemListener(this);
        this._resHelper.resLabel(this._lblAvail, this._lstAvail, UIArb.getString(62), "_lstAvail");
        this._shtCols.setFromPicker((ItemPicker)this._pckAvail);
        this._lstAvail.addFocusListener(this);
        this._resHelper.resLabel(this._lblSel, this._lstSel, UIArb.getString(466), "_lstSel");
        this._shtCols.setToPicker((ItemPicker)this._pckSel);
        this._lstSel.addFocusListener(this);
        this._resHelper.resLabel(this._lblWhen, this._fldWhen, UIArb.getString(189), "_fldWhen");
        this.add(this._lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this._cmbOwner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._lblTable, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this._cmbTable, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this._pnlDMLOption), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel pnlWhen = new JPanel();
        pnlWhen.setLayout(new GridBagLayout());
        pnlWhen.add((Component)this._radBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        pnlWhen.add((Component)this._radAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlWhen.add((Component)this._radStatement, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 20, 0, 0), 0, 0));
        pnlWhen.add((Component)this._radRow, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
        JPanel pnlSubWhen = new JPanel();
        pnlSubWhen.setLayout(new GridBagLayout());
        pnlSubWhen.add((Component)this._lblWhen, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlSubWhen.add((Component)this._fldWhen, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        pnlWhen.add((Component)pnlSubWhen, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(pnlWhen, new GridBagConstraints(2, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this._shtCols.add((Component)this._lblAvail, (Object)"FromHeader");
        this._shtCols.add((Component)this._lblSel, (Object)"ToHeader");
        this.add((Component)this._shtCols, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void itemStateChanged(ItemEvent e) {
        Object src = e.getSource();
        if (src == this._radStatement) {
            boolean row = this._radStatement.isSelected() ^ true;
            this._fldWhen.setEnabled(row);
        }
        this._updateShuttle(this._pnlDMLOption.isUpdateSelected());
    }

    private void _updateShuttle(boolean enabled) {
        this._shtCols.setEnabled(enabled);
        this._lstAvail.setEnabled(enabled);
        this._lstSel.setEnabled(enabled);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this._cmbOwner) {
            try {
                this._updateSchema(this._cmbOwner.getSchema());
            }
            catch (TraversalException traversalException) {}
        } else if (src == this._cmbTable) {
            try {
                this._updateTable(this._cmbOwner.getSchema(), (Table)this._cmbTable.getSchemaObject());
            }
            catch (TraversalException f) {
                // empty catch block
            }
        }
    }

    private void _updateSchema(Schema schema) {
        this._cmbTable.init(this.getProvider(), schema, "TABLE");
        this._updateTable(schema, (Table)this._cmbTable.getSchemaObject());
    }

    private void _updateTable(Schema schema, Table table) {
        if (this.lastTable != null && this.lastTable != table) {
            this.getTrigger().setColumnIDs(new DBObjectID[0]);
            this.lastTable = table;
        }
        this._setColumnList(schema, table);
    }

    private void _setColumnList(Schema schema, Table table) {
        DefaultListModel<String> availModel = new DefaultListModel<String>();
        DefaultListModel<String> selectedModel = new DefaultListModel<String>();
        if (table != null) {
            Column[] tableCols = table.getColumns();
            DBObjectID[] updateColumnIds = this.getTrigger().getColumnIDs();
            int i = 0;
            while (i < tableCols.length) {
                boolean selected = false;
                if (updateColumnIds == null || updateColumnIds.length == 0) {
                    selected = true;
                } else {
                    DBObjectID[] dBObjectIDArray = updateColumnIds;
                    int n = 0;
                    while (n < dBObjectIDArray.length) {
                        DBObjectID id = dBObjectIDArray[n];
                        if (id.equals(tableCols[i].getID())) {
                            selected = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (selected) {
                    selectedModel.addElement(tableCols[i].getName());
                } else {
                    availModel.addElement(tableCols[i].getName());
                }
                ++i;
            }
        }
        this._lstAvail.setModel(availModel);
        this._lstSel.setModel(selectedModel);
    }

    private String _getKey(Schema schema, String tableName) {
        FastStringBuffer buf = new FastStringBuffer();
        if (schema != null) {
            buf.append(schema.getName()).append('.');
        }
        buf.append(tableName);
        return buf.toString();
    }

    void setParent(TriggerPanel parent) {
        super.setParent(parent);
        this._pnlDMLOption.setParent(parent);
    }

    protected boolean getCurrentOKState() {
        return this._pnlDMLOption.getCurrentOKState() && (!this._pnlDMLOption.isUpdateSelected() || this._lstSel.getModel().getSize() > 0);
    }
}

