/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class DMLSubPanel
extends BaseTriggerPanel {
    private GridBagLayout _layMain;
    private JCheckBox _chkInsert;
    private JCheckBox _chkDelete;
    private JCheckBox _chkUpdate;
    private JPanel _pnlReferencing;
    private GridBagLayout _layReferencing;
    private Border _bdrReferencing;
    private JLabel _lblOld;
    private JTextField _fldOld;
    private JLabel _lblNew;
    private JTextField _fldNew;
    private DBUIResourceHelper _resHelper;

    private void $init$() {
        this._layMain = new GridBagLayout();
        this._chkInsert = new JCheckBox();
        this._chkDelete = new JCheckBox();
        this._chkUpdate = new JCheckBox();
        this._pnlReferencing = new JPanel();
        this._layReferencing = new GridBagLayout();
        this._bdrReferencing = BorderFactory.createTitledBorder(UIArb.getString(326));
        this._lblOld = new JLabel();
        this._fldOld = new JTextField();
        this._lblNew = new JLabel();
        this._fldNew = new JTextField();
        this._resHelper = new DBUIResourceHelper("DMLSubPanel");
    }

    public DMLSubPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layMain);
        this._pnlReferencing.setLayout(this._layReferencing);
        this._resHelper.resButton(this._chkInsert, UIArb.getString(632), "_chkInsert");
        this._resHelper.resButton(this._chkDelete, UIArb.getString(769), "_chkDelete");
        this._resHelper.resButton(this._chkUpdate, UIArb.getString(58), "_chkUpdate");
        this._resHelper.resLabel(this._lblOld, this._fldOld, UIArb.getString(408), "_fldOld");
        this._resHelper.resLabel(this._lblNew, this._fldNew, UIArb.getString(184), "_fldNew");
        this._pnlReferencing.setBorder(this._bdrReferencing);
        this._pnlReferencing.add((Component)this._lblOld, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 12), 0, 0));
        this._pnlReferencing.add((Component)this._fldOld, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this._pnlReferencing.add((Component)this._lblNew, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this._pnlReferencing.add((Component)this._fldNew, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._chkInsert, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._chkDelete, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._chkUpdate, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._pnlReferencing, new GridBagConstraints(1, 0, 1, 3, 1.0, 0.0, 10, 1, new Insets(0, 24, 0, 0), 0, 0));
    }

    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        this._chkInsert.setSelected(false);
        this._chkDelete.setSelected(false);
        this._chkUpdate.setSelected(false);
        String[] stringArray = trigger.getEvents();
        int n = 0;
        while (n < stringArray.length) {
            String event = stringArray[n];
            if ("INSERT".equals(event)) {
                this._chkInsert.setSelected(true);
            } else if ("DELETE".equals(event)) {
                this._chkDelete.setSelected(true);
            } else if ("UPDATE".equals(event)) {
                this._chkUpdate.setSelected(true);
            }
            ++n;
        }
        String[] refNames = trigger.getReferenceNames();
        if (refNames.length > 0) {
            this._fldOld.setText(refNames[0]);
        }
        if (refNames.length > 1) {
            this._fldNew.setText(refNames[1]);
        }
        if (!canEditTrigger) {
            this._chkInsert.setEnabled(false);
            this._chkDelete.setEnabled(false);
            this._chkUpdate.setEnabled(false);
            this._lblOld.setEnabled(false);
            this._fldOld.setEnabled(false);
            this._lblNew.setEnabled(false);
            this._fldNew.setEnabled(false);
        }
    }

    public void addUpdateItemListener(ItemListener l) {
        this._chkUpdate.addItemListener(l);
    }

    public void removeUpdateItemListener(ItemListener l) {
        this._chkUpdate.removeItemListener(l);
    }

    public void setUpdateSelected(boolean sel) {
        this._chkUpdate.setSelected(sel);
    }

    public boolean isUpdateSelected() {
        return this._chkUpdate.isSelected();
    }

    public void commit() throws TraversalException {
        ArrayList<String> events = new ArrayList<String>();
        if (this._chkInsert.isSelected()) {
            events.add("INSERT");
        }
        if (this._chkDelete.isSelected()) {
            events.add("DELETE");
        }
        if (this._chkUpdate.isSelected()) {
            events.add("UPDATE");
        }
        String[] refNames = new String[2];
        String refOld = this._fldOld.getText();
        String refNew = this._fldNew.getText();
        refNames[0] = ModelUtil.hasLength((String)refOld) ? refOld : null;
        refNames[1] = ModelUtil.hasLength((String)refNew) ? refNew : null;
        Trigger trigger = this.getTrigger();
        trigger.setEvents(events.toArray(new String[events.size()]));
        trigger.setReferenceNames(refNames);
    }

    protected boolean getCurrentOKState() {
        return this._chkDelete.isSelected() || this._chkInsert.isSelected() || this._chkUpdate.isSelected();
    }
}

