/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import oracle.ide.Ide;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.panels.table.TableTypePanel;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIHelper;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.dialogs.MessageDialog;

public class TableInfoPanel
extends NameAndSchemaAdvancedEditor {
    private JLabel m_tableTypeLabel;
    private TableTypePanel m_tableTypePanel;
    private TableInfoVerifier m_tableVerifier;
    private Table.TableType m_lastType;
    private final Map<String, Object> m_cachedProps;
    private DBUIHelper m_helper;

    private void $init$() {
        this.m_tableTypeLabel = new JLabel(UIArb.getString(562));
        this.m_tableTypePanel = new TableTypePanel(false);
        this.m_cachedProps = new HashMap<String, Object>();
    }

    public TableInfoPanel() {
        this.$init$();
        this.m_helper = new DBUIHelper("TableInfoPanel", (Component)((Object)this));
        this.m_helper.registerComponent((Component)this.m_tableTypePanel, Property.properties, Property.TableType);
        this.m_tableTypePanel.addActionListener(this);
    }

    private void removeTypePanel() {
        this.remove(this.m_tableTypeLabel);
        this.remove(this.m_tableTypePanel);
    }

    private void addTypePanel() {
        this.removeTypePanel();
        PropertyManager pm = ((AbstractDBObjectProvider)this.getProvider()).getPropertyManager();
        if (pm != null && !pm.supportsProperty("TABLE", (Object)"properties/TableType")) {
            return;
        }
        this.add(this.m_tableTypeLabel, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_tableTypePanel, new GridBagConstraints(1, 30, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext data) {
        super.onEntry(data);
        if (this.isAdvancedLayout() || this.isEditing()) {
            this.addTypePanel();
        }
        Table table = (Table)this.getSchemaObject();
        this.m_lastType = (Table.TableType)table.getProperty("TableType", (Object)Table.TableType.NORMAL);
        this.m_tableTypePanel.setTableType(this.m_lastType);
        this.m_tableVerifier = (TableInfoVerifier)data.find("SchemaObjectInfoVerifier");
        boolean isEditable = (Boolean)data.find("DBObjectIsEditable");
        if (!isEditable) {
            this.m_tableTypePanel.enableAllComponents(false);
        } else if (this.m_tableVerifier != null && !this.m_tableVerifier.canChangeTempState()) {
            this.m_tableTypePanel.enableAllComponents(false);
        }
        this.m_helper.setProvider(this.getProvider());
        this.m_helper.processComponents((DBObject)this.getOriginalObject(), (DBObject)this.getSchemaObject());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Table table;
        Object tableType;
        super.onExit(dataContext);
        TableInfoVerifier verifier = (TableInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        if (verifier != null) {
            verifier.verifyRelation();
        }
        if ((tableType = (table = (Table)this.getSchemaObject()).getProperty("TableType")) == Table.TableType.EXTERNAL || tableType == Table.TableType.SESSION_TEMP || tableType == Table.TableType.TRANSACTION_TEMP) {
            this.nullProperties(table, "OracleStorageProperties");
        }
        try {
            this.getProvider().validateObject((DBObject)((Table)dataContext.get("OriginalObject")), (DBObject)((Table)dataContext.get("NewObject")));
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage(), e.getTitle());
        }
        this.m_lastType = null;
    }

    public void commit() throws TraversalException {
        super.commit();
        this.commitType();
    }

    private Table.TableType commitType() {
        Table table = (Table)this.getSchemaObject();
        Table.TableType type = this.m_tableTypePanel.getTableType();
        table.setProperty("TableType", (Object)type);
        return type;
    }

    protected void showSimplePanel() throws TraversalException {
        super.showSimplePanel();
        this.removeTypePanel();
    }

    protected void showAdvancedPanel() throws TraversalException {
        this.showPanelsForTableType((Table)this.getSchemaObject());
        this.addTypePanel();
    }

    private void showPanelsForTableType(Table table) throws TraversalException {
        Table.TableType defaultType;
        List<Navigable> navs = this.isEditing() ? this.getPanelLibrary().getEditNavigables((DBObject)table, this.getProvider()) : this.getPanelLibrary().getCreateNavigables((DBObject)table, this.getProvider());
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        String key = type == (defaultType = this.isEditing() ? (Table.TableType)this.getOriginalObject().getProperty("TableType") : Table.TableType.NORMAL) ? "DEFAULT_PANEL" : (type == Table.TableType.TRANSACTION_TEMP || type == Table.TableType.SESSION_TEMP ? Table.TableType.SESSION_TEMP.toString() : type.toString());
        this.changePanels(key, navs.toArray(new Navigable[navs.size()]));
    }

    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_tableTypePanel) {
            Table table = (Table)this.getSchemaObject();
            this.m_lastType = (Table.TableType)table.getProperty("TableType");
            Table.TableType type = this.commitType();
            if (this.m_lastType != type) {
                try {
                    this.showPanelsForTableType(table);
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    table.setProperty("TableType", (Object)this.m_lastType);
                    this.m_tableTypePanel.setTableType(this.m_lastType);
                }
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    private void validateTableTypePanelChange(Table table) throws TraversalException {
        Table.TableType tableType = (Table.TableType)table.getProperty("TableType");
        if (this.m_lastType != null && this.m_lastType != tableType) {
            if (!this.doTypeChange(table, this.m_lastType)) {
                throw new TraversalException(null);
            }
            this.m_lastType = null;
            try {
                this.getProvider().validateObjectProperty((DBObject)table, (Object)Property.createPath((Property[])new Property[]{Property.properties, Property.TableType}));
            }
            catch (ValidationException ve) {
                throw new TraversalException(ve.getMessage(), ve.getTitle());
            }
        }
    }

    public void validatePanelChange(TraversableContext data) throws TraversalException {
        this.validateTableTypePanelChange((Table)this.getSchemaObject());
    }

    private boolean doTypeChange(Table table, Table.TableType oldType) {
        Table.TableType type = (Table.TableType)table.getProperty("TableType");
        boolean ok = true;
        if (type != oldType) {
            StringBuilder message = new StringBuilder();
            if (type == Table.TableType.SESSION_TEMP || type == Table.TableType.TRANSACTION_TEMP) {
                ArrayList<FKConstraint> toRemove = new ArrayList<FKConstraint>();
                Constraint[] constraintArray = table.getConstraints();
                int n = 0;
                while (n < constraintArray.length) {
                    Constraint c = constraintArray[n];
                    if (c instanceof FKConstraint) {
                        toRemove.add((FKConstraint)c);
                    }
                    ++n;
                }
                if (toRemove.size() > 0) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(671), (String)UIArb.getString(117), null, (boolean)true)) {
                        for (FKConstraint fk : toRemove) {
                            table.removeConstraint((Constraint)fk);
                        }
                        table.setProperty("OracleIndexOrganizedTableProperties", null);
                        table.setProperty("OracleExternalTableProperties", null);
                    } else {
                        ok = false;
                    }
                }
                if (ok) {
                    this.nullProperties(table, "OracleStorageProperties", "OracleIndexOrganizedTableProperties", "OracleExternalTableProperties");
                }
            } else if (type == Table.TableType.EXTERNAL) {
                if (table.getConstraints().length > 0) {
                    if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(234), (String)UIArb.getString(117), null, (boolean)true)) {
                        table.setConstraints(null);
                    } else {
                        ok = false;
                    }
                }
                if (ok) {
                    this.nullProperties(table, "OracleStorageProperties", "OracleIndexOrganizedTableProperties");
                }
            } else if (oldType == Table.TableType.INDEX_ORGANIZED) {
                this.nullProperties(table, "OracleIndexOrganizedTableProperties");
            } else if (oldType == Table.TableType.EXTERNAL) {
                this.nullProperties(table, "OracleExternalTableProperties");
            }
            if (ok) {
                if (type == Table.TableType.INDEX_ORGANIZED) {
                    this.restoreProperties(table, "OracleIndexOrganizedTableProperties");
                }
                if (type == Table.TableType.EXTERNAL) {
                    this.restoreProperties(table, "OracleExternalTableProperties");
                } else if (type != Table.TableType.TRANSACTION_TEMP && type != Table.TableType.SESSION_TEMP) {
                    this.restoreProperties(table, "OracleStorageProperties");
                }
            }
        }
        return ok;
    }

    private void nullProperties(Table table, String ... keys) {
        String[] stringArray = keys;
        int n = 0;
        while (n < stringArray.length) {
            String key = stringArray[n];
            Object value = table.getProperty(key);
            if (value != null) {
                table.setProperty(key, null);
                this.m_cachedProps.put(key, value);
            }
            if (key == "OracleStorageProperties") {
                Column[] columnArray = table.getColumns();
                int n2 = 0;
                while (n2 < columnArray.length) {
                    Column column = columnArray[n2];
                    column.setProperty("OracleColumnProperties", null);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void restoreProperties(Table table, String key) {
        if (this.m_cachedProps.containsKey(key)) {
            table.setProperty(key, this.m_cachedProps.get(key));
        }
    }
}

