/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaObjectComboBox;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.IndexEditorPanel;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;

public class IndexInfoPanel
extends BaseInfoPanel
implements ActionListener,
PropertyChangeListener {
    private DBObjectProvider m_prov;
    private Schema[] m_existingSchemas;
    private Schema m_schema;
    private Index m_index;
    private BorderLayout m_layMain;
    private JMultiLineLabel m_lblTop;
    private JPanel m_pnlContext;
    private GridBagLayout m_layCenter;
    private JLabel m_lblOwner;
    private JLabel m_lblTable;
    private SchemaPicker m_cmbTableOwner;
    private SchemaObjectComboBox m_cmbTable;
    IndexEditorPanel m_pnlDetails;
    private boolean m_listening;

    private void $init$() {
        this.m_layMain = new BorderLayout();
        this.m_lblTop = new JMultiLineLabel();
        this.m_pnlContext = new JPanel();
        this.m_layCenter = new GridBagLayout();
        this.m_lblOwner = new JLabel();
        this.m_lblTable = new JLabel();
        this.m_cmbTableOwner = new SchemaPicker();
        this.m_cmbTable = new SchemaObjectComboBox();
        this.m_pnlDetails = new IndexEditorPanel(false);
    }

    public IndexInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getHeaderTitle() {
        return UIArb.getString(766);
    }

    public String getHeaderDescription() {
        return UIArb.getString(825);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_cmbTableOwner.setName("IndexInfoPanel.CMB_TABLE_OWNER");
        this.m_cmbTable.setName("IndexInfoPanel.CMB_TABLE");
        this.m_pnlContext.setName("IndexInfoPanel.PNL_CONTEXT");
        this.m_pnlDetails.setName("IndexInfoPanel.PNL_DETAILS");
        this.m_pnlDetails.setComponentNames(this.m_pnlDetails.getName());
        this.setTopLabel(UIArb.getString(303));
        this.m_lblTop.setPreferredAspectRatio(0.0f);
        this.m_lblTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        this.add((Component)this.m_lblTop, "North");
        this.m_pnlContext.setLayout(this.m_layCenter);
        this.setOwnerLabel(UIArb.getString(474));
        this.setTableLabel(UIArb.getString(464));
        this.m_pnlContext.add((Component)this.m_lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)this.m_cmbTableOwner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlContext.add((Component)this.m_lblTable, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.m_pnlContext.add((Component)this.m_cmbTable, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        JPanel pnlCenter = new JPanel(new GridBagLayout());
        pnlCenter.add((Component)this.m_pnlContext, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        pnlCenter.add((Component)this.m_pnlDetails, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(pnlCenter, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_index = (Index)dataContext.find("NewObject");
        Index origIndex = (Index)dataContext.get("OriginalObject");
        IndexInfoVerifier verifier = (IndexInfoVerifier)dataContext.find("IndexVerifier");
        this.m_existingSchemas = (Schema[])dataContext.find("SchemaList");
        this.m_schema = (Schema)dataContext.find("Schema");
        this.m_pnlDetails.init(this.m_prov, this.m_index.getTable(), verifier, origIndex != null ? origIndex.getTable() : null, true);
        this.init(this.m_index, verifier);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((Index)dataContext.find("OriginalObject"), (Index)dataContext.find("NewObject"));
        this.m_listening = false;
    }

    protected void init(Index index, IndexInfoVerifier verifier) {
        boolean newIndex = index.getColumnExpressions().length == 0;
        boolean canChangeTable = verifier == null || verifier.canAddIndexes();
        super.init(this.m_prov, verifier);
        this.m_pnlDetails.setNewIndex(newIndex);
        this.m_pnlDetails.setIndex(this.m_index);
        Table table = index.getTable();
        Schema schema = index.getSchema();
        if (schema == null) {
            schema = this.m_schema;
        }
        if (canChangeTable) {
            this.m_cmbTableOwner.init(this.m_prov, schema, this.m_existingSchemas);
            this.m_cmbTable.init(this.m_prov, schema, "TABLE", "MATERIALIZED VIEW");
            this.m_cmbTableOwner.addActionListener(this);
            this.m_cmbTable.addActionListener(this);
        } else {
            this.m_cmbTableOwner.initWithOneSchema(this.m_prov, schema);
            this.m_cmbTable.initWithOneItem((SchemaObject)table);
            this.m_cmbTable.setShowIcon(true);
        }
        if (table != null) {
            this.m_cmbTable.setSchemaObject((SchemaObject)table);
        }
        this.m_pnlDetails.setTable((Table)this.m_cmbTable.getSchemaObject());
        this.m_lblOwner.setEnabled(canChangeTable);
        this.m_cmbTableOwner.setEnabled(canChangeTable);
        this.m_cmbTableOwner.setEditable(false);
        this.m_lblTable.setEnabled(canChangeTable);
        this.m_cmbTable.setEnabled(canChangeTable);
        this.m_cmbTable.setEditable(false);
        this.m_pnlDetails.updateIndexData(index);
        this.m_pnlDetails.updateButtons();
        this.m_listening = true;
    }

    protected void commit(Index orig, Index model) throws TraversalException {
        Table table = (Table)this.m_cmbTable.getSchemaObject();
        if (table == null) {
            throw new TraversalException(UIArb.getString(435));
        }
        Table updatedTable = (Table)table.copyTo(null, true);
        if (orig != null) {
            Index utoi = updatedTable.getIndex(orig.getName());
            updatedTable.removeIndex(utoi);
        } else {
            Index utui = updatedTable.getIndex(model.getName());
            updatedTable.removeIndex(utui);
        }
        updatedTable.addIndex(model);
        this.m_pnlDetails.commit();
    }

    public void setOwnerLabel(String label) {
        ResourceUtils.resLabel((JLabel)this.m_lblOwner, (Component)this.m_cmbTableOwner, (String)label);
    }

    public void setTableLabel(String label) {
        ResourceUtils.resLabel((JLabel)this.m_lblTable, (Component)this.m_cmbTable, (String)label);
    }

    public void setTopLabel(String label) {
        this.m_lblTop.setText(label);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object source = ae.getSource();
            if (source == this.m_cmbTableOwner) {
                Schema schema = null;
                try {
                    schema = this.m_cmbTableOwner.getSchema();
                }
                catch (TraversalException te) {
                    // empty catch block
                }
                if (schema != this.m_schema) {
                    this.m_schema = schema;
                    this.m_cmbTable.init(this.m_prov, schema, "TABLE", "MATERIALIZED VIEW");
                }
            } else if (source == this.m_cmbTable) {
                this.updateTableName();
            }
        }
    }

    private void updateTableName() {
        Table table = (Table)this.m_cmbTable.getSchemaObject();
        if (table != null) {
            this.m_index.setTable(table);
            this.m_pnlDetails.setTable(table);
            this.m_pnlDetails.populateColumnExpressions(this.m_index);
            this.m_pnlDetails.populateColumns(this.m_index);
            this.m_pnlDetails.populateIndexType(this.m_index);
            this.m_pnlDetails.updateButtons();
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        this.updateTableName();
    }
}

