/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.IndexInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class IndexEditorPanel
extends JPanel
implements ActionListener,
ListDataListener,
FocusListener {
    private static final String[] INDEXTYPES = new String[]{"INDEXTYPE"};
    private ArrayList m_whatsHappening;
    private JLabel m_lblIndexName;
    JLabel m_lblIndexType;
    private JLabel m_lblColExprs;
    private DefaultListModel m_mdlColExprs;
    private JList m_lstColExprs;
    private DBObjectRenderer m_renderer;
    private ListButtons m_pnlOrderColExprs;
    private ListSelectionListener m_mdlColExprsListSelectionListener;
    private DefaultComboBoxModel m_mdlCmbColExpr;
    private JTextField m_fldName;
    private JLabel m_lblColExpr;
    private JComboBox m_cmbColExpr;
    private JComboBox m_cmbCol;
    private JLabel m_lblAsc;
    private JComboBox m_cmbAsc;
    private DBObjectProvider m_prov;
    private Table m_table;
    private Index m_oldIndex;
    private Index m_index;
    private boolean m_isNewIndex;
    private IndexInfoVerifier m_verifier;
    private JRadioButton m_rdbNormal;
    private JRadioButton m_rdbDomain;
    private JRadioButton m_rdbNonUnique;
    private JRadioButton m_rdbUnique;
    private JRadioButton m_rdbBitmap;
    private JPanel m_pnlNormal;
    private Map<String, List<Indextype>> m_indextypes;
    private JLabel m_lblCol;
    private JPanel m_pnlDomain;
    private JPanel m_pnlIndextype;
    private JLabel m_lblIndextypeName;
    private JComboBox m_cmbIndextype;
    private JLabel m_lblSchema;
    private SchemaPicker m_cmbIndextypeSchema;
    private JLabel m_lblIndextypeParameters;
    private JTextArea m_txtIndextypeParameters;
    private JLabel m_lblIndextypeStatus;
    private JTextField m_txtIndextypeStatus;
    int m_mdlColExprsIndex;
    boolean m_cmbColExprSaved;
    private GridBagConstraints m_gbcNormalDomain;
    private Table m_originalTable;
    private static String WH_ADD_A_COLUMN_EXPRESSION = "Add a column expression";
    private static String WH_REMOVE_A_COLUMN_EXPRESSION = "Remove a column expression";
    private static String WH_EDIT_COLUMN_EXPRESSION = "Edit column expression";
    private static String WH_CHANGE_COLEXPR_SELECTION = "Change column expression selection";
    private static String WH_SET_ASC_DESC = "Set the column expression order";

    private void $init$() {
        this.m_whatsHappening = new ArrayList();
        this.m_lblIndexName = new JLabel();
        this.m_lblIndexType = new JLabel(UIArb.getString(815));
        this.m_lblColExprs = new JLabel();
        this.m_mdlColExprs = new DefaultListModel();
        this.m_lstColExprs = new JList(this.m_mdlColExprs);
        this.m_renderer = new DBObjectRenderer();
        this.m_pnlOrderColExprs = new ListButtons(this.m_lstColExprs, new ButtonsHelper(null));
        this.m_mdlColExprsListSelectionListener = new 1();
        this.m_mdlCmbColExpr = new DefaultComboBoxModel();
        this.m_lblColExpr = new JLabel();
        this.m_cmbColExpr = new JComboBox();
        this.m_cmbCol = new JComboBox();
        this.m_lblAsc = new JLabel();
        this.m_cmbAsc = new JComboBox();
        this.m_rdbNormal = new JRadioButton();
        this.m_rdbDomain = new JRadioButton();
        this.m_rdbNonUnique = new JRadioButton();
        this.m_rdbUnique = new JRadioButton();
        this.m_rdbBitmap = new JRadioButton();
        this.m_indextypes = new HashMap<String, List<Indextype>>();
        this.m_lblCol = new JLabel();
        this.m_lblIndextypeName = new JLabel();
        this.m_cmbIndextype = new JComboBox();
        this.m_lblSchema = new JLabel();
        this.m_cmbIndextypeSchema = new SchemaPicker();
        this.m_lblIndextypeParameters = new JLabel();
        this.m_txtIndextypeParameters = new JTextArea();
        this.m_lblIndextypeStatus = new JLabel();
        this.m_txtIndextypeStatus = new JTextField();
        this.m_mdlColExprsIndex = 0;
        this.m_cmbColExprSaved = true;
    }

    public IndexEditorPanel() {
        this(true);
    }

    public IndexEditorPanel(boolean incNameField) {
        this.$init$();
        ResourceUtils.resButton((AbstractButton)this.m_rdbNormal, (String)UIArb.getString(580));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomain, (String)UIArb.getString(20));
        ButtonGroup bgNormal = new ButtonGroup();
        bgNormal.add(this.m_rdbNormal);
        bgNormal.add(this.m_rdbDomain);
        this.m_rdbNormal.addActionListener(this);
        this.m_rdbDomain.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_rdbNonUnique, (String)UIArb.getString(607));
        ResourceUtils.resButton((AbstractButton)this.m_rdbUnique, (String)UIArb.getString(733));
        ResourceUtils.resButton((AbstractButton)this.m_rdbBitmap, (String)UIArb.getString(704));
        ButtonGroup bgUniqueness = new ButtonGroup();
        bgUniqueness.add(this.m_rdbNonUnique);
        bgUniqueness.add(this.m_rdbUnique);
        bgUniqueness.add(this.m_rdbBitmap);
        this.m_rdbNonUnique.setSelected(true);
        this.m_rdbNonUnique.addActionListener(this);
        this.m_rdbUnique.addActionListener(this);
        this.m_rdbBitmap.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblColExprs, (Component)this.m_lstColExprs, (String)UIArb.getString(83));
        JScrollPane scrColExprs = new JScrollPane();
        scrColExprs.setVerticalScrollBarPolicy(22);
        this.m_lstColExprs.setSelectionMode(0);
        this.m_lstColExprs.setCellRenderer(this.m_renderer);
        if (incNameField) {
            this.m_fldName = new JTextField();
            ResourceUtils.resLabel((JLabel)this.m_lblIndexName, (Component)this.m_fldName, (String)UIArb.getString(79));
            this.m_fldName.setColumns(30);
        }
        ResourceUtils.resLabel((JLabel)this.m_lblColExpr, (Component)this.m_cmbColExpr, (String)UIArb.getString(103));
        this.m_cmbColExpr.setModel(this.m_mdlCmbColExpr);
        this.m_cmbColExpr.setEditable(true);
        ResourceUtils.resLabel((JLabel)this.m_lblAsc, (Component)this.m_cmbAsc, (String)UIArb.getString(181));
        scrColExprs.getViewport().add((Component)this.m_lstColExprs, null);
        JPanel pnlColExprs = new JPanel(new GridBagLayout());
        pnlColExprs.add((Component)this.m_lblColExprs, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlColExprs.add((Component)scrColExprs, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        pnlColExprs.add((Component)this.m_pnlOrderColExprs, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlColExprs.add(Box.createHorizontalStrut(150), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel pnlColExpr = new JPanel(new GridBagLayout());
        pnlColExpr.add((Component)this.m_lblColExpr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        pnlColExpr.add((Component)this.m_cmbColExpr, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        pnlColExpr.add((Component)this.m_lblAsc, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        pnlColExpr.add((Component)this.m_cmbAsc, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.m_pnlNormal = new JPanel(new GridBagLayout());
        this.m_pnlNormal.add((Component)this.m_rdbNonUnique, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbUnique, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 15), 0, 0));
        this.m_pnlNormal.add((Component)this.m_rdbBitmap, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlNormal.add((Component)pnlColExprs, new GridBagConstraints(0, 2, 0, 1, 2.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlNormal.add((Component)pnlColExpr, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.m_pnlDomain = new JPanel(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_lblCol, (Component)this.m_cmbCol, (String)UIArb.getString(720));
        this.m_pnlDomain.add((Component)this.m_lblCol, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlDomain.add((Component)this.m_cmbCol, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.m_pnlIndextype = new JPanel(new GridBagLayout());
        this.m_pnlIndextype.setBorder(BorderFactory.createTitledBorder(UIArb.getString(248)));
        ResourceUtils.resLabel((JLabel)this.m_lblSchema, (Component)this.m_cmbIndextypeSchema, (String)UIArb.getString(136));
        this.m_pnlIndextype.add((Component)this.m_lblSchema, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlIndextype.add((Component)this.m_cmbIndextypeSchema, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_lblIndextypeName, (Component)this.m_cmbIndextype, (String)UIArb.getString(223));
        this.m_pnlIndextype.add((Component)this.m_lblIndextypeName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 12), 0, 0));
        this.m_pnlIndextype.add((Component)this.m_cmbIndextype, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_lblIndextypeParameters, (Component)this.m_txtIndextypeParameters, (String)UIArb.getString(68));
        this.m_pnlIndextype.add((Component)this.m_lblIndextypeParameters, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlIndextype.add((Component)new JScrollPane(this.m_txtIndextypeParameters), new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlDomain.add((Component)this.m_pnlIndextype, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlDomain.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        if (incNameField) {
            this.add((Component)this.m_lblIndexName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
            this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0));
        }
        this.add((Component)this.m_lblIndexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.m_rdbNormal, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_rdbDomain, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_gbcNormalDomain = new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        this.setComponentNames("IndexEditorPanel");
    }

    protected void setComponentNames(String prefix) {
        prefix = ModelUtil.hasLength((String)prefix) ? prefix + '.' : "";
        this.m_rdbNormal.setName(prefix + "RDB_NORMAL_IDX");
        this.m_rdbDomain.setName(prefix + "RDB_DOMAIN_IDX");
        this.m_rdbBitmap.setName(prefix + "RDB_BITMAP");
        this.m_rdbUnique.setName(prefix + "RDB_UNIQUE");
        this.m_rdbNonUnique.setName(prefix + "RDB_NON_UNIQUE");
        this.m_lstColExprs.setName(prefix + "LST_COL_EXPRS");
        this.m_txtIndextypeParameters.setName(prefix + "IDXTYPE_PARAMETERS");
        this.m_txtIndextypeStatus.setName(prefix + "TXT_IDXTYPE_STATUS");
        this.m_cmbAsc.setName(prefix + "CMB_ASC");
        this.m_cmbCol.setName(prefix + "CMB_COLUMN");
        this.m_cmbColExpr.setName(prefix + "CMB_COL_EXPR");
        this.m_cmbIndextype.setName(prefix + "CMB_IDX_TYPE");
        this.m_pnlDomain.setName(prefix + "PNL_DOMAIN_IDX");
        this.m_pnlIndextype.setName(prefix + "PNL_IDXTYPE");
        this.m_pnlNormal.setName(prefix + "PNL_NORMAL_IDX");
        this.m_pnlOrderColExprs.setName(prefix + "PNL_ORDER_COL_EXPRS");
        this.m_pnlOrderColExprs.setButtonNames(this.m_pnlOrderColExprs.getName());
        if (this.m_fldName != null) {
            this.m_fldName.setName(prefix + "FLD_INDEX_NAME");
        }
    }

    protected void init(DBObjectProvider prov, Table table, IndexInfoVerifier verifier, Table originalTable, boolean haveIndex) {
        this.m_prov = prov;
        this.m_table = table;
        this.m_verifier = verifier;
        this.m_originalTable = originalTable;
        this.m_index = null;
        this.m_renderer.setProvider(prov);
        this.m_lstColExprs.getSelectionModel().removeListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_mdlColExprs.removeListDataListener(this);
        this.m_mdlColExprs.removeAllElements();
        this.m_mdlCmbColExpr.removeAllElements();
        this.m_mdlColExprs.addListDataListener(this);
        this.m_cmbColExpr.getEditor().getEditorComponent().removeFocusListener(this);
        this.m_cmbColExpr.getEditor().getEditorComponent().addFocusListener(this);
        this.m_cmbAsc.removeActionListener(this);
        this.m_cmbAsc.addActionListener(this);
        this.m_cmbAsc.setEditable(false);
        if (this.m_cmbAsc.getItemCount() == 0) {
            this.m_cmbAsc.addItem(null);
            this.m_cmbAsc.addItem("ASC");
            this.m_cmbAsc.addItem("DESC");
        }
        this.m_lstColExprs.getSelectionModel().addListSelectionListener(this.m_mdlColExprsListSelectionListener);
        this.m_cmbCol.removeActionListener(this);
        this.m_cmbCol.addActionListener(this);
        this.m_cmbCol.setEditable(false);
        this.m_cmbIndextype.removeActionListener(this);
        this.m_cmbIndextype.addActionListener(this);
        this.m_cmbIndextype.setEditable(this.m_prov instanceof Database ^ true);
        this.m_cmbIndextypeSchema.removeActionListener(this);
        this.m_cmbIndextypeSchema.addActionListener(this);
        this.m_cmbIndextypeSchema.setEditable(false);
        this.updateTableColumns(table);
        this.updateIndexData(null);
        this.setColExprControls(null);
        this.updateButtons();
        this.updateListContents(this.m_mdlColExprs);
        this.setFieldEnable(verifier, null, haveIndex);
    }

    public void setFieldEnable(IndexInfoVerifier verifier, Index index, boolean haveIndex) {
        if (verifier != null) {
            boolean haveColExpr;
            boolean bl = haveColExpr = this.m_mdlColExprs.size() > 0;
            if (this.m_fldName != null) {
                this.m_lblIndexName.setEnabled(haveIndex && verifier.canRenameIndex(index));
                this.m_fldName.setEnabled(haveIndex && verifier.canRenameIndex(index));
            }
            this.m_rdbDomain.setEnabled(haveIndex && verifier.canEditDomain(index));
            this.m_rdbNormal.setEnabled(haveIndex && verifier.canEditDomain(index));
            this.m_rdbBitmap.setEnabled(haveIndex && verifier.canEditUniqueness(index));
            this.m_rdbNonUnique.setEnabled(haveIndex && verifier.canEditUniqueness(index));
            this.m_rdbUnique.setEnabled(haveIndex && verifier.canEditUniqueness(index));
            this.m_lblColExprs.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_pnlOrderColExprs.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_lblColExpr.setEnabled(haveColExpr && verifier.canEditIndex(index));
            this.m_cmbColExpr.setEditable(haveColExpr && verifier.canEditIndex(index));
            this.m_cmbColExpr.setEnabled(haveColExpr && verifier.canEditIndex(index));
            this.m_lblAsc.setEnabled(haveIndex && haveColExpr && verifier.canEditIndex(index) && !this.m_rdbBitmap.isSelected());
            this.m_cmbAsc.setEnabled(haveIndex && haveColExpr && verifier.canEditIndex(index) && !this.m_rdbBitmap.isSelected());
            this.m_lblCol.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_cmbCol.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_lblIndexType.setEnabled(haveIndex && verifier.canEditDomain(index));
            this.m_lblIndextypeName.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_cmbIndextype.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_lblIndextypeParameters.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_txtIndextypeParameters.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_lblSchema.setEnabled(haveIndex && verifier.canEditIndex(index));
            this.m_cmbIndextypeSchema.setEnabled(haveIndex && verifier.canEditIndex(index));
        }
    }

    private void updateTableColumns(Table table) {
        this.m_mdlCmbColExpr.removeAllElements();
        if (table != null) {
            Column[] columnArray = table.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column col = columnArray[n];
                String colName = col.getName();
                if (col instanceof ViewColumn && colName.contains(".")) {
                    colName = colName.substring(colName.indexOf(".") + 1);
                }
                this.m_mdlCmbColExpr.addElement(this.m_prov.getExternalName(colName, "COLUMN"));
                ++n;
            }
        }
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public void commit() throws TraversalException {
        if (this.m_index != null) {
            TraversalException x;
            if (!this.m_cmbColExprSaved) {
                this.saveCmbColExpr();
            }
            if ((x = this.saveIndexAttributes()) != null) {
                throw x;
            }
            if (this.m_fldName != null) {
                this.m_index.setName(this.m_prov.getInternalName(this.m_fldName.getText()));
            }
            if (this.m_index.getIndexType() != Index.IndexType.DOMAIN) {
                this.m_index.setDomainIndextype(null);
                this.m_index.setDomainIndextypeOpStatus(null);
                this.m_index.setDomainIndextypeParameters(null);
            }
            if (this.m_verifier != null) {
                this.m_verifier.verifyIndex(this.m_oldIndex, this.m_index);
            }
        }
    }

    private TraversalException saveIndexAttributes() {
        if (this.m_index != null) {
            IndexObject[] colExprs = null;
            if (this.m_rdbNormal.isSelected()) {
                this.m_index.setIndexType(Index.IndexType.NORMAL);
                if (this.m_rdbUnique.isSelected()) {
                    this.m_index.setIndexType(Index.IndexType.UNIQUE);
                } else if (this.m_rdbBitmap.isSelected()) {
                    this.m_index.setIndexType(Index.IndexType.BITMAP);
                }
                colExprs = new IndexObject[this.m_mdlColExprs.size()];
                int i = 0;
                while (i < this.m_mdlColExprs.size()) {
                    colExprs[i] = (IndexObject)this.m_mdlColExprs.getElementAt(i);
                    ++i;
                }
            } else {
                this.m_index.setIndexType(Index.IndexType.DOMAIN);
                this.m_index.setDomainIndextypeOpStatus("VALID");
                String externalName = (String)this.m_cmbIndextype.getSelectedItem();
                try {
                    this.m_prov.validateName("INDEXTYPE", externalName);
                }
                catch (InvalidNameException e) {
                    TraversalException traversalException = new TraversalException(e.getMessage());
                    return traversalException;
                }
                String internalName = this.m_prov.getInternalName(externalName);
                Schema schema = null;
                try {
                    schema = this.m_cmbIndextypeSchema.getSchema();
                }
                catch (TraversalException e) {
                    TraversalException traversalException = e;
                    return traversalException;
                }
                Indextype indextype = this.findIndextype(schema, internalName);
                if (indextype == null && this.m_cmbIndextype.isEditable()) {
                    indextype = new Indextype(internalName, schema);
                    indextype.setID((DBObjectID)new ReferenceID((DBObject)indextype));
                }
                if (indextype == null) {
                    return new TraversalException(UIArb.getString(752), this.m_index.getName());
                }
                this.m_index.setDomainIndextype(indextype.getID());
                String parameters = this.m_txtIndextypeParameters.getText().trim();
                this.m_index.setDomainIndextypeParameters(ModelUtil.hasLength((String)parameters) ? parameters : null);
                SimpleSQLFragment ssf = new SimpleSQLFragment((String)this.m_cmbCol.getSelectedItem());
                colExprs = new IndexObject[]{new IndexObject((SQLFragment)ssf)};
            }
            this.m_index.setColumnExpressions(colExprs);
        }
        return null;
    }

    public void setIndex(Index index) {
        this.m_index = index;
        if (index != null) {
            this.populateName(index);
            this.populateIndexType(index);
        }
    }

    public void setTable(Table table) {
        if (table != this.m_table) {
            this.m_table = table;
            this.updateTableColumns(table);
        }
    }

    public Index getIndex() {
        return this.m_index;
    }

    public void updateIndexData(Index index) {
        this.m_index = index;
        if (index == null) {
            if (this.m_fldName != null) {
                this.m_fldName.setText("");
                this.m_fldName.setEnabled(false);
            }
            this.m_oldIndex = null;
        } else {
            this.m_oldIndex = this.m_isNewIndex ? null : (Index)index.copyTo(null);
            this.populateName(index);
        }
        this.populateIndexType(this.m_index);
        this.populateUniqueness(this.m_index);
        this.populateColumnExpressions(this.m_index);
        this.populateColumns(this.m_index);
        if (this.m_fldName != null) {
            this.m_fldName.requestFocusInWindow();
        }
    }

    public void setNewIndex(boolean val) {
        this.m_isNewIndex = val;
    }

    private void switchToNormalIndex() {
        this.remove(this.m_pnlDomain);
        this.add((Component)this.m_pnlNormal, this.m_gbcNormalDomain);
        String column = (String)this.m_cmbCol.getSelectedItem();
        if (ModelUtil.hasLength((String)column)) {
            this.m_cmbColExpr.setSelectedItem(column);
        }
        this.validate();
        this.repaint();
    }

    private void switchToDomainIndex() {
        this.remove(this.m_pnlNormal);
        this.add((Component)this.m_pnlDomain, this.m_gbcNormalDomain);
        this.populateColumns(null);
        String colexpr = (String)this.m_cmbColExpr.getSelectedItem();
        if (ModelUtil.hasLength((String)colexpr)) {
            try {
                ArrayList colNames = new ArrayList(ParserUtils.getColumnNames((String)colexpr, (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC));
                if (colNames.size() > 0) {
                    this.m_cmbCol.setSelectedItem(((String[])colNames.get(0))[0]);
                }
            }
            catch (SQLQueryException e) {
                DBLog.getLogger().warning(e.getMessage());
            }
        }
        this.populateDomain(this.m_index);
        this.validate();
        this.repaint();
    }

    private void switchIndexType() {
        if (this.m_rdbNormal.isSelected()) {
            this.switchToNormalIndex();
        } else if (this.m_rdbDomain.isSelected()) {
            this.switchToDomainIndex();
        }
    }

    private void switchUnique() {
        if (this.m_rdbBitmap.isSelected()) {
            this.m_cmbAsc.setSelectedItem(null);
            this.m_cmbAsc.setEnabled(false);
        } else {
            this.m_cmbAsc.setEnabled(this.m_verifier.canEditIndex(null));
        }
    }

    private void setColExprControls(IndexObject colExpr) {
        if (colExpr == null) {
            this.m_cmbColExpr.setSelectedItem("");
            this.m_lblColExpr.setEnabled(false);
            this.m_cmbColExpr.setEnabled(false);
            this.m_cmbAsc.setSelectedItem(null);
            this.m_lblAsc.setEnabled(false);
            this.m_cmbAsc.setEnabled(false);
        } else {
            SQLFragment expr = colExpr.getExpression();
            if (expr instanceof ColumnUsage) {
                ((ColumnUsage)expr).setProvider(this.m_prov);
            }
            this.m_cmbColExpr.setSelectedItem(expr.getSQLText());
            this.m_cmbAsc.removeActionListener(this);
            this.m_cmbAsc.setSelectedItem(colExpr.getOrder());
            this.m_cmbAsc.addActionListener(this);
            boolean colExprEnable = this.m_verifier == null || this.m_verifier.canEditIndex(null);
            this.m_lblColExpr.setEnabled(colExprEnable);
            this.m_cmbColExpr.setEnabled(colExprEnable);
            boolean ascEnable = (this.m_verifier == null || this.m_verifier.canEditIndex(null)) && !this.m_rdbBitmap.isSelected();
            this.m_lblAsc.setEnabled(ascEnable);
            this.m_cmbAsc.setEnabled(ascEnable);
        }
    }

    private void updateSelColExpr(Object sel) {
        if (sel != null) {
            this.m_lstColExprs.setSelectedValue(sel, true);
            this.setColExprControls((IndexObject)sel);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        this.m_pnlOrderColExprs.enableButtons();
    }

    public void populateName(Index index) {
        if (this.m_fldName != null) {
            if (index != null) {
                this.m_fldName.setText(this.m_prov.getExternalName(index.getName(), "INDEX"));
            }
            boolean canChangeName = this.m_isNewIndex || this.m_verifier == null || this.m_verifier.canRenameIndex(index);
            this.m_fldName.setEnabled(canChangeName);
            this.m_fldName.setEditable(canChangeName);
        }
    }

    public void populateIndexType(Index index) {
        if (index == null) {
            this.m_rdbNormal.setSelected(true);
            this.m_rdbNormal.setEnabled(false);
            this.m_rdbDomain.setEnabled(false);
        } else {
            this.m_rdbNormal.setSelected(Index.IndexType.DOMAIN != index.getIndexType());
            this.m_lblIndexType.setEnabled(this.m_verifier != null && this.m_verifier.canEditDomain(index));
            this.m_rdbDomain.setSelected(Index.IndexType.DOMAIN == index.getIndexType());
            this.m_rdbNormal.setEnabled(this.m_verifier != index && this.m_verifier.canEditDomain(index));
            this.m_rdbDomain.setEnabled(this.m_verifier != index && this.m_verifier.canEditDomain(index));
        }
        this.switchIndexType();
    }

    public void populateUniqueness(Index index) {
        if (index == null) {
            this.m_rdbNonUnique.setSelected(true);
            this.m_rdbNonUnique.setEnabled(false);
            this.m_rdbUnique.setEnabled(false);
            this.m_rdbBitmap.setEnabled(false);
        } else {
            this.m_rdbNonUnique.setSelected(Index.IndexType.NORMAL == index.getIndexType());
            this.m_rdbUnique.setSelected(Index.IndexType.UNIQUE == index.getIndexType());
            this.m_rdbBitmap.setSelected(Index.IndexType.BITMAP == index.getIndexType());
            this.m_rdbNonUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
            this.m_rdbUnique.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
            this.m_rdbBitmap.setEnabled(this.m_verifier != null && this.m_verifier.canEditUniqueness(null));
        }
    }

    public void populateColumns(Index index) {
        this.m_cmbCol.removeAllItems();
        if (this.m_table != null) {
            IndexObject[] colExprs;
            Column[] cols = this.m_table.getColumns();
            int i = 0;
            while (i < cols.length) {
                String colName = this.m_prov.getExternalName(cols[i].getName(), "COLUMN");
                this.m_cmbCol.addItem(colName);
                ++i;
            }
            if (index != null && (colExprs = index.getColumnExpressions()) != null && colExprs.length > 0) {
                IndexObject colExpr = colExprs[0];
                SQLFragment expr = colExpr.getExpression();
                if (expr instanceof ColumnUsage) {
                    ((ColumnUsage)expr).setProvider(this.m_prov);
                }
                this.m_cmbCol.setSelectedItem(expr.getSQLText());
            }
        }
        boolean colEnable = this.m_index != null && (this.m_verifier == null || this.m_verifier.canEditIndex(null));
        this.m_lblCol.setEnabled(colEnable);
        this.m_cmbCol.setEnabled(colEnable);
    }

    public void populateDomain(Index index) {
        if (index != null) {
            DBObjectID indextypeID = index != null ? index.getDomainIndextype() : null;
            Indextype indextype = null;
            if (indextypeID != null) {
                if (indextypeID instanceof ReferenceID) {
                    ReferenceID id = (ReferenceID)indextypeID;
                    indextype = new Indextype(id.getName(), new Schema(id.getSchemaName()));
                    indextype.setID((DBObjectID)id);
                } else {
                    try {
                        indextype = (Indextype)indextypeID.resolveID();
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
            Schema schema = indextype != null ? indextype.getSchema() : (index == null ? null : index.getSchema());
            this.m_cmbIndextypeSchema.removeActionListener(this);
            this.m_cmbIndextypeSchema.init(this.m_prov, schema);
            this.m_cmbIndextypeSchema.addActionListener(this);
            try {
                schema = this.m_cmbIndextypeSchema.getSchema();
            }
            catch (TraversalException e) {
                // empty catch block
            }
            if (schema != null) {
                Index originalIndex;
                this.populateIndextypes(schema);
                if (indextype != null) {
                    Indextype found = this.findIndextype(schema, indextype.getName());
                    if (found == null) {
                        this.addIndextype(schema, indextype);
                        found = indextype;
                    }
                    this.m_cmbIndextype.setSelectedItem(this.m_prov.getExternalName(indextype.getName(), "INDEXTYPE"));
                    if (index != null) {
                        this.m_txtIndextypeParameters.setText(index.getDomainIndextypeParameters());
                    }
                }
                Index index2 = originalIndex = this.m_originalTable != null && index != null ? this.m_originalTable.getIndex(index.getName()) : null;
                if (originalIndex != null && this.m_prov instanceof Database) {
                    ResourceUtils.resLabel((JLabel)this.m_lblIndextypeStatus, (Component)this.m_txtIndextypeStatus, (String)UIArb.getString(469));
                    this.m_pnlIndextype.add((Component)this.m_lblIndextypeStatus, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
                    this.m_pnlIndextype.add((Component)this.m_txtIndextypeStatus, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
                    this.m_lblIndextypeStatus.setEnabled(true);
                    this.m_txtIndextypeStatus.setEnabled(true);
                    this.m_txtIndextypeStatus.setEditable(false);
                    this.m_txtIndextypeStatus.setText(originalIndex.getDomainIndextypeOpStatus());
                }
            }
        }
    }

    private void populateIndextypes(Schema schema) {
        this.m_cmbIndextype.removeAllItems();
        List<Indextype> indextypes = this.m_indextypes.get(schema.getName());
        if (indextypes == null) {
            try {
                SchemaObject[] schemaObjectArray = this.m_prov.listObjects(INDEXTYPES, schema);
                int n = 0;
                while (n < schemaObjectArray.length) {
                    SchemaObject it = schemaObjectArray[n];
                    this.addIndextype(schema, (Indextype)it);
                    ++n;
                }
            }
            catch (DBException e) {}
        } else {
            for (Indextype it : indextypes) {
                this.m_cmbIndextype.addItem(this.m_prov.getExternalName(it.getName(), "INDEXTYPE"));
            }
        }
    }

    private void addIndextype(Schema schema, Indextype it) {
        List<Indextype> indextypes = this.m_indextypes.get(schema.getName());
        if (indextypes == null) {
            indextypes = new ArrayList<Indextype>();
            this.m_indextypes.put(schema.getName(), indextypes);
        }
        indextypes.add(it);
        this.m_cmbIndextype.addItem(this.m_prov.getExternalName(it.getName(), "INDEXTYPE"));
    }

    private Indextype findIndextype(Schema schema, String internalName) {
        Indextype found = null;
        List<Indextype> indextypes = this.m_indextypes.get(schema.getName());
        if (indextypes != null && ModelUtil.hasLength((String)internalName)) {
            for (Indextype it : indextypes) {
                if (!internalName.equals(it.getName())) continue;
                found = it;
                break;
            }
        }
        return found;
    }

    public void populateColumnExpressions(Index index) {
        this.m_cmbColExpr.setSelectedItem(null);
        this.m_cmbAsc.setSelectedIndex(0);
        this.m_mdlColExprs.removeAllElements();
        if (index != null) {
            IndexObject[] colExprs = index.getColumnExpressions();
            int numExpr = colExprs.length;
            IndexObject[] indexObjectArray = colExprs;
            int n = 0;
            while (n < indexObjectArray.length) {
                IndexObject io = indexObjectArray[n];
                if (io.getExpression() instanceof ColumnUsage) {
                    ColumnUsage cu = (ColumnUsage)io.getExpression();
                    Column c = null;
                    try {
                        c = (Column)cu.getObjectID().resolveID();
                    }
                    catch (DBException e) {
                        c = null;
                    }
                    if (c != null && c.getParent() != null && !c.getParent().equals(index.getTable())) {
                        Table t1 = (Table)c.getParent();
                        Table t2 = (Table)index.getParent();
                        if (t1 == null || t2 == null) {
                            numExpr = 0;
                            break;
                        }
                        if (!t1.getName().equals(t2.getName()) || !t1.getSchema().equals((Object)t2.getSchema())) {
                            numExpr = 0;
                            break;
                        }
                    }
                }
                ++n;
            }
            if (numExpr == 0) {
                colExprs = this.getDefaultExpressions(index);
            }
            int i = 0;
            while (i < colExprs.length) {
                this.m_mdlColExprs.addElement(colExprs[i]);
                SQLFragment expr = colExprs[i].getExpression();
                if (expr instanceof ColumnUsage) {
                    ((ColumnUsage)expr).setProvider(this.m_prov);
                }
                ++i;
            }
            if (colExprs != null && colExprs.length > 0) {
                this.m_lstColExprs.setSelectedIndex(0);
                this.setColExprControls(colExprs[0]);
            }
        }
    }

    private IndexObject[] getDefaultExpressions(Index index) {
        IndexObject[] empty = new IndexObject[]{};
        String origName = index.getName();
        String newName = null;
        int i = 0;
        while (true) {
            newName = "INDEX" + i++;
            try {
                this.m_prov.validateUniqueName("INDEX", (DBObject)index.getSchema(), newName);
                index.setName(newName);
            }
            catch (NameInUseException e) {
                continue;
            }
            break;
        }
        IndexObject[] deflt = this.getDefaultExpressions(index, empty);
        index.setName(origName);
        return deflt == null ? empty : deflt;
    }

    private IndexObject[] getDefaultExpressions(Index index, IndexObject[] parent) {
        if (index == null || index.getTable() == null) {
            return null;
        }
        IndexObject[] retval = new IndexObject[parent.length + 1];
        int i = 0;
        while (i < parent.length) {
            retval[i] = parent[i];
            ++i;
        }
        boolean valid = false;
        Table tab = index.getTable();
        DBObjectID lastID = null;
        if (parent.length > 0) {
            lastID = ((ColumnUsage)parent[parent.length - 1].getExpression()).getObjectID();
        }
        Column[] columnArray = tab.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            Column c = columnArray[n];
            if (lastID == null) {
                IndexObject io;
                retval[retval.length - 1] = io = new IndexObject((SQLFragment)new ColumnUsage(c.getID()));
                index.setColumnExpressions(retval);
                try {
                    try {
                        this.m_verifier.verifyIndex(null, index);
                        valid = true;
                        index.setColumnExpressions(null);
                        break;
                    }
                    catch (TraversalException e) {
                        boolean blah = false;
                    }
                }
                catch (Throwable throwable) {
                    index.setColumnExpressions(null);
                    throw throwable;
                }
                index.setColumnExpressions(null);
            } else if (lastID.equals(c.getID())) {
                lastID = null;
            }
            ++n;
        }
        if (valid) {
            return retval;
        }
        IndexObject[] parent2 = new IndexObject[parent.length + 1];
        int i2 = 0;
        while (i2 < parent.length) {
            parent2[i2] = parent[i2];
            ++i2;
        }
        lastID = null;
        if (parent.length > 0) {
            lastID = ((ColumnUsage)parent[parent.length - 1].getExpression()).getObjectID();
        }
        Column[] columnArray2 = tab.getColumns();
        int n2 = 0;
        while (n2 < columnArray2.length) {
            Column c = columnArray2[n2];
            if (lastID == null) {
                IndexObject io;
                parent2[parent2.length - 1] = io = new IndexObject((SQLFragment)new ColumnUsage(c.getID()));
                retval = this.getDefaultExpressions(index, parent2);
                if (retval != null) {
                    return retval;
                }
            } else if (lastID.equals(c.getID())) {
                lastID = null;
            }
            ++n2;
        }
        return null;
    }

    private void updateListContents(Object o) {
        boolean haveColExpr = false;
        if (this.m_mdlColExprs == o) {
            haveColExpr = this.m_mdlColExprs.getSize() > 0;
            this.m_lstColExprs.setFocusable(haveColExpr);
            boolean colExprEnable = haveColExpr && (this.m_verifier == null || this.m_verifier.canEditIndex(null));
            this.m_lblColExpr.setEnabled(colExprEnable);
            this.m_cmbColExpr.setEditable(colExprEnable);
            this.m_cmbColExpr.setEnabled(colExprEnable);
        }
    }

    private void swap(int i1, int i2) {
        Object o1 = this.m_mdlColExprs.getElementAt(i1);
        Object o2 = this.m_mdlColExprs.getElementAt(i2);
        this.m_mdlColExprs.setElementAt(o1, i2);
        this.m_mdlColExprs.setElementAt(o2, i1);
    }

    private void updateColExprModel() {
        this.logActionStart(WH_EDIT_COLUMN_EXPRESSION, true);
        String colExpr = (String)this.m_cmbColExpr.getSelectedItem();
        String ascDesc = (String)this.m_cmbAsc.getSelectedItem();
        int colExprIndex = this.m_lstColExprs.getSelectedIndex();
        if (colExprIndex >= 0) {
            SQLFragment usage = OracleIndexBuilder.createExpression((String)colExpr, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
            IndexObject io = new IndexObject(usage, ascDesc);
            this.m_mdlColExprs.setElementAt(io, colExprIndex);
        }
        this.m_lstColExprs.repaint();
        this.logActionEnd(WH_EDIT_COLUMN_EXPRESSION);
    }

    public void logActionStart(String action, boolean multipleActionsOK) {
        if (multipleActionsOK || this.m_whatsHappening.size() != 0) {
            // empty if block
        }
        this.m_whatsHappening.add(0, action);
    }

    public void logActionEnd(String action) {
        if (this.m_whatsHappening.size() == 0) {
            // empty if block
        }
        this.m_whatsHappening.remove(0);
    }

    public int logSize() {
        return this.m_whatsHappening.size();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.m_rdbNonUnique || src == this.m_rdbUnique || src == this.m_rdbBitmap) {
            this.switchUnique();
            this.saveIndexAttributes();
            this.updateButtons();
        } else if (src == this.m_rdbNormal || src == this.m_rdbDomain) {
            this.switchIndexType();
        } else if (src != this.m_cmbCol) {
            if (src == this.m_cmbAsc) {
                this.logActionStart(WH_SET_ASC_DESC, true);
                this.updateColExprModel();
                this.logActionEnd(WH_SET_ASC_DESC);
            } else if (src == this.m_mdlColExprs) {
                this.saveIndexAttributes();
                this.updateButtons();
            } else if (src == this.m_cmbIndextypeSchema) {
                try {
                    this.populateIndextypes(this.m_cmbIndextypeSchema.getSchema());
                }
                catch (TraversalException e) {
                    String msg = e.getMessage();
                }
            }
        }
    }

    public void intervalAdded(ListDataEvent p0) {
        this.updateListContents(p0.getSource());
    }

    public void intervalRemoved(ListDataEvent p0) {
        this.updateListContents(p0.getSource());
    }

    public void contentsChanged(ListDataEvent p0) {
        this.updateListContents(p0.getSource());
    }

    public void focusGained(FocusEvent fe) {
        this.m_mdlColExprsIndex = this.m_lstColExprs.getSelectedIndex();
        this.m_cmbColExprSaved = false;
    }

    public void focusLost(FocusEvent fe) {
        if (!this.m_cmbColExprSaved) {
            this.saveCmbColExpr();
        }
        int i = this.m_lstColExprs.getSelectedIndex();
        IndexObject io = (IndexObject)this.m_mdlColExprs.getElementAt(i);
        this.m_cmbColExpr.setSelectedItem(io.getExpression().getSQLText());
        this.m_cmbAsc.removeActionListener(this);
        this.m_cmbAsc.setSelectedItem(io.getOrder());
        this.m_cmbAsc.addActionListener(this);
        this.updateColExprModel();
    }

    private void saveCmbColExpr() {
        String colExpr = (String)this.m_cmbColExpr.getEditor().getItem();
        String ascDesc = (String)this.m_cmbAsc.getSelectedItem();
        SQLFragment usage = OracleIndexBuilder.createExpression((String)colExpr, (Relation)this.m_table, (DBObjectProvider)this.m_prov);
        IndexObject io = new IndexObject(usage, ascDesc);
        this.m_mdlColExprs.set(this.m_mdlColExprsIndex, io);
        this.m_cmbColExprSaved = true;
    }

    static Index ra$m_index(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_index;
    }

    static IndexInfoVerifier ra$m_verifier(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_verifier;
    }

    static JList ra$m_lstColExprs(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_lstColExprs;
    }

    static DefaultListModel ra$m_mdlColExprs(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_mdlColExprs;
    }

    static String ra$WH_REMOVE_A_COLUMN_EXPRESSION() {
        return WH_REMOVE_A_COLUMN_EXPRESSION;
    }

    static void mav$updateSelColExpr(IndexEditorPanel indexEditorPanel, Object object) {
        indexEditorPanel.updateSelColExpr(object);
    }

    static void mav$setColExprControls(IndexEditorPanel indexEditorPanel, IndexObject indexObject) {
        indexEditorPanel.setColExprControls(indexObject);
    }

    static TraversalException mav$saveIndexAttributes(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.saveIndexAttributes();
    }

    static String ra$WH_ADD_A_COLUMN_EXPRESSION() {
        return WH_ADD_A_COLUMN_EXPRESSION;
    }

    static Table ra$m_table(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_table;
    }

    static DBObjectProvider ra$m_prov(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_prov;
    }

    static JComboBox ra$m_cmbColExpr(IndexEditorPanel indexEditorPanel) {
        return indexEditorPanel.m_cmbColExpr;
    }

    static void mav$saveCmbColExpr(IndexEditorPanel indexEditorPanel) {
        indexEditorPanel.saveCmbColExpr();
    }

    static String ra$WH_CHANGE_COLEXPR_SELECTION() {
        return WH_CHANGE_COLEXPR_SELECTION;
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            if (!IndexEditorPanel.this.m_cmbColExprSaved) {
                IndexEditorPanel.mav$saveCmbColExpr(IndexEditorPanel.this);
            }
            IndexEditorPanel.this.logActionStart(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION(), true);
            IndexEditorPanel.mav$updateSelColExpr(IndexEditorPanel.this, IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedValue());
            IndexEditorPanel.this.logActionEnd(IndexEditorPanel.ra$WH_CHANGE_COLEXPR_SELECTION());
        }
    }

    private class ButtonsHelper
    extends ListButtons.HelperAdapter {
        public void addToList() {
            IndexEditorPanel.this.logActionStart(IndexEditorPanel.ra$WH_ADD_A_COLUMN_EXPRESSION(), false);
            IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).clearSelection();
            if (IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedValue() == null) {
                String defaultColExpr = "";
                Column[] cols = IndexEditorPanel.ra$m_table(IndexEditorPanel.this).getColumns();
                if (cols.length > 0) {
                    defaultColExpr = cols[0].getName();
                    Constraint[] cons = IndexEditorPanel.ra$m_table(IndexEditorPanel.this).getConstraints();
                    int i = 0;
                    while (i < cons.length) {
                        if ("PKConstraint".equals(cons[i].getConstraintType())) {
                            defaultColExpr = ((PKConstraint)cons[i]).getColumns()[0].getName();
                            break;
                        }
                        if ("UniqueConstraint".equals(cons[i].getConstraintType())) {
                            defaultColExpr = ((UniqueConstraint)cons[i]).getColumns()[0].getName();
                        }
                        ++i;
                    }
                }
                String colExpr = IndexEditorPanel.ra$m_prov(IndexEditorPanel.this).getExternalName(defaultColExpr, "COLUMN");
                SQLFragment usage = OracleIndexBuilder.createExpression((String)colExpr, (Relation)IndexEditorPanel.ra$m_table(IndexEditorPanel.this), (DBObjectProvider)IndexEditorPanel.ra$m_prov(IndexEditorPanel.this));
                IndexObject io = new IndexObject(usage);
                IndexEditorPanel.ra$m_mdlColExprs(IndexEditorPanel.this).addElement(io);
                IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).setSelectedIndex(IndexEditorPanel.ra$m_mdlColExprs(IndexEditorPanel.this).size() - 1);
                IndexEditorPanel.ra$m_cmbColExpr(IndexEditorPanel.this).requestFocusInWindow();
            }
            IndexEditorPanel.mav$saveIndexAttributes(IndexEditorPanel.this);
            IndexEditorPanel.this.updateButtons();
            IndexEditorPanel.this.logActionEnd(IndexEditorPanel.ra$WH_ADD_A_COLUMN_EXPRESSION());
        }

        public void removeFromList() {
            IndexEditorPanel.this.logActionStart(IndexEditorPanel.ra$WH_REMOVE_A_COLUMN_EXPRESSION(), false);
            int idx = IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedIndex();
            if (idx != -1) {
                int newIdx = idx == IndexEditorPanel.ra$m_mdlColExprs(IndexEditorPanel.this).size() - 1 ? idx - 1 : idx + 1;
                IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).setSelectedIndex(newIdx);
                IndexEditorPanel.ra$m_mdlColExprs(IndexEditorPanel.this).removeElementAt(idx);
                if (newIdx == -1) {
                    IndexEditorPanel.mav$updateSelColExpr(IndexEditorPanel.this, null);
                    IndexEditorPanel.mav$setColExprControls(IndexEditorPanel.this, null);
                }
            }
            IndexEditorPanel.mav$saveIndexAttributes(IndexEditorPanel.this);
            IndexEditorPanel.this.updateButtons();
            IndexEditorPanel.this.logActionEnd(IndexEditorPanel.ra$WH_REMOVE_A_COLUMN_EXPRESSION());
        }

        public String getAddTooltipText() {
            return UIArb.getString(521);
        }

        public String getDownTooltipText() {
            return UIArb.getString(274);
        }

        public String getRemoveTooltipText() {
            return UIArb.getString(370);
        }

        public String getUpTooltipText() {
            return UIArb.getString(661);
        }

        public boolean canAdd() {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canEditIndex(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        public boolean canAdd(Object val) {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canAddIndexEntry(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        public boolean canRemove() {
            int selColExprs = IndexEditorPanel.ra$m_lstColExprs(IndexEditorPanel.this).getSelectedIndex();
            IndexObject io = selColExprs != -1 ? (IndexObject)IndexEditorPanel.ra$m_mdlColExprs(IndexEditorPanel.this).get(selColExprs) : null;
            SQLFragment sf = io == null ? null : io.getExpression();
            String colExpr = sf == null ? null : sf.getSQLText();
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || colExpr != null);
        }

        public boolean canRemove(Object val) {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canEditIndex(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        public boolean canMoveUp(Object val) {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canEditIndex(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        public boolean canMoveDown(Object val) {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canEditIndex(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        public boolean canReorder() {
            return IndexEditorPanel.ra$m_index(IndexEditorPanel.this) != null && (IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this) == null || IndexEditorPanel.ra$m_verifier(IndexEditorPanel.this).canEditIndex(IndexEditorPanel.ra$m_index(IndexEditorPanel.this)));
        }

        private ButtonsHelper() {
        }

        ButtonsHelper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

