/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.ora.verifiers.table.EditStorageInfoVerifier;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.OracleIndexOrganizedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;

public class IOTInfoPanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectRenderer m_rend;
    private JLabel m_incColLabel;
    private JComboBox m_incColComboBox;
    private JCheckBox m_keyCompCheckBox;
    private NumberTextField m_keyCompField;
    private JLabel m_pctLabel;
    private NumberTextField m_pctField;
    private JCheckBox m_mappingCheckBox;
    private JCheckBox m_overflowCheckBox;
    private JButton m_storageButton;
    private DBObjectProvider m_prov;
    private Table m_table;
    private OracleIndexOrganizedTableProperties m_iotProps;
    private StorageInfoVerifier m_siVerifier;
    private String[] m_tablespaces;
    private final EditOverflowStorageInfoVerifier _editOverflowStorageInfoVerifier;

    private void $init$() {
        this.m_rend = new DBObjectRenderer();
        this.m_incColLabel = new JLabel();
        this.m_incColComboBox = new JComboBox();
        this.m_keyCompCheckBox = new JCheckBox();
        this.m_keyCompField = new NumberTextField();
        this.m_pctLabel = new JLabel();
        this.m_pctField = new NumberTextField();
        this.m_mappingCheckBox = new JCheckBox();
        this.m_overflowCheckBox = new JCheckBox();
        this.m_storageButton = new JButton();
        this._editOverflowStorageInfoVerifier = new EditOverflowStorageInfoVerifier(null);
    }

    public IOTInfoPanel() {
        this.$init$();
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.m_incColComboBox.setName("IOTInfoPanel.INC_COL_COMBO_BOX");
        this.m_keyCompField.setName("IOTInfoPanel.KEY_COMP_FIELD");
        this.m_overflowCheckBox.setName("IOTInfoPanel.OVERFLOW_CHECK_BOX");
        this.m_keyCompCheckBox.setName("IOTInfoPanel.KEY_COMP_CHECK_BOX");
        this.m_mappingCheckBox.setName("IOTInfoPanel.MAPPING_CHECK_BOX");
        this.m_pctField.setName("IOTInfoPanel.PCT_FIELD");
        this.m_storageButton.setName("IOTInfoPanel.BTN_STORAGE");
        this.m_incColComboBox.setRenderer(this.m_rend);
        this.m_keyCompField.setDecimal(false);
        this.m_keyCompField.setSigned(false);
        this.m_overflowCheckBox.addActionListener(this);
        this.m_keyCompCheckBox.addActionListener(this);
        this.m_storageButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_incColLabel, (Component)this.m_incColComboBox, (String)UIArb.getString(863));
        DBObjectRenderer.setToolTipText(this.m_incColLabel, UIArb.getString(646));
        ResourceUtils.resButton((AbstractButton)this.m_keyCompCheckBox, (String)UIArb.getString(824));
        ResourceUtils.resButton((AbstractButton)this.m_overflowCheckBox, (String)UIArb.getString(747));
        ResourceUtils.resButton((AbstractButton)this.m_mappingCheckBox, (String)UIArb.getString(442));
        ResourceUtils.resLabel((JLabel)this.m_pctLabel, (Component)this.m_pctField, (String)UIArb.getString(95));
        ResourceUtils.resButton((AbstractButton)this.m_storageButton, (String)UIArb.getString(843));
        this.add(this.m_keyCompCheckBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_keyCompField, new GridBagConstraints(2, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_pctLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_pctField, new GridBagConstraints(2, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_mappingCheckBox, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JPanel overflowPanel = new JPanel(new GridBagLayout());
        overflowPanel.add((Component)this.m_incColLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 20, 5), 0, 0));
        overflowPanel.add((Component)this.m_incColComboBox, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 20, 5), 0, 0));
        overflowPanel.add((Component)this.m_storageButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 20, 15), 0, 0));
        overflowPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.m_overflowCheckBox);
        cardPanel.showSubPanel((JComponent)overflowPanel);
        this.add((Component)cardPanel, new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 17, 1, new Insets(15, 5, 0, 5), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        Table oldTab = (Table)dataContext.get("OriginalObject");
        StorageInfoVerifier verifier = (StorageInfoVerifier)dataContext.find("StorageInfoVerifier");
        String[] tablespaces = this.getTablespaces(dataContext, pro);
        OracleIndexOrganizedTableProperties iotp = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties");
        this.init(pro, tab, iotp, verifier, tablespaces, oldTab != null);
        if (!((Boolean)dataContext.find("DBObjectIsEditable")).booleanValue()) {
            this.m_keyCompCheckBox.setEnabled(false);
            this.m_keyCompField.setEnabled(false);
            this.m_pctLabel.setEnabled(false);
            this.m_pctField.setEnabled(false);
            this.m_mappingCheckBox.setEnabled(false);
            this.m_overflowCheckBox.setEnabled(false);
            this.m_storageButton.setEnabled(false);
            this.overflowEnable(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        OracleIndexOrganizedTableProperties iotp = (OracleIndexOrganizedTableProperties)tab.getProperty("OracleIndexOrganizedTableProperties");
        if (iotp == null) {
            iotp = this.m_iotProps;
            tab.setProperty("OracleIndexOrganizedTableProperties", (Object)iotp);
        }
        this.commit(pro, tab, iotp);
    }

    private void init(DBObjectProvider pro, Table tab, OracleIndexOrganizedTableProperties iotp, StorageInfoVerifier verifier, String[] tablespaces, boolean editing) {
        this.m_prov = pro;
        this.m_table = tab;
        this.m_iotProps = iotp;
        this.m_siVerifier = verifier;
        this.m_tablespaces = tablespaces;
        if (this.m_iotProps == null) {
            this.m_iotProps = new OracleIndexOrganizedTableProperties();
        }
        this.initDynamicControls(tab);
        if (editing) {
            verifier = this._editOverflowStorageInfoVerifier;
            verifier.initializeVerifier(pro, null, (SchemaObject)tab);
        }
        if (iotp != null) {
            this.m_mappingCheckBox.setSelected(iotp.isMapped());
            this.m_pctField.setNumber((Number)iotp.getPctThreshold());
            Integer keyComp = iotp.getKeyCompression();
            this.m_keyCompCheckBox.setSelected(keyComp != null);
            this.m_keyCompCheckBox.setEnabled(true);
            this.m_keyCompField.setNumber(keyComp == null || keyComp == 0 ? null : keyComp);
            this.m_keyCompField.setEnabled(keyComp != null);
            DBObjectID colId = iotp.getIncludeColumn();
            if (colId != null) {
                try {
                    Column c = (Column)colId.resolveID();
                    if (c != null) {
                        this.m_incColComboBox.setSelectedItem(c);
                        if (editing && pro instanceof Database) {
                            this.m_incColComboBox.removeItem(" ");
                        }
                    }
                }
                catch (DBException dbe) {
                    // empty catch block
                }
            }
            if (iotp.isOverflowable()) {
                this.m_overflowCheckBox.setSelected(true);
                this.overflowEnable(true);
                if (editing && pro instanceof Database) {
                    this.m_overflowCheckBox.setEnabled(false);
                }
            } else {
                this.m_overflowCheckBox.setSelected(false);
                this.overflowEnable(false);
            }
        } else {
            this.m_keyCompCheckBox.setSelected(false);
            this.m_keyCompCheckBox.setEnabled(true);
            this.m_keyCompField.setEnabled(false);
            this.m_overflowCheckBox.setSelected(true);
            this.overflowEnable(true);
        }
    }

    private void commit(DBObjectProvider pro, Table tab, OracleIndexOrganizedTableProperties iotp) throws TraversalException {
        Object c = this.m_incColComboBox.getSelectedItem();
        if (c instanceof Column) {
            DBObjectID id = ((Column)c).getID();
            if (id == null) {
                id = TemporaryObjectID.createID((DBObject)((Column)c));
                ((Column)c).setID(id);
            }
            iotp.setIncludeColumn(id);
        } else {
            iotp.setIncludeColumn(null);
        }
        iotp.setMapped(this.m_mappingCheckBox.isSelected());
        if (this.m_keyCompCheckBox.isSelected()) {
            int maxValue;
            Number num = this.m_keyCompField.getNumber();
            PKConstraint pk = this.getPK(tab);
            int n = maxValue = pk != null ? pk.getColumns().length - 1 : 0;
            if (num != null) {
                if (num.intValue() < 1 || num.intValue() > maxValue) {
                    throw new TraversalException(UIArb.getString(708));
                }
            } else {
                num = 0;
            }
            iotp.setKeyCompression(Integer.valueOf(num.intValue()));
        } else {
            iotp.setKeyCompression(null);
        }
        Number pct = this.m_pctField.getNumber();
        iotp.setPctThreshold(pct == null ? null : new Integer(pct.intValue()));
        iotp.setOverflowable(this.m_overflowCheckBox.isSelected());
        if (!iotp.isOverflowable()) {
            iotp.setOverflowProperties(null);
        }
        try {
            pro.validateObject((DBObject)iotp);
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage(), e.getTitle());
        }
    }

    private void initDynamicControls(Table tab) {
        ArrayList<Column> cols = new ArrayList<Column>(Arrays.asList(tab.getColumns()));
        boolean canHaveKeyComp = false;
        Constraint[] constraintArray = tab.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            Constraint con = constraintArray[n];
            if (con instanceof PKConstraint) {
                List<Column> keyColsList = Arrays.asList(((PKConstraint)con).getColumns());
                canHaveKeyComp = keyColsList.size() > 1;
                Iterator<Column> keyCols = keyColsList.iterator();
                while (keyCols.hasNext()) {
                    Column pkColumn = keyCols.next();
                    if (!keyCols.hasNext()) continue;
                    cols.remove(pkColumn);
                }
                break;
            }
            ++n;
        }
        this.m_incColComboBox.removeAllItems();
        this.m_incColComboBox.addItem(" ");
        for (Column c : cols) {
            this.m_incColComboBox.addItem(c);
        }
        this.m_keyCompCheckBox.setSelected(canHaveKeyComp);
        this.m_keyCompCheckBox.setEnabled(canHaveKeyComp);
        this.m_keyCompField.setEnabled(canHaveKeyComp);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_overflowCheckBox) {
            this.overflowEnable(this.m_overflowCheckBox.isSelected());
        } else if (source == this.m_keyCompCheckBox) {
            this.m_keyCompField.setEnabled(this.m_keyCompCheckBox.isSelected());
        } else if (source == this.m_storageButton) {
            OracleStorageProperties osp = StorageInfoPanel.edit(this.m_iotProps.getOverflowProperties(), StorageInfoPanel.StorageInfoFor.IOT_OVERFLOW, this.m_prov, (DBObject)this.m_table, null, this.m_siVerifier, this.m_tablespaces, (Component)((Object)this));
            this.m_iotProps.setOverflowProperties(osp);
        }
    }

    private void overflowEnable(boolean boo) {
        this.m_incColLabel.setEnabled(boo);
        this.m_incColComboBox.setEnabled(boo);
        this.m_storageButton.setEnabled(boo);
    }

    private PKConstraint getPK(Table table) {
        if (table != null) {
            Constraint[] constraintArray = table.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint constraint = constraintArray[n];
                if (constraint instanceof PKConstraint) {
                    return (PKConstraint)constraint;
                }
                ++n;
            }
        }
        return null;
    }

    private class EditOverflowStorageInfoVerifier
    extends EditStorageInfoVerifier {
        public boolean canChangePercentFree() {
            return true;
        }

        public boolean canChangePercentUsed() {
            return true;
        }

        private EditOverflowStorageInfoVerifier() {
        }

        EditOverflowStorageInfoVerifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

