/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;

public class ConstraintColumnSelectionPanel
extends JPanel
implements ConstraintPanel {
    private JList lstFrom;
    private JList lstTo;
    private ListPicker pckFrom;
    private ListPicker pckTo;
    private Shuttle shtColumns;
    private GridBagLayout gridBagLayout1;
    private JLabel lblFrom;
    private JLabel lblTo;
    private JCheckBox chkEnabled;
    private JLabel lblName;
    private JTextField fldName;
    private DBObjectRenderer renderer;
    protected Table _table;
    private UniqueConstraint _con;
    private ConstraintsInfoVerifier _verifier;
    protected DBObjectProvider _prov;
    protected DefaultListModel mdlFrom;
    protected DefaultListModel mdlTo;

    private void $init$() {
        this.lstFrom = new JList();
        this.lstTo = new JList();
        this.pckFrom = new ListPicker(this.lstFrom);
        this.pckTo = new ReorderableListPicker(this.lstTo);
        this.shtColumns = new Shuttle();
        this.gridBagLayout1 = new GridBagLayout();
        this.lblFrom = new JLabel();
        this.lblTo = new JLabel();
        this.chkEnabled = new JCheckBox();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.renderer = new DBObjectRenderer();
    }

    public ConstraintColumnSelectionPanel(String pnlName) {
        this.$init$();
        try {
            this.jbInit(pnlName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(String pnlName) throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper(pnlName);
        this.setLayout(this.gridBagLayout1);
        this.shtColumns.setFromPicker((ItemPicker)this.pckFrom);
        this.shtColumns.setToPicker((ItemPicker)this.pckTo);
        reshelp.resButton(this.chkEnabled, UIArb.getString(373), "Enabled");
        reshelp.resLabel(this.lblName, this.fldName, UIArb.getString(79), "Name");
        this.shtColumns.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shtColumns.add((Component)this.lblTo, (Object)"ToHeader");
        reshelp.resLabel(this.lblFrom, this.lstFrom, UIArb.getString(2), "Available");
        reshelp.resLabel(this.lblTo, this.lstTo, UIArb.getString(854), "Selected");
        this.lstFrom.setCellRenderer(this.renderer);
        this.lstTo.setCellRenderer(this.renderer);
        this.add((Component)this.shtColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.chkEnabled, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(Namespace namespace) {
        this._prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this._table = (Table)namespace.find("NewObject");
        this._con = (UniqueConstraint)namespace.find("NewChildObject");
        this._verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        boolean modifiable = (Boolean)namespace.find("Modifiable");
        this.mdlFrom = new DefaultListModel();
        this.mdlTo = new DefaultListModel();
        if (this._con != null) {
            this.fldName.setText(this._prov.getExternalName(this._con.getName()));
            this.chkEnabled.setSelected(this._con.isEnabled());
            Column[] tblCols = this._table.getColumns();
            Column[] consCols = this._con.getColumns();
            int i = 0;
            while (i < tblCols.length) {
                this.mdlFrom.addElement(tblCols[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < consCols.length) {
                if (this.mdlFrom.contains(consCols[i2])) {
                    this.mdlFrom.removeElement(consCols[i2]);
                }
                this.mdlTo.addElement(consCols[i2]);
                ++i2;
            }
        } else {
            this.fldName.setText("");
            this.chkEnabled.setSelected(false);
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shtColumns.setEnabled(modifiable);
        this.lstFrom.setEnabled(modifiable);
        this.lstTo.setEnabled(modifiable);
        this.fldName.setEnabled(modifiable);
        this.chkEnabled.setEnabled(modifiable);
        this.shtColumns.validate();
    }

    public void addShuttleListener(ShuttleListener listener) {
        this.shtColumns.addShuttleListener(listener);
    }

    public void removeShuttleListener(ShuttleListener listener) {
        this.shtColumns.removeShuttleListener(listener);
    }

    public boolean canCommit() {
        DefaultListModel mdl = (DefaultListModel)this.lstTo.getModel();
        return mdl.getSize() > 0;
    }

    public void commit() throws TraversalException {
        if (this._con != null) {
            this._con.setEnabled(this.chkEnabled.isSelected());
            DefaultListModel mdl = (DefaultListModel)this.lstTo.getModel();
            Object[] cols = new Column[mdl.getSize()];
            mdl.copyInto(cols);
            this._con.setColumns((Column[])cols);
            String conName = this.fldName.getText();
            if (this._verifier != null) {
                this._verifier.verifyName(conName);
            }
            this._con.setName(this._prov.getInternalName(conName));
        }
    }
}

