/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ColumnEditorPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;

public class ColumnInfoPanel
extends BaseInfoPanel
implements ListSelectionListener,
ListDataListener,
DocumentListener {
    private DefaultListModel m_mdlColumns;
    private JList m_lstColumns;
    private ListButtons m_pnlButtons;
    private ColumnEditorPanel m_pnlColumn;
    private DataType m_defaultType;
    private Relation m_relation;
    private Column m_col;
    private WizardCallbacks m_callbacks;
    private String m_columnBaseName;
    private int m_currentSelection;
    private boolean m_edit;

    private void $init$() {
        this.m_mdlColumns = new DefaultListModel();
        this.m_lstColumns = new JList(this.m_mdlColumns);
        this.m_pnlButtons = new ListButtons(this.m_lstColumns, new ButtonsHelper(null));
        this.m_pnlColumn = new ColumnEditorPanel();
        this.m_currentSelection = 0;
        this.m_edit = false;
    }

    public ColumnInfoPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String pnlName = "ColumnInfoPanel.";
        DBUIResourceHelper reshelp = new DBUIResourceHelper("ColumnInfoPanel.");
        this.m_pnlButtons.setButtonNames("ColumnInfoPanel.");
        JLabel lblColumns = new JLabel();
        reshelp.resLabel(lblColumns, this.m_lstColumns, UIArb.getString(810), "ColumnList");
        JScrollPane scrColumns = new JScrollPane();
        scrColumns.setVerticalScrollBarPolicy(22);
        this.m_lstColumns.setSelectionMode(2);
        this.m_lstColumns.setCellRenderer(new DBObjectRenderer());
        scrColumns.getViewport().add((Component)this.m_lstColumns, null);
        JPanel pnlList = new JPanel(new GridBagLayout());
        pnlList.setName("ColumnInfoPanelList");
        pnlList.add((Component)lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)scrColumns, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlList.add(Box.createHorizontalStrut(140), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_pnlColumn, new GridBagConstraints(2, 0, 1, 2, 2.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(pnlList, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        this.m_edit = dataContext.find("OriginalObject") != null;
        this.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (Relation)dataContext.find("NewObject"), (ColumnInfoVerifier)dataContext.find("ColumnInfoVerifier"), callbacks);
        if (callbacks != null) {
            callbacks.wizardSetInitialFocus((Component)this.m_lstColumns);
        }
        this.setInitialSelection(dataContext.find("DefaultChild"));
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((Relation)dataContext.find("OriginalObject"), (Relation)dataContext.find("NewObject"), dataContext.getDirection() == 2);
    }

    protected void init(DBObjectProvider prov, Relation relation, ColumnInfoVerifier verifier, WizardCallbacks callbacks) {
        super.init(prov, verifier);
        this.m_relation = relation;
        if (this.m_columnBaseName == null) {
            this.m_columnBaseName = prov.getDescriptor().getCasePolicy() == 1 ? "column" : "COLUMN";
        }
        this.m_defaultType = verifier.getDefaultType();
        if (this.m_defaultType == null) {
            this.m_defaultType = prov.getDataType("VARCHAR2");
            this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getDataType("VARCHAR");
            this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getDataType("CHAR");
            DataType dataType = this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getDataType("CHARACTER");
        }
        if (relation.getColumns().length == 0 && !this.m_edit) {
            Column c = new Column(this.m_columnBaseName + '1');
            c.setDataTypeUsage(this.m_defaultType.createDefaultUsage());
            c.setID(TemporaryObjectID.createID((DBObject)c));
            relation.addColumn(c);
        }
        this.m_lstColumns.getSelectionModel().removeListSelectionListener(this);
        this.m_mdlColumns.removeListDataListener(this);
        this.m_mdlColumns.removeAllElements();
        this.m_mdlColumns.clear();
        this.m_col = null;
        this.m_callbacks = callbacks;
        this.m_pnlColumn.init(prov, relation, verifier);
        this.m_mdlColumns.addListDataListener(this);
        this.m_lstColumns.getSelectionModel().addListSelectionListener(this);
        this.updateColumnData(null);
        Column[] cols = relation.getColumns();
        int i = 0;
        while (i < cols.length) {
            this.m_mdlColumns.addElement(cols[i]);
            ++i;
        }
        this.updateButtons();
        this.updateListContents();
    }

    protected void commit(Relation oldTable, Relation newTable, boolean backwards) throws TraversalException {
        if (this.m_col != null) {
            this.commitColumnChanges(this.m_col);
        }
        int size = this.m_mdlColumns.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        int i = 0;
        while (i < size) {
            Column col = (Column)this.m_mdlColumns.getElementAt(i);
            cols.add(col);
            ++i;
        }
        newTable.setColumns(cols.toArray(new Column[cols.size()]));
        ColumnInfoVerifier verifier = (ColumnInfoVerifier)this.getVerifier();
        if (!backwards && verifier != null) {
            verifier.verifyRelation();
        }
    }

    private void setInitialSelection(Object selObj) {
        int idx;
        int sel = 0;
        if (selObj != null && (idx = this.m_mdlColumns.indexOf(selObj)) != -1) {
            sel = idx;
        }
        if (this.m_mdlColumns.size() > 0) {
            this.setSelectedColumn(sel);
        }
    }

    private void commitColumnChanges(Column col) throws TraversalException {
        this.m_pnlColumn.commit(col);
        this.m_pnlColumn.getNameField().getDocument().removeDocumentListener(this);
    }

    private void updateColumnData(Column col) {
        this.m_col = col;
        this.m_pnlColumn.setColumn(col);
        if (col != null) {
            this.m_pnlColumn.getNameField().getDocument().addDocumentListener(this);
        }
        this.validate();
        this.repaint();
    }

    private void updateSelection(Object sel) {
        if (sel != this.m_col) {
            if (this.m_col != null) {
                try {
                    this.commitColumnChanges(this.m_col);
                }
                catch (TraversalException e) {
                    this.showColumnError(e);
                    return;
                }
            }
            this.updateColumnData((Column)sel);
        }
        this.updateButtons();
    }

    private void showColumnError(TraversalException ex) {
        ex.showMessageDialog((Component)((Object)this));
        int indexOfSelectedColumn = this.m_lstColumns.getSelectedIndex();
        if (indexOfSelectedColumn < 0 || this.m_mdlColumns.elementAt(indexOfSelectedColumn).equals(this.m_mdlColumns.elementAt(this.m_currentSelection))) {
            this.setSelectedColumn(this.m_currentSelection);
        } else if (this.m_currentSelection != indexOfSelectedColumn) {
            this.setSelectedColumn(this.m_col);
        }
    }

    private void updateButtons() {
        this.m_pnlButtons.enableButtons();
    }

    private void updateListContents() {
        boolean notEmpty = this.m_mdlColumns.getSize() > 0;
        this.m_lstColumns.setFocusable(notEmpty);
        if (this.m_callbacks != null) {
            Boolean val = notEmpty;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, val, val);
        }
    }

    private void swap(int i1, int i2) {
        Object o1 = this.m_mdlColumns.getElementAt(i1);
        Object o2 = this.m_mdlColumns.getElementAt(i2);
        this.m_mdlColumns.setElementAt(o1, i2);
        this.m_mdlColumns.setElementAt(o2, i1);
    }

    private void updateColumnName() {
        if (this.m_col != null) {
            String colName = this.m_pnlColumn.getNameField().getText();
            this.m_col.setName(colName);
        }
    }

    public void valueChanged(ListSelectionEvent lse) {
        Object[] sel = this.m_lstColumns.getSelectedValues();
        if (sel.length == 1) {
            this.updateSelection(this.m_lstColumns.getSelectedValue());
        } else {
            this.updateSelection(null);
        }
    }

    public void intervalAdded(ListDataEvent p0) {
        this.updateListContents();
    }

    public void intervalRemoved(ListDataEvent p0) {
        this.updateListContents();
    }

    public void contentsChanged(ListDataEvent p0) {
        this.updateListContents();
    }

    public void insertUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    public void removeUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    public void changedUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    private void setSelectedColumn(int indexOfColumn) {
        this.m_currentSelection = indexOfColumn;
        this.m_lstColumns.setSelectedIndex(this.m_currentSelection);
    }

    private void setSelectedColumn(Column column) {
        this.m_lstColumns.setSelectedValue(column, true);
        this.m_currentSelection = this.m_lstColumns.getSelectedIndex();
    }

    static Verifier mav$getVerifier(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.getVerifier();
    }

    static JList ra$m_lstColumns(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_lstColumns;
    }

    static void wa$m_currentSelection(ColumnInfoPanel columnInfoPanel, int n) {
        columnInfoPanel.m_currentSelection = n;
    }

    static Relation ra$m_relation(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_relation;
    }

    static Column ra$m_col(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_col;
    }

    static void wa$m_col(ColumnInfoPanel columnInfoPanel, Column column) {
        columnInfoPanel.m_col = column;
    }

    static DefaultListModel ra$m_mdlColumns(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_mdlColumns;
    }

    static void mav$setSelectedColumn(ColumnInfoPanel columnInfoPanel, int n) {
        columnInfoPanel.setSelectedColumn(n);
    }

    static void mav$updateSelection(ColumnInfoPanel columnInfoPanel, Object object) {
        columnInfoPanel.updateSelection(object);
    }

    static void mav$updateColumnData(ColumnInfoPanel columnInfoPanel, Column column) {
        columnInfoPanel.updateColumnData(column);
    }

    static String ra$m_columnBaseName(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_columnBaseName;
    }

    static String maS$getUniqueName(String string, DefaultListModel defaultListModel) {
        return BaseInfoPanel.getUniqueName(string, defaultListModel);
    }

    static DataType ra$m_defaultType(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_defaultType;
    }

    static void mav$setSelectedColumn(ColumnInfoPanel columnInfoPanel, Column column) {
        columnInfoPanel.setSelectedColumn(column);
    }

    static ColumnEditorPanel ra$m_pnlColumn(ColumnInfoPanel columnInfoPanel) {
        return columnInfoPanel.m_pnlColumn;
    }

    private class ButtonsHelper
    extends ListButtons.HelperAdapter {
        public void addToList() {
            ColumnInfoPanel.wa$m_currentSelection(ColumnInfoPanel.this, ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).getSelectedIndex());
            int idx = ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).getSelectedIndex();
            ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).clearSelection();
            if (ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).getSelectedValue() == null) {
                Column next;
                int total;
                boolean insert;
                String name = ColumnInfoPanel.maS$getUniqueName(ColumnInfoPanel.ra$m_columnBaseName(ColumnInfoPanel.this), ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this));
                Column col = new Column(name);
                col.setID(TemporaryObjectID.createID((DBObject)col));
                ColumnInfoPanel.ra$m_relation(ColumnInfoPanel.this).addColumn(col);
                col.setDataTypeUsage(ColumnInfoPanel.ra$m_defaultType(ColumnInfoPanel.this).createDefaultUsage());
                ColumnInfoVerifier verifier = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
                boolean bl = insert = idx >= 0 && (verifier == null || verifier.canReorderColumns());
                if (insert && idx < (total = ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).getSize()) - 1 && !verifier.canMoveColumnDown(next = (Column)ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).getElementAt(idx))) {
                    insert = false;
                }
                if (insert) {
                    ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).insertElementAt(col, idx + 1);
                } else {
                    ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).addElement(col);
                }
                ColumnInfoPanel.mav$setSelectedColumn(ColumnInfoPanel.this, col);
                ColumnInfoPanel.ra$m_pnlColumn(ColumnInfoPanel.this).getNameField().requestFocusInWindow();
            }
        }

        public void removeFromList() {
            ColumnInfoPanel.wa$m_currentSelection(ColumnInfoPanel.this, ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).getSelectedIndex());
            int[] selectedIndicies = ColumnInfoPanel.ra$m_lstColumns(ColumnInfoPanel.this).getSelectedIndices();
            ColumnInfoPanel.ra$m_relation(ColumnInfoPanel.this).removeColumn(ColumnInfoPanel.ra$m_col(ColumnInfoPanel.this));
            ColumnInfoPanel.wa$m_col(ColumnInfoPanel.this, null);
            int i = selectedIndicies.length - 1;
            while (i >= 0) {
                ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).remove(selectedIndicies[i]);
                --i;
            }
            int newIdx = -1;
            newIdx = selectedIndicies.length > 0 && ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).size() > selectedIndicies[0] ? selectedIndicies[0] : ColumnInfoPanel.ra$m_mdlColumns(ColumnInfoPanel.this).size() - 1;
            ColumnInfoPanel.mav$setSelectedColumn(ColumnInfoPanel.this, newIdx);
            if (newIdx == -1) {
                ColumnInfoPanel.mav$updateSelection(ColumnInfoPanel.this, null);
                ColumnInfoPanel.mav$updateColumnData(ColumnInfoPanel.this, null);
            }
        }

        public String getAddTooltipText() {
            return UIArb.getString(695);
        }

        public String getDownTooltipText() {
            return UIArb.getString(462);
        }

        public String getRemoveTooltipText() {
            return UIArb.getString(849);
        }

        public String getUpTooltipText() {
            return UIArb.getString(756);
        }

        public boolean canAdd() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v.canAddColumns();
        }

        public boolean canAdd(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canAddColumn((Column)val);
        }

        public boolean canMoveUp(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canMoveColumnUp((Column)val);
        }

        public boolean canRemove() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canRemoveColumns();
        }

        public boolean canRemove(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canRemoveColumn((Column)val);
        }

        public boolean canReorder() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canReorderColumns();
        }

        public boolean canMoveDown(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.mav$getVerifier(ColumnInfoPanel.this);
            return v == null || v.canMoveColumnDown((Column)val);
        }

        private ButtonsHelper() {
        }

        ButtonsHelper(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

