/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.SchemaPicker;
import oracle.ide.db.panels.DataTypePanel;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class ColumnEditorPanel
extends JPanel
implements ActionListener {
    private boolean m_listening;
    private JLabel m_lblColName;
    private JTextField m_fldName;
    private JLabel m_lblDataType;
    private JRadioButton m_rdbSimpleType;
    private JRadioButton m_rdbComplexType;
    private JPanel m_typePanel;
    private JLabel m_lblType;
    private JComboBox m_cmbType;
    private DataTypePanel m_pnlDataType;
    private JLabel m_lblSchemas;
    private SchemaPicker m_cmbSchemas;
    private JLabel m_lblComplexType;
    private JComboBox m_cmbComplexType;
    private JLabel m_lblDefault;
    private JTextField m_fldDefault;
    private JCheckBox m_chkNotNull;
    private JLabel m_lblComment;
    private JTextArea m_fldComment;
    private JScrollPane m_scrComment;
    private DefaultComboBoxModel m_mdlTypes;
    private DefaultComboBoxModel mdlComplexTypes;
    private ColumnInfoVerifier m_verifier;
    private DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    private DBUIHelper m_helper;
    private Column m_col;
    private HashMap<String, ArrayList<String>> m_schemaTypeMap;
    private String m_lastSchemaName;

    private void $init$() {
        this.m_lblColName = new JLabel();
        this.m_fldName = new JTextField();
        this.m_lblDataType = new JLabel();
        this.m_rdbSimpleType = new JRadioButton();
        this.m_rdbComplexType = new JRadioButton();
        this.m_typePanel = new JPanel();
        this.m_lblType = new JLabel();
        this.m_cmbType = new JComboBox();
        this.m_pnlDataType = new DataTypePanel();
        this.m_lblSchemas = new JLabel();
        this.m_cmbSchemas = new SchemaPicker();
        this.m_lblComplexType = new JLabel();
        this.m_cmbComplexType = new JComboBox();
        this.m_lblDefault = new JLabel();
        this.m_fldDefault = new JTextField();
        this.m_chkNotNull = new JCheckBox();
        this.m_lblComment = new JLabel();
        this.m_fldComment = new JTextArea();
        this.m_scrComment = new JScrollPane();
        this.m_mdlTypes = new NonNullableComboBoxModel();
        this.mdlComplexTypes = new NonNullableComboBoxModel();
        this.m_schemaTypeMap = new HashMap();
        this.m_lastSchemaName = null;
    }

    public ColumnEditorPanel() {
        this(false);
    }

    public ColumnEditorPanel(boolean standalone) {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_helper = new DBUIHelper("ColumnEditorPanel", this);
        this.m_helper.setBasePath(Property.columns);
        this.m_helper.registerComponent(this.m_lblColName, (Component)this.m_fldName, UIArb.getString(375), "Name", Property.name);
        this.m_helper.registerComponent(this.m_lblType, (Component)this.m_cmbType, UIArb.getString(774), "SimpleTypeList", Property.dataTypeUsage);
        this.m_helper.registerComponent(this.m_lblComplexType, (Component)this.m_cmbComplexType, UIArb.getString(774), "ComplexTypeList", Property.dataTypeUsage);
        this.m_helper.registerComponent(this.m_lblSchemas, (Component)this.m_cmbSchemas, UIArb.getString(474), "ComplexTypeSchema", Property.dataTypeUsage);
        this.m_helper.registerComponent(this.m_lblDefault, (Component)this.m_fldDefault, UIArb.getString(707), "Default", Property.default_);
        this.m_helper.registerComponent((AbstractButton)this.m_chkNotNull, UIArb.getString(138), "NotNull", Property.notNull);
        this.m_helper.registerComponent(this.m_lblComment, (Component)this.m_fldComment, UIArb.getString(480), "Comment", Property.Comment);
        this.m_helper.registerComponent((Component)this.m_scrComment, Property.Comment);
        this.m_helper.registerComponent((AbstractButton)this.m_rdbSimpleType, UIArb.getString(346), "SimpleType", Property.dataTypeUsage);
        this.m_helper.registerComponent((AbstractButton)this.m_rdbComplexType, UIArb.getString(102), "ComplexType", Property.dataTypeUsage);
        this.m_fldName.setColumns(30);
        this.m_cmbType.setModel(this.m_mdlTypes);
        this.m_cmbType.addActionListener(this);
        this.m_cmbSchemas.addActionListener(this);
        this.m_cmbSchemas.setEditable(false);
        this.m_cmbComplexType.addActionListener(this);
        this.m_cmbComplexType.setModel(this.mdlComplexTypes);
        AccessibleContext actx = this.m_rdbSimpleType.getAccessibleContext();
        if (actx != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(623)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(346)));
        }
        if ((actx = this.m_rdbComplexType.getAccessibleContext()) != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(623)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(102)));
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbSimpleType);
        bg.add(this.m_rdbComplexType);
        this.m_rdbSimpleType.setSelected(true);
        this.m_rdbSimpleType.addActionListener(this);
        this.m_rdbComplexType.addActionListener(this);
        this.m_lblDataType.setText(UIArb.getString(623));
        this.m_scrComment.setVerticalScrollBarPolicy(22);
        this.m_fldComment.setWrapStyleWord(true);
        this.m_fldComment.setLineWrap(true);
        this.m_scrComment.getViewport().add((Component)this.m_fldComment, null);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(UIArb.getString(650)));
        this.add((Component)this.m_lblColName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add((Component)this.m_fldName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.m_lblDataType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 12), 0, 0));
        this.add((Component)this.m_rdbSimpleType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.m_rdbComplexType, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.createSimpleTypePanel(this.m_typePanel);
        this.add((Component)this.m_typePanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 24, 0, 5), 0, 0));
        this.add(Box.createVerticalStrut(100), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_chkNotNull, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_lblComment, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_scrComment, new GridBagConstraints(0, 12, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_listening = true;
    }

    private void createSimpleTypePanel(JPanel p) {
        p.removeAll();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.m_lblType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.m_pnlDataType, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        p.add((Component)this.m_lblDefault, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        p.add((Component)this.m_fldDefault, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 13, 2, new Insets(10, 0, 0, 5), 0, 0));
    }

    private void createComplexTypePanel(JPanel p) {
        p.removeAll();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.m_lblSchemas, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbSchemas, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.m_lblComplexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbComplexType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        p.add((Component)this.m_pnlDataType, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private ComplexType getSelectedComplexType() {
        Schema schema = null;
        try {
            schema = this.m_cmbSchemas.getSchema();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
        String dataTypeName = (String)this.mdlComplexTypes.getSelectedItem();
        return this.getComplexType(schema, dataTypeName);
    }

    private DataType getSelectedSimpleType() {
        Object selected = this.m_mdlTypes.getSelectedItem();
        if (selected instanceof DataType) {
            return (DataType)selected;
        }
        return null;
    }

    private ComplexType getComplexType(Schema schema, String name) {
        if (ModelUtil.hasLength((String)name) && schema != null) {
            try {
                SchemaObject type = this.m_prov.getObject("TYPE", schema, name);
                if (type != null) {
                    ComplexType complexType = (ComplexType)type;
                    return complexType;
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            try {
                DataType type = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
                if (type instanceof ComplexType && ModelUtil.areEqual((Object)type.getName(), (Object)name) && ModelUtil.areEqual((Object)((ComplexType)type).getSchema().getName(), (Object)schema.getName())) {
                    ComplexType complexType = (ComplexType)type;
                    return complexType;
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return null;
    }

    private SchemaObject[] getComplexTypes(Schema schema) {
        try {
            SchemaObject[] schemaObjectArray = this.m_prov.listObjects(new String[]{"TYPE"}, schema);
            return schemaObjectArray;
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public void init(DBObjectProvider prov, Relation rel, ColumnInfoVerifier verifier) {
        this.init(prov, rel == null ? null : rel.getSchema(), verifier);
        this.m_helper.setProvider(prov);
        this.m_helper.processComponents(null, (DBObject)rel);
    }

    public void init(DBObjectProvider prov, Schema schema, ColumnInfoVerifier verifier) {
        this.m_prov = prov;
        this.m_defaultSchema = schema;
        this.m_verifier = verifier;
        if (this.m_mdlTypes.getSize() < 1) {
            DataType[] topTypes;
            DataType[] types = prov.listSupportedDataTypes();
            TreeSet<DataType> sortedTypes = new TreeSet<DataType>(new 1());
            int i = 0;
            while (i < types.length) {
                sortedTypes.add(types[i]);
                ++i;
            }
            if (verifier != null && (topTypes = verifier.getPreferredTypes()) != null) {
                int i2 = 0;
                while (i2 < topTypes.length) {
                    this.m_mdlTypes.addElement(topTypes[i2]);
                    ++i2;
                }
                this.m_mdlTypes.addElement("--------");
            }
            Iterator iterTypes = sortedTypes.iterator();
            while (iterTypes.hasNext()) {
                this.m_mdlTypes.addElement(iterTypes.next());
            }
        }
    }

    private void initSchemas() {
        if (this.m_cmbSchemas.getModel().getSize() == 0) {
            this.m_listening = false;
            this.m_cmbSchemas.init(this.m_prov, this.m_defaultSchema);
            this.m_listening = true;
        }
        this.m_cmbSchemas.setSelectedIndex(this.m_cmbSchemas.getSelectedIndex());
    }

    public void setColumn(Column col) {
        if (col == null) {
            this.m_col = null;
        } else {
            this.m_col = (Column)col.copyTo(null);
            this.m_col.setRelation(col.getRelation());
        }
        this.updateColumnData();
    }

    public void commit(Column col) throws TraversalException {
        Column newCol = (Column)col.copyTo(null);
        newCol.setRelation(col.getRelation());
        String name = this.m_prov.getInternalName(this.m_fldName.getText());
        newCol.setName(name);
        ComplexType dataType = null;
        if (this.m_rdbSimpleType.isSelected()) {
            String def = this.m_fldDefault.getText();
            newCol.setDefault((Object)(ModelUtil.hasLength((String)def) ? def : null));
            dataType = this.getSelectedSimpleType();
            if (!LOBDescriptor.isLOBColumn((Column)newCol) && newCol.getProperty("OracleColumnProperties") != null) {
                newCol.setProperty("OracleColumnProperties", null);
            }
        } else {
            dataType = this.getSelectedComplexType();
            newCol.setDefault(null);
        }
        if (dataType == null) {
            throw new TraversalException(DBArb.format((int)40, (Object)newCol.getName()));
        }
        try {
            DataTypeUsage dataTypeUsage = this.m_pnlDataType.commit(newCol);
            dataType.validateUsage(dataTypeUsage, (DBObject)newCol);
            newCol.setDataTypeUsage(dataTypeUsage);
        }
        catch (ValidationException ex) {
            throw new TraversalException(ex.getMessage());
        }
        newCol.setNotNull(this.m_chkNotNull.isSelected());
        String comment = this.m_fldComment.getText();
        newCol.setProperty("Comment", (Object)(ModelUtil.hasLength((String)comment) ? comment : null));
        if (this.m_verifier != null) {
            this.m_verifier.verifyColumn(this.m_col, newCol);
        }
        newCol.copyTo((Object)col);
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    private void updateColumnData() {
        if (this.m_col == null) {
            this.m_fldName.setText("");
            this.m_fldDefault.setText("");
            this.m_chkNotNull.setSelected(false);
            this.m_fldComment.setText("");
            this.m_lblColName.setEnabled(false);
            this.m_fldName.setEnabled(false);
            this.m_lblDataType.setEnabled(false);
            this.m_rdbSimpleType.setEnabled(false);
            this.m_rdbComplexType.setEnabled(false);
            this.m_lblType.setEnabled(false);
            this.m_cmbType.setEnabled(false);
            this.m_pnlDataType.setEnabled(false);
            this.m_lblSchemas.setEnabled(false);
            this.m_cmbSchemas.setEnabled(false);
            this.m_lblComplexType.setEnabled(false);
            this.m_cmbComplexType.setEnabled(false);
            this.m_lblDefault.setEnabled(false);
            this.m_fldDefault.setEnabled(false);
            this.m_chkNotNull.setEnabled(false);
            this.m_lblComment.setEnabled(false);
            this.m_scrComment.setEnabled(false);
            this.m_fldComment.setEnabled(false);
            this.m_fldComment.setOpaque(false);
        } else {
            boolean canChangeType;
            this.m_fldName.setText(this.m_prov.getExternalName(this.m_col.getName()));
            this.m_fldName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            this.m_lblColName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            boolean bl = canChangeType = this.m_verifier == null || this.m_verifier.canChangeColumnType(this.m_col);
            if (dataType instanceof ComplexType) {
                this.initSchemas();
                this.m_rdbComplexType.getModel().setSelected(true);
                Schema schema = ((ComplexType)dataType).getSchema();
                boolean schemaExists = false;
                int i = 0;
                while (i < this.m_cmbSchemas.getModel().getSize()) {
                    if (this.m_cmbSchemas.getModel().getElementAt(i).toString().equals(schema.getName())) {
                        schemaExists = true;
                        break;
                    }
                    ++i;
                }
                if (!schemaExists) {
                    this.m_cmbSchemas.addItem(schema);
                }
                this.m_cmbSchemas.setSelectedItem(schema);
                String typeName = dataType.getName();
                if (this.mdlComplexTypes.getIndexOf(typeName) < 0) {
                    this.mdlComplexTypes.addElement(typeName);
                }
                this.m_cmbComplexType.setSelectedItem(typeName);
                this.createComplexTypePanel(this.m_typePanel);
            } else {
                this.m_mdlTypes.setSelectedItem(dataType);
                this.m_rdbSimpleType.getModel().setSelected(true);
                this.createSimpleTypePanel(this.m_typePanel);
            }
            this.m_pnlDataType.initialise(this.m_col.getDataTypeUsage(), this.m_prov, this.m_col);
            this.m_lblDataType.setEnabled(canChangeType);
            this.m_rdbSimpleType.setEnabled(canChangeType);
            Table.TableType tableType = (Table.TableType)this.m_col.getRelation().getProperty("TableType");
            this.m_rdbComplexType.setEnabled(canChangeType && tableType != Table.TableType.EXTERNAL && this.m_prov.supportsObjectType("TYPE"));
            this.m_lblSchemas.setEnabled(canChangeType);
            this.m_cmbSchemas.setEnabled(canChangeType);
            this.m_lblComplexType.setEnabled(canChangeType);
            this.m_cmbComplexType.setEnabled(canChangeType);
            this.m_cmbType.setEnabled(canChangeType);
            this.m_lblType.setEnabled(canChangeType);
            this.m_pnlDataType.setEnabled(canChangeType);
            boolean canChangeDef = this.m_verifier == null || this.m_verifier.canChangeColumnDefaultValue(this.m_col);
            Object def = this.m_col.getDefault();
            this.m_fldDefault.setText(def != null ? def.toString() : "");
            this.m_fldDefault.setEnabled(canChangeDef);
            this.m_lblDefault.setEnabled(canChangeDef);
            this.m_chkNotNull.setSelected(this.m_col.isNotNull());
            this.m_chkNotNull.setEnabled(this.m_verifier == null || this.m_verifier.canChangeColumnNotNullState(this.m_col));
            String comment = (String)this.m_col.getProperty("Comment");
            this.m_fldComment.setText(comment != null ? comment : "");
            boolean commentEnabled = this.m_verifier == null || this.m_verifier.canChangeColumnComment(this.m_col);
            this.m_fldComment.setEnabled(commentEnabled);
            this.m_fldComment.setOpaque(commentEnabled);
            this.m_lblComment.setEnabled(commentEnabled);
            this.m_scrComment.setEnabled(commentEnabled);
        }
        this.validate();
        this.repaint();
    }

    private void updateDefault(DataType datatype) {
        boolean canTakeDef = true;
        boolean canEditDef = true;
        if (this.m_verifier != null) {
            canTakeDef = this.m_verifier.canTakeDefaultValue(datatype);
            canEditDef = this.m_verifier.canChangeColumnDefaultValue(this.m_col);
        }
        if (canTakeDef) {
            Object def = this.m_col == null ? null : this.m_col.getDefault();
            this.m_fldDefault.setText(def != null ? def.toString() : "");
            this.m_fldDefault.setEnabled(canEditDef);
            this.m_lblDefault.setEnabled(canEditDef);
        } else {
            this.m_fldDefault.setText("");
            this.m_fldDefault.setEnabled(false);
            this.m_lblDefault.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object src = ae.getSource();
            if (src == this.m_cmbType || src == this.m_cmbComplexType) {
                Object dataType = src == this.m_cmbType ? this.getSelectedSimpleType() : this.getSelectedComplexType();
                if (dataType != null) {
                    this.m_pnlDataType.initialise(dataType.createDefaultUsage(), this.m_prov, this.m_col);
                }
                this.updateDefault((DataType)dataType);
            } else if (src == this.m_cmbSchemas) {
                Schema s = null;
                try {
                    s = this.m_cmbSchemas.getSchema();
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)this.m_cmbSchemas);
                }
                if (s != null && !s.getName().equals(this.m_lastSchemaName)) {
                    this.mdlComplexTypes.removeAllElements();
                    ArrayList<Object> tList = null;
                    if (!this.m_schemaTypeMap.containsKey(s.getName())) {
                        tList = new ArrayList();
                        SchemaObject[] types = this.getComplexTypes(s);
                        Arrays.sort(types, new 2());
                        int i = 0;
                        while (types != null && i < types.length) {
                            tList.add(types[i].getName());
                            ++i;
                        }
                        this.m_schemaTypeMap.put(s.getName(), tList);
                    } else {
                        tList = this.m_schemaTypeMap.get(s.getName());
                    }
                    int i = 0;
                    while (i < tList.size()) {
                        this.mdlComplexTypes.addElement((String)tList.get(i));
                        ++i;
                    }
                    this.m_lastSchemaName = s.getName();
                }
            } else if (src == this.m_rdbSimpleType || src == this.m_rdbComplexType) {
                DataType dataType;
                if (this.m_rdbSimpleType.isSelected()) {
                    this.createSimpleTypePanel(this.m_typePanel);
                    dataType = this.getSelectedSimpleType();
                } else {
                    this.createComplexTypePanel(this.m_typePanel);
                    this.initSchemas();
                    dataType = this.getSelectedComplexType();
                }
                this.m_pnlDataType.initialise(dataType == null ? null : dataType.createDefaultUsage(), this.m_prov, this.m_col);
                this.updateDefault(dataType);
                this.validate();
                this.repaint();
            }
        }
    }

    final class 1
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof PredefinedDataType && o2 instanceof ComplexType) {
                return -1;
            }
            if (o1 instanceof ComplexType && o2 instanceof PredefinedDataType) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    final class 2
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return o1 == null && o2 == null ? 0 : (o1 == null ? 1 : (o2 == null ? -1 : o1.toString().compareTo(o2.toString())));
        }

        public boolean equals(Object obj) {
            return obj != null && this.toString().equals(obj.toString());
        }
    }
}

