/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObjectProvider;

public class CheckPanel
extends JPanel
implements ConstraintPanel,
DocumentListener {
    private GridBagLayout layMain;
    private JScrollPane scrCondition;
    private JLabel lblCondition;
    private JTextArea txtCondition;
    private JLabel lblName;
    private JTextField fldName;
    private JCheckBox chkEnabled;
    private CheckConstraint _con;
    private ConstraintsInfoVerifier _verifier;
    private DBObjectProvider _prov;
    private BaseConstraintPanel _baseConstraintPanel;

    private void $init$() {
        this.layMain = new GridBagLayout();
        this.scrCondition = new JScrollPane();
        this.lblCondition = new JLabel();
        this.txtCondition = new JTextArea();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.chkEnabled = new JCheckBox();
    }

    public CheckPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("CheckPanel");
        reshelp.resLabel(this.lblCondition, this.txtCondition, UIArb.getString(613), "Condition");
        reshelp.resButton(this.chkEnabled, UIArb.getString(373), "Enabled");
        reshelp.resLabel(this.lblName, this.fldName, UIArb.getString(79), "Name");
        this.scrCondition.setHorizontalScrollBarPolicy(31);
        this.scrCondition.setVerticalScrollBarPolicy(22);
        this.txtCondition.setWrapStyleWord(true);
        this.txtCondition.setRows(4);
        this.txtCondition.setLineWrap(true);
        this.scrCondition.getViewport().add((Component)this.txtCondition, null);
        this.setLayout(this.layMain);
        this.add((Component)this.scrCondition, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.lblCondition, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.chkEnabled, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
    }

    public void init(Namespace namespace) {
        this._prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this._con = (CheckConstraint)namespace.find("NewChildObject");
        this._verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        this._baseConstraintPanel = (BaseConstraintPanel)((Object)namespace.find("constraintPanel"));
        boolean modifiable = (Boolean)namespace.find("Modifiable");
        this.fldName.setEnabled(modifiable);
        this.chkEnabled.setEnabled(modifiable);
        this.txtCondition.setEnabled(modifiable);
        CheckPanel myListener = this;
        this.txtCondition.getDocument().addDocumentListener(myListener);
        if (this._con != null) {
            this.fldName.setText(this._prov.getExternalName(this._con.getName()));
            this.chkEnabled.setSelected(this._con.isEnabled());
            this.txtCondition.setText(this._con.getCheckCondition());
        } else {
            this.fldName.setText("");
            this.chkEnabled.setSelected(false);
            this.txtCondition.setText("");
        }
    }

    public void commit() throws TraversalException {
        if (this._con != null) {
            String conName = this.fldName.getText();
            if (this._verifier != null) {
                this._verifier.verifyName(conName);
            }
            this._con.setName(this._prov.getInternalName(conName));
            this._con.setEnabled(this.chkEnabled.isSelected());
            this._con.setCheckCondition(this.txtCondition.getText());
        }
    }

    public void changedUpdate(DocumentEvent e) {
        this._baseConstraintPanel.constraintChanged((Constraint)this._con);
    }

    public void insertUpdate(DocumentEvent e) {
        this._baseConstraintPanel.constraintChanged((Constraint)this._con);
    }

    public void removeUpdate(DocumentEvent e) {
        this._baseConstraintPanel.constraintChanged((Constraint)this._con);
    }
}

