/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.panels.sql.FunctionComboBox;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.db.util.TreeNodeMaker;
import oracle.ide.util.FastStringBuffer;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.FKUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class WhereEditor
extends JPanel
implements MouseListener,
TreeSelectionListener,
ActionListener {
    public static final String AND = WhereObject.getOperatorText((int)372);
    public static final String OR = WhereObject.getOperatorText((int)373);
    private DBUIResourceHelper reshelp;
    private CompletionTextArea m_where;
    private JScrollPane m_scrollPane;
    private ExpressionEditSupport m_editSupport;
    private DefaultMutableTreeNode m_top;
    private DefaultTreeModel m_templatesModel;
    private JTree m_templates;
    private JLabel m_tempDesc;
    private JButton m_insertTempl;
    private JButton m_insertFunc;
    private FunctionComboBox m_functions;
    private TreeNodeMaker m_nodeMaker;
    private DBObjectRenderer m_rend;
    private String m_cachedWhere;
    private JButton m_and;
    private JButton m_or;
    private JButton m_pars;
    private transient DBObjectProvider m_pro;

    private void $init$() {
        this.m_where = new CompletionTextArea();
        this.m_scrollPane = new JScrollPane((Component)this.m_where, 20, 31);
        this.m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_where);
        this.m_top = new DefaultMutableTreeNode("WHERE_TEMPS");
        this.m_templatesModel = new DefaultTreeModel(this.m_top);
        this.m_templates = new JTree(this.m_templatesModel);
        this.m_tempDesc = new JLabel();
        this.m_insertTempl = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.m_insertFunc = new JButton(OracleIcons.getIcon((String)"shuttle_left.png"));
        this.m_functions = new FunctionComboBox();
        this.m_nodeMaker = new TreeNodeMaker(false);
        this.m_rend = new DBObjectRenderer();
        this.m_and = new JButton();
        this.m_or = new JButton();
        this.m_pars = new JButton();
    }

    public WhereEditor(String compPrefix) {
        this.$init$();
        this.m_rend.setIncludeIcon(true);
        try {
            this.layoutComponents(compPrefix);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents(String compPrefix) {
        this.reshelp = new DBUIResourceHelper(compPrefix);
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.setLayout(new GridBagLayout());
        this.m_where.setEditable(true);
        this.m_where.setLineWrap(true);
        this.m_where.setWrapStyleWord(true);
        this.add((Component)this.m_scrollPane, new GridBagConstraints(1, 0, 1, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 15), 0, 0));
        this.reshelp.setName(this.m_scrollPane, "Where");
        this.setTemplatesLabel(UIArb.getString(616));
        this.add((Component)this.m_tempDesc, new GridBagConstraints(2, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        ExpressionPanel.setupButton(this.m_insertTempl, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertTempl.setMnemonic('c');
        this.m_insertTempl.setEnabled(false);
        ttm.registerComponent(this.m_insertTempl);
        this.reshelp.setName(this.m_insertTempl, "InsertTemplate");
        DBObjectRenderer.setToolTipText(this.m_insertTempl, UIArb.getString(131));
        this.add((Component)this.m_insertTempl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_templates.setRootVisible(false);
        this.m_templates.setShowsRootHandles(true);
        this.m_templates.setEditable(false);
        this.m_templates.setExpandsSelectedPaths(true);
        this.m_templates.setCellRenderer(this.m_rend);
        this.m_templates.addMouseListener(this);
        this.m_templates.addTreeSelectionListener(this);
        this.m_templates.getSelectionModel().setSelectionMode(1);
        this.m_templates.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this.m_templates);
        JScrollPane templateSP = new JScrollPane(this.m_templates);
        this.add((Component)templateSP, new GridBagConstraints(3, 1, 3, 2, 0.5, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.setName(templateSP, "Templates");
        ExpressionPanel.setupButton(this.m_insertFunc, this, null, ExpressionPanel.EMPTY_INSETS);
        this.m_insertFunc.setMnemonic('f');
        ttm.registerComponent(this.m_insertFunc);
        this.reshelp.setName(this.m_insertFunc, "InsertFunction");
        DBObjectRenderer.setToolTipText(this.m_insertFunc, UIArb.getString(241));
        this.add((Component)this.m_insertFunc, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.reshelp.setName(this.m_functions, "Functions");
        this.add((Component)this.m_functions, new GridBagConstraints(3, 3, 3, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.reshelp.resButton(this.m_and, "&" + AND, "And");
        this.m_and.addActionListener(this);
        ttm.registerComponent(this.m_and);
        DBObjectRenderer.setToolTipText(this.m_and, UIArb.getString(78));
        this.add((Component)this.m_and, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.reshelp.resButton(this.m_or, "&" + OR, "Or");
        this.m_or.addActionListener(this);
        ttm.registerComponent(this.m_or);
        DBObjectRenderer.setToolTipText(this.m_or, UIArb.getString(446));
        this.add((Component)this.m_or, new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_pars.setText("(...)");
        this.m_pars.addActionListener(this);
        this.m_pars.setMnemonic('9');
        ttm.registerComponent(this.m_pars);
        this.reshelp.setName(this.m_pars, "Brackets");
        DBObjectRenderer.setToolTipText(this.m_pars, UIArb.getString(268));
        this.add((Component)this.m_pars, new GridBagConstraints(5, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 0), 0, 0));
    }

    public void setDBObjectProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setTemplatesLabel(String desc) {
        this.reshelp.resLabel(this.m_tempDesc, this.m_templates, desc, "Templates");
    }

    public void setTemplates(FromObject[] froms, FKUsage[] fks) {
        this.m_top.removeAllChildren();
        HashMap<FromObject, ArrayList<FKUsage>> fkMap = new HashMap<FromObject, ArrayList<FKUsage>>();
        int i = 0;
        while (fks != null && i < fks.length) {
            FromObject left = fks[i].resolveLeftFromObject();
            ArrayList<FKUsage> fkList = (ArrayList<FKUsage>)fkMap.get(left);
            if (fkList == null) {
                fkList = new ArrayList<FKUsage>();
                fkMap.put(left, fkList);
            }
            fkList.add(fks[i]);
            ++i;
        }
        int i2 = 0;
        while (froms != null && i2 < froms.length) {
            if (froms[i2] != null && froms[i2].getExpression() instanceof RelationUsage) {
                DefaultMutableTreeNode node = this.m_nodeMaker.createTreeNode((SQLFragment)froms[i2], true);
                this.m_top.add(node);
                if (fkMap.containsKey(froms[i2])) {
                    List fkList = (List)fkMap.get(froms[i2]);
                    Iterator iter = fkList.iterator();
                    while (iter.hasNext()) {
                        node.add(this.m_nodeMaker.createTreeNode((SQLFragment)((FKUsage)iter.next())));
                    }
                }
            }
            ++i2;
        }
        this.m_templatesModel.reload();
    }

    public void setFunctions(Collection funcs) {
        this.m_functions.removeAllItems();
        TreeSet funcs2 = new TreeSet();
        funcs2.addAll(funcs);
        Iterator iter = funcs2.iterator();
        while (iter.hasNext()) {
            this.m_functions.addItem(iter.next());
        }
    }

    private void insertCurrentFunction() {
        Object func = this.m_functions.getSelectedItem();
        if (func instanceof SQLFragment) {
            this.addToWhere(((SQLFragment)func).getSQLText());
        } else {
            this.addToWhere(func.toString());
        }
        this.m_where.requestFocus();
    }

    private void insertCurrentTemplate() {
        Object last;
        TreePath p;
        if (this.m_templates != null && (p = this.m_templates.getSelectionPath()) != null && (last = p.getLastPathComponent()) != null && ((DefaultMutableTreeNode)last).isLeaf()) {
            Object obj = ((DefaultMutableTreeNode)last).getUserObject();
            String addText = null;
            if (obj instanceof Column) {
                Object parentObj;
                FastStringBuffer text = new FastStringBuffer();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)((DefaultMutableTreeNode)last).getParent();
                Object object = parentObj = parent == null ? null : parent.getUserObject();
                if (parentObj != null && parentObj instanceof FromObject) {
                    text.append(((FromObject)parentObj).getName());
                    text.append(".");
                } else {
                    Relation rel = ((Column)obj).getRelation();
                    if (rel != null) {
                        String name = ((Relation)obj).getName();
                        if (this.m_pro != null) {
                            name = this.m_pro.getExternalName(name);
                        }
                        text.append(name).append(".");
                    }
                }
                String name = ((Column)obj).getName();
                if (this.m_pro != null) {
                    name = this.m_pro.getExternalName(name);
                }
                text.append(name);
                addText = text.toString();
            } else if (obj instanceof SQLFragment) {
                addText = ((SQLFragment)obj).getSQLText();
            } else if (obj instanceof DBObject) {
                addText = DBUtil.getFullyQualifiedName((DBObject)((DBObject)obj));
            }
            this.addToWhere(addText);
            this.m_where.requestFocus();
        }
    }

    private void addToWhere(String text) {
        this.m_editSupport.addToExpressionField(text);
    }

    public boolean hasTextChanged() {
        String sql = this.m_where.getText();
        if (ModelUtil.hasLength((String)sql)) {
            return ModelUtil.areDifferent((Object)this.m_cachedWhere, (Object)sql);
        }
        return ModelUtil.hasLength((String)this.m_cachedWhere);
    }

    public void init(WhereObject where, SQLQueryBuilder builder) {
        this.m_cachedWhere = where == null ? null : where.getSQLText();
        this.m_where.setText(this.m_cachedWhere);
        this.m_editSupport.clearUndo();
        if (builder != null) {
            HashSet<Object> objs = new HashSet<Object>();
            FromObject[] froms = builder.listAllFromObjects();
            int i = 0;
            while (i < froms.length) {
                objs.add(froms[i]);
                ++i;
            }
            if (this.m_functions.getModel().getSize() == 0) {
                List<FunctionDefinition> functions = Arrays.asList(builder.getBuiltInFunctions());
                this.setFunctions(functions);
                objs.addAll(functions);
            }
            objs.add(AND);
            objs.add(OR);
            objs.add(Comparison.getComparatorText((int)26));
            objs.add(Comparison.getComparatorText((int)27));
            objs.add(Comparison.getComparatorText((int)43));
            objs.add(Comparison.getComparatorText((int)44));
            objs.add(SetOperation.getSetOperator((int)704));
            objs.add(SetOperation.getSetOperator((int)706));
            objs.add(SetOperation.getSetOperator((int)705));
            objs.add(SetOperation.getSetOperator((int)707));
            this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(froms));
            this.m_editSupport.setInsightObjects(objs);
        }
    }

    public Component getDefaultComponent() {
        return this.m_where;
    }

    public String getWhereText() {
        return this.m_where.getText();
    }

    public void mouseClicked(MouseEvent e) {
        TreePath path;
        Object source = e.getSource();
        if (e.getClickCount() % 2 == 0 && source == this.m_templates && (path = this.m_templates.getPathForLocation(e.getX(), e.getY())) != null) {
            this.insertCurrentTemplate();
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        this.m_templates.scrollPathToVisible(path);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        this.m_insertTempl.setEnabled(node.isLeaf());
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_and) {
            this.addToWhere(AND);
        } else if (source == this.m_or) {
            this.addToWhere(OR);
        } else if (source == this.m_pars) {
            this.addToWhere("()");
        } else if (source == this.m_insertFunc) {
            this.insertCurrentFunction();
        } else if (source == this.m_insertTempl) {
            this.insertCurrentTemplate();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_and.setEnabled(enabled);
        this.m_or.setEnabled(enabled);
        this.m_pars.setEnabled(enabled);
        this.m_templates.setEnabled(enabled);
        this.m_scrollPane.setEnabled(enabled);
        this.m_where.setEnabled(enabled);
    }
}

