/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.ide.Ide;
import oracle.ide.db.DBObjectTransferable;
import oracle.ide.db.UIArb;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLFragmentID;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class QueryTargetPicker
extends ReorderableListPicker {
    public static final String REMOVE_HELP_ID = null;
    private SQLQueryBuilder m_builder;
    private Map m_paths;
    private Collection m_newToMe;
    private Collection m_newFroms;
    private boolean m_changed;

    private void $init$() {
        this.m_paths = new HashMap();
        this.m_newToMe = new ArrayList();
        this.m_newFroms = new HashSet();
    }

    public QueryTargetPicker() {
        this(new JList());
    }

    public QueryTargetPicker(JList list) {
        super(list);
        this.$init$();
        ToolTipManager.sharedInstance().registerComponent(list);
    }

    public void setQueryBuilder(SQLQueryBuilder builder) {
        this.clear();
        this.m_builder = builder;
        this.m_changed = false;
    }

    public SQLQueryBuilder getQueryBuilder() {
        return this.m_builder;
    }

    public void loadQuery() {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        model.removeAllElements();
        this.m_newToMe.clear();
        this.m_newFroms.clear();
        AbstractSQLQuery query = this.m_builder.getSQLQuery();
        SelectObject[] s = query.getSelectObjects();
        int i = 0;
        while (i < s.length) {
            model.addElement(s[i]);
            ++i;
        }
        this.m_changed = false;
    }

    private FromObject findOrCreateFromPath(List path) {
        FromObject retval = null;
        if (path != null && path.size() > 0) {
            if (this.m_paths.containsKey(path)) {
                retval = (FromObject)this.m_paths.get(path);
            } else {
                ArrayList searchPath = new ArrayList(path);
                try {
                    FromObject lastFrom = null;
                    int i = path.size() - 1;
                    while (i >= 0) {
                        DBObject obj = (DBObject)path.get(i);
                        if (obj instanceof Relation) {
                            SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructFromObject((Relation)obj, false, false, null);
                            lastFrom = retval = (FromObject)set.getObject();
                            this.m_paths.put(new ArrayList(searchPath), retval);
                            this.m_newFroms.add(retval);
                            searchPath.remove(i);
                        } else if (obj instanceof FKConstraint) {
                            searchPath.remove(i);
                            Relation rel = (Relation)path.get(--i);
                            FromObject f2 = null;
                            boolean makeNoMore = false;
                            if (this.m_paths.containsKey(searchPath)) {
                                f2 = (FromObject)this.m_paths.get(searchPath);
                                makeNoMore = true;
                            } else {
                                SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructFromObject(rel, false, false, null);
                                f2 = (FromObject)set.getObject();
                                this.m_paths.put(new ArrayList(searchPath), f2);
                                this.m_newFroms.add(f2);
                            }
                            searchPath.remove(i);
                            if (lastFrom.getExpression() instanceof JoinObject) {
                                lastFrom = ((JoinObject)lastFrom.getExpression()).getLeftExpression();
                            }
                            SQLQueryBuilder.SQLQueryObjectSet s = this.m_builder.constructFKJoin((FKConstraint)obj, f2, lastFrom);
                            lastFrom = (FromObject)f2.getParent().getParent();
                            if (makeNoMore) break;
                        }
                        --i;
                    }
                }
                catch (SQLQueryException sqe) {
                    ExceptionDialog.showExceptionDialog((Component)this.getComponent(), (Throwable)sqe);
                }
            }
        }
        return retval;
    }

    public SelectObject[] getSelectList() {
        DefaultListModel model = (DefaultListModel)this.getList().getModel();
        SelectObject[] s = new SelectObject[model.getSize()];
        int i = 0;
        while (i < s.length) {
            s[i] = (SelectObject)model.get(i);
            ++i;
        }
        return s;
    }

    public boolean addSelectedItems(Transferable[] t) {
        int i = 0;
        while (i < t.length && this.m_builder != null) {
            if (t[i] instanceof DBObjectTransferable) {
                this.m_changed = true;
                DBObject obj = ((DBObjectTransferable)t[i]).getDBObject();
                DBObject[] path = ((DBObjectTransferable)t[i]).getPath();
                if (obj instanceof Relation || obj instanceof Column) {
                    ArrayList<DBObject> pathList = new ArrayList<DBObject>(Arrays.asList(path));
                    try {
                        if (obj instanceof Relation) {
                            FromObject from = this.findOrCreateFromPath(pathList);
                            if (this.m_builder.getFromObject(from.getName()) != from) {
                                this.m_builder.addFromObject(from);
                                this.m_newFroms.add(from);
                            }
                            Column[] cols = ((Relation)obj).getColumns();
                            SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructSelectObjects(cols, new FromObject[]{from});
                            SelectObject[] s = set.getSelectObjects();
                            int j = 0;
                            while (j < s.length) {
                                this.addSelectObject(s[j]);
                                ++j;
                            }
                        } else if (obj instanceof Column) {
                            pathList.remove(obj);
                            FromObject from = this.findOrCreateFromPath(pathList);
                            SQLQueryBuilder.SQLQueryObjectSet set = this.m_builder.constructSelectObject((Column)obj, from);
                            SelectObject s = (SelectObject)set.getObject();
                            this.addSelectObject(s);
                        }
                    }
                    catch (SQLQueryException sqe) {
                        ExceptionDialog.showExceptionDialog((Component)this.getComponent(), (Throwable)sqe);
                    }
                } else if (obj instanceof FKConstraint) {
                    // empty if block
                }
            }
            ++i;
        }
        return true;
    }

    private void addSelectObject(SelectObject obj) throws SQLQueryException {
        SQLFragmentID id = new SQLFragmentID((SQLFragment)obj, this.m_builder.getSQLQuery().getID());
        obj.setID((DBObjectID)id);
        ((DefaultListModel)this.getList().getModel()).addElement(obj);
        this.m_newToMe.add(obj);
    }

    protected Transferable createTransferable(Object obj) {
        SQLFragment exp;
        if (obj instanceof SelectObject && (exp = ((SelectObject)obj).getExpression()) instanceof ColumnUsage) {
            DBObjectID id = ((ColumnUsage)exp).getObjectID();
            try {
                DBObjectTransferable dBObjectTransferable = new DBObjectTransferable(id.resolveID());
                return dBObjectTransferable;
            }
            catch (DBException dbe) {
                dbe.printStackTrace();
            }
        }
        return new DBObjectTransferable(null);
    }

    public void removeAllSelectableItems() {
        this.getList().setSelectionInterval(0, this.getList().getModel().getSize() - 1);
        this.removeSelectedItems();
    }

    public void removeSelectedItems() {
        this.m_changed = true;
        ListModel m = this.getList().getModel();
        if (!(m instanceof DefaultListModel)) {
            return;
        }
        boolean remove = true;
        DefaultListModel model = (DefaultListModel)m;
        Object[] objs = this.getList().getSelectedValues();
        int i = 0;
        while (i < objs.length) {
            if (!this.m_newToMe.contains(objs[i])) {
                remove = false;
            }
            ++i;
        }
        if (!remove) {
            remove = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)UIArb.getString(275), (String)UIArb.getString(302), (String)REMOVE_HELP_ID, (boolean)true);
        }
        if (remove) {
            int i2 = 0;
            while (i2 < objs.length) {
                if (objs[i2] instanceof SelectObject) {
                    this.m_builder.removeSelectObject((SelectObject)objs[i2]);
                    model.removeElement(objs[i2]);
                }
                ++i2;
            }
        }
    }

    void clear() {
        super.removeAllSelectableItems();
        this.m_changed = false;
    }

    boolean hasChanged() {
        return this.m_changed;
    }

    void removeNewEmptyFroms() {
        FromObject[] queryFroms = this.m_builder.getSQLQuery().getFromObjects();
        int i = 0;
        while (i < queryFroms.length) {
            if (this.canRemove(queryFroms[i])) {
                this.m_builder.removeFromObject(queryFroms[i]);
                for (Map.Entry entry : this.m_paths.entrySet()) {
                    if (entry.getValue() != queryFroms[i]) continue;
                    this.m_paths.remove(entry.getKey());
                    break;
                }
            }
            ++i;
        }
    }

    private boolean canRemove(FromObject from) {
        SQLFragment exp = from.getExpression();
        if (exp instanceof JoinObject) {
            FromObject left = ((JoinObject)exp).getLeftExpression();
            if (!this.canRemove(left)) {
                return false;
            }
            FromObject right = ((JoinObject)exp).getRightExpression();
            return this.canRemove(right);
        }
        if (this.m_newFroms.contains(from)) {
            Object[] deps = this.m_builder.getDependentObjects(from);
            return ModelUtil.hasNonNullElement((Object[])deps) ^ true;
        }
        return false;
    }
}

