/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.checkboxlist.CheckBoxListItemStateListener;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.controls.completionfield.CompletionTextArea;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinObjectEditDialog
extends JPanel
implements ItemListener,
ActionListener,
CheckBoxListItemStateListener,
VetoableChangeListener,
Comparator,
DocumentListener {
    public static final String JOIN_HELP_ID = "f1_odbeditjoin_html";
    private JoinObject m_join;
    private SQLQueryBuilder m_builder;
    private final DBUIResourceHelper m_reshelp;
    private final JWrappedLabel m_desc;
    private final JLabel m_typeListLabel;
    private final JComboBox m_typeList;
    private final JCheckBox m_natural;
    private final JRadioButton m_using;
    private final JRadioButton m_on;
    private final ButtonGroup m_condition;
    private final JPanel m_conditionPanel;
    private final JButton m_swapExpressions;
    private CompletionTextArea m_onCondition;
    private CheckBoxListPanel m_usingList;
    private JEWTDialog m_dialog;

    private void $init$() {
        this.m_reshelp = new DBUIResourceHelper("JoinObjectEditDialog");
        this.m_desc = new JWrappedLabel();
        this.m_typeListLabel = new JLabel();
        this.m_typeList = new JComboBox();
        this.m_natural = new JCheckBox();
        this.m_using = new JRadioButton();
        this.m_on = new JRadioButton();
        this.m_condition = new ButtonGroup();
        this.m_conditionPanel = new JPanel();
        this.m_swapExpressions = new JButton();
    }

    public JoinObjectEditDialog() {
        this.$init$();
        try {
            this.layoutComponents();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, JOIN_HELP_ID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int y = 0;
        this.add((Component)this.m_desc, new GridBagConstraints(1, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.m_reshelp.resButton(this.m_swapExpressions, UIArb.getString(338), "Swap");
        this.m_swapExpressions.addActionListener(this);
        this.add((Component)this.m_swapExpressions, new GridBagConstraints(3, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.m_reshelp.resLabel(this.m_typeListLabel, this.m_typeList, UIArb.getString(377), "JoinType");
        this.add((Component)this.m_typeListLabel, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_typeList.addItem("CROSS");
        this.m_typeList.addItem("FULL");
        this.m_typeList.addItem("INNER");
        this.m_typeList.addItem("LEFT");
        this.m_typeList.addItem("RIGHT");
        this.m_typeList.setSelectedItem("INNER");
        this.m_typeList.addItemListener(this);
        this.add((Component)this.m_typeList, new GridBagConstraints(2, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_natural, "&NATURAL", "Natural");
        this.m_natural.addActionListener(this);
        this.add((Component)this.m_natural, new GridBagConstraints(1, ++y, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_on, "&ON", "On");
        this.m_condition.add(this.m_on);
        this.m_on.addActionListener(this);
        this.add((Component)this.m_on, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.m_reshelp.resButton(this.m_using, "&USING", "Using");
        this.m_condition.add(this.m_using);
        this.m_using.addActionListener(this);
        this.add((Component)this.m_using, new GridBagConstraints(2, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.m_conditionPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_conditionPanel, new GridBagConstraints(1, ++y, 3, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setupOnPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_onCondition == null) {
            JoinCondition c;
            this.m_onCondition = new CompletionTextArea();
            this.m_onCondition.setLineWrap(true);
            this.m_onCondition.setWrapStyleWord(true);
            this.m_onCondition.getDocument().addDocumentListener(this);
            this.m_reshelp.setName((Component)this.m_onCondition, "OnCondition");
            ExpressionEditSupport ees = new ExpressionEditSupport((JTextComponent)this.m_onCondition);
            ees.setInsightMap(ExpressionEditSupport.createInsightMap(new FromObject[]{this.m_join.getLeftExpression(), this.m_join.getRightExpression()}));
            HashSet<FromObject> objs = new HashSet<FromObject>();
            objs.add(this.m_join.getLeftExpression());
            objs.add(this.m_join.getRightExpression());
            ees.setInsightObjects(objs);
            if (this.m_join != null && (c = this.m_join.getCondition()) != null && c instanceof OnJoinCondition) {
                this.m_onCondition.setText(((OnJoinCondition)c).getConditionText());
            }
        }
        this.m_conditionPanel.add((Component)new JScrollPane((Component)this.m_onCondition, 22, 31), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setupUsingPanel() {
        this.m_conditionPanel.removeAll();
        if (this.m_usingList == null) {
            JoinCondition c;
            TreeSet<FromObjectUsage> used = null;
            Collection colNames = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (this.m_join != null && (c = this.m_join.getCondition()) != null && c instanceof UsingJoinCondition) {
                FromObjectUsage[] cols = ((UsingJoinCondition)c).getColumns();
                used = new TreeSet<FromObjectUsage>(this);
                int i = 0;
                while (i < cols.length) {
                    used.add(cols[i]);
                    ++i;
                }
            }
            Iterator iter = colNames.iterator();
            CheckBoxListModel usingModel = new CheckBoxListModel();
            while (iter.hasNext()) {
                Object obj = iter.next();
                boolean check = used == null || used.contains(obj);
                usingModel.addElement(obj, null, true, check);
            }
            this.m_usingList = new CheckBoxListPanel(usingModel);
            this.m_reshelp.setName((Component)this.m_usingList, "UsingList");
            if (colNames.size() < 1) {
                MessageDialog.error((Component)this, (Object)"Cannot use USING - no common columns", (String)"USING", null);
            }
        }
        this.m_conditionPanel.add((Component)this.m_usingList, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.validate();
        this.m_conditionPanel.repaint();
    }

    private void setDialog(JEWTDialog dialog) {
        this.m_dialog = dialog;
        this.m_dialog.addVetoableChangeListener((VetoableChangeListener)this);
    }

    private void enableCondition(boolean enable) {
        this.m_using.setEnabled(enable);
        this.m_on.setEnabled(enable);
        this.enable(this.m_conditionPanel, enable);
    }

    private void enable(Container c, boolean enable) {
        if (c != null) {
            int max = c.getComponentCount();
            int i = 0;
            while (i < max) {
                Component kid = c.getComponent(i);
                if (kid instanceof Container) {
                    this.enable((Container)kid, enable);
                }
                ++i;
            }
            c.setEnabled(enable);
        }
    }

    public void setBuilder(SQLQueryBuilder builder) {
        this.m_builder = builder;
    }

    public JoinObject getJoin() {
        return this.m_join;
    }

    public void setJoin(JoinObject join) {
        this.m_join = join;
        this.setDescription();
        JoinCondition condition = this.m_join.getCondition();
        this.enableCondition(true);
        if (condition == null && !join.isNatural()) {
            Collection colNames = this.getCommonFromObjectUsages(this.m_join.getLeftExpression(), this.m_join.getRightExpression(), false);
            if (colNames == null || colNames.size() < 1) {
                this.m_on.setSelected(true);
                this.setupOnPanel();
            } else {
                this.m_using.setSelected(true);
                this.setupUsingPanel();
            }
        } else if (condition instanceof UsingJoinCondition) {
            this.m_using.setSelected(true);
            this.setupUsingPanel();
        } else {
            this.m_on.setSelected(true);
            this.setupOnPanel();
        }
        this.m_natural.setSelected(this.m_join.isNatural());
        this.m_typeList.setSelectedItem(this.m_join.getJoinType());
        this.joinTypeChanged();
    }

    public void commit() throws SQLQueryException {
        String type = (String)this.m_typeList.getSelectedItem();
        JoinCondition c = this.m_join.getCondition();
        UsingJoinCondition newCondition = null;
        if (this.m_using.isEnabled()) {
            if (this.m_using.isSelected()) {
                newCondition = c != null && c instanceof UsingJoinCondition ? (UsingJoinCondition)c : new UsingJoinCondition();
                List sel = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (sel == null || sel.size() < 1) {
                    throw new SQLQueryException(UIArb.getString(594));
                }
                FromObjectUsage[] cols = sel.toArray(new FromObjectUsage[sel.size()]);
                newCondition.setColumns(cols);
            } else {
                String exp;
                newCondition = c != null && c instanceof OnJoinCondition ? (OnJoinCondition)c : new OnJoinCondition();
                String string = exp = this.m_condition == null ? null : this.m_onCondition.getText().trim();
                if (!ModelUtil.hasLength((String)exp)) {
                    throw new SQLQueryException(UIArb.getString(325));
                }
                if (c == null || ModelUtil.areDifferent((Object)exp, (Object)c.getConditionText())) {
                    try {
                        OnJoinCondition parsed = this.m_builder.parseOnExpression(exp, this.m_join);
                        parsed.copyTo((Object)newCondition);
                    }
                    catch (SQLParseException pe) {
                        throw new SQLQueryException(UIArb.format(691, pe.getMessage()));
                    }
                }
            }
        }
        this.m_join.setJoinType(type);
        this.m_join.setNatural(this.m_natural.isSelected());
        this.m_join.setCondition((JoinCondition)newCondition);
    }

    private Collection getCommonFromObjectUsages(FromObject one, FromObject two, boolean incFrom) {
        Collection oneCols = ExpressionEditSupport.getColumns(one);
        Collection twoCols = ExpressionEditSupport.getColumns(two);
        TreeSet<Object> retval = new TreeSet<Object>(this);
        for (Object next : oneCols) {
            if (!twoCols.contains(next)) continue;
            if (next instanceof Column) {
                retval.add(new ColumnUsage(((Column)next).getID(), (FromObject)(incFrom ? one : null)));
                continue;
            }
            if (!(next instanceof SelectObject)) continue;
            retval.add(new SelectObjectUsage((SelectObject)next, (FromObject)(incFrom ? one : null)));
        }
        return retval;
    }

    private void setDescription() {
        FromObject left = this.m_join.getLeftExpression();
        FromObject right = this.m_join.getRightExpression();
        this.m_desc.setText(UIArb.format(361, left.getName(), right.getName()));
    }

    private void checkOKButton() {
        if (this.m_dialog != null) {
            boolean enable = true;
            if (this.m_usingList != null && this.m_using.isSelected()) {
                List sel = this.m_usingList.getList().getCheckBoxListModel().getSelectionList();
                if (sel == null || sel.size() < 1) {
                    enable = false;
                }
            } else if (this.m_onCondition != null && this.m_on.isSelected() && this.m_onCondition.getText().length() < 1) {
                enable = false;
            }
            this.m_dialog.setOKButtonEnabled(enable);
        }
    }

    private void joinTypeChanged() {
        if ("CROSS".equals(this.m_typeList.getSelectedItem())) {
            this.m_natural.setSelected(false);
            this.m_natural.setEnabled(false);
            this.enableCondition(false);
        } else {
            this.m_natural.setEnabled(true);
            this.enableCondition(this.m_natural.isSelected() ^ true);
        }
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof FromObjectUsage && o2 instanceof FromObjectUsage) {
            String s1 = ((FromObjectUsage)o1).getColumnName();
            String s2 = ((FromObjectUsage)o2).getColumnName();
            return s1.compareTo(s2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.m_typeList) {
            this.joinTypeChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_natural) {
            this.enableCondition(this.m_natural.isSelected() ^ true);
        } else if (source == this.m_using || source == this.m_on) {
            if (this.m_using.isSelected()) {
                this.setupUsingPanel();
                this.m_usingList.getList().requestFocus();
                this.checkOKButton();
            } else {
                this.setupOnPanel();
                this.m_onCondition.requestFocus();
                this.checkOKButton();
            }
        } else if (source == this.m_swapExpressions) {
            FromObject left = this.m_join.getLeftExpression();
            FromObject right = this.m_join.getRightExpression();
            this.m_join.setLeftExpression(null);
            this.m_join.setRightExpression(null);
            this.m_join.setLeftExpression(right);
            this.m_join.setRightExpression(left);
            this.setDescription();
        }
    }

    public void stateChanged(Object source) {
        this.checkOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkOKButton();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkOKButton();
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
            try {
                this.commit();
            }
            catch (SQLQueryException sqe) {
                MessageDialog.error((Component)this, (Object)sqe.getMessage(), (String)UIArb.getString(238), null);
                throw new PropertyVetoException("invalid join condition", evt);
            }
        }
    }

    public static boolean editJoin(FromObject from, Component parent, SQLQueryBuilder builder) {
        String TITLE = UIArb.getString(97);
        JoinObject join = (JoinObject)from.getExpression();
        FromObject left = join.getLeftExpression();
        FromObject right = join.getRightExpression();
        if (left == null || right == null) {
            throw new IllegalArgumentException("Join must have a left and right expression setup");
        }
        int bit = 7;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)parent, (String)TITLE, (int)bit);
        JoinObjectEditDialog panel = new JoinObjectEditDialog();
        panel.setBuilder(builder);
        JoinObject copy = (JoinObject)join.copyTo(null, true);
        panel.setJoin(copy);
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setPreferredSize(300, 400);
        panel.setDialog(dialog);
        if (dialog.runDialog()) {
            try {
                FromObject newFrom = new FromObject((SQLFragment)panel.getJoin(), null);
                builder.replaceFromObject(from, newFrom);
            }
            catch (SQLQueryException sqe) {
                DBExceptionDialog.showErrorDialog(parent, TITLE, (DBException)((Object)sqe));
            }
            return true;
        }
        dialog.dispose();
        return false;
    }
}

